** Microsoft Work Group Extensions is lacking a routine to
** handle all E-Mailing and faxing functions.  I developed 
** both that I would like to share with your readers.

** I wrote a Fax function that uses MS At Work Fax
** via my E-Mail routine.  You call it like so:
** = FAX ( "customer.frx", "John Doe", "555-1212" )
** I am working on cleaning that up and will also send that
** to you also when I am finished.  This is just the E-Mail

** Author:  Tom DeMay  CompuServe 75141,275

********************************
PROCEDURE EMAIL
PARAMETERS To, SUBJECT, NOTETEXT, FILES, MessagType, MailFlags
Private lnSelect, llSendFile, lcSafety, fornum

** (c) Copyright 1994   Government Micro Resources, Inc.
** Author:  Tom DeMay  CompuServe 75141,275
********
* This function will handle all E-Mail functions in one command line
*  Just put these functions where they are visible to your calling program
********
* Returns .t. if successful else .f.
********
* Example Call
* if !EMail( "John Doe;Jane Smith", "Test E-Mail Message", ;
*			"This is a test of a new FoxPro function.  I have attached " + ;
*			"two files.  AUTOEXEC.BAT and CONFIGY.SYS", "C:\AUTOEXEC.BAT;C:\CONFIG.SYS" )
*		wait window "Could Not Process E-Mail Message" 
* else
*		wait window "E-Mail message successfully sent"
* endif
********
* Parameters
* To					- List of Recipients ( delimited by semicolons )
* Subject			- Subject of E-Mail Message
* NoteText		- Message to be E-Mailed
* Files				- List of Attachments ( delimited by semicolons ) ( optional )
* MessagType	- A message type string used by applications other 
*									than interpersonal electronic mail. An empty string 
*									indicates an interpersonal message (IPM) type. ( optional )
* MailFlags		- List of Flags passed to Mapi - how they are delimited is not important ( optional )
*									- Example MailFlags =  "MP_RECEIPT_REQUESTED;MP_DIALOG"
*									- refer to WRKEXTS for more info.
*									MP_UNREAD							- Sent Unread
*									MP_RECEIPT_REQUESTED	- Receipt Requested
*									MP_SENT								- ???
*									MP_OLE								- Object is OLE object
*									MP_OLE_STATIC					- Attachment is OLE static object
*									MP_LOGON_UI						- display a dialog box to prompt for sign in (if required). 
*									MP_NEW_SESSION				- establish a session other than a current session
*									MP_DIALOG							- display a dialog box to prompt for 
*																						recipients and other sending options
*********
* Variables
* To_Arry			- m.To is converted to an array and stored here
* Files_Arry	- m.Files is converted to an array and stored here
* lnSelect		- current selected area to return to
* llSendFile	- Logical variable - .t. if files are to be sent else .f.
* lcSafety		- current safety setting to return to when exiting
* fornum			- for, endfor counter
* MailSession - Current Mail Session FoxPro is able to open
******
* Important Notes - Must have WorkGroup Extensions to run this routine
********************************

	wait window "Please Wait....An E-Mail message is being generated." nowait

**** initialize variables

	To_Arry = ""  						&& Character string will be converted to an array
	Files_Arry = ""						&& Character string will be converted to an array
	lnSelect = select()
	lcSafety = set("safety")
	m.MessagType = iif( parameters() < 5 or empty( m.MessagType ) , "IPM.", m.MessagType )
	m.llSendFile = parameters() >= 4 and !empty( m.Files )
	m.MailFlags = iif( parameters() < 6, "IPM.MSMAIL.FOXPROW", m.MailFlags )
	
**** convert recipent list to an array
	do CharToArry with To_Arry, ( m.To )
	
**** convert file list to an array
	if m.llSendFile
		do CharToArry with Files_Arry, ( m.Files )
	endif

**** Set library
	IF !"FOXTOOLS"$SET("library")
		SET LIBRARY TO (SYS(2004)+"\FOXTOOLS.FLL") ADDITIVE
	ENDIF

	set safety off

**** Logon to Mail and set
	islogon=.F.
	DO CASE
		CASE TYPE('mailsession')#'N'
			PUBLIC mailsession
			mailsession = 0
			mailsession= mapilib('LOGON')
		CASE m.mailsession=0
			mailsession= mapilib('LOGON')
		OTHERWISE
			islogon=.T.
	ENDCASE

**** Return .f. if unsuccessful logging into Mail
	IF m.mailsession=0  &&failed to logon
		wait clear
		select ( m.lnselect )
		set safety &lcSafety
		RETURN .f.
	ENDIF

**** Create Required Cursors by WRKEXTS Maillib routines
	=mapilib ('newcursor','mapiMesg')
	=mapilib ('newcursor','mapiFile')
	=mapilib ('newcursor','mapiRecip', 'filelist')

**** Test to see if user is in PostOffice, if so add them 
*				to the recipient list ( filelist )
*				note:  mapirecip is not used for the final recipient list because
*						function checkid reserves that cursor name
	for fornum = 1 to alen( To_Arry )
		if checkid( To_Arry( m.fornum ) )
			SELECT mapirecip
			SCATTER MEMVAR MEMO
			INSERT INTO filelist FROM MEMVAR
		endif
	endfor

**** Building memvars to be inserted into the MapiMesg Cursor
	m.reserved   = 0													&& Reserved field
	** m.NoteText = Actual Message - note spaces are added for attachments
	m.NoteText   = iif( m.llSendFile, ;
				space( alen( Files_Arry )) + chr(13) + m.NoteText, ;
				m.NoteText )
	m.DateRecved = mapilib('getdate')					&& Date - in format required by MAPI
	m.ConvertnId = ''													&& String indicating conversation thread ID
	m.Flags      = 0													&& Bitmap of Flags passed to Mapi 
																						&&		- refer to WRKEXTS for more info.
																						&& 1 - MP_UNREAD
																						&& 2 - MP_RECEIPT_REQUESTED
																						&& 4 - MP_SENT
	m.flags = iif ( "MP_UNREAD" $ m.mailflags, m.flags + 1, m.flags )
	m.flags = iif ( "MP_RECEIPT_REQUESTED" $ m.mailflags, m.flags + 2, m.flags )
	m.flags = iif ( "MP_SENT" $ m.mailflags, m.flags + 4, m.flags )
																						
	m.RecipCount = reccount ( 'filelist' )		&& Number of recipients
	*** m.filecount = Number of attachments
	m.FileCount  = iif( m.llSendFile, ;
			alen ( Files_Arry ), ;
			0 )
	
	insert into mapimesg from memvar


***** Building memvars to be inserted inth the MapiFile Cursor
	m.reserved   = 0													&& Reserved field
	m.Flags      = 0													&& Bitmap of Flags passed to Mapi 
																						&&		- refer to WRKEXTS for more info.
																						&& 1 - MP_OLE
																						&& 2 - MP_OLE_STATIC
	m.flags = iif ( "MP_OLE" $ m.MailFlags, m.flags + 1, m.flags )
	m.flags = iif ( "MP_OLE_STATIC" $ m.MailFlags, m.flags + 2, m.flags )

	m.filetype   = ""													&& reserved descriptor that describes to
																						&& the recipients the type of attached file.
																						&& Empty string indicates an unknown or OS 
																						&& determined file type.
	if llSendFile
		for fornum = 1 to alen( Files_Arry )
			m.position   = fornum - 1							&& an int. describing where the attachment
																						&& is stored in the body of message
			m.pathname   = Files_Arry( fornum )		&& Path and File Name 
			m.filename   = JustFName( m.pathname )&& Just the File Name
			insert into mapifile from memvar
		endfor
	endif

**** Send mail store result into RetVal
	m.Flags      = 0													&& Bitmap of Flags passed to Mapi 
																						&&		- refer to WRKEXTS for more info.
																						&& 1 - MP_LOGON_UI
																						&& 2 - MP_NEW_SESSION
																						&& 8 - MP_DIALOG
	m.flags = iif ( "MP_LOGON_UI" $ m.mailflags, m.flags + 1, m.flags )
	m.flags = iif ( "MP_NEW_SESSION" $ m.mailflags, m.flags + 2, m.flags )
	m.flags = iif ( "MP_DIALOG" $ m.mailflags, m.flags + 8, m.flags )

	retval = mapilib ('sendmail', 'mailsession', 'mapiMesg', 'filelist', 'mapiFile', m.flags )

**** Now log off and cleanup stuff
	IF !islogon
		=mapilib( 'LOGOFF',(m.mailsession))
		mailsession = 0
	ENDIF
	
	= Close("mapiFile")
	= Close("mapimesg")
	= Close("mapiRecip")
	= close("filelist")

	wait clear
	select ( m.lnselect )
	set safety &lcSafety
	return retval
		
***********************************
FUNCTION checkid
PARAMETERS lcToName
* this routine calls mapilib - resolve function to 
*   test if user is in post office
***********************************

	validid=.T.
	IF !mapilib( 'resolve', mailsession, alltrim(lcToName))
		validid=.F.
	ENDif
	RETURN validid


***********************************
PROCEDURE CharToArry
PARAMETERS ArryName, ToList, Delimiter
Private ArryName, ToList, Delimiter, Count
***********************************

	ToList = alltrim( m.ToList )
	Delimiter = iif( parameters() < 3, ";", left( m.Delimiter, 1 ) )
	ToList = iif ( right ( m.ToList, 1 ) <> m.Delimiter, m.ToList + m.Delimiter, m.ToList )
	
	Count = 1
	do while AT( m.delimiter, m.ToList ) <> 0
		dimension ArryName( m.count )
		ArryName( m.count ) = alltrim( left( m.Tolist , at( m.delimiter, m.tolist ) -1 ))
		ToList = iif( len( m.ToList ) <> len( ArryName( m.count ) ) + len ( m.delimiter ) , ;
			substr ( m.ToList , len ( ArryName( m.count ) ) + 2 ), ;
			"" )
		count = count + 1
	enddo
	
	return
	
**************************
PROCEDURE CLOSE
parameters lcDBF
private lcDBF
* Simple function to test and close cursors/tables
**************************

	if used( lcdbf)
		use in (lcdbf)
	endif
	return 

