*-------------------------------------------------------------------------
* NAME     :   DUPKEY.PRG
* AUTHOR   :   SPYROS SAKELLARIADIS, 02/20/87
* ADDRESS  :   SOURCE # BBH751, OR TEL. (202)364-4378 EVES. (WASH.DC.)
* FUNCTION :   DUPLICATES INDIVIDUAL FIELDS IN APPENDING/EDITING ROUTINES
*          :   FUNCTIONS AS 'AUTODUP' KEY ON IBM SYSTEM 34/36
*          :   MAJOR TIME-SAVER FOR DATA ENTRY INTENSIVE WORK
* USAGE    :   IF A FIELD HAS SAME VALUE FROM RECORD TO RECORD, 
*          :   E.G. CITY NAME IN ADDRESS FILE, HIT FUNCTION KEY F3
*          :   TO DUPLICATE THAT DATA INSTEAD OF TYPING IT.  
* CALLS    :   AUTODUP -- PROCEDURE
* COMPLD   :   CLIPPER AUT.'86
*-------------------------------------------------------------------------
* USES     :   ANY DATABASE, E.G. TESTDB.DBF WITH STRUCTURE --
* DBF STRU :   Name     Type  Width  
*              NAME     CHAR  30
*              ADDRESS  CHAR  30
*              CITY     CHAR  15
*-------------------------------------------------------------------------
* NAME    :    TESTDB.FMT
*              @ 1,0 say 'ENTER NAME ->' get name
*              @ 2,0 say '   ADDRESS ->' get address
*              @ 3,0 say '      CITY ->' get city
*              EOF: TESTDB.FMT
*-------------------------------------------------------------------------
set key -2 to autodup                    && USE FUNCTION KEY F3
use testdb 
set form to testdb
declare m[fcount()]                      && SET UP ARRAY TO HOLD PREV.REC.
clear
set carry off
pressed = 0
do while pressed<> 23                    && LOOP UNTIL EXIT WITH CTRL-W
	for i=1 to fcount()              && FILL WITH PREV.REC'S INFO, IN
		fname=fieldname(i)       && CASE AUTODUP KEY HIT
		m[i]=&fname
	next	
	append blank
	go bottom
	read
	pressed = lastkey()
enddo
use
* EOF: DUPKEY.PRG

*-------------------------------------------------------------------------
procedure autodup 
	parameters call_prg, line_num,input_var
	if call_prg="AUTODUP"                   && TO PREVENT SELF-CALLING
		return
	endif
	fieldno=0
	for i=1 to fcount()                     && FIND VARIABLE NUMBER
		if input_var=fieldname(i)       && BY CHECKING ALL FIELDS
			fieldno=i
			i=fcount()              && EXIT WHEN FOUND
		endif
	next
	replace &input_var with m[fieldno]      && FILL IT IN NEW RECORD
	return

*-------------------------------------------------------------------------
