***************************************************************************
*
* Procedure file: DRAGEVNT.PRG
*         System: DragDrop
*        Version: 2.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* DRAGEVNT- Drag event handler.
*
* Description:
* This program is used to handle drag events for DragDrop objects.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
FUNCTION dragevnt
PARAMETERS winname0,objrow0,objcol0,mclktimer,dragicon0,objclass0,objmsg0,;
           objarray,dragmode,dragheight,dragwidth,centerrow,centercol,;
           objheight0,objwidth0,scnno,colorscheme,dblclkfnct,icontxt0
PRIVATE dragicon,dragicon1,dragicon2,objover,objover2,objclass
PRIVATE icontxt,icontxt1,icontxt2,icontxthgt,iconno,m.icontxtrow,m.icontxtcol
PRIVATE iconreset,icondelay,icontimer,iconmode,iconstretch,iconcheck
PRIVATE dragtxt,dragtxt1,dragtxt2,objstate,objstate2,objheight,objwidth
PRIVATE objheight1,objwidth1,fileext,objmsg,objmsg2,dblclick
PRIVATE objrow,objcol,objrow2,objcol2,objrow3,objcol3,overmsg,overclass
PRIVATE foxtools,maxmove,lastmsgbar,crsrtimer,htfactor,wdfactor
PRIVATE null,arraycnt,arrayrows,arraycols,at_pos,loopflag
EXTERNAL ARRAY regfn,callfn

m.dblclick=.T.
IF _WINDOWS.OR._MAC
  m.htfactor=((FONTMETRIC(1,'MS Sans Serif',8,'N')+;
             FONTMETRIC(5,'MS Sans Serif',8,'N'))/;
             FONTMETRIC(1,WFONT(1,m.winname0),WFONT(2,m.winname0),WFONT(3,m.winname0)))
  m.wdfactor=FONTMETRIC(6,'MS Sans Serif',8,'N')/;
             FONTMETRIC(6,WFONT(1,m.winname0),WFONT(2,m.winname0),WFONT(3,m.winname0))
ELSE
  m.htfactor=1
  m.wdfactor=1
ENDIF
m.maxmove=m.htfactor*SCOLS()/256
DO WHILE MDOWN()
  IF ABS(MROW()-m.objrow0)>=m.maxmove.OR.ABS(MCOL()-m.objcol0)>m.maxmove
    m.dblclick=.F.
    EXIT
  ENDIF
  IF ABS(SECONDS()-m.mclktimer)>_dblclick
    m.dblclick=.F.
  ENDIF
ENDDO
IF MDOWN().OR.EMPTY(m.dblclkfnct)
  m.dblclick=.F.
ENDIF
IF m.dblclick
  m.dblclick=.F.
  DO WHILE .T.
    IF ABS(MROW()-m.objrow0)>=m.maxmove.OR.ABS(MCOL()-m.objcol0)>m.maxmove
      EXIT
    ENDIF
    IF MDOWN()
      m.dblclick=.T.
      EXIT
    ENDIF
    IF ABS(SECONDS()-m.mclktimer)>_dblclick
      EXIT
    ENDIF
  ENDDO
ENDIF
m.null=CHR(0)
m.dragicon=m.dragicon0
m.dragicon1=''
m.dragicon2=''
m.icontxt=m.icontxt0
m.icontxt1=''
m.icontxt2=''
m.icontxthgt=m.htfactor*1.25*(FONTMETRIC(1,'Arial',6,'N')+FONTMETRIC(5,'Arial',6,'N'))*;
             SROWS()/SYSMETRIC(1)
m.icontxtrow=0
m.icontxtcol=0
m.objclass=UPPER(ALLTRIM(m.objclass0))
m.objmsg=m.objmsg0
m.objmsg2=''
m.objover=m.null
m.objover2=m.objover
m.overmsg=m.null
m.overclass=m.null
m.objstate=3
m.objstate2=3
m.dragtxt=''
m.dragtxt1=''
m.dragtxt2=m.null
m.objheight=m.objheight0
m.objheight1=0
m.objwidth=m.objwidth0
m.objwidth1=0
m.iconmode=.F.
m.iconstretch=.F.
m.iconcheck=.F.
m.objrow2=-999
m.objcol2=-999
m.iconno=-1
m.iconreset=.F.
m.icondelay=0
m.icontimer=-999
m.crsrtimer=-999
m.foxtools=.F.
m.loopflag=.F.
IF m.dblclick
  m.objclass=UPPER(ALLTRIM(evlmsg(m.objclass0)))
  m.overclass=m.objclass
  m.objmsg=evlmsg(m.objmsg0)
  m.overmsg=m.objclass
  m.objover=m.overclass+'||'+m.overmsg
  m.objover2=m.objover
  m.objstate=-1
  IF '('$m.dblclkfnct
    =&dblclkfnct
  ELSE
    DO (m.dblclkfnct)
  ENDIF
  RETURN .F.
ENDIF
IF .NOT.MDOWN()
  RETURN .F.
ENDIF
_FOX25=(SUBSTR(VERSION(),AT('2.',VERSION()),3)>='2.5')
_FOX25REV=IIF(_FOX25,SUBSTR(VERSION(),AT('2.',VERSION())+3,1),'')
IF .NOT._FOX25
  _DOS=.T.
  _WINDOWS=.F.
  _MAC=.F.
  _UNIX=.F.
ENDIF
IF _WINDOWS.OR._MAC
  m.lastmsgbar=SET('MESSAGE',1)
  IF .NOT.SET('MESSAGE',1)==' '
    SET MESSAGE TO ' '
  ENDIF
ELSE
  WAIT CLEAR
ENDIF
IF m.colorscheme<1
  m.colorscheme=1
ENDIF
IF EMPTY(m.dragicon0)
  m.dragicon0=m.null
ENDIF
IF EMPTY(m.icontxt0)
  m.icontxt0=''
ENDIF
IF _WINDOWS
  IF .NOT.'\FOXTOOLS.FLL'$SET('LIBRARY').AND.FILE(SYS(2004)+'FOXTOOLS.FLL')
    SET LIBRARY TO SYS(2004)+'FOXTOOLS' ADDITIVE
  ENDIF
  m.foxtools=('\FOXTOOLS.FLL'$SET('LIBRARY'))
ENDIF
DO WHILE MDOWN()
  m.objrow=MROW(m.winname0)
  m.objcol=MCOL(m.winname0)
  IF m.objrow<0.OR.m.objcol<0
    m.objrow=999
    m.objcol=999
    IF WEXIST('w_dragobj')
      =updwinpos()
    ENDIF
  ENDIF
  IF m.foxtools.AND.(m.objrow2<0.OR.m.objcol2<0.OR.m.objrow=999.OR.;
     m.dragicon1==m.null.OR.ABS(SECONDS()-m.crsrtimer)>=.1)
    m.loadcsr=regfn("LoadCursor","IL","I")
    m.setcsr=regfn("SetCursor","I","I")
    =callfn((m.setcsr),callfn((m.loadcsr),0,IIF(m.objrow=999.OR.;
            m.dragicon1==m.null,32512,0)))
    m.crsrtimer=SECONDS()
  ENDIF
  IF m.loopflag.AND.m.objrow=999.AND.m.objrow=m.objrow2.AND.m.objcol=m.objcol2
    LOOP
  ENDIF
  IF m.dragheight>=0.AND.ABS(m.objrow-m.centerrow)>(m.dragheight/2)
    m.objrow=IIF(m.objrow>m.centerrow,m.centerrow+m.dragheight/2,;
                 m.centerrow-m.dragheight/2)
  ENDIF
  IF m.dragwidth>=0.AND.ABS(m.objcol-m.centercol)>(m.dragwidth/2)
    m.objcol=IIF(m.objcol>m.centercol,m.centercol+m.dragwidth/2,;
                 m.centercol-m.dragwidth/2)
  ENDIF
  IF .NOT.WEXIST('w_dragobj')
    =updwinsize(m.dragicon)
    IF _WINDOWS.OR._MAC
      DEFINE WINDOW w_dragobj;
                    FROM 999,999 TO m.objheight1+999,m.objwidth1+999;
                    IN WINDOW (m.winname0) NONE;
                    FONT WFONT(1,m.winname0),WFONT(2,m.winname0);
                    STYLE WFONT(3,m.winname0);
                    COLOR RGB(,,,192,192,192)
    ELSE
      DEFINE WINDOW w_dragobj;
                    FROM 999,999 TO m.objheight1+999,m.objwidth1+999;
                    IN WINDOW (m.winname0) NONE COLOR SCHEME (m.colorscheme)
    ENDIF
    ACTIVATE WINDOW w_dragobj NOSHOW
  ENDIF
  IF EMPTY(m.icontxt)
    m.icontxt=m.icontxt0
  ENDIF
  m.icontxt1=LEFT(evlmsg(m.icontxt),79)
  IF EMPTY(m.dragicon)
    m.dragicon=m.dragicon0
    m.objheight=m.objheight0
    m.objwidth=m.objwidth0
    m.iconno=-1
    m.icondelay=0
    m.icontimer=-999
  ENDIF
  IF LEFT(m.dragicon,1)=='@'
    IF ABS(SECONDS()-m.icontimer)>=m.icondelay
      m.dragicon1=evlmsg(m.dragicon)
      IF m.icontimer<0
        m.icontimer=SECONDS()
      ELSE
        m.icontimer=MAX(m.icontimer,SECONDS()-m.icondelay)+m.icondelay
      ENDIF
    ELSE
      m.dragicon1=ALLTRIM(m.dragicon2)
    ENDIF
    IF EMPTY(m.dragicon1)
      m.dragicon1=ALLTRIM(m.dragicon2)
      IF LEFT(m.dragicon1,1)=='@'
        m.dragicon1=m.null
      ENDIF
    ENDIF
    IF m.dragicon1==m.null
      m.dragicon1=''
    ENDIF
  ELSE
    m.dragicon1=m.dragicon
    m.iconno=-1
    m.icondelay=0
    m.icontimer=-999
  ENDIF
  IF EMPTY(m.dragicon1)
    m.dragicon1=m.dragicon0
    m.objheight=m.objheight0
    m.objwidth=m.objwidth0
    m.iconno=-1
    m.icondelay=0
    m.icontimer=-999
  ELSE
    m.dragicon1=MLINE(m.dragicon1,1)
  ENDIF
  IF .NOT.m.dragicon1==m.dragicon2
    m.dragicon2=m.dragicon1
    IF m.iconno=-1.AND..NOT.m.dragicon1==m.dragicon0
      IF m.objheight<=0
        m.objheight=-1
      ENDIF
      IF m.objwidth<=0
        m.objwidth=-1
      ENDIF
    ENDIF
    m.fileext=UPPER(RIGHT(m.dragicon1,4))
    IF m.fileext=='.BMP'.OR.m.fileext=='.ICO'
      DO CASE
        CASE .NOT._WINDOWS.AND..NOT._MAC
          m.dragicon1=trimpath(m.dragicon1,.T.)
        CASE m.iconno=-1.AND..NOT.m.iconcheck.AND..NOT.FILE(m.dragicon1)
          m.dragicon1=trimpath(m.dragicon1)+'*'
          m.dragicon0=m.dragicon1
          m.fileext=''
      ENDCASE
    ENDIF
    m.iconcheck=.T.
    DO CASE
      CASE m.dragicon1==m.null
        MOVE WINDOW w_dragobj TO 999,999
        m.objrow2=-999
        m.objcol2=-999
        IF m.foxtools
          m.loadcsr=regfn("LoadCursor","IL","I")
          m.setcsr=regfn("SetCursor","I","I")
          =callfn((m.setcsr),callfn((m.loadcsr),0,32512))
        ENDIF
      CASE (_WINDOWS.OR._MAC).AND.(m.fileext=='.BMP'.OR.m.fileext=='.ICO')
        IF .NOT.m.iconmode.OR.m.objheight>-2.OR.m.objwidth>-2
          m.iconstretch=(m.fileext=='.BMP')
          IF m.objheight=0
            m.objheight=m.objheight0
          ENDIF
          DO CASE
            CASE m.objheight=-1.OR.m.objheight=0
              m.objheight1=2.462
            CASE m.objheight>0
              m.objheight1=m.objheight
              m.iconstretch=.T.
          ENDCASE
          IF m.objwidth=0
            m.objwidth=m.objwidth0
          ENDIF
          DO CASE
            CASE m.objwidth=-1.OR.m.objwidth=0
              m.objwidth1=6.4
            CASE m.objwidth>0
              m.objwidth1=m.objwidth
              m.iconstretch=.T.
          ENDCASE
          IF .NOT.EMPTY(m.icontxt1)
            m.objheight1=m.objheight1+m.icontxthgt
            m.objwidth1=m.objwidth1+m.wdfactor*.25
          ENDIF
          MODIFY WINDOW w_dragobj;
                        FROM m.objrow-(m.htfactor*m.objheight1/2),;
                             m.objcol-(m.wdfactor*m.objwidth1/2);
                        SIZE m.htfactor*m.objheight1,m.wdfactor*m.objwidth1
          IF .NOT.EMPTY(m.icontxt1)
            m.icontxt2=''
          ENDIF
          m.iconmode=.T.
          m.objheight=-2
          m.objwidth=-2
        ENDIF
        IF .NOT.WOUTPUT('w_dragobj')
          ACTIVATE WINDOW w_dragobj SAME
        ENDIF
        IF EMPTY(m.icontxt1)
          CLEAR
          IF m.iconstretch
            @ 0,0 SAY (m.dragicon1) BITMAP;
                      SIZE WROWS(),WCOLS();
                      STRETCH STYLE 'T'
          ELSE
            @ 0,0 SAY (m.dragicon1) BITMAP;
                      SIZE WROWS(),WCOLS();
                      ISOMETRIC STYLE 'T'
          ENDIF
        ELSE
          IF m.iconreset.OR..NOT.m.icontxt1==m.icontxt2
            CLEAR
            m.icontxt2=''
          ELSE
            @ 0,0 CLEAR TO WROWS()-m.icontxthgt,WCOLS()
          ENDIF
          IF m.iconstretch
            @ 0,0 SAY (m.dragicon1) BITMAP;
                      SIZE WROWS()-m.icontxthgt,WCOLS()-m.wdfactor*.25;
                      STRETCH STYLE 'T'
          ELSE
            @ 0,0 SAY (m.dragicon1) BITMAP;
                      SIZE WROWS()-m.icontxthgt,WCOLS()-m.wdfactor*.25;
                      ISOMETRIC STYLE 'T'
          ENDIF
        ENDIF
        IF m.foxtools
          m.loadcsr=regfn("LoadCursor","IL","I")
          m.setcsr=regfn("SetCursor","I","I")
          =callfn((m.setcsr),callfn((m.loadcsr),0,0))
        ENDIF
      OTHERWISE
        =updwinsize(m.dragicon1)
        IF _WINDOWS.OR._MAC
          MODIFY WINDOW w_dragobj;
                        FROM m.objrow-(m.htfactor*m.objheight1/2),;
                             m.objcol-(m.wdfactor*m.objwidth1/2);
                        SIZE m.htfactor*m.objheight1,m.wdfactor*m.objwidth1
        ELSE
          ZOOM WINDOW w_dragobj NORM;
                      FROM m.objrow,m.objcol-(m.objwidth1/2);
                      SIZE m.objheight1,m.objwidth1
        ENDIF
        m.iconmode=.F.
        m.objheight=-1
        m.objwidth=-1
        m.iconstretch=.F.
        IF .NOT.WOUTPUT('w_dragobj')
          ACTIVATE WINDOW w_dragobj SAME
        ENDIF
        CLEAR
        IF .NOT.m.dragicon1==m.null
          IF _WINDOWS.OR._MAC
            @ 0,0 SAY m.dragicon1;
                      FONT 'MS Sans Serif',8
          ELSE
            @ 0,0 SAY m.dragicon1
          ENDIF
          IF m.foxtools
            m.loadcsr=regfn("LoadCursor","IL","I")
            m.setcsr=regfn("SetCursor","I","I")
            =callfn((m.setcsr),callfn((m.loadcsr),0,0))
          ENDIF
        ENDIF
    ENDCASE
  ENDIF
  IF m.iconmode.AND..NOT.m.icontxt1==m.icontxt2
    m.icontxtrow=WROWS()-m.icontxthgt
    m.icontxtcol=MAX((WCOLS()/2-m.wdfactor*TXTWIDTH(m.icontxt1,'Arial',6,'N')/2),0)
    @ m.icontxtrow,0 CLEAR
    @ m.icontxtrow,m.icontxtcol SAY m.icontxt1 FONT 'Arial',6
    m.icontxt2=m.icontxt1
  ENDIF
  m.dragtxt1=LEFT(evlmsg(m.dragtxt),79)
  IF .NOT.m.dragtxt1==m.dragtxt2
    m.dragtxt2=m.dragtxt1
    IF EMPTY(m.dragtxt1)
      IF _WINDOWS.OR._MAC
        IF .NOT.SET('MESSAGE',1)==' '
          SET MESSAGE TO ' '
        ENDIF
      ELSE
        WAIT CLEAR
      ENDIF
    ELSE
      IF _WINDOWS.OR._MAC
        IF .NOT.SET('MESSAGE',1)==m.dragtxt1
          SET MESSAGE TO m.dragtxt1
        ENDIF
      ELSE
        WAIT CLEAR
        WAIT m.dragtxt1 WINDOW NOWAIT
      ENDIF
    ENDIF
  ENDIF
  IF m.objstate=1
    m.objstate=0
  ENDIF
  m.objclass=UPPER(ALLTRIM(evlmsg(m.objclass0)))
  m.objmsg=evlmsg(m.objmsg0)
  IF m.loopflag.AND.(m.objrow#m.objrow2.OR.m.objcol#m.objcol2)
    m.objover=dragover()
    IF m.objover==m.null.OR.EMPTY(m.objover)
      m.overclass=m.null
      m.overmsg=m.null
    ELSE
      m.at_pos=AT('||',m.objover)
      IF m.at_pos=0
        m.overclass=''
        m.overmsg=LEFT(evlmsg(m.objover),24)
      ELSE
        m.overclass=LEFT(evlmsg(LEFT(m.objover,m.at_pos-1)),24)
        m.overmsg=LEFT(evlmsg(SUBSTR(m.objover,m.at_pos+2)),24)
      ENDIF
    ENDIF
    IF m.objover==m.null.OR.(.NOT.EMPTY(m.objover2).AND.;
       .NOT.m.objover==m.objover2))
      m.objstate=1
      IF .NOT.m.objover2==m.null
        m.objrow3=m.objrow
        m.objcol3=m.objcol
        m.objrow=m.objrow2
        m.objcol=m.objcol2
        =dragover()
        m.objrow=m.objrow3
        m.objcol=m.objcol3
        m.objstate=1
      ENDIF
    ENDIF
    IF .NOT.EMPTY(m.dragmode)
      IF m.objstate#1.OR..NOT.m.objover==m.null
        m.objstate=2
      ENDIF
      IF '('$m.dragmode
        =&dragmode
      ELSE
        DO (m.dragmode)
      ENDIF
    ENDIF
  ENDIF
  =updwinpos()
  IF .NOT.m.dragicon1==m.null.AND.(.NOT.WVISIBLE('w_dragobj').OR.;
     .NOT.WONTOP('w_dragobj'))
    =updwinpos()
    ACTIVATE WINDOW w_dragobj
  ENDIF
  IF m.objstate#1.OR..NOT.m.objover==m.null
    m.objstate=2
  ENDIF
  m.objstate2=m.objstate
  m.objmsg2=m.objmsg
  m.objover2=m.objover
  IF m.objrow>=0
    m.objrow2=m.objrow
  ENDIF
  IF m.objcol>=0
    m.objcol2=m.objcol
  ENDIF
  m.loopflag=.T.
ENDDO
IF _WINDOWS.OR._MAC
  IF .NOT.m.lastmsgbar==SET('MESSAGE',1)
    IF m.lastmsgbar==''
      SET MESSAGE TO
    ELSE
      SET MESSAGE TO m.lastmsgbar
    ENDIF
  ENDIF
ELSE
  WAIT CLEAR
ENDIF
IF .NOT.WEXIST('w_dragobj')
  RETURN .F.
ENDIF
RELEASE WINDOW w_dragobj
IF m.foxtools
  m.loadcsr=regfn("LoadCursor","IL","I")
  m.setcsr=regfn("SetCursor","I","I")
  =callfn((m.setcsr),callfn((m.loadcsr),0,32512))
ENDIF
m.objstate=-1
IF .NOT.EMPTY(m.dragmode)
  IF '('$m.dragmode
    =&dragmode
  ELSE
    DO (m.dragmode)
  ENDIF
  IF _WINDOWS.OR._MAC
    IF .NOT.m.lastmsgbar==SET('MESSAGE',1)
      IF m.lastmsgbar==''
        SET MESSAGE TO
      ELSE
        SET MESSAGE TO m.lastmsgbar
      ENDIF
    ENDIF
  ELSE
    WAIT CLEAR
  ENDIF
ENDIF
IF EMPTY(m.objarray)
  m.objclass=UPPER(ALLTRIM(evlmsg(m.objclass0)))
  m.objmsg=evlmsg(m.objmsg0)
  =dragover()
  RETURN .T.
ENDIF
m.arrayrows=IIF(TYPE(m.objarray)=='C',ALEN((m.objarray),1),0)
IF m.arrayrows=0
  RETURN .T.
ENDIF
m.arraycols=ALEN((m.objarray),2)
IF m.arraycols=0
  m.objclass=UPPER(ALLTRIM(evlmsg(m.objclass0)))
ENDIF
FOR m.arraycnt = 1 TO m.arrayrows
  IF m.arraycols=0
    m.objmsg=evlmsg(EVALUATE(m.objarray+'(m.arraycnt)'))
  ELSE
    m.objclass=UPPER(ALLTRIM(evlmsg(EVALUATE(m.objarray+'(m.arraycnt,1)'))))
    m.objmsg=evlmsg(EVALUATE(m.objarray+'(m.arraycnt,2)'))
  ENDIF
  IF .NOT.EMPTY(m.objmsg)
    =dragover()
  ENDIF
ENDFOR
RETURN .T.

* END dragevnt



FUNCTION updwinpos
PRIVATE moverow,movecol

IF (m.objrow=m.objrow2.AND.m.objcol=m.objcol2).OR.m.dragicon1==m.null
  RETURN .F.
ENDIF
IF _WINDOWS.OR._MAC
  m.moverow=m.objrow-(m.htfactor*m.objheight1/2)
  m.movecol=m.objcol-(m.wdfactor*m.objwidth1/2)
ELSE
  m.moverow=m.objrow
  m.movecol=m.objcol-(m.wdfactor*m.objwidth1/2)
ENDIF
IF MROW('w_dragobj')#m.moverow.OR.MCOL('w_dragobj')#m.movecol
  MOVE WINDOW w_dragobj TO m.moverow,m.movecol
ENDIF
m.crsrtimer=SECONDS()
RETURN .T.

* END updwinpos



FUNCTION updwinsize
PARAMETER str_data

IF _WINDOWS.OR._MAC
  m.objheight1=SROWS()/SYSMETRIC(1)*FONTMETRIC(1,WFONT(1,''),WFONT(2,''),;
               WFONT(3,''))+(8*SROWS()/SYSMETRIC(1))               
  m.objwidth1=TXTWIDTH(m.str_data,'MS Sans Serif',8,'N')+;
              (2*SCOLS()/SYSMETRIC(2))
ELSE
  m.objheight1=1
  m.objwidth1=LEN(m.str_data)
ENDIF
RETURN .T.

* END updwinsize



FUNCTION trimext
PARAMETERS filename,plattype
PRIVATE at_pos

m.at_pos=AT('.',m.filename)
IF m.at_pos>0
  m.filename=LEFT(m.filename,m.at_pos-1)
ENDIF
IF m.plattype
  m.filename=IIF(_DOS.OR._UNIX,UPPER(m.filename),LOWER(m.filename))
ENDIF
RETURN ALLTRIM(m.filename)

* END trimext



FUNCTION trimpath
PARAMETERS filename,trim_ext,plattype
PRIVATE at_pos

IF EMPTY(m.filename)
  RETURN ''
ENDIF
m.at_pos=AT(':',m.filename)
IF m.at_pos>0
  m.filename=SUBSTR(m.filename,m.at_pos+1)
ENDIF
IF m.trim_ext
  m.filename=trimext(m.filename)
ENDIF
IF m.plattype
  m.filename=IIF(_DOS.OR._UNIX,UPPER(m.filename),LOWER(m.filename))
ENDIF
m.filename=ALLTRIM(SUBSTR(m.filename,AT('\',m.filename,;
           MAX(OCCURS('\',m.filename),1))+1))
DO WHILE LEFT(m.filename,1)=='.'
  m.filename=ALLTRIM(SUBSTR(m.filename,2))
ENDDO
DO WHILE RIGHT(m.filename,1)=='.'
  m.filename=ALLTRIM(LEFT(m.filename,LEN(m.filename)-1))
ENDDO
RETURN m.filename

* END trimpath



FUNCTION evlmsg
PARAMETERS old_str
PRIVATE new_text,eval_str,var_type

IF TYPE('m.old_str')#'C'
  RETURN ''
ENDIF
IF .NOT.LEFT(m.old_str,1)=='@'
  RETURN m.old_str
ENDIF
m.eval_str=EVALUATE(SUBSTR(MLINE(m.old_str,1),2))
m.var_type=TYPE('m.eval_str')
DO CASE
  CASE m.var_type=='C'
    m.new_str=m.eval_str
  CASE m.var_type=='N'
    m.new_str=ALLTRIM(STR(m.eval_str,24,12))
    DO WHILE RIGHT(m.new_str,1)=='0'
      m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
      IF RIGHT(m.new_str,1)=='.'
        m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
        EXIT
      ENDIF
    ENDDO
  CASE m.var_type=='D'
    m.new_str=DTOC(m.eval_str)
  CASE m.var_type=='L'
    m.new_str=IIF(m.eval_str,'.T.','.F.')
  OTHERWISE
    m.new_str=m.old_str
ENDCASE
RETURN m.new_str

* END evlmsg



FUNCTION animate
PARAMETERS iconmask,iconspeed,value1,value2,valuecount
PRIVATE ascflag,wildcard,iconfile

DO CASE
  CASE TYPE('m.value1')=='C'
    m.ascflag=.T.
    m.value1=ASC(m.value1)
    m.value2=ASC(m.value2)
  CASE TYPE('m.value1')#'N'
    RETURN m.iconmask
  OTHERWISE
    m.ascflag=.F.
ENDCASE
DO CASE
  CASE '??'$m.iconmask
    m.wildcard='??'
  CASE '?'$m.iconmask
    m.wildcard='?'
  OTHERWISE
    RETURN m.iconmask
ENDCASE
IF TYPE('m.iconspeed')#'N'
  m.iconspeed=0
ENDIF
m.icondelay=IIF(m.iconspeed<=0,0,1/m.iconspeed)
IF m.value2>=m.value1
  IF TYPE('m.valuecount')#'N'
    m.valuecount=1
  ENDIF
  IF m.valuecount<0
    m.valuecount=-m.valuecount
  ENDIF
  m.iconreset=.NOT.BETWEEN(m.iconno,m.value1,m.value2)
  IF m.iconreset
    m.iconno=m.value1
  ENDIF
ELSE
  IF TYPE('m.valuecount')#'N'
    m.valuecount=-1
  ENDIF
  IF m.valuecount>0
    m.valuecount=-m.valuecount
  ENDIF
  m.iconreset=.NOT.BETWEEN(m.iconno,m.value2,m.value1)
  IF m.iconreset
    m.iconno=m.value1
  ENDIF
ENDIF
IF m.ascflag
  m.iconfile=CHR(m.iconno)
ELSE
  m.iconfile=ALLTRIM(STR(m.iconno,2))
  IF LEN(m.wildcard)>LEN(m.iconfile)
    m.iconfile=REPLICATE('0',LEN(m.wildcard)-LEN(m.iconfile))+m.iconfile
  ENDIF
ENDIF
m.iconfile=STRTRAN(m.iconmask,m.wildcard,m.iconfile,1,1)
m.iconno=m.iconno+m.valuecount
IF m.foxtools
  m.loadcsr=regfn("LoadCursor","IL","I")
  m.setcsr=regfn("SetCursor","I","I")
  =callfn((m.setcsr),callfn((m.loadcsr),0,0))
ENDIF
RETURN m.iconfile

* END animate
