***************************************************************************
*
* Procedure file: DRAGDROP.PRG
*         System: GenScrnX
*        Version: 2.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* DRAGDROP - DragDrop driver for GENSCRNX.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Generates drag-and-drop event/property code.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* Function calls made from this program may be contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE c_dragmode,dragover,c_dragdrop,c_dragenter,c_dragleave,c_dragwithin
PRIVATE c_objcmd,c_objmsg,objarray,c_objtxt,c_dragicon,c_icontxt,c_overicon
PRIVATE c_overtxt,c_overbutton,c_dblclick,c_dragheight,c_dragwidth,c_noiconlist
PRIVATE c_objheight,c_objwidth,c_overheight,c_overwidth,c_3d,c_no3d,c_objdgdp
PRIVATE dragicon,icontxt,overicon,overtxt,overbutton,objclass,objmsg,objclsmsg
PRIVATE dragmode,dragover,dragdrop,dragenter,dragleave,dragwithin,objtxt
PRIVATE objarray,iconlist,codedata,codedata2,codedata3,setupdata,cleanupdata
PRIVATE dragheight,dragwidth,objheight,objwidth,overheight,overwidth,dblclick
PRIVATE fontface2,fontstyle2,fontsize2,match,vpos2,hpos2,height2,width2
PRIVATE cfontstylm,vfontratio,hfontratio,htfactor,wdfactor,htfactor2,wdfactor2
PRIVATE vfactor,hfactor,r,i,at_pos,expr2,str_data,voffset

IF OBJTYPE#1.OR..NOT.drvenable(PROGRAM())
  GOTO BOTTOM
  RETURN .F.
ENDIF
IF TYPE('m.gsxversion')#'C'.OR.LEFT(m.gsxversion,4)<'2.0'
  GOTO BOTTOM
  =warning('DragDrop driver requires GENSCNRX 2.0 or later')
  RETURN .F.
ENDIF
IF m.drv_no#5.AND.m.drv_no#7
  GOTO BOTTOM
  =warning('DragDrop driver requires *:SCXDRV5')
  RETURN .F.
ENDIF
IF STYLE=0
  GOTO BOTTOM
  =warning('DragDrop driver requires non-desktop window style')
  RETURN .F.
ENDIF
IF (_DOS.OR._UNIX).AND.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC')
  GOTO BOTTOM
  RETURN .F.
ENDIF
IF (_WINDOWS.OR._MAC).AND.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC').AND.;
   (.NOT.WFONT(1,'')=='FoxFont'.OR.WFONT(2,'')#9)
  expr2="MODIFY WINDOW SCREEN FONT 'FoxFont',9 STYLE 'N'"
  &expr2
ENDIF
IF m.drv_no=5
  FOR m.i = 1 TO m.drv_cnt-1
    IF ATC('\3D.PRG',a_scxdrv(m.i,5))>0
      GOTO BOTTOM
      =warning('*:SCXDRV5 DragDrop must be declared before *:SCXDRV5 3D')
      RETURN .F.
    ENDIF
  ENDFOR
  IF .NOT.m.loop_flag
    a_scxdrvs(7)=a_scxdrvs(7)+1
    IF ALEN(a_scxdrv)<(8*a_scxdrvs(7))
      DIMENSION a_scxdrv(a_scxdrvs(7),8)
    ENDIF
    a_scxdrv(a_scxdrvs(7),7)=a_scxdrv(m.drv_cnt,m.drv_no)
  ENDIF
ENDIF
m.c_dblclick='*:DBLCLICK'
m.c_dragdrop='*:DRAGDROP'
m.c_dragenter='*:DRAGENTER'
m.c_dragheight='*:DRAGHEIGHT'
m.c_dragicon='*:DRAGICON'
m.c_dragleave='*:DRAGLEAVE'
m.c_dragmode='*:DRAGMODE'
m.c_dragover='*:DRAGOVER'
m.c_dragwidth='*:DRAGWIDTH'
m.c_dragwithin='*:DRAGWITHIN'
m.c_icontxt='*:ICONTXT'
m.c_noiconlist='*:NOICONLIST'
m.c_objarray='*:OBJARRAY'
m.c_objclass='*:OBJCLASS'
m.c_objheight='*:OBJHEIGHT'
m.c_objmsg='*:OBJMSG'
m.c_objtxt='*:OBJTXT'
m.c_objwidth='*:OBJWIDTH'
m.c_overbutton='*:OVERBUTTON'
m.c_overheight='*:OVERHEIGHT'
m.c_overicon='*:OVERICON'
m.c_overtxt='*:OVERTXT'
m.c_overwidth='*:OVERWIDTH'
m.c_3d='*:3D'
m.c_no3d='*:NO3D'
m.c_objdgdp='*:OBJDRAGDROP'
m.iconlist=(wordsearch(m.c_noiconlist)==m.null)
IF (_WINDOWS.OR._MAC).AND.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC')
  m.cfontstylm=IIF(m.fontstyle=1.OR.m.fontstyle=3,'B','')
  m.vfontratio=FONTMETRIC(1,'MS Sans Serif',8,'N')/;
               (FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)+;
               FONTMETRIC(5,m.fontface,m.fontsize,m.cfontstylm))*;
               (FONTMETRIC(1,WFONT(1,''),WFONT(2,''),WFONT(3,''))+;
               FONTMETRIC(5,WFONT(1,''),WFONT(2,''),WFONT(3,'')))/;
               FONTMETRIC(1,'FoxFont',9,'N')
  m.hfontratio=FONTMETRIC(6,'MS Sans Serif',8,'N')/;
               FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)*;
               FONTMETRIC(6,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
               FONTMETRIC(6,'FoxFont',9,'N')
  m.htfactor=((FONTMETRIC(1,WFONT(1,''),WFONT(2,''),WFONT(3,''))+;
             FONTMETRIC(5,WFONT(1,''),WFONT(2,''),WFONT(3,'')))/;
             FONTMETRIC(1,'FoxFont',9,'N'))
  m.wdfactor=(FONTMETRIC(6,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
             FONTMETRIC(6,'FoxFont',9,'N'))
  m.htfactor2=((FONTMETRIC(1,'MS Sans Serif',8,'N')+;
              FONTMETRIC(5,'MS Sans Serif',8,'N'))/;
              FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm))
  m.wdfactor2=FONTMETRIC(6,'MS Sans Serif',8,'N')/;
              FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)
ELSE
  m.cfontstylm=''
  m.vfontratio=1
  m.hfontratio=1
  m.htfactor=1
  m.wdfactor=1
  m.htfactor2=1
  m.wdfactor2=1
ENDIF
IF m.drv_no=7
  IF EMPTY(NAME)
    REPLACE NAME WITH SYS(2015)
  ENDIF
  m.iconlist=(wordsearch(m.c_noiconlist)==m.null)
  m.cleanupdata=''
  m.codedata="dragover"+IIF(m.scxcount=1,"",;
             ALLTRIM(STR(m.scxcount,2)))+m.cr_lf+;
             "PARAMETERS objmsgonly"+m.cr_lf+;
             "PRIVATE xlinkfnct,arraycount"+m.cr_lf+;
             "EXTERNAL ARRAY evlmsg"+m.cr_lf+m.cr_lf
  IF m.scxcount=1
    m.codedata=m.codedata+"IF m.scnno>1"+m.cr_lf+;
               "  m.xlinkfnct=[dragover]+ALLTRIM(STR(m.scnno,2))+"+;
               "[(m.objmsgonly)]"+m.cr_lf+"  RETURN &xlinkfnct"+m.cr_lf+;
               "ENDIF"+m.cr_lf
  ENDIF
  m.codedata2=''
  m.setupdata=''
  m.match=.F.
  SCAN ALL FOR .NOT.DELETED()
    m.dragdrop=nobrackets(wordsearch(m.c_dragdrop))
    m.dragmode=nobrackets(wordsearch(m.c_dragmode))
    IF m.dragdrop==m.null
      IF .NOT.m.dragmode==m.null
        m.match=.T.
      ENDIF
      LOOP
    ENDIF
    m.match=.T.
    m.dragmode=fnctexpr(m.dragmode)
    m.dragover=fnctexpr(nobrackets(wordsearch(m.c_dragover)))
    m.dragenter=fnctexpr(nobrackets(wordsearch(m.c_dragenter)))
    m.dragwithin=fnctexpr(nobrackets(wordsearch(m.c_dragwithin)))
    m.dragleave=fnctexpr(nobrackets(wordsearch(m.c_dragleave)))
    m.objarray=nobrackets(wordsearch(m.c_objarray))
    DO CASE
      CASE m.objarray==m.null.OR.m.dragdrop==m.null
        m.objarray=''
      CASE EMPTY(m.objarray)
        m.objarray=SYS(2015)
    ENDCASE
    m.objtxt=nobrackets(wordsearch(m.c_objtxt))
    IF m.objtxt==m.null
      m.objtxt=''
    ENDIF
    m.objmsg=nobrackets(wordsearch(m.c_objmsg))
    =updobjmsg()
    m.objclass=nobrackets(wordsearch(m.c_objclass))
    IF m.objclass==m.null.OR.EMPTY(m.objmsg)
      m.objclass=''
    ENDIF
    IF EMPTY(m.objclass)
      m.objclsmsg=m.objmsg
    ELSE
      m.objclsmsg=m.objclass+'||'+m.objmsg
    ENDIF
    IF LEFT(m.dragdrop,1)=='*'
      m.dragdrop=m.null
    ELSE
      m.dragdrop=fnctexpr(m.dragdrop)
    ENDIF
    m.overheight=nobrackets(wordsearch(m.c_overheight))
    DO CASE
      CASE m.overheight==m.null.OR.VAL(m.overheight)<0
        m.overheight=''
      CASE EMPTY(m.overheight)
        m.overheight=ALLTRIM(STR(objheight()/m.htfactor2,9,3))
      OTHERWISE
        m.overheight=ALLTRIM(STR(VAL(m.overheight)/m.htfactor2,9,3))
    ENDCASE
    m.overwidth=nobrackets(wordsearch(m.c_overwidth))
    DO CASE
      CASE m.overwidth==m.null.OR.VAL(m.overwidth)<0
        m.overwidth=''
      CASE EMPTY(m.overwidth)
        m.overwidth=ALLTRIM(STR(objwidth()/m.wdfactor2,9,3))
      OTHERWISE
        m.overwidth=ALLTRIM(STR(VAL(m.overwidth)/m.wdfactor2,9,3))
    ENDCASE
    m.overtxt=nobrackets(wordsearch(m.c_overtxt))
    DO CASE
      CASE m.overtxt==m.null
        DO CASE
          CASE m.dragdrop==m.null
            m.overtxt=''
          CASE OBJTYPE=1
            m.overtxt="[]"
          CASE EMPTY(m.objmsg)
            m.overtxt="[Drop ]+ALLTRIM(m.objmsg)"
          OTHERWISE
            m.overtxt="[Drop ]+ALLTRIM(m.objmsg)+[ on ]+evlmsg(["+m.objmsg+"])"
        ENDCASE
      CASE EMPTY(m.overtxt)
        m.overtxt=''
      CASE .NOT.LEFT(m.overtxt,1)=="'".AND..NOT.LEFT(m.overtxt,1)=='"'
        m.overtxt="["+m.overtxt+"]"
    ENDCASE
    m.overbutton=nobrackets(wordsearch(m.c_overbutton))
    DO CASE
      CASE m.overbutton==m.null.OR.OBJTYPE#14
        m.overbutton=''
      CASE EMPTY(m.overbutton)
        m.overbutton=MLINE(NAME,1)
    ENDCASE
    m.overicon=nobrackets(wordsearch(m.c_overicon))
    DO CASE
      CASE m.overicon==m.null
        m.overicon=''
      CASE EMPTY(m.overicon)
        IF EMPTY(m.overbutton)
          IF OBJTYPE=1
            m.overicon="[]"
          ELSE
            m.overicon="IIF(FILE([OVERICON.ICO]),[OVERICON.ICO],[])"
            =updiconlst('OVERICON.ICO')
          ENDIF
        ELSE
          m.overicon=''
        ENDIF
      CASE .NOT.LEFT(m.overicon,1)=="'".AND..NOT.LEFT(m.overicon,1)=='"'
        =updiconlst(m.overicon)
        m.overicon="["+m.overicon+"]"
    ENDCASE
    m.vpos2=VPOS
    m.hpos2=HPOS
    IF ALLTRIM(m.platform_)=='DOS'.OR.ALLTRIM(m.platform_)=='UNIX'
      m.hpos2=m.hpos2+1
      m.height2=objheight()-1
      m.width2=objwidth()-1
    ELSE
      m.height2=objheight()
      m.width2=objwidth()
    ENDIF
    m.codedata2="IF BETWEEN(m.objrow,"+ALLTRIM(STR(m.vpos2,7,3))+","+;
                ALLTRIM(STR(m.vpos2+m.height2,7,3))+").AND.BETWEEN(m.objcol,"+;
                ALLTRIM(STR(m.hpos2,7,3))+","+;
                ALLTRIM(STR(m.hpos2+m.width2,7,3))+")"+m.cr_lf
    m.codedata2=m.codedata2+;
                "  IF .NOT.m.objmsgonly"+m.cr_lf+;
                "    IF m.objstate<=-1"+m.cr_lf
    IF .NOT.EMPTY(m.overbutton)
      m.codedata2=m.codedata2+;
                  "      "+m.overbutton+"=0"+m.cr_lf+;
                  "      SHOW GET "+m.overbutton+m.cr_lf
    ENDIF
    IF .NOT.EMPTY(m.objarray)
      m.codedata2=m.codedata2+;
                  "      IF TYPE(["+m.objarray+"])#[C]"+m.cr_lf+;
                  "        m.arraycount=1"+m.cr_lf+;
                  "        PUBLIC "+m.objarray+"(m.arraycount,2)"+m.cr_lf+;
                  "      ELSE"+m.cr_lf+;
                  "        m.arraycount=ALEN("+m.objarray+",1)+1"+m.cr_lf+;
                  "        DIMENSION "+m.objarray+"(m.arraycount,2)"+m.cr_lf+;
                  "      ENDIF"+m.cr_lf+;
                  "      "+m.objarray+"(m.arraycount,1)=m.objclass"+m.cr_lf+;
                  "      "+m.objarray+"(m.arraycount,2)=m.objmsg"+m.cr_lf
      m.cleanupdata="RELEASE "+m.objarray+m.cr_lf+m.cleanupdata
    ENDIF
    IF EMPTY(m.dragdrop).OR.m.dragdrop==m.null
      m.codedata2=m.codedata2+;
                  "      =.F."+m.cr_lf
    ELSE
      m.codedata2=m.codedata2+;
                  "      IF m.objstate=-1"+m.cr_lf+;
                  "        ="+m.dragdrop+m.cr_lf+;
                  "      ENDIF"+m.cr_lf
    ENDIF
    IF .NOT.EMPTY(m.dragover).OR..NOT.EMPTY(m.dragenter).OR.;
       .NOT.EMPTY(m.dragwithin).OR..NOT.EMPTY(m.dragleave).OR.;
       .NOT.EMPTY(m.overicon).OR..NOT.EMPTY(m.overheight).OR.;
       .NOT.EMPTY(m.overwidth).OR..NOT.EMPTY(m.overtxt)
      m.codedata2=m.codedata2+;
                  "    ELSE"+m.cr_lf+;
                  "      IF .NOT.m.objover==["+m.objclsmsg+"]"+m.cr_lf+;
                  "        IF .NOT.m.objover==m.null"+m.cr_lf+;
                  "          RETURN m.null"+m.cr_lf+;
                  "        ENDIF"+m.cr_lf+;
                  "        IF m.objstate#1"+m.cr_lf+;
                  "          m.objstate=0"+m.cr_lf+;
                  "        ENDIF"+m.cr_lf+;
                  "      ENDIF"+m.cr_lf
      m.codedata2=m.codedata2+;
                  "      DO CASE"+m.cr_lf+;
                  "        CASE m.objmsg0==["+m.objmsg+"]"+m.cr_lf+;
                  "          =.F."+m.cr_lf
      m.codedata3=''
      IF .NOT.EMPTY(m.overtxt)
        IF m.dragmode==m.null
          m.codedata3=m.codedata3+;
                      "          m.dragtxt="+m.overtxt+m.cr_lf
        ELSE
          m.codedata3=m.codedata3+;
                      "          m.dragtxt="+m.overtxt+m.cr_lf
        ENDIF
      ENDIF
      IF .NOT.EMPTY(m.overicon)
        m.codedata3=m.codedata3+;
                    "          m.dragicon="+m.overicon+m.cr_lf+;
                    "          m.objheight=-1"+m.cr_lf+;
                    "          m.objwidth=-1"+m.cr_lf+;
                    "          m.icontimer=-1000"+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overheight)
        m.codedata3=m.codedata3+;
                    "          m.objheight="+m.overheight+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overwidth)
        m.codedata3=m.codedata3+;
                    "          m.objwidth="+m.overwidth+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overbutton)
        m.codedata3=m.codedata3+;
                    "          "+m.overbutton+"=1"+m.cr_lf+;
                    "          SHOW GET "+m.overbutton+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.codedata3)
        m.codedata2=m.codedata2+;
                    "        CASE m.objstate=0"+m.cr_lf+m.codedata3
      ENDIF
      m.codedata3=''
      IF .NOT.EMPTY(m.overtxt)
        m.codedata3=m.codedata3+;
                  "          m.dragtxt=[]"+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overicon)
        m.codedata3=m.codedata3+;
                  "          m.dragicon=[]"+m.cr_lf+;
                  "          m.icontimer=-1000"+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.overbutton)
        m.codedata3=m.codedata3+;
                    "          "+m.overbutton+"=0"+m.cr_lf+;
                    "          SHOW GET "+m.overbutton+m.cr_lf
      ENDIF
      IF .NOT.EMPTY(m.codedata3)
        m.codedata2=m.codedata2+;
                    "        CASE m.objstate=1"+m.cr_lf+m.codedata3
      ENDIF
      m.codedata2=m.codedata2+;
                  "      ENDCASE"+m.cr_lf
      m.codedata3=''
      IF .NOT.EMPTY(m.dragenter).OR..NOT.EMPTY(m.dragwithin).OR.;
         .NOT.EMPTY(m.dragleave)
        m.codedata2=m.codedata2+;
                    "      DO CASE"+m.cr_lf
        IF .NOT.EMPTY(m.dragenter)
          m.codedata2=m.codedata2+;
                      "        CASE m.objstate=0"+m.cr_lf+;
                      "          ="+m.dragenter+m.cr_lf
        ENDIF
        IF .NOT.EMPTY(m.dragleave)
          m.codedata2=m.codedata2+;
                      "        CASE m.objstate=1"+m.cr_lf+;
                      "          ="+m.dragleave+m.cr_lf
        ENDIF
        IF .NOT.EMPTY(m.dragwithin)
          m.codedata2=m.codedata2+;
                      "        CASE m.objstate=2"+m.cr_lf+;
                      "          ="+m.dragwithin+m.cr_lf
        ENDIF
        m.codedata2=m.codedata2+;
                    "      ENDCASE"+m.cr_lf
      ENDIF
    ENDIF
    IF .NOT.EMPTY(m.dragover)
      m.codedata2=m.codedata2+"      ="+m.dragover+m.cr_lf
    ENDIF
    m.codedata2=m.codedata2+;
                "    ENDIF"+m.cr_lf+;
                "  ENDIF"+m.cr_lf+;
                "  RETURN ["+m.objclsmsg+"]"+m.cr_lf+;
                "ENDIF"+m.cr_lf
    IF OBJTYPE=1
      m.setupdata=m.codedata2
      m.codedata2=''
    ELSE
      m.codedata=m.codedata+m.codedata2
    ENDIF
  ENDSCAN
  m.codedata=m.codedata+m.setupdata+"RETURN m.null"+m.cr_lf
  m.codedata2=''
  m.setupdata=''
  IF TYPE('m.iconfiles')=='N'.AND.m.iconfiles>0
    =ASORT(a_iconfile)
    m.codedata=m.codedata+"* Start of null icon file list"+m.cr_lf
    FOR m.i = 1 TO m.iconfiles
      IF .NOT.EMPTY(a_iconfile(m.i))
        m.codedata=m.codedata+"DO "+LOWER(a_iconfile(m.i))+m.cr_lf
      ENDIF
    ENDFOR
    m.codedata=m.codedata+"* End of null icon file list"+m.cr_lf
  ENDIF
  RELEASE a_iconfile,m.iconfiles
  m.codedata=m.codedata+m.cr_lf+"* END dragover"+m.cr_lf
  IF m.match.OR.m.screens>1
    =insfnct(m.codedata)
  ENDIF
  IF .NOT.EMPTY(m.cleanupdata)
    LOCATE
    REPLACE PROCCODE WITH m.cleanupdata+m.cr_lf+PROCCODE
  ENDIF
  GOTO BOTTOM
  RETURN .T.
ENDIF
SCAN ALL FOR .NOT.DELETED()
  IF OBJTYPE=1.OR.OBJTYPE=6.OR.EMPTY(COMMENT).OR..NOT.drvobj().OR.;
     'dragevnt('$WHEN.OR..NOT.wordsearch(m.c_objdgdp)==m.null
    LOOP
  ENDIF
  m.vpos2=VPOS
  m.hpos2=HPOS
  m.height2=objheight()
  m.width2=objwidth()
  m.expr2=''
  m.dragmode=nobrackets(wordsearch(m.c_dragmode))
  m.dragdrop=nobrackets(wordsearch(m.c_dragdrop))
  m.dragover=nobrackets(wordsearch(m.c_dragover))
  m.dragenter=nobrackets(wordsearch(m.c_dragenter))
  m.dragwithin=nobrackets(wordsearch(m.c_dragwithin))
  m.dragleave=nobrackets(wordsearch(m.c_dragleave))
  m.overicon=nobrackets(wordsearch(m.c_overicon))
  m.overbutton=nobrackets(wordsearch(m.c_overbutton))
  IF m.dragdrop==m.null.AND.(.NOT.m.dragover==m.null.OR.;
                 .NOT.m.dragenter==m.null.OR..NOT.m.dragwithin==m.null.OR.;
                 .NOT.m.dragleave==m.null.OR..NOT.m.overicon==m.null.OR.;
                 .NOT.m.overbutton==m.null)
    REPLACE COMMENT WITH m.c_dragdrop+" *"+m.cr_lf+COMMENT
  ENDIF
  m.objarray=nobrackets(wordsearch(m.c_objarray))
  DO CASE
    CASE m.objarray==m.null
      m.objarray=''
    CASE EMPTY(m.objarray)
      m.objarray=SYS(2015)
      REPLACE COMMENT WITH m.c_objarray+' '+m.objarray+m.cr_lf+COMMENT
  ENDCASE
  m.objtxt=nobrackets(wordsearch(m.c_objtxt))
  IF m.objtxt==m.null
    m.objtxt=''
  ENDIF
  DO CASE
    CASE OBJTYPE#14.OR.m.overbutton==m.null
      m.overbutton=''
    CASE EMPTY(m.overbutton)
      m.overbutton=MLINE(NAME,1)
      IF EMPTY(WHEN)
        REPLACE WHENTYPE WITH 0, WHEN WITH ".F."
      ENDIF
  ENDCASE
  IF (_WINDOWS.OR._MAC).AND.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC')
    m.voffset=4
    IF OBJTYPE=17.AND..NOT.m.dragdrop==m.null.AND.;
       wordsearch(m.c_3d)==m.null.AND.wordsearch(m.c_no3d)==m.null
      REPLACE COMMENT WITH m.c_3d+' '+IIF(m.dragmode==m.null,'INSET','RAISED')+;
                           m.cr_lf+COMMENT
      =insblank(-1)
      m.vfactor=(8-2*(1-m.htfactor2))/m.htfactor*m.vfontratio*(SROWS()/SYSMETRIC(1))/m.htfactor
      m.hfactor=(16-2*(1-m.wdfactor2))/m.wdfactor*m.hfontratio*(SROWS()/SYSMETRIC(2))/m.wdfactor
      REPLACE OBJTYPE WITH 7, OBJCODE WITH 4,;
              VPOS WITH m.vpos2-m.vfactor, HPOS WITH m.hpos2-m.hfactor,;
              HEIGHT WITH m.height2+2*m.vfactor,;
              WIDTH WITH m.width2+2*m.hfactor,;
              PENSIZE WITH 1, PENPAT WITH 8,;
              COMMENT WITH m.c_3d+' '+IIF(m.dragmode==m.null,'1','-1')+' BOX'+stripcmnt()
      m.voffset=m.voffset+4
      SKIP
    ENDIF
    IF .NOT.EMPTY(m.objtxt)
      =insblank(-1)
      m.vfactor=m.voffset*m.vfontratio*(SROWS()/SYSMETRIC(1))/m.htfactor
      IF LEFT(m.objtxt,1)=='@'
        m.str_data=SUBSTR(m.objtxt,2)
        m.hfactor=m.hfontratio*TXTWIDTH(m.str_data,m.fontface,m.fontsize,;
                  m.cfontstylm)/(2*m.wdfactor)
        m.str_data=ALLTRIM(m.str_data)
        REPLACE OBJTYPE WITH 15, OBJCODE WITH 0, EXPR WITH m.str_data,;
                VPOS WITH m.vpos2+m.height2+m.vfactor,;
                HPOS WITH m.hpos2+m.width2/2-m.hfactor,;
                HEIGHT WITH 1, WIDTH WITH 2*m.hfactor,;
                FONTFACE WITH 'MS Sans Serif', FONTSTYLE WITH 0,;
                FONTSIZE WITH 8, MODE WITH 1,;
                COMMENT WITH m.c_no3d+stripcmnt(), REFRESH WITH .T.
      ELSE
        m.hfactor=m.hfontratio*TXTWIDTH(m.objtxt,m.fontface,m.fontsize,;
                  m.cfontstylm)/(2*m.wdfactor)
        REPLACE OBJTYPE WITH 5, EXPR WITH '"'+m.objtxt+'"',;
                VPOS WITH m.vpos2+m.height2+m.vfactor,;
                HPOS WITH m.hpos2+m.width2/2-m.hfactor,;
                HEIGHT WITH 1, WIDTH WITH m.hfactor,;
                FONTFACE WITH 'MS Sans Serif', FONTSTYLE WITH 0,;
                FONTSIZE WITH 8, MODE WITH 1,;
                COMMENT WITH m.c_no3d+stripcmnt()
      ENDIF
      SKIP
    ENDIF
  ENDIF
  IF m.dragmode==m.null.OR..NOT.wordsearch(m.c_click)==m.null
    LOOP
  ENDIF
  m.objmsg=nobrackets(wordsearch(m.c_objmsg))
  =updobjmsg()
  m.objclass=nobrackets(wordsearch(m.c_objclass))
  IF m.objclass==m.null
    m.objclass=''
  ENDIF
  IF EMPTY(m.objclass).AND..NOT.EMPTY(m.objarray)
    m.objclass='ARRAY'
  ENDIF
  m.dragicon=nobrackets(wordsearch(m.c_dragicon))
  IF m.dragicon==m.null
    IF OBJTYPE=17.AND..NOT.EMPTY(PICTURE)
      m.dragicon=FULLPATH(LEFT(SUBSTR(PICTURE,2),LEN(PICTURE)-2),m.fscxbase)
      IF EMPTY(m.dragicon)
        m.dragicon=m.expr2
      ELSE
        m.dragicon=LOWER(FULLPATH(m.dragicon,m.fscxbase))
      ENDIF
    ELSE
      m.dragicon=m.expr2
    ENDIF
  ENDIF
  m.icontxt=nobrackets(wordsearch(m.c_icontxt))
  IF m.icontxt==m.null
    m.icontxt=''
  ENDIF
  =updiconlst(m.dragicon)
  m.dblclick=fnctexpr(nobrackets(wordsearch(m.c_dblclick)))
  m.dragheight=nobrackets(wordsearch(m.c_dragheight))
  DO CASE
    CASE m.dragheight==m.null.OR.VAL(m.dragheight)<0
      m.dragheight='-1'
    CASE EMPTY(m.dragheight)
      m.dragheight=ALLTRIM(STR(objheight(),9,3))
  ENDCASE
  m.dragwidth=nobrackets(wordsearch(m.c_dragwidth))
  DO CASE
    CASE m.dragwidth==m.null.OR.VAL(m.dragwidth)<0
      m.dragwidth='-1'
    CASE EMPTY(m.dragwidth)
      m.dragwidth=ALLTRIM(STR(objwidth(),9,3))
  ENDCASE
  m.objheight=nobrackets(wordsearch(m.c_objheight))
  DO CASE
    CASE m.objheight==m.null.OR.VAL(m.objheight)<0
      m.objheight='0'
    CASE EMPTY(m.objheight)
      m.objheight=ALLTRIM(STR(objheight()/m.htfactor2,9,3))
    OTHERWISE
      m.objheight=ALLTRIM(STR(VAL(m.objheight)/m.htfactor2,9,3))
  ENDCASE
  m.objwidth=nobrackets(wordsearch(m.c_objwidth))
  DO CASE
    CASE m.objwidth==m.null.OR.VAL(m.objwidth)<0
      m.objwidth='0'
    CASE EMPTY(m.objwidth)
      m.objwidth=ALLTRIM(STR(objwidth()/m.wdfactor2,9,3))
    OTHERWISE
      m.objwidth=ALLTRIM(STR(VAL(m.objwidth)/m.wdfactor2,9,3))
  ENDCASE
  IF (_WINDOWS.OR._MAC).AND.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC').AND.;
     wordsearch(m.c_3d)==m.null.AND.wordsearch(m.c_no3d)==m.null
    IF OBJTYPE=5.AND.MODE=1
      REPLACE MODE WITH 0
    ENDIF
    REPLACE COMMENT WITH m.c_3d+' RAISED'+m.cr_lf+COMMENT
  ENDIF
  m.codedata="MDOWN().AND.BETWEEN(MROW(),"+ALLTRIM(STR(VPOS,9,3))+","+;
             ALLTRIM(STR(VPOS+m.height2,9,3))+").AND.BETWEEN(MCOL(),"+;
             ALLTRIM(STR(HPOS,9,3))+","+ALLTRIM(STR(HPOS+m.width2,9,3))+;
             ").AND."+"dragevnt(MWINDOW(),MROW(MWINDOW()),MCOL(MWINDOW()),"+;
             "SECONDS(),["+m.dragicon+"],["+m.objclass+"],["+m.objmsg+"],["+;
             m.objarray+"],["+m.dragmode+"],"+m.dragheight+","+m.dragwidth+;
             ","+ALLTRIM(STR(VPOS+m.height2/2,9,3))+","+;
             ALLTRIM(STR(HPOS+m.width2/2,9,3))+","+m.objheight+","+m.objwidth+;
             ","+ALLTRIM(STR(m.scxcount,2))+","+ALLTRIM(STR(m.scheme,2))+;
             ",["+m.dblclick+"],["+m.icontxt+"])"
  IF OBJTYPE=17.OR.OBJTYPE=5.OR.OBJTYPE=7.OR.(OBJTYPE=15.AND.OBJCODE=0)
    m.fontface2=FONTFACE
    m.fontstyle2=FONTSTYLE
    m.fontsize2=FONTSIZE
    m.codedata=m.codedata+".AND..F."
    m.r=RECNO()
    GOTO m.r_scxdata
    IF .NOT.insblank(-1)
      GOTO m.r
      LOOP
    ENDIF
    REPLACE VPOS WITH m.vpos2, HPOS WITH m.hpos2,;
            HEIGHT WITH m.height2, WIDTH WITH m.width2
    REPLACE OBJTYPE WITH 20, OBJCODE WITH 1,;
            NAME WITH 'm.null'+ALLTRIM(STR(RECNO(),6)), EXPR WITH '',;
            PICTURE WITH '"@*IHN "', FONTFACE WITH m.fontface,;
            FONTSTYLE WITH m.fontstyle, FONTSIZE WITH m.fontsize,;
            WHENTYPE WITH 0, WHEN WITH m.codedata,;
            INITIALVAL WITH '', INITIALNUM WITH 0,;
            COMMENT WITH m.c_no3d+m.cr_lf+m.c_objdgdp+stripcmnt()
    GOTO m.r
    SKIP
    REPLACE COMMENT WITH m.c_objdgdp+m.cr_lf+COMMENT
  ELSE
    DO CASE
      CASE EMPTY(WHEN)
        m.codedata=".NOT.("+m.codedata+")"
        REPLACE WHENTYPE WITH 0, WHEN WITH m.codedata
      CASE WHENTYPE=1
        m.codedata="IF "+m.codedata+m.cr_lf+"  RETURN .F."+m.cr_lf+"ENDIF"
        REPLACE WHEN WITH m.codedata+m.cr_lf+WHEN
      OTHERWISE
        m.codedata=".NOT.("+m.codedata+")"
        REPLACE WHEN WITH m.codedata+".AND."+WHEN
    ENDCASE
  ENDIF
ENDSCAN
GOTO BOTTOM
RETURN .T.

* END dragdrop



FUNCTION updobjmsg

IF m.objmsg==m.null
  m.objmsg=''
ENDIF
DO CASE
  CASE .NOT.EMPTY(m.objmsg)
    m.expr2=m.objmsg
  CASE OBJTYPE=17
    m.expr2=MLINE(PICTURE,1)
    IF LEFT(m.expr2,1)=='"'.AND.RIGHT(m.expr2,1)=='"'
      m.expr2=EVALUATE(m.expr2)
    ENDIF
    m.expr2=LOWER(ALLTRIM(FULLPATH(m.expr2,m.fscxbase)))
    IF m.drv_no<7
      REPLACE PICTURE WITH '"'+m.expr2+'"'
    ENDIF
  CASE OBJTYPE=5
    m.expr2=''
    FOR m.i = 1 TO MEMLINES(EXPR)
      m.expr2=m.expr2+MLINE(EXPR,m.i)
    ENDFOR
    m.expr2=ALLTRIM(EVALUATE(m.expr2))
  OTHERWISE
    m.expr2=ALLTRIM(MLINE(NAME,1))
    IF m.drv_no<7.AND..NOT.EMPTY(m.expr2)
      m.expr2='@'+m.expr2
    ENDIF
ENDCASE
IF EMPTY(m.objmsg)
  DO CASE
    CASE .NOT.EMPTY(m.objarray).AND..NOT.LEFT(m.objarray,1)=='_'
      m.objmsg=m.objarray
    CASE EMPTY(m.objtxt)
      m.objmsg=IIF(OBJTYPE=17,trimpath(m.expr2),m.expr2)
    OTHERWISE
      m.objmsg=m.objtxt
  ENDCASE
  IF EMPTY(m.objmsg)
    m.objmsg=SYS(2015)
    IF m.drv_no<7
      REPLACE COMMENT WITH m.c_objmsg+' '+m.objmsg+m.cr_lf+COMMENT
    ENDIF
  ENDIF
ENDIF
IF EMPTY(m.expr2)
  m.expr2=m.objmsg
ENDIF
RETURN .T.

* END updobjmsg



FUNCTION updiconlst
PARAMETERS m.iconfile
PRIVATE m.iconfile,m.fileext,m.updflag,m.at_pos,m.iconno,m.laststexct
PRIVATE m.animate,m.lowrange,m.highrange,m.iconmask,m.wildcard
PRIVATE m.ascflag,str_data

IF .NOT.m.iconlist
  RETURN .F.
ENDIF
m.iconfile=ALLTRIM(UPPER(m.iconfile))
m.animate=(ATC('animate(',m.iconfile)>0)
IF m.animate
  m.at_pos=ATC('animate(',m.iconfile)
  m.iconfile=SUBSTR(m.iconfile,m.at_pos+9)
  m.str_data=''
  m.at_pos=AT("'",m.iconfile)
  IF m.at_pos>0
    m.str_data=SUBSTR(m.iconfile,m.at_pos+1)
    m.iconfile=LEFT(m.iconfile,m.at_pos-1)
  ENDIF
  m.at_pos=AT('"',m.iconfile)
  IF m.at_pos>0
    m.str_data=SUBSTR(m.iconfile,m.at_pos+1)
    m.iconfile=LEFT(m.iconfile,m.at_pos-1)
  ENDIF
  m.iconfile=ALLTRIM(UPPER(m.iconfile))
  m.at_pos=AT(')',m.str_data)
  IF m.at_pos>0
    m.str_data=LEFT(m.str_data,m.at_pos-1)
  ENDIF
  m.str_data=ALLTRIM(UPPER(m.str_data))
ENDIF
m.fileext=UPPER(RIGHT(m.iconfile,4))
IF .NOT.m.fileext=='.BMP'.AND..NOT.m.fileext=='.ICO'
  RETURN .F.
ENDIF
IF m.animate.AND.'?'$m.iconfile
  m.at_pos=AT(',',m.str_data,2)
  IF m.at_pos=0
    RETURN .F.
  ENDIF
  m.lowrange=SUBSTR(m.str_data,m.at_pos+1)
  m.at_pos=AT(',',m.lowrange)
  IF m.at_pos=0
    RETURN .F.
  ENDIF
  m.iconmask=m.iconfile
  IF '??'$m.iconmask
    m.wildcard='??'
  ELSE
    m.wildcard='?'
  ENDIF
  m.highrange=SUBSTR(m.lowrange,m.at_pos+1)
  m.lowrange=LEFT(m.lowrange,m.at_pos-1)
  IF "'"$m.lowrange.OR.'"'$m.lowrange
    m.ascflag=.T.
    m.lowrange=ASC(SUBSTR(m.lowrange,2,1))
    m.highrange=ASC(SUBSTR(m.highrange,2,1))
  ELSE
    m.ascflag=.F.
    m.lowrange=VAL(m.lowrange)
    m.highrange=VAL(m.highrange)
  ENDIF
  IF m.lowrange>m.highrange
    m.iconno=m.lowrange
    m.lowrange=m.highrange
    m.highrange=m.iconno
  ENDIF
  FOR m.iconno = m.lowrange TO m.highrange
    IF m.ascflag
      m.iconfile=CHR(m.iconno)
    ELSE
      m.iconfile=ALLTRIM(STR(m.iconno,2))
      IF LEN(m.wildcard)>LEN(m.iconfile)
        m.iconfile=REPLICATE('0',LEN(m.wildcard)-LEN(m.iconfile))+m.iconfile
      ENDIF
    ENDIF
    m.iconfile=STRTRAN(m.iconmask,m.wildcard,m.iconfile,1,1)
    =updiconlst(m.iconfile)
  ENDFOR
  RETURN .T.
ENDIF
m.laststexct=SET('EXACT')
SET EXACT ON
IF TYPE('a_iconfile')#'C'
  PUBLIC a_iconfile(1)
  a_iconfile=''
ENDIF
IF TYPE('m.iconfiles')#'N'
  PUBLIC m.iconfiles
  m.iconfiles=0
ENDIF
IF EMPTY(m.iconfile).OR.ASCAN(a_iconfile,m.iconfile)>0
  m.updflag=.F.
ELSE
  m.updflag=.T.
  m.iconfiles=m.iconfiles+1
  DIMENSION a_iconfile(m.iconfiles)
  a_iconfile(m.iconfiles)=UPPER(m.iconfile)
ENDIF
IF m.laststexct=='ON'
  SET EXACT ON
ELSE
  SET EXACT OFF
ENDIF
RETURN m.updflag

* END updiconlst



FUNCTION fnctexpr
PARAMETERS fnctname

DO CASE
  CASE m.fnctname==m.null
    m.fnctname=''
  CASE .NOT.EMPTY(m.fnctname).AND..NOT.RIGHT(m.fnctname,1)==')'
    m.fnctname=m.fnctname+'()'
ENDCASE
RETURN m.fnctname

* END fnctexpr
