*
*                   DISCOUNTED CASH FLOW ANALYSIS
*
*-----------------------------------------------------------------------
*Copyright (C) 1987, Cliff Peterson and Associates, All Rights Reserved.
*-----------------------------------------------------------------------
*
*  Discounted cash flow analysis...  will figure the present value of a
*  number of annual payments.
*
*  "Interest Rate" gives you "Net Note", and "Desired Interest Rate"
*  gives you "Estimated Value".  That way, the seller of the note can
*  see its true present value (Net Note), and how a buyer's desired
*  interest rate will change its worth.
*
*  In other words, if I were to hold a note with a face interest rate of
*  ten percent with annual payments of $10,000 in each of the first
*  ten years, with a "balloon" payment of $100,000 in the eleventh
*  year, then my "Net Note" would be worth $ 96,495.06.  What does that
*  mean?  Well, if you hold that note to maturity, you would receive
*  ten percent return for your money.
*
*  Now, suppose you want to sell that note to another person.  Since
*  interest rates are down, you find an investor who is willing to make
*  eight percent.  Putting that in the "Desired Interest Rate" tells you
*  that the face value of the note would be $ 109,989.10.
*
*  See?  The face value of the note depends on the desired interest
*  rate, as applied to the payments and their positioning.
*
*  Cliff Peterson
*  (602) 435-8309
*
*
****************
* housekeeping *
****************
*
LAST_FIG  = " "
CURRINT   = 0              && Current interest rate
PROPOSINT = 0              && Proposed interest rate
PUBLIC DCURRENT, DPROPOSED && Accumulated present worths (rounded for display)
PUBLIC CURRENT, PROPOSED   && Accumulated present worths (no rounding)
DECLARE FLOW[25]           && Actual cash payments per year
DECLARE C[25]              && Present worth of payments at current rate
DECLARE P[25]              && Present worth of payments at proposed rate
AFILL(FLOW, 0)
AFILL(C, 0)
AFILL(P, 0)
SET KEY 27  TO KEYWORK
SET KEY 83  TO KEYWORK
SET KEY 115 TO KEYWORK
*
*************************
* build the base screen *
*************************
*
SET COLOR TO BG+/B,N/BG
CLEAR
@  9,  0  SAY REPL("",80)
@  9, 40  SAY ""
@ 10, 40  TO 22, 40
@  1, 25  SAY "Discounted Cash Flow Analysis"
@ 24, 16  SAY "Esc"
@ 24, 30  SAY "Shift-PrtSc"
@ 24, 53  SAY "S"
SET COLOR TO W/B,N/BG
@  2, 16  SAY "by Cliff Peterson and Associates, (602) 435-8309"
@ 24, 16  SAY "Esc - Quit    Shift-PrtSc - Print    S - Same"
@  5,  0  SAY "Interest Rate:"
@  5, 55  SAY "Net Note:"
@  7, 24  SAY "Desired Interest Rate:"
@  8, 24  SAY "Estimated Value:"
FOR A = 1 TO 25
    @ IF(A<13,A+10,A-3),IF(A<13,6,44) SAY "Year " + ALLTRIM(STR(A))
NEXT
*
**********************************************
* main loop - gather and display information *
**********************************************
*
*
* By the way, the character macro of "B" is required
* for the subscript of FLOW, since it is evaluated
* during the READ.  If "FLOW[A]" was used, all 25
* GETs would evaluate as 26, the value of A when
* READ is invoked.
*
DO WHILE .T.
    @  5, 15  GET  CURRINT     PICTURE "99.99" VALID CALC("C")
    @  7, 47  GET  PROPOSINT   PICTURE "99.99" VALID CALC("P")
    FOR A = 1 TO 25
        B = ALLTRIM(STR(A))
        @ IF(A<13,A+10,A-3),IF(A<13,27,65)  GET  FLOW[&B] PICTURE "99,999,999.99" VALID CALX(&B)
    NEXT
    READ
ENDDO
RETURN

*
*****************
PROCEDURE KEYWORK
*****************
*
* This procedure is called by the "SET KEY" commands.  27 is the
* <Esc> key, and forces the program to quit.  83 and 115 are upper-
* and lower-case "S", and fills the GET field with the last scanned
* value.  That way, you can "repeat" fields with few keystrokes.
* The second CASE disables this procedure for interest rate fields.
*

PARAMETERS CALL_PRG, LINE_NUM, INPUT_VAR
    DO CASE
        CASE LASTKEY() = 27
            SET COLOR TO
            CLEAR
            QUIT
        CASE INPUT_VAR = "CURRINT" .OR. INPUT_VAR = "PROPOSINT"
        OTHERWISE
            KEYBOARD LAST_FIG
    ENDCASE
RETURN

*************
FUNCTION CALC
*************
*
* This function is called as the two interest rates are passed.
* Since changing these numbers affects ALL payment calculations,
* all are recalculated for their present worth at the desired
* interest rate.  Then they are added together for the total.
*

PARAMETERS WHICHONE
    SET COLOR TO BG+/B,N/BG
    IF WHICHONE = "C"
        CURRENT  = 0
        FOR A = 1 TO 25
            C[A] =  (FLOW[A]/ ((1 + (CURRINT/100))**A))
            CURRENT = CURRENT + C[A]
        NEXT
        DCURRENT = ROUND(CURRENT,2)
        @  5, 65  SAY DCURRENT   PICTURE "999,999,999.99"
        KEYBOARD ""
    ELSE
        PROPOSED = 0
        FOR A = 1 TO 25
            P[A] =  (FLOW[A]/ ((1 + (PROPOSINT/100))**A))
            PROPOSED = PROPOSED + P[A]
        NEXT
        DPROPOSED = ROUND(PROPOSED,2)
        @  8, 41  SAY DPROPOSED  PICTURE "999,999,999.99"
    ENDIF
    SET COLOR TO W/B,N/BG
RETURN(.T.)

*
*************
FUNCTION CALX
*************
*
* As each payment is passed, only that payment's effect on the
* current note values is calculated.  It is then added into
* the value, and the old value is subtracted.
*
* The old payment amount is not saved, so the current net worth
* is calculated.  If it is the same as the stored amount, the
* rest of the routine is skipped.
*

PARAMETERS POS
    CURRCHNG  = (FLOW[POS] / ((1 + (CURRINT/100))**POS))
    IF CURRCHNG <> C[POS]
        CURRENT   = CURRENT - C[POS] + CURRCHNG
        DCURRENT  = ROUND(CURRENT,2)
        C[POS]    = CURRCHNG
        PROPCHNG  = (FLOW[POS] / ((1 + (PROPOSINT/100))**POS))
        PROPOSED  = PROPOSED - P[POS] + PROPCHNG
        DPROPOSED = ROUND(PROPOSED,2)
        P[POS]    = PROPCHNG
        SET COLOR TO BG+/B,N/BG
        @ 5, 65  SAY DCURRENT   PICTURE "999,999,999.99"
        @ 8, 41  SAY DPROPOSED  PICTURE "999,999,999.99"
        SET COLOR TO W/B,N/BG
        LAST_FIG = LTRIM(STR(FLOW[POS],13,2))
    ENDIF
RETURN(.T.)

