****** DBASE III PROGRAM FILE DFREQDOC.PRG. DOCUMENTATION FOR
****** dFREQ PROGRAM.
****** WRITTEN BY GARY GRIFFITH; SSA, OHR, DPPDR; 2/86. REVISED 5-6/86.
TEXT
                     dFREQ DOCUMENTATION FILE


     WHAT IS dFREQ?

     - "dFREQ" is a set of dBASE III program files which create
     frequency tables from dBASE data bases.  The user of dFREQ
     identifies the dBASE data base file (.dbf file) to use and the
     field or fields from which to generate frequencies.

     HOW DOES IT WORK?

     - dFREQ prompts the user for the .dbf file and field(s) to use.
     The program searches the named field(s) for unique occurrences of
     field data elements then lists them on screen to assist the user
     in determining data validity.  If the user opts to continue,
     dFREQ saves the data element names to a set(s) of memory
     variables.  This set(s) of memory variables is then used in a
     sequence of commands to count for each data element, or
     combination, in the named field(s).  The results of these count
     commands are stored in an additional set(s) of memory variables.
     The last set(s) of memory variables is used to output the
     frequency table in a form designated by the user.

ENDTEXT
WAIT
CLEAR
TEXT

     dFREQ FILES:

     - dFREQ files are:  1- dFREQ.PRG, 2- dFREQ1.PRG, 3- dFREQ2.PRG,
     4- dFREQDOC.PRG, and 5- dFREQ.DOC.  The first three are required.
     The fourth is recommended for on-line documentation and the fifth
     is a text file version of the documentation included for user's
     convenience.


     TYPES OF FREQUENCY TABLES:

     ONE-WAY:

     - dFREQ will create one-way frequency tables from fields with up
     to 99 unique data elements.  Percentages are calculated for each
     element total.  The percentages are rounded so that percentage
     totals may not equal 100%.  Also, due to variance in the
     character length of data elements, the table columns may not line
     up correctly.  Users are encouraged to save their tables to text
     files for any necessary "cleaning up."

ENDTEXT
WAIT
CLEAR
TEXT

     TWO-WAY:

     - dFREQ creates two-way frequency tables (or cross-tabulations)
     from fields with up to 40 unique data elements for the horizontal
     axis, and up to 99 unique data elements for the vertical axis of
     the table.  These data element limitations are set primarily due
     to the limitations dBASE III places on the use of memory
     variables (up to 256).  Consideration was also be given to
     practical limitations as well.  A two-way frequency table with 40
     elements by 99 elements will make 4356 separate counts, each
     requiring a separate pass through the data file.  Even with a
     small .dbf file, this will take a long time to complete.  Getting
     a usable printed copy of a 40 x 99 table will also be a problem.
     As a result, it's highly recommended that fields with a high
     number of unique data elements be grouped in some fashion prior
     to use with dFREQ.

     - Due to variance in the character length of data elements, the
     table columns may not line up correctly.  This is likely to occur
     when the character length of the data elements along the vertical
     axis is greater than 10.  Users are encouraged to save their
     tables to text files for "cleaning up."

ENDTEXT
WAIT
CLEAR
TEXT
     - In order to "get around" dBASE's memory variable ceiling, dFREQ
     saves and restores sets of memory variables created in the count
     sequence.  The .MEM files are named MR?.MEM and MR??.MEM, with
     the ?'s representing numbers 1 through 99.  The command "RUN DEL
     MR??.MEM" is executed at the end of the two-way output sequence.
     ALL FILES MEETING THIS SPECIFICATION WILL BE DELETED, including
     files created by the user independently of dFREQ. The user should
     move or rename any such files prior to running dFREQ.

     - Percentages and column/row totals are not calculated for the
     two-way tables.


     IMPORTANT NOTES:

     - Do not attempt to view the dFREQ programs in the DBASE word
     processor.  They were created elsewhere and are too large to be
     accommodated in the DBASE word processor.

     - Several output options are available to the user in dFREQ.  The
     frequency tables can be saved to a text file, printed, displayed
     or a combination of the three.  Additionally, the users can chose
     compressed or normal type for printed output.

ENDTEXT
WAIT
CLEAR
TEXT

     - Users are encouraged to make use of the text file creation
     option.  Once the frequency tables are stored in a text file,
     many enhancements/refinements can be made.  Data element-headings
     can be spelled out or changed, percentages can be added or
     deleted, text can be added, etc.  The user will find that some
     tables need to be "cleaned up," especially if they are intended
     for presentation.  Most word processors or text editors will
     allow the user to edit the text files created by dFREQ.  Another
     option is to import the text file into a spreadsheet program like
     LOTUS 123 for further calculations, special formatting or the
     creation of graphics.

     - dFREQ will do a count for a field data element even if the
     field is empty, i.e. a count for the number of blank field
     occurrences.  In the resulting table there will be a column or
     row with a blank heading.


ENDTEXT
WAIT
CLEAR
TEXT

     - dFREQ was designed to work with character fields only, as these
     are the fields from which frequency tabulations are most often
     required.  Numeric, date, logical and memo fields will not be
     processed and the program will bomb.  In the event that the user
     wants to do use one of these types of fields, the simplest
     solution is to convert to a character field prior to running
     dFREQ.  The program could also be modified to accept different
     field types.  Users are encouraged to make this modification if
     their needs require it.

     - Processing time will of course vary from application to
     application depending on hardware configuration, size of the .dbf
     file and the number of unique data elements in the field(s) used.
     Two-way tabulations will be especially time consuming to run
     when a high number of data elements occur in one or both of the
     fields.  Users are again encouraged to group data wherever
     possible prior to running dFREQ.  This will speed processing time
     and in many cases make the resulting data tabulations more
     meaningful.


ENDTEXT
WAIT
CLEAR
TEXT
     - The user must know the exact spelling of both the file name and
     field names or the program will bomb.  Also, the .dbf file must
     be on the same disk and in the same subdirectory as the dFREQ.PRG
     files.

     - This program is in the public domain.  Users are encouraged to
     use, modify, customize and copy the program as they see fit.  If
     improvements are made, please let me know.


     Contact:

                 Gary Griffith
                 Personnel Information Planning Staff
                 Office of Human Resources
                 Social Security Administration
                 6401 Security Blvd., 4120 Annex
                 Baltimore, Maryland  21235
                 Phone:  (301)597-5445 (data)


ENDTEXT
WAIT
CLEAR
RETURN