;**
;**	FileList -	A BRIEF 2.0 macro to allow the user to choose a file to
;**					edit from a menu.  First, the user is prompted for a
;**					File Spec., which may contain DOS wildcards.  Then, 
;**					the user is presented a menu of files which match
;**					the File Spec.
;**
;**	Copyright (C) 1989 Brian C. Cheetham
;**
;**		You may use and distribute this macro freely, provided:
;**			o	proper credit is given to the author (me)
;**			o	it is not sold, or distributed for a fee
;**

#include "dialog.h"
#define	SYSTEM	1						;** The value to use for system buffers

(macro filelist
	(
		(int			_file_list			;** temp buffer that contains list
						num_files			;** number of files in the list
						start_buf			;** buffer we started on
						lx					 	;** left of list box
						ty						;** top of list box
						rx						;** right of list box
						by						;** bottom of list box
						filesize				;** file size - not used
						filedate				;** file date - not used
						filetime				;** file time - not used
						fileattr				;** attribute of found file
		)
		(string		_file_name			;** file name of current match
						file_line			;** string to insert into temp buffer
						_pattern				;** wildcard pattern to search for
						_file_path			;** path name in '_pattern' to use
		)
		(global		_file_name			;** so that action macro can use it
						_pattern				;** so that get_pattern can use it
						_file_path			;** so that get_pattern can set it
		)

		(get_pattern)							;** dialog box to input pattern

		(if (== _pattern "")					;** i.e., if user ESCAPEd
			(return "")
		)

		(message "Creating file list...");** like buffers.m

		(= start_buf (inq_buffer))			;** save current buffer

;**
;**	Create the temp buffer as a "SYSTEM" type.  This little device
;**	allows the simulation of arrays.
;**

		(= _file_list (create_buffer "File List" NULL SYSTEM))
		(set_buffer _file_list)

;**
;**		This loop creates the file list, but exclude directories
;**

		(file_pattern _pattern)				;** find first match

		(while (find_file _file_name filesize filedate filetime fileattr)
			(
				(if (!= fileattr 0x10)		;** if "filename" is NOT a directory
					(
						(insert (lower _file_name))
						(insert "\n")
						(++ num_files)
						(message "Creating file list [#%d]..." num_files)
					)
				)
			)
		)
		(delete_line)							;** delete blank line from end of file

		(if (> num_files 1)					;** if there's more than one
			(
				(= _file_name "")				;** re-initialize
				(message "List created.")	;** again, a la buffers.m

;**
;**	Calculate top, bottom, left & right in order to 
;**	center the list horizontally & vertically
;**

				(= ty (+ 1 (/ (- 20 num_files) 2)))
				(if (< ty 1)					;** if > 1 screen of files
					(= ty 1)
				)
				(= by (- 23 ty))

				(= lx (/ (- 78 (strlen _pattern)) 2))
				(if (> lx 31)
					(= lx 31)
				)
				(= rx (+ 42 (- 39 lx)))

;**
;**	This calls BRIEF's Dialog Manager
;**

				(_process_menu lx by rx ty NULL _pattern NULL _file_list 
									"filelist_action" TRUE)
			)
		)

		(set_buffer start_buf)				;** restore buffer first
		(delete_buffer _file_list)			;** then delete temp buffer

		(if (== _file_name "")				;** i.e., if user ESCAPEd
			(
				(message "")
				(if (== num_files 0)
					(error "No files found for %s" _pattern)
				)
			)
		;else
			(
				(+= _file_path _file_name)	;** use path + filename
				(edit_file _file_path)		;** edit the file
				(message "File: %s" _file_path)
			)
		)
	)
)


;**
;** 	get user input of File Spec in a dialog box
;**

(macro get_pattern
	(
		(int	i									;** pointer
				x									;** dummy
		)

;**
;**	This calls BRIEF's Dialog Manager
;**

      (_process_dialog_box 10 13 60 11 "File Spec" "Get file specification"
									"filelist.box" NULL "pattern_action")

;**
;**	get the path from the entry (if one was entered)
;**

		(= _file_path "")						;** initialize

		(while (= i (> (search_string "\\" _pattern x 0) 0))
			(
				(+= _file_path (substr _pattern 1 i))
				(= _pattern (substr _pattern (++ i)))
			)
		)
		(= _pattern (+ _file_path _pattern))  ;** stick path back onto pattern
   )
)

;**
;**	this is the "action" macro for _process_dialog_box (above)
;**

(macro pattern_action
	(
		(int    event_type)
		(string  button_text)

		(get_parm 0 event_type)

		(switch event_type
			DIALOG_ESCAPE
				(
					(= _pattern "")			;** if ESCAPEd, blank out '_pattern'
				)
			DIALOG_F10							;** if user accepted input...
			DIALOG_ENTER_FIELD
			DIALOG_EXIT_FIELD
				(
					(get_parm 2 button_text)
					(= _pattern button_text);** 	save it to '_pattern'
				)
		)
		(return TRUE)
	)
)

;**
;**	this is the "action" macro passed in call to _process_menu (above)
;**

(macro filelist_action
   (
		(int		event_type)
      (string	button_text)

      (get_parm 0 event_type)

      (switch event_type
			DIALOG_PICK_MENU					;** user has picked a file
				(
					(get_parm 2 button_text)

					;**   fill global '_file_name' with picked file name

					(= _file_name button_text) ;** save file name
					(_dialog_esc)				;** terminate dialog box
				)
			DIALOG_ESCAPE
					;** do nothing
      )
		(return TRUE)
   )
)

