* 
* user selects report file to use,
* exit if no file was selected
* 
vc_RprtLFile = GETFILE("FRX","Select Report")
IF EMPTY(vc_RprtLFile)
	RETURN
ENDIF
WAIT WINDOW "Working, please wait" NOWAIT
vc_RprtSFile = SYS(2014,vc_RprtLFile,FULLPATH(vc_RprtLFile))
* 
* the variable TotalType in the report dbf contains
* a value indicating the type of calculation for
* a report variable.  the dbf RprtCalc is used to
* translate this value to text on the report
* 
USE RprtCalc ORDER TAG Calc IN SELECT(1)
* 
* the variable ResetTotal in the report dbf contains
* a value indicating when the report variable gets
* reset.  an array is created to translate this 
* value to the corresponding reset expression.
* 
* the first two elements of the array are the same
* for all reports as defined below, End of Report
* and End of Page. the third is not used (for now?)
* 
vn_AryCnt = 3
PUBLIC ac_DataGrp[vn_AryCnt]
ac_DataGrp[1] = "End of Report"
ac_DataGrp[2] = "End of Page"
ac_DataGrp[3] = "Unknown"
SELECT 0
USE (vc_RprtLFile)
GO TOP
* 
* user created data groupings are contained in the 
* report.dbf with ObjType of 9 and ObjCode of 3.
* the rest of the array is filled with expressions
* from these data groupings.
* 
DO WHILE NOT EOF()
	IF ObjType= 9 AND ObjCode = 3
		vn_AryCnt = vn_AryCnt + 1
		DIMENSION ac_DataGrp[vn_AryCnt]
		ac_DataGrp[vn_AryCnt] = Expr
	ENDIF
	SKIP
ENDDO
* 
* create cursor from selected report.dbf of report
* variable (ObjType = 18) and fields (ObjType = 8).
* natural order of report.dbf is order that 
* report variables are calculated
* 
*    Name       - name of variable
*    Expr       - report variable/field expression
*    Tag        - initial value
*    TotalType  - type of calculation
*    ResetTotal - when variable is reset
* 
SELECT ObjType,Name,Expr,Tag,TotalType,ResetTotal ;
	FROM (vc_RprtLFile);
	WHERE ObjType = 18 OR ObjType = 8;
	ORDER BY 1;
	INTO CURSOR Rprt
SELECT Rprt
* 
* exit if no report variables in selected report
* 
IF RECCOUNT() = 0
	WAIT WINDOW "No report variables/fields on report" NOWAIT 
	RETURN
ENDIF
* 
* create report header containing report selected,
* plus date and time
* 
vc_Header = "Report "+LEFT(vc_RprtSFile,AT(".",vc_RprtSFile)-1)+;
	" in "+LEFT(vc_RprtLFile,FndBkSlsh(vc_RprtLFile)-1)+;
	" as of "+DTOC(DATE())+" at "+LEFT(TIME(),5)
WAIT CLEAR
DO CASE
	CASE rn_OutWhere = 1
		REPORT FORM RprtInfo PREVIEW
	CASE rn_OutWhere = 2
		WAIT WINDOW "Printing report, please wait" NOWAIT
		REPORT FORM RprtInfo TO PRINT NOCONSOLE PDSETUP
		WAIT WINDOW "Printing complete" NOWAIT
	CASE rn_OutWHere = 3
		WAIT WINDOW "Printing report to file, please wait" NOWAIT
		REPORT FORM RprtInfo TO FILE (vc_File) NOCONSOLE
		WAIT WINDOW "Printing complete" NOWAIT
ENDCASE
CLOSE DATA
RETURN
*
* 
* Procedure: FndBkSlsh
* return first backslash from end of a string
* 
PROCEDURE FndBkSlsh
PARAMETERS rc_File
FOR I = LEN(ALLTRIM(rc_File)) TO 1 STEP -1
	IF SUBSTR(rc_File,I,1) = "\"
		EXIT
	ENDIF
ENDFOR
RETURN I
