******************************************************************
* dd.prg
* peter wagner
* 8/1/90
* 
* Requires : None
* Returns  : None
* Modifies : None
* Calls    : de.prg,pf.prg
* Called By: 
* Effects  : Creates menu for access to the data dictionary files
********************************************************************

parameter backcol,backcol2

clear windows
release menus
release popups
close all
on error do dderr with error()
set deleted ON
set sysmenu ON
set talk OFF
set clock off
set safety off

set function f10 to ''

on key
activate screen
bottomline=wrows()-1
confirmed=.t.
do case           && last line on the screen
   case sys(2006)="EGA/Color"
      set blink off
      back="w/b"
      set display to ega43
   case sys(2006)="VGA/Color"
      set blink off
      back="w/b"
      set display to ega43
   case sys(2006)="CGA/Color"
      back="w/b"
      set color to w/b
   otherwise 
      back="w/b"
endcase

if empty(backcol)
   backcol=back
   backcol2="w/b"
endif
set color to &backcol

   
      
activate screen
clear
do col_schm
@ 0,0
@ 0,28 say "Data Dictionary Toolkit"
* set color set to apr

dimension dd(8)
dd(1)="Browse Data \<Files"
dd(2)="Browse Data \<Elements"
dd(3)="Browse \<Index Files"
dd(4)="Browse \<Program Files"
dd(5)="Browse \<Memory Files"
dd(6)="\-"
dd(7)="\<Data Dic Maintenance"
dd(8)="\<Quit"

set border to single

do while .t.
   close databases   && in case left some open - sloppy, but...
   @ 6,15 MENU dd, 8 shadow
   read menu to choice
   do case
      case choice=0 .or. choice=6
         loop
      case choice=8
         exit
      case choice=7
         do ddutils
* restore these vars since the MEM util plays with memory and they get lost         
         dimension dd(8)
         dd(1)="Browse Data \<Files"
         dd(2)="Browse Data \<Elements"
         dd(3)="Browse \<Index Files"
         dd(4)="Browse \<Program Files"
         dd(5)="Browse \<Memory Files"
         dd(6)="\-"
         dd(7)="\<Data Dic Maintenance"
         dd(8)="\<Quit"
         confirmed=.t.
         bottomline=42
         backcol="w/b"
         backcol2="w/b"
      otherwise
         do ddbrow with choice
   endcase
enddo

close databases
set safety on
clear all
RETURN


******************************************************************
* ddbrow.prg
* peter wagner
* 8/1/90
* taken from brwsr.prg
* 
* Requires : None
* Returns  : None
* Modifies : 
* Calls    : 
* Called By: main.prg
* Effects  : Throws up a browse window so the user can easily peruse
*            all the records in the dictionary file.  Dialogue box allows
*            user to change the order of the data, seek specific
*            records, edit a record, add a record, or quit.  Parameter
*            determines which dictionary is being browsed.
********************************************************************

PROCEDURE DDBROW

parameter which

activate screen
save screen to start
set color to &backcol2
clear
do col_schm

@ 0,0 say replicate(chr(250),80) color scheme 24
@ 0,40 say replicate(chr(219),40) color scheme 2
@ 0,41 say "Select File:" color scheme 15
do case
   case which=1
      @ 0,14 say " DATA FILES " color scheme 23
      use df index df0 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif

      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='file :P="@!", briefdesc :38/h="Brief Description", records :5 /h="# Rec", updated, size :7, recsize :5 /h="RSize",dfupdate /h="DF Upd",readonly,lost save window brw title "Data Files"'
      thewin="Data Files"
      butt2=""
      butt3=""
      butt4="Find File"
      butt5=""
      prefix="df"
   case which=2
      @ 0,12 say " DATA ELEMENTS " color scheme 23
      use de index de0,de1 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='fieldname :H="Field Name" :P="@!", file /h="File" :P="@!", briefdesc :39 /h="Brief Description",type,length /h="Len",decimals /h="Dec",readonly,lost,deupdate /h="DE Upd" save window brw title "Data Elements"'
      thewin="Data Elements"
      butt2="Ordr Field"
      butt3="Ordr File"
      butt4="Find Field"
      butt5="Find File"
      prefix="de"
   case which=3
      @ 0,13 say " INDEX FILES " color scheme 23
      use id index id0,id1 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='indexname /h="Index Name" :P="@!", file /h="Data File" :P="@!", briefdesc :37 /h="Brief Description",size :5, updated,readonly,lost,idupdate /h="ID Upd" save window brw title "Index Files"'
      thewin="Index Files"
      butt2="Ordr Index"
      butt3="Ordr File"
      butt4="Find Index"
      butt5="Find File"
      prefix="id"
   case which=4
      @ 0,12 say " PROGRAM FILES " color scheme 23
      use pf index pf0,pf1 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='prgname /h="Program" :P="@!", Proc=iif(is_proc,"Proc",""), procname /h="Procedure" :P="@!", briefdesc :40 /h="Brief Description",updated,size,fxpsize,readonly,lost,pfupdate /h="PF Upd" save window brw title "Program Files"'
      thewin="Program Files"
      butt2="Ordr Prog"
      butt3="Ordr Proc"
      butt4="Find Prog"
      butt5="Find Proc"
      prefix="pf"
   case which=5
      @ 0,12 say " MEMORY FILES " color scheme 23
      use mf index mf0 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='memname /h="MEM File" :P="@!", briefdesc :40 /h="Brief Description", updated,size,readonly,lost,mfupdate /h="MF Upd" save window brw title "Memory Files"'
      thewin="Memory Files"
      butt2=""
      butt3=""
      butt4="Find File"
      butt5=""
      prefix="mf"
endcase

ulr=2
ulc=1
lrr=19
lrc=76

mbulr=22
mbulc=1
mblrr=40
mblrc=54
                    
define window buttons from 22,58 to 40,76 FLOAT GROW NOZOOM;
                    NOCLOSE SYSTEM SHADOW TITLE "Action"
define window edit from 1,1 to 1,15 NONE in window buttons color scheme 15
define window add from 3,1 to 3,15 NONE in window buttons color scheme 15
define window exit from 5,1 to 5,15 NONE in window buttons color scheme 15
define window ordfield from 7,1 to 7,15 NONE in window buttons color scheme 15
define window ordfile from 9,1 to 9,15 NONE in window buttons color scheme 15
define window fndfield from 11,1 to 11,15 NONE in window buttons color scheme 15
define window fndfile from 13,1 to 13,15 NONE in window buttons color scheme 15
define window fndkeys from 15,1 to 15,15 NONE in window buttons color scheme 15
define window dumbwind from 16,0 to 16,1 NONE in window buttons color scheme 15
define window df from 0,55 to 0,58 NONE color scheme 15
define window de from 0,60 to 0,63 NONE color scheme 15
define window id from 0,65 to 0,68 NONE color scheme 15
define window pf from 0,70 to 0,73 NONE color scheme 15
define window mf from 0,75 to 0,78 NONE color scheme 15
activate window df
@ 0,1 say "DF"
@ 0,1 say "D" color scheme 1
@ 0,0 say "" color scheme 19
@ 0,3 say "" color scheme 19
activate window de
@ 0,1 say "DE"
@ 0,2 say "E" color scheme 1
@ 0,0 say "" color scheme 19
@ 0,3 say "" color scheme 19
activate window id
@ 0,1 say "ID"
@ 0,1 say "I" color scheme 1
@ 0,0 say "" color scheme 19
@ 0,3 say "" color scheme 19
activate window pf
@ 0,1 say "PF"
@ 0,1 say "P" color scheme 1
@ 0,0 say "" color scheme 19
@ 0,3 say "" color scheme 19
activate window mf
@ 0,1 say "MF"
@ 0,1 say "M" color scheme 1
@ 0,0 say "" color scheme 19
@ 0,3 say "" color scheme 19
activate window buttons
activate window edit
@ 0,0 say "F10    > Edit"
@ 0,9 say "" color scheme 19
@ 0,14 say "" color scheme 19
activate window add
@ 0,0 say "F9     > Add "
@ 0,9 say "" color scheme 19
@ 0,14 say "" color scheme 19
activate window exit
@ 0,0 say "Escape > Exit"
@ 0,9 say "" color scheme 19
@ 0,14 say "" color scheme 19
if .not. empty(butt2)
   activate window ordfield
   @ 0,0 say "F2  "+butt2
   @ 0,3 say "" color scheme 19
   @ 0,14 say "" color scheme 19
endif
if .not. empty(butt3)
   activate window ordfile
   @ 0,0 say "F3  "+butt3
   @ 0,3 say "" color scheme 19
   @ 0,14 say "" color scheme 19
endif
activate window fndfield
@ 0,0 say "F4  "+butt4
@ 0,3 say "" color scheme 19
@ 0,14 say "" color scheme 19
if .not. empty(butt5)
   activate window fndfile
   @ 0,0 say "F5  "+butt5
   @ 0,3 say "" color scheme 19
   @ 0,14 say "" color scheme 19
endif
activate window fndkeys
@ 0,0 say "F6 Find Keys "
@ 0,3 say "" color scheme 19
@ 0,14 say "" color scheme 19
do while .t.
   keyboard chr(23)
   read
   action="NONE"
   on key label F9 do setaction with "ADD"
   on key label F2 do setaction with "F2"
   on key label F3 do setaction with "F3"
   on key label F4 do setaction with "F4"
   on key label F5 do setaction with "F5"
   on key label F6 do setaction with "F6"
   on key label rightmouse do setaction with "ENTER"
   on key label F10 do setaction with "ENTER"
   on key label ctrl-S do skipper with 1
   on key label ctrl-B do skipper with -1
   on key label ctrl-X do skipper with 10
   on key label ctrl-Z do skipper with -10
   * pew 4/2/92 - add on keys for accessing file menu at top of screen
   on key label ctrl-D do setaction with "DATAFILES"
   on key label ctrl-E do setaction with "DATAELEMENTS"
   on key label ctrl-I do setaction with "INDEXFILES"
   on key label ctrl-P do setaction with "PROGRAMFILES"
   on key label ctrl-M do setaction with "MEMORYFILES"
   
   
   activate window dumbwind
   
   define window brw from ulr,ulc to lrr,lrc FLOAT GROW ZOOM;
                     NOCLOSE SYSTEM SHADOW
   
   keyboard chr(29) && ctrl-home
   read

   define window membox from mbulr,mbulc to mblrr,mblrc FLOAT GROW ZOOM NOCLOSE SYSTEM SHADOW title "Long Description"
   modify memo longdesc save nowait window membox
   
   browse fields &whichbrow
   
*   release window brw
   
   on key
   
   if lastkey()=27 .or. lastkey()=23  && escape and ctrl-w
      action="ESCAPE"
   else
   
      if upper(wontop())="LONG DESCRIPTION"
         on key label ctrl-S do skipper with 1
         on key label ctrl-A do skipper with -1
         on key label ctrl-X do skipper with 10
         on key label ctrl-Z do skipper with -10
         modify memo longdesc save window membox
         on key
      endif
* resize the browse window      
      ulr=        WLROW(thewin)
      ulc=        WLCOL(thewin)
      lrr=ulr+    WROWS(thewin) - 1
      lrc=ulc+    WCOLS(thewin) - 1
      
      if wexist("Long Description")
         mbulr=        WLROW("Long Description")
         mbulc=        WLCOL("Long Description")
         mblrr=mbulr+    WROWS("Long Description")+1
         mblrc=mbulc+    WCOLS("Long Description")+1
      endif
      
   endif
   
   do case
      case wontop()="DF" .or. action="DATAFILES"
         activate window df
         @ 0,1 say "DF" color scheme 20
         ikcc=inkey(.1)
         @ 0,1 say "DF"
         @ 0,1 say "D" color scheme 1
         which=1
         do ddreset with which
      case wontop()="DE" .or. action="DATAELEMENTS"
         activate window de
         @ 0,1 say "DE" color scheme 20
         ikcc=inkey(.1)
         @ 0,1 say "DE"
         @ 0,2 say "E" color scheme 1
         which=2
         do ddreset with which
      case wontop()="ID" .or. action="INDEXFILES"
         activate window id
         @ 0,1 say "ID" color scheme 20
         ikcc=inkey(.1)
         @ 0,1 say "ID"
         @ 0,1 say "I" color scheme 1
         which=3
         do ddreset with which
      case wontop()="PF" .or. action="PROGRAMFILES"
         activate window pf
         @ 0,1 say "PF" color scheme 20
         ikcc=inkey(.1)
         @ 0,1 say "PF"
         @ 0,1 say "P" color scheme 1
         which=4
         do ddreset with which
      case wontop()="MF" .or. action="MEMORYFILES"
         activate window mf
         @ 0,1 say "MF" color scheme 20
         ikcc=inkey(.1)
         @ 0,1 say "MF"
         @ 0,1 say "M" color scheme 1
         which=5
         do ddreset with which
        
      case wontop()="EDIT" .or. action="ENTER"
         activate window edit
         @ 0,10 say "Edit" color scheme 20
         ikcc=inkey(.1)
         @ 0,10 say "Edit"
         do &prefix.rec with "EDIT"
      case wontop()="ADD" .or. action="ADD"
         activate window add
         @ 0,10 say "Add" color scheme 20
         ikcc=inkey(.1)
         @ 0,10 say "Add"
         do &prefix.rec with "ADD"
      case wontop()="EXIT" .or. action="ESCAPE"
         activate window exit
         @ 0,10 say "Exit" color scheme 20
         ikcc=inkey(.1)
         @ 0,10 say "Exit"
         exit
      case wontop()="ORDFIELD" .or. action="F2"
         activate window ordfield
         @ 0,4 say butt2 color scheme 20
         ikcc=inkey(.1)
         @ 0,4 say butt2
         set order to 1
      case wontop()="ORDFILE" .or. action="F3"
         activate window ordfile
         @ 0,4 say butt3 color scheme 20
         ikcc=inkey(.1)
         @ 0,4 say butt3
         set order to 2
      case wontop()="FNDFIELD" .or. action="F4"
         activate window fndfield
         @ 0,4 say butt4 color scheme 20
         ikcc=inkey(.1)
         @ 0,4 say butt4
         set order to 1
         do &prefix.fnd1
      case wontop()="FNDFILE" .or. action="F5"
         activate window fndfile
         @ 0,4 say butt5 color scheme 20
         ikcc=inkey(.1)
         @ 0,4 say butt5
         set order to 2
         do &prefix.fnd2
      case wontop()="FNDKEYS" .or. action="F6"
         activate window fndkeys
         @ 0,4 say "Find Keys" color scheme 20
         ikcc=inkey(.1)
         @ 0,4 say "Find Keys"
         set order to 1
         do fndkey
   endcase
enddo

release windows buttons,df,de,pf,id,mf
if wexist(thewin)
   release window &thewin
endif
if wexist("brw")
   release window brw
endif
release window long description

activate screen
restore screen from start
* @ 0,33 say "      " color scheme 22

RETURN

*****************************************************************

******************************************************************
* skipper.prg
* peter wagner
* 8/23/90
* 
* Requires : # recs to skip
* Returns  : None
* Modifies : record pointer
* Calls    : None
* Called By: ddbrow.prg
* Effects  : skips in active file by amount specified by NO_SKIPS
********************************************************************

PROCEDURE SKIPPER
   parameter no_skips
   
   private i
   
   i=0
   if no_skips>0
      do while i<no_skips .and. .not. eof()
         skip
         i=i+1
      enddo
   else
      do while i>no_skips .and. .not. bof()
         skip -1
         i=i-1
      enddo
   endif
   if eof()
      go bottom
   endif
RETURN
********************************************************************

******************************************************************
* ddreset.prg
* peter wagner
* 8/1/90
* taken from brwsr.prg
* 
* Requires : None
* Returns  : None
* Modifies : 
* Calls    : 
* Called By: main.prg
* Effects  : Switches the Browse window to another file
********************************************************************

PROCEDURE DDRESET

parameter which

activate screen

@ 0,0 say replicate(chr(250),80) color scheme 24
@ 0,40 say replicate(chr(219),40) color scheme 2
@ 0,41 say "Select File:" color scheme 19
do case
   case which=1
      @ 0,14 say " DATA FILES " color scheme 23
      use df index df0 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='file :P="@!", briefdesc :38/h="Brief Description", records :5 /h="# Rec", updated, size :7, recsize :5 /h="RSize",dfupdate /h="DF Upd",readonly,lost save window brw title "Data Files"'
      thewin="Data Files"
      butt2=""
      butt3=""
      butt4="Find File"
      butt5=""
      prefix="df"
   case which=2
      @ 0,12 say " DATA ELEMENTS " color scheme 23
      use de index de0,de1 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='fieldname :H="Field Name" :P="@!", file /h="File" :P="@!", briefdesc :39 /h="Brief Description",type,length /h="Len",decimals /h="Dec",readonly,lost,deupdate /h="DE Upd" save window brw title "Data Elements"'
      thewin="Data Elements"
      butt2="Ordr Field"
      butt3="Ordr File"
      butt4="Find Field"
      butt5="Find File"
      prefix="de"
   case which=3
      @ 0,13 say " INDEX FILES " color scheme 23
      use id index id0,id1 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='indexname /h="Index Name" :P="@!", file /h="Data File" :P="@!", briefdesc :37 /h="Brief Description",size :5, updated,readonly,lost,idupdate /h="ID Upd" save window brw title "Index Files"'
      thewin="Index Files"
      butt2="Ordr Index"
      butt3="Ordr File"
      butt4="Find Index"
      butt5="Find File"
      prefix="id"
   case which=4
      @ 0,12 say " PROGRAM FILES " color scheme 23
      use pf index pf0,pf1 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='prgname /h="Program" :P="@!", Proc=iif(is_proc,"Proc",""), procname /h="Procedure" :P="@!", briefdesc :40 /h="Brief Description",updated,size,fxpsize,readonly,lost,pfupdate /h="PF Upd" save window brw title "Program Files"'
      thewin="Program Files"
      butt2="Ordr Prog"
      butt3="Ordr Proc"
      butt4="Find Prog"
      butt5="Find Proc"
      prefix="pf"
   case which=5
      @ 0,12 say " MEMORY FILES " color scheme 23
      use mf index mf0 exclusive
      if .not. confirmed
         activate screen
         do box with 8,25,12,55,0,"n","w+","bg",1
         @ 9,27 say "DF.DBF not available..."
         =inkey(3)
         RETURN
      endif
      @ 0,col()+3 say "<"+ltrim(str(reccount()))+">" color scheme 24
      whichbrow='memname /h="MEM File" :P="@!", briefdesc :40 /h="Brief Description", updated,size,readonly,lost,mfupdate /h="MF Upd" save window brw title "Memory Files"'
      thewin="Memory Files"
      butt2=""
      butt3=""
      butt4="Find File"
      butt5=""
      prefix="mf"
endcase


activate window ordfield
clear
if .not. empty(butt2)
   @ 0,0 say "F2  "+butt2
   @ 0,3 say "" color scheme 19
   @ 0,14 say "" color scheme 19
endif

activate window ordfile
clear
if .not. empty(butt3)
   @ 0,0 say "F3  "+butt3
   @ 0,3 say "" color scheme 19
   @ 0,14 say "" color scheme 19
endif

activate window fndfield
clear
@ 0,0 say "F4  "+butt4
@ 0,3 say "" color scheme 19
@ 0,14 say "" color scheme 19

activate window fndfile
clear
if .not. empty(butt5)
   @ 0,0 say "F5  "+butt5
   @ 0,3 say "" color scheme 19
   @ 0,14 say "" color scheme 19
endif


RETURN

*****************************************************************



*****************************************************************
* setaction.prg
* peter wagner
* 7/9/90
*
* Requires : string designating key pressed
* Returns  : None
* Modifies : variable ACTION which is already defined
* Calls    : None
* Procedure: None
* Called By: ddbrow
* Effects  : allows program to interpret special keys instead of
*            relying on the mouse
*****************************************************************
PROCEDURE SETACTION
   parameter act
   
   action=act
   if action<>"ESCAPE"
      activate window buttons
   endif
RETURN
*****************************************************************


*****************************************************************
* fndkey.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by key words
*            
*****************************************************************
PROCEDURE FNDKEY
   keys=space(20)
   define window prompt from 10,15 to 14,65 system shadow
   define window next from 1,1 to 1,15 NONE in window buttons color scheme 15
   define window done from 3,1 to 3,15 NONE in window buttons color scheme 15
   activate window prompt
   @ 1,2 say "Enter Key Words to find:" get keys
   read
   release window prompt
   rc=recno()
   set exact off
   go top
   locate for upper(trim(keys))$upper(longdesc)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
      yesfound=.f.
   else
      hide windows edit,add,exit,ordfile,ordfield,fndfile,fndfield,fndkeys
      activate window next
      @ 0,1 say "Locate Next" color scheme 15
      @ 0,0 say chr(174) color scheme 19
      @ 0,12 say chr(175) color scheme 19
      activate window done
      @ 0,1 say "Done" color scheme 15
      @ 0,0 say chr(174) color scheme 19
      @ 0,5 say chr(175) color scheme 19
      activate window dumbwind
      yesfound=.t.
   endif
   do while yesfound
*      do &prefix.edrec
*      brwrec=recno()
      browse fields &whichbrow
      if upper(wontop())="NEXT"
*         go brwrec
         continue
         if found()
            yesfound=.t.
         else
            yesfound=.f.
         endif
      else
         if upper(wontop())="DONE"
            exit
         endif
      endif
   enddo
   release windows next,done
   show windows edit,add,exit,ordfile,ordfield,fndfile,fndfield,fndkeys
   
RETURN
*****************************************************************


*************************************************************************
*************************************************************************
*
* * * Data Element branch of Data Dictionary Module
* 
*************************************************************************
*************************************************************************


*****************************************************************
* defnd1.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by fieldname
*            
*****************************************************************
PROCEDURE DEFND1
   fldnm=space(10)
   define window prompt from 10,20 to 14,60 system shadow
   activate window prompt
   @ 1,2 say "Enter Field Name to find:" get fldnm func '!'
   read
   rc=recno()
   set exact off
   set order to 1
   seek trim(fldnm)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
   endif
   release window prompt
RETURN
*****************************************************************

*****************************************************************
* defnd2.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by file name
*            
*****************************************************************
PROCEDURE DEFND2
   flnm=space(8)
   define window prompt from 10,20 to 14,60 system shadow
   activate window prompt
   @ 1,2 say "Enter File Name to find:" get flnm func '!'
   read
   rc=recno()
   set exact off
   set order to 2
   seek trim(flnm)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
   endif
   release window prompt
RETURN
*****************************************************************

*****************************************************************
* derec.prg
* peter wagner
* 8/1/90
*
* Requires : Record pointer positioned on record to be edited
* Returns  : None
* Modifies : Current Record
* Calls    : None
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to Add new record or edit current record
*            depending on mode
*            
*****************************************************************
PROCEDURE DEREC

   parameter mode
   
   define window edrec from 8,10 to 24,70 system shadow float
   activate window edrec
   if mode="ADD"
      append blank
      title="Add Data Element Record"
   else
      title="Edit Data Element Record"
   endif
   do while .t.
      @ 0,17 say title color scheme 15
      @ 2,2 say "Field Name:" get fieldname func "!"
      @ 2,27 say "File Name: " get file func "!"
      @ 4,2 say "Brief Description:"
      @ 5,2 get briefdesc
      @ 7,2 say "Long Description:" get longdesc
      @ 9,2 say "Type:" get type
      @ 9,17 say "Length:" get length
      @ 9,32 say "Decimals:" get decimals
      @ 11,2 say "ReadOnly:" get readonly
      @ 11,17 say "Lost:" get lost
      @ 11,40 say "DE Upd: " + dtoc(deupdate) color scheme 24
      @ 13,15 say "Press F10 or <Escape> to exit" color scheme 19
      read
      if readkey()=14 .or. readkey()=270 .or. readkey()=12 .or. readkey()=268 .or. wontop()<>"EDREC"
         exit
      endif
   enddo
   release window edrec
RETURN
*****************************************************************




*************************************************************************
*************************************************************************
*
* * * Program File branch of Data Dictionary Module
* 
*************************************************************************
*************************************************************************



*****************************************************************
* pffnd2.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by px1 name
*            
*****************************************************************
PROCEDURE PFFND2
   procnm=space(8)
   define window prompt from 10,20 to 14,60 system shadow
   activate window prompt
   @ 1,2 say "Enter Procedure to find:" get procnm func '!'
   read
   rc=recno()
   set exact off
   set order to 2
   seek trim(procnm)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
   endif
   release window prompt
RETURN
*****************************************************************

*****************************************************************
* pf1.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by program file name
*            
*****************************************************************
PROCEDURE PFFND1
   flnm=space(8)
   define window prompt from 10,20 to 14,60 system shadow
   activate window prompt
   @ 1,2 say "Enter Program Name to find:" get flnm func '!'
   read
   rc=recno()
   set exact off
   set order to 1
   seek trim(flnm)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
   endif
   release window prompt
RETURN
*****************************************************************

*****************************************************************
* pfrec.prg
* peter wagner
* 8/1/90
*
* Requires : Record pointer positioned on record to be edited
* Returns  : None
* Modifies : Current Record
* Calls    : None
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to Add new record or edit current record
*            depending on mode
*            
*****************************************************************
PROCEDURE PFREC

   parameter mode
   
   define window edrec from 8,10 to 24,70 system shadow float
   activate window edrec
   if mode="ADD"
      append blank
      title="Add Program File Record"
   else
      title="Edit Program File Record"
   endif
   do while .t.
   
   
      @ 0,17 say title color scheme 15
      @ 2,2 say "Program Name:  " get prgname func "!"
      @ 2,30 say "Procedure Name:" get procname func "!"
      @ 4,2 say "Brief Description:"
      @ 5,2 get briefdesc
      @ 7,2 say "Long Description:" get longdesc
      @ 9,2 say "Updated:" get updated
      @ 9,22 say "Size:" get size
      @ 9,37 say "FXP Size:" get fxpsize
      @ 11,2 say "ReadOnly:" get readonly
      @ 11,22 say "Lost:" get lost
      @ 11,40 say "PF Upd: " + dtoc(pfupdate) color scheme 24
      @ 13,15 say "Press F10 or <Escape> to exit" color scheme 19

      read
      if readkey()=14 .or. readkey()=270 .or. readkey()=12 .or. readkey()=268 .or. wontop()<>"EDREC"
         exit
      endif
   enddo
   release window edrec
RETURN
*****************************************************************



*************************************************************************
*************************************************************************
*
* * * Data File branch of Data Dictionary Module
* 
*************************************************************************
*************************************************************************



*****************************************************************
* df1.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by data file name
*            
*****************************************************************
PROCEDURE DFFND1
   flnm=space(8)
   define window prompt from 10,18 to 14,62 system shadow
   activate window prompt
   @ 1,2 say "Enter Data File Name to find:" get flnm func '!'
   read
   rc=recno()
   set exact off
   set order to 1
   seek trim(flnm)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
   endif
   release window prompt
RETURN
*****************************************************************

*****************************************************************
* dfrec.prg
* peter wagner
* 8/1/90
*
* Requires : Record pointer positioned on record to be edited
* Returns  : None
* Modifies : Current Record
* Calls    : None
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to Add new record or edit current record
*            depending on mode
*            
*****************************************************************
PROCEDURE DFREC

   parameter mode
   
   define window edrec from 8,10 to 26,70 system shadow float
   activate window edrec
   
   if mode="ADD"
      append blank
      title="Add Data File Record"
   else
      title="Edit Data File Record"
   endif
   
   do while .t.
      
      
      @ 0,18 say title color scheme 15
      @ 2,2 say "Data File Name:" get file func "!"
      @ 4,2 say "Brief Description:"
      @ 5,2 get briefdesc
      @ 7,2 say "Long Description:" get longdesc
      @ 9,2 say "Updated:" get updated
      @ 9,22 say "Size:" get size
      @ 11,2 say "Rec Size:" get recsize
      @ 11,22 say "# Recs:" get records
      @ 13,2 say "ReadOnly:" get readonly
      @ 13,22 say "Lost:" get lost
      @ 13,40 say "DF Upd: " + dtoc(dfupdate) color scheme 24
      @ 15,15 say "Press F10 or <Escape> to exit" color scheme 19
      
      read
      if readkey()=14 .or. readkey()=270 .or. readkey()=12 .or. readkey()=268 .or. wontop()<>"EDREC"
         exit
      endif
   enddo
   release window edrec
RETURN
*****************************************************************



*************************************************************************
*************************************************************************
*
* * * Index File branch of Data Dictionary Module
* 
*************************************************************************
*************************************************************************



*****************************************************************
* iffnd2.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by px1 name
*            
*****************************************************************
PROCEDURE IDFND2
   filenm=space(8)
   define window prompt from 10,18 to 14,62 system shadow
   activate window prompt
   @ 1,2 say "Enter Data File Name to find:" get filenm func '!'
   read
   rc=recno()
   set exact off
   set order to 2
   seek trim(filenm)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
   endif
   release window prompt
RETURN
*****************************************************************

*****************************************************************
* if1.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by program file name
*            
*****************************************************************
PROCEDURE IDFND1
   flnm=space(8)
   define window prompt from 10,18 to 14,62 system shadow
   activate window prompt
   @ 1,2 say "Enter Index File Name to find:" get flnm func '!'
   read
   rc=recno()
   set exact off
   set order to 1
   seek trim(flnm)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
   endif
   release window prompt
RETURN
*****************************************************************

*****************************************************************
* idrec.prg
* peter wagner
* 8/1/90
*
* Requires : Record pointer positioned on record to be edited
* Returns  : None
* Modifies : Current Record
* Calls    : None
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to Add new record or edit current record
*            depending on mode
*            
*****************************************************************
PROCEDURE IDREC

   parameter mode
   
   define window edrec from 8,10 to 24,70 system shadow float
   activate window edrec
   if mode="ADD"
      append blank
      title="Add Index File Record"
   else
      title="Edit Index File Record"
   endif
   do while .t.
   
   
      @ 0,18 say title color scheme 15
      @ 2,2 say "Index File Name:" get indexname func "!"
      @ 2,30 say "Data File Name: " get file func "!"
      @ 4,2 say "Brief Description:"
      @ 5,2 get briefdesc
      @ 7,2 say "Long Description:" get longdesc
      @ 9,2 say "Updated:" get updated
      @ 9,22 say "Size:" get size
      @ 11,2 say "ReadOnly:" get readonly
      @ 11,22 say "Lost:" get lost
      @ 11,40 say "ID Upd: " + dtoc(idupdate) color scheme 24
      @ 13,15 say "Press F10 or <Escape> to exit" color scheme 19

      read
      if readkey()=14 .or. readkey()=270 .or. readkey()=12 .or. readkey()=268 .or. wontop()<>"EDREC"
         exit
      endif
   enddo
   release window edrec
RETURN
*****************************************************************



*************************************************************************
*************************************************************************
*
* * * Memory File branch of Data Dictionary Module
* 
*************************************************************************
*************************************************************************



*****************************************************************
* mf1.prg
* peter wagner
* 8/1/90
*
* Requires : None
* Returns  : None
* Modifies : Repositions record pointer
* Calls    : errmess
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to find a record by data file name
*            
*****************************************************************
PROCEDURE MFFND1
   flnm=space(8)
   define window prompt from 10,18 to 14,62 system shadow
   activate window prompt
   @ 1,2 say "Enter MEM File Name to find:" get flnm func '!'
   read
   rc=recno()
   set exact off
   set order to 1
   seek trim(flnm)
   if .not. found()
      do errmess with "Not found",1,0
      go rc
   endif
   release window prompt
RETURN
*****************************************************************

*****************************************************************
* mfrec.prg
* peter wagner
* 8/1/90
*
* Requires : Record pointer positioned on record to be edited
* Returns  : None
* Modifies : Current Record
* Calls    : None
* Procedure: None
* Called By: ddbrow
* Effects  : Allows user to Add new record or edit current record
*            depending on mode
*            
*****************************************************************
PROCEDURE MFREC

   parameter mode
   
   define window edrec from 8,10 to 24,70 system shadow float
   activate window edrec
   if mode="ADD"
      append blank
      title="Add Memory File Record"
   else
      title="Edit Memory File Record"
   endif
   do while .t.
   
   
      @ 0,17 say title color scheme 15
      @ 2,2 say "MEM File Name:" get memname func "!"
      @ 4,2 say "Brief Description:"
      @ 5,2 get briefdesc
      @ 7,2 say "Long Description:" get longdesc
      @ 9,2 say "Updated:" get updated
      @ 9,22 say "Size:" get size
      @ 11,2 say "ReadOnly:" get readonly
      @ 11,22 say "Lost:" get lost
      @ 11,40 say "MF Upd: " + dtoc(mfupdate) color scheme 24
      @ 13,15 say "Press F10 or <Escape> to exit" color scheme 19
   
      read
      if readkey()=14 .or. readkey()=270 .or. readkey()=12 .or. readkey()=268 .or. wontop()<>"EDREC"
         exit
      endif
   enddo
   release window edrec
RETURN
*****************************************************************



*****************************************************************
* col_schm.prg
* peter kodzis
* 7/29/90
*
* Requires : None
* Returns  : None
* Modifies : Color set
* Calls    : None
* Procedure: None
* Called By: Main
* Effects  : Sets all the colors
*****************************************************************

PROCEDURE COL_SCHM

set color of scheme(1)  to W+/BG,W+/B,W+/W,N/W,N/W,W/B,N+/W,N+/N,GR+/B,R+/B,+
set color of scheme(2)  to BG/W,N/W,N/W,N/W,N/W,N/BG,W+/W,N+/N,B/W,W/N,+
set color of scheme(3)  to BG/W,N/W,BG/N,BG/N,BG/N,N/BG,W+/W,N+/N,BG/N,BG/N,+
set color of scheme(4)  to BG/W,N/W,N/W,B/W,W/N,N/BG,W+/W,N+/N,B/W,W/N,+
set color of scheme(5)  to W+/RB,W+/BG,W+/RB,W+/RB,W/RB,W+/B,GR+/RB,N+/N,W+/RB,W/RB,+
set color of scheme(6)  to W/BG,W+/BG,W+/RB,W+/RB,W/RB,W+/B,GR+/RB,N+/N,W+/RB,W/RB,+
set color of scheme(7)  to GR+/R,W+/W,GR+/R,W+/R,W/R,W+/N,GR+/R,N+/N,W+/R,W/R,+
set color of scheme(8)  to W+/BG,W+/W,GR+/W,GR+/W,N+/W,W+/GR,BG+/BG,N+/N,B/BG,W/BG,+
set color of scheme(9)  to W/BG,W+/BG,B/BG,GR+/W,N+/W,W+/GR,W+/B,N+/N,GR+/W,N+/W,+
set color of scheme(10) to W+/BG,GR+/B,GR+/W,GR+/W,N+/W,GR+/GR,W+/B,N+/N,GR+/W,N+/W,+
set color of scheme(11) to W+/BG,W+/W,GR+/W,GR+/W,N+/W,W+/GR,W/B,N+/N,W+/B,W/BG,+
set color of scheme(12) to GR+/RB,W+/B,N+/W,N/W,N/W,W/B,N+/W,N+/N,GR+/B,R+/B,+
set color of scheme(13) to W+/B,W+/BG,GR+/B,GR+/B,R+/B,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(14) to W+/BG,W+/N,W+/BG,W+/BG,N/BG,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(15) to GR+/BG,W+/BG,W+/B,W+/B,W+/B,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(16) to W+/B,W+/BG,W+/B,W+/B,W+/B,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(17) to W+/BG,W+/N,W+/W,GR+/W,N+/W,W+/GR,W+/B,N+/N,GR+/B,R+/B,+
set color of scheme(18) to W+/R,W+/BG,GR+/B,GR+/B,R+/B,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(19) to N/BG,W+/BG,GR+/B,GR+/B,R+/B,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(20) to W+/N,W+/BG,GR+/B,GR+/B,R+/B,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(21) to W/R,W+/BG,GR+/B,GR+/B,R+/B,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(22) to N/W,W+/BG,B/R,W+/R,N+/R,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(23) to W+/W,W+/BG,GR+/B,GR+/B,R+/B,W+/GR,GR+/RB,N+/N,GR+/B,R+/B,+
set color of scheme(24) to n/w,N/W,W/W,N+/W,N+/W,N+/W,GR+/RB,N+/N,GR+/B,R+/B,+


******************************************************************
* ddutils.prg
* peter wagner
* 8/6/90
* 
* Requires : None
* Returns  : None
* Modifies : None
* Calls    : ddreind
* Called By: dd
* Effects  : Creates menu for access to the data dictionary utilities
********************************************************************

PROCEDURE DDUTILS


do while .t.
   close databases
* intitialize in loop since mfupd causes these vars to be lost
   dimension ddutils(12)
   ddutils(1)="Update \<Data Files"
   ddutils(2)="Update Data \<Elements"
   ddutils(3)="Update \<Index Files"
   ddutils(4)="Update \<Prg Files"
   ddutils(5)="Update \<Mem Files"
   ddutils(6)="\-"
   ddutils(7)="\<Set Search Paths"
   ddutils(8)="Delete \<Lost Records"
   ddutils(9)="Pack & \<Reindex DD Files"
   ddutils(10)="\<Zap all DD Files"
   ddutils(11)="\-"
   ddutils(12)="Pre\<vious Menu"
   @ 6,15 MENU ddutils, 12 shadow
   read menu to choice2
   do case
      case choice2=0 .or. choice2=12
         exit
      case choice2=1
         do dfupd
      case choice2=2
         do deupd
      case choice2=3
         do idupd
      case choice2=4
         do pfupd
      case choice2=5
         do mfupd
      case choice2=7
         do getpath
      case choice2=8
         do dellost
      case choice2=9
         do ddreind
      case choice2=10
         do clearall
   endcase
enddo

RETURN
******************************************************************


******************************************************************
* ddreind.prg
* peter wagner
* 8/6/90
* 
* Requires : None
* Returns  : None
* Modifies : All DD index files
* Calls    : None
* Called By: ddutils
* Effects  : Reindexes all DD index files
********************************************************************

PROCEDURE DDREIND

   activate screen
   set color to w+/b
   save screen to rndx
   @ 0,0 say "Reindexing..."
   set talk on

   @ 2,0 say "Data Elements"
   use de exclusive
   copy to x for .not. deleted()
   use
   set talk off
   erase de.dbf
   erase de.fpt
   set talk on
   rename x.dbf to de.dbf
   rename x.fpt to de.fpt
   use de exclusive
   index on fieldname to de0
   index on file+fieldname to de1

   @ row()+2,0 say "Data Files"
   use df exclusive
   copy to x for .not. deleted()
   use
   set talk off
   erase df.dbf
   erase df.fpt
   set talk on
   rename x.dbf to df.dbf
   rename x.fpt to df.fpt
   use df exclusive
   index on file to df0

   @ row()+2,0 say "Index Files"
   use id exclusive
   copy to x for .not. deleted()
   use
   set talk off
   erase id.dbf
   erase id.fpt
   set talk on
   rename x.dbf to id.dbf
   rename x.fpt to id.fpt
   use id exclusive
   index on indexname to id0
   index on file to id1

   @ row()+2,0 say "Program Files"
   use pf exclusive
   copy to x for .not. deleted()
   use
   set talk off
   erase pf.dbf
   erase pf.fpt
   set talk on
   rename x.dbf to pf.dbf
   rename x.fpt to pf.fpt
   use pf exclusive
   index on prgname to pf0
   index on procname+prgname to pf1
   
   @ row()+2,0 say "Memory Files"
   use mf exclusive
   copy to x for .not. deleted()
   use
   set talk off
   erase mf.dbf
   erase mf.fpt
   set talk on
   rename x.dbf to mf.dbf
   rename x.fpt to mf.fpt
   use mf exclusive
   index on memname to mf0
   
   @ row()+2,0 say "Directory File"
   use mf exclusive
   use dirs exclusive
   pack
  
   use
   set talk off
   restore screen from rndx
*   close databases
   do col_schm
      
RETURN
********************************************************************



*****************************************************************************
*
*    Program Name: GETPATH.PRG        Copyright: Peer Review Analysis                                     
*    Date Created: 08/08/90           Language: FoxPro                                              
*    Time Created: 12:27:14             Author: Peter Kodzis                              
*
*****************************************************************************
* Requires : None
* Returns  : None
* Modifies : Dirs.dbf
* Calls    : 
* Procedure: None
* Called By: DD.PRG
* Effects  : Allows the user to modify the list of directories used by the
*            application.
* 
*****************************************************************************

PROCEDURE GETPATH

   use dirs
   browse fields directory :30, contents
   use

RETURN


*****************************************************************************
*
*    Program Name: DDERR.PRG         Copyright: Peer Review Analysis                                     
*    Date Created: 08/08/90           Language: FoxPro                                              
*    Time Created: 12:27:14             Author: Peter Kodzis                              
*
*****************************************************************************
* Requires : None
* Returns  : Confirmed=.f.
* Modifies : confirmed
* Calls    : None
* Procedure: None
* Called By: DD.PRG
* Effects  : If any error occurs, sets confirmed to .f.
* 
*****************************************************************************

PROCEDURE DDERR

parameter errno
do case
   case errno = 1
      * File does not exist
      confirmed=.f.
   case errno =  3 .OR. errno = 108
      * File is in use by another.
      confirmed=.f.
   case errno = 41
      * Memo file is missing / invalid
      confirmed=.f.
   case errno = 114
      * Index file doesn't match database
      confirmed=.f.
   otherwise
      @ 0,0
      @ 0,0 say errno
      ON ERROR
      retry
endcase

RETURN

*****************************************************************************
* box.prg
* Copyright 1989 Peter Wagner Associates
* draws box with a shadow (depending on lev parameter)
* ulr    = upper left row
* ulc    = upper left col
* lrr    = lower right row
* lrc    = lower right col
* border = border type
* shadow = shadow color
* fore   = foreground color
* back   = background color
* lev    = level of box - determines breadth of shadow
*****************************************************************************

PROCEDURE BOX

parameters ulr,ulc,lrr,lrc,pmborder,shadow,fore,pmback,lev

corns=.f.
do case
   case pmborder=0
      bordertype="clear"
   case pmborder=1
      bordertype=""
   case pmborder=2
      bordertype="double"
   case pmborder=3
      bordertype="clear"
      corns=.t.
endcase

set color to &shadow/&shadow
@ ulr+1*lev,ulc+2*lev to lrr+1*lev,lrc+2*lev clear
set color to &fore/&pmback,&fore/&shadow
@ ulr,ulc to lrr,lrc clear
if m->bordertype<>"clear"
   @ ulr,ulc to lrr,lrc &bordertype
endif
if corns
   @ ulr,ulc+1 say chr(218)
   @ ulr,lrc-1 say chr(191)
   @ lrr,ulc+1 say chr(192)
   @ lrr,lrc-1 say chr(217)
endif

RETURN


*****************************************************************************
*
*    Program Name: DFUPD.PRG         Copyright: Peer Review Analysis
*    Date Created: 08/06/90           Language: FoxPro
*    Time Created: 15:28:38             Author: Peter Wagner
*
*****************************************************************************
* Requires : Data files in df.dbf be accessible for use
* Returns  : None
* Modifies : df.dbf
* Calls    : dderr.prg
* Procedure: None
* Called By: dd.prg
* Effects  : Updates the df.dbf file to reflect the most current state
*            of all the data files listed in df.dbf.  Will not update
*            a record which is marked as READONLY.
*****************************************************************************

PROCEDURE DFUPD

save screen to dfupd

use dirs
pathv=trim(directory)
skip
do while .not. eof()
   pathv=pathv+";"+trim(directory)
   skip
enddo
use
set path to &pathv

define window mess from 8,25 to 12,55 NONE SHADOW
* activate window mess

do box with 8,25,12,55,0,"n","w+","bg",1
@ 9,27 say "Making Backup - DF.BKK/BKF"
copy file df.dbf to df.bkk
copy file df.fpt to df.bkf

@ 9,27 say "Scanning Directories...   "

use dirlist exclusive
zap
select 0
use dirs
go top

scan

   @ 11,27 say space(29)
   @ 11,27 say trim(directory)
   @ 20,0 say ""
   
   dir=trim(directory)
   dirfiles=dir+"\*.dbf"
   
   ! dir &dirfiles > x.txt
   
   select dirlist
   append from x.txt sdf
   select dirs
endscan

activate screen
set color to w+/b
clear

activate window mess
clear
@ 1,2 say "Getting Data Structures..."
select dirs
use

select dirlist
index on name for ext="DBF" to dirlist
replace all date with ctod(datetxt)

select 0
use df index df0 exclusive

select dirlist
go top

scan 

   select df
   go top
   locate for file=dirlist->name
   if .not. found()
      append blank
      replace file with dirlist->name,briefdesc with "DBF on Path but not documented",updated with dirlist->date,size with dirlist->size
   endif
   select dirlist
   
endscan


select dirlist
use
select df
go top

activate screen
set color to w+/b
clear

scan

   activate window mess
   @ 3,5 say file
   activate screen
   
   if .not. readonly
      if alltrim(df->file)<>"DF"
            select 0
            if file(trim(df->file)+".dbf")
               fil=df->file
               confirmed=.t.
               use (fil) exclusive
*               confirmed=openfile(df->file,"E",.f.)
            else
               confirmed=.f.
               select df
               replace df->lost with .t.
            endif
            if .not. confirmed
               select df
               loop
            endif
      endif   
      
      list structure to x.stru
      
      replace df->updated with lupdate(),df->recsize with recsize(),df->size with (reccount()*recsize())+header()+1,df->records with reccount(),df->dfupdate with date(),df->lost with .f.
      
      if alltrim(df->file)<>"DF"
         use
      endif
      select df
      append memo longdesc from x.stru overwrite
   endif
   
endscan

activate screen
clear
close databases
release window mess
do col_schm
restore screen from dfupd


RETURN



*****************************************************************************
*
*    Program Name: IDUPD.PRG         Copyright: Peer Review Analysis
*    Date Created: 08/08/90           Language: FoxPro
*    Time Created: 15:28:38             Author: Peter Wagner
*
*****************************************************************************
* Requires : Data files in id.dbf be accessible for use
* Returns  : None
* Modifies : id.dbf
* Calls    : None
* Procedure: None
* Called By: dd.prg
* Effects  : Updates the id.dbf file to reflect the most current state
*            of all the index files in the path specified by dirs.dbf.
*            Will not update a record which is marked as READONLY.
*****************************************************************************
PROCEDURE IDUPD

save screen to idupd

use dirs
pathv=trim(directory)
skip
do while .not. eof()
   pathv=pathv+";"+trim(directory)
   skip
enddo
use
set path to &pathv

define window mess from 8,25 to 12,55 NONE SHADOW
* activate window mess

do box with 8,25,12,55,0,"n","w+","bg",1
@ 9,27 say "Making Backup - ID.BKK/BKF"
copy file id.dbf to id.bkk
copy file id.fpt to id.bkf

@ 9,27 say "Scanning Directories...   "

use dirlist exclusive
zap
select 0
use dirs
go top

scan

   @ 11,27 say space(29)
   @ 11,27 say trim(directory)
   @ 20,0 say ""
   
   dir=trim(directory)
   dirfiles=dir+"\*.idx"
   
   ! dir &dirfiles > x.txt
   
   select dirlist
   append from x.txt sdf
   select dirs
endscan

activate screen
set color to w+/b
clear

activate window mess
clear
@ 1,2 say "Scanning Index Files..."

select dirlist
index on name for ext="IDX" to dirlist
replace all date with ctod(datetxt)

select 0
use id index id0,id1 exclusive

select dirlist
go top

scan 

   select id
   go top
   locate for indexname=dirlist->name
   if .not. found()
      append blank
      replace indexname with dirlist->name,file with "?",briefdesc with "IDX on Path but not documented",updated with dirlist->date,size with dirlist->size
   endif
   select dirlist
   
endscan


select id
set relation to upper(indexname) into dirlist
go top

scan

   activate window mess
   @ 3,5 say indexname
   activate screen
   
   if .not. readonly
   
      replace updated with dirlist->date,size with dirlist->size,idupdate with date(),lost with .f.
      if eof("dirlist")
         replace lost with .t.
      endif

      if trim(file)<>"?"
      
         select 0
         fil=id->file
         confirmed=.t.
         use (fil)
*         confirmed=openfile(id->file,"S",.f.)
         
         if confirmed
            set index to (id->indexname)
            if confirmed
               replace id->longdesc with key(1)
            endif
            use
         endif
         
         select id
         
      endif
      
   endif
   
endscan



activate screen
set color to w+/b
clear
close databases
release window mess
do col_schm
restore screen from idupd


RETURN


*****************************************************************************
*
*    Program Name: MFUPD.PRG         Copyright: Peer Review Analysis
*    Date Created: 08/08/90           Language: FoxPro
*    Time Created: 15:28:38             Author: Peter Wagner
*
*****************************************************************************
* Requires : Data files in mf.dbf be accessible for use
* Returns  : None
* Modifies : mf.dbf
* Calls    : None
* Procedure: None
* Called By: dd.prg
* Effects  : Updates the mf.dbf file to reflect the most current state
*            of all the memory files in the path specified by dirs.dbf.
*            Will not update a record which is marked as READONLY.
*****************************************************************************

PROCEDURE MFUPD

save screen to mfupd

use dirs
pathv=trim(directory)
skip
do while .not. eof()
   pathv=pathv+";"+trim(directory)
   skip
enddo
use
set path to &pathv

define window mess from 8,25 to 12,55 NONE SHADOW
* activate window mess

do box with 8,25,12,55,0,"n","w+","bg",1
@ 9,27 say "Making Backup - MF.BKK/BKF"
copy file mf.dbf to mf.bkk
copy file mf.fpt to mf.bkf

@ 9,27 say "Scanning Directories...   "

use dirlist exclusive
zap
select 0
use dirs
go top

scan

   @ 11,27 say space(29)
   @ 11,27 say trim(directory)
   @ 20,0 say ""
   
   dir=trim(directory)
   dirfiles=dir+"\*.mem"
   
   ! dir &dirfiles > x.txt
   
   select dirlist
   append from x.txt sdf
   select dirs
endscan

activate screen
set color to w+/b
clear

activate window mess
clear
@ 1,2 say "Scanning MEM Files..."

select dirlist
index on name for ext="MEM" to dirlist
replace all date with ctod(datetxt)


select 0
use mf index mf0 exclusive

select dirlist
go top

scan 

   select mf
   go top
   locate for memname=dirlist->name
   if .not. found()
      append blank
      replace memname with dirlist->name,briefdesc with "MEM on Path but not documented",updated with dirlist->date,size with dirlist->size
   endif
   select dirlist
   
endscan


select mf
set relation to upper(memname) into dirlist
go top

save to mfupd

scan

   activate window mess
   @ 3,5 say memname
   activate screen
   set color to w+/b
   
   if .not. readonly
   
      clear memory
      memfil=trim(memname)+".mem"
      if file(memfil)
*         memfil=memname
         restore from &memfil
         list memo to x.txt
         append memo longdesc from x.txt overwrite
      endif

      replace updated with dirlist->date,size with dirlist->size,mfupdate with date(),lost with .f.
      if eof("dirlist")
         replace lost with .t.
      endif
      
   endif
   
endscan


restore from mfupd
erase mfupd.mem

activate screen
set color to w+/b
clear
close databases
release window mess
do col_schm
restore screen from mfupd

RETURN

*****************************************************************************
*
*    Program Name: PFUPD.PRG         Copyright: Peer Review Analysis
*    Date Created: 08/08/90           Language: FoxPro
*    Time Created: 15:28:38             Author: Peter Wagner
*
*****************************************************************************
* Requires : None
* Returns  : None
* Modifies : pf.dbf
* Calls    : None
* Procedure: None
* Called By: dd.prg
* Effects  : Updates the pf.dbf file to reflect the most current state
*            of all the program files in the path specified by dirs.dbf.
*            Will not update a record which is marked as READONLY.
*****************************************************************************

PROCEDURE PFUPD

save screen to pfupd

define window mess from 8,25 to 12,55 NONE SHADOW
* activate window mess

do box with 8,25,12,55,0,"n","w+","bg",1
@ 9,27 say "Making Backup - PF.BKK/BKF"
copy file pf.dbf to pf.bkk
copy file pf.fpt to pf.bkf

@ 9,27 say "Scanning Directories...   "

use dirlist exclusive
zap
select 0
use dirs
go top

scan

   @ 11,27 say space(29)
   @ 11,27 say trim(directory)
   @ 20,0 say ""
   
   dir=trim(directory)
   dirfiles=dir+"\*.prg"
   
   ! dir &dirfiles > x.txt
   
   select dirlist
   append from x.txt sdf
   select dirs
endscan

activate screen
set color to w+/b
clear

activate window mess
clear
@ 1,2 say "Scanning Program Files..."

select dirlist
index on name for ext="PRG" to dirlist
replace all date with ctod(datetxt)


select 0
use pf index pf0,pf1 exclusive

select dirlist
go top

scan 

   select pf
   go top
   locate for prgname=dirlist->name
   if .not. found()
      append blank
      replace prgname with dirlist->name,briefdesc with "PRG on Path but not documented",updated with dirlist->date,size with dirlist->size
   endif
   select dirlist
   
endscan


select pf
set relation to upper(prgname) into dirlist
go top

scan

   activate window mess
   @ 3,5 say prgname
*   activate screen
*   set color to w+/b
   
   if .not. readonly
   
      prg=trim(prgname)+".prg"
      if file(prg) .and. .not. insideproc
         append memo longdesc from &prg overwrite
      endif

      replace updated with dirlist->date,size with dirlist->size,pfupdate with date(),lost with .f.
      if eof("dirlist") .and. .not. insideproc
         replace lost with .t.
      else
         if .not. insideproc
            replace lost with .f.
         endif
      endif
      
   endif
   
endscan

* determine if any procedures have been deleted
* not perfect, but it'll do 
activate window mess
clear
@ 1,1 say "Checking for Deleted Procs..."
select pf
set order to 1
go top
scan

   pfrc=recno()
   if .not. insideproc .or. readonly
      loop
   endif
   mprgname=trim(prgname)
   mprocname=procname
   seek mprocname
   if .not. found()
      go pfrc
      replace lost with .t.
      loop
   endif
   pos=atc("procedure "+mprgname,longdesc)
   go pfrc            && return to correct record
   replace lost with iif(pos=0,.t.,.f.)
   
endscan


clear
@ 1,2 say "Locating Procedures..."

select pf
set order to 0
go top
scan
   @ 3,5 say prgname
   if insideproc
      loop
   endif
   rc=recno()
   procfound=.f.
   occurs=1
   do while .t.
      pos=atc("procedure ",longdesc,occurs)
      if pos=0
         exit
      else
         occurs=occurs+1
* determine if it's a real procedure line         
         procline=substr(longdesc,pos,150)  && 150 is probably too much, but to be safe...
         cr_pos=at(chr(13),procline)
         if cr_pos=0  && no carriage return found within 150 chars - prob. not procedure
            loop
         else
            procline=substr(procline,1,cr_pos)
            remainder=substr(procline,11)
* now, remainder must have either one word plus carriage return OR
* one word plus some spaces plus ampersands

            if " "$remainder
               start=at(" ",remainder)
               do while substr(remainder,start,1)=" "
                  start=start+1
               enddo
               if substr(remainder,start,1)<>"&"
* not a comment and there is stuff after the first word after procedure,
* so it's probably not a procedure               
                  loop
               endif
            else  && it is a procedure
            endif            
         endif
         
         prginside=substr(longdesc,pos+10,8)
         pos=atc(chr(13),prginside)
         if pos<>0
            prginside=substr(prginside,1,pos-1)
         else
            pos=atc(" ",prginside)
            if pos<>0
               prginside=substr(prginside,1,pos-1)
            endif
         endif
         procv=prgname
         
         set order to 2
         seek upper(procv)+upper(prginside)
         if .not. found()
            append blank
            replace prgname with upper(prginside),is_proc with .f.,insideproc with .t.,procname with upper(procv),briefdesc with "PRG within Procedure "+procv,pfupdate with date(),lost with .f.
            procfound=.t.
         endif
         set order to 0
         
      endif
      go rc
      if procfound
         replace procname with prgname,is_proc with .T.
      endif
   enddo 
endscan

close databases
activate screen
clear
release window mess
do col_schm
restore screen from pfupd

RETURN


*****************************************************************************
*
*    Program Name: DEUPD.PRG         Copyright: Peer Review Analysis
*    Date Created: 08/08/90           Language: FoxPro
*    Time Created: 15:28:38             Author: Peter Wagner
*
*****************************************************************************
* Requires : Data files in df.dbf be current
* Returns  : None
* Modifies : de.dbf
* Calls    : None
* Procedure: None
* Called By: dd.prg
* Effects  : Updates the de.dbf file to reflect the most current state
*            of all the index files in the path specified by dirs.dbf.
*            Will not update a record which is marked as READONLY.
*****************************************************************************
PROCEDURE DEUPD

save screen to deupd

define window mess from 8,23 to 10,56 NONE SHADOW
activate window mess
yn=.t.
@ 1,1 say "Have Data Files been updated?" get yn pict 'Y'
read
release window mess
if .not. yn
   RETURN
endif

use dirs
pathv=trim(directory)
skip
do while .not. eof()
   pathv=pathv+";"+trim(directory)
   skip
enddo
use
set path to &pathv

define window mess from 8,25 to 12,55 NONE SHADOW

activate window mess
clear
@ 1,2 say "Making Backup - DE.BKK/BKF"
copy file de.dbf to de.bkk
copy file de.fpt to de.bkf

@ 1,2 say "Scanning Data Files...   "

select 0
use de index de0,de1 exclusive
replace all lost with .t.
set order to 2
select 0
use df index df0


scan
   @ 3,5 say file
   if file<>"DF" .and. file<>"DE"
      select 0
      fil=df->file
      confirmed=.t.
      use (fil)
*      confirmed=openfile(df->file,"S",.f.)
   else
      fil=df->file
      select &fil
      confirmed=.t.
   endif
   
   if .not. confirmed
      loop
   endif
   copy structure extended to xxxyxxx
   if df->file="DF" .or. df->file="DE"
      select 0
   endif
   use xxxyxxx
   
   scan
      select de
      seek df->file+xxxyxxx->field_name
      if found()
         replace type with xxxyxxx->field_type,length with xxxyxxx->field_len,decimals with xxxyxxx->field_dec,lost with .f.,deupdate with date()
      else
         append blank
         replace file with df->file,fieldname with xxxyxxx->field_name,type with xxxyxxx->field_type,length with xxxyxxx->field_len,decimals with xxxyxxx->field_dec,lost with .f.,deupdate with date()
      endif
      select xxxyxxx
   endscan
   use
   select df   
endscan


erase xxxyxxx.dbf
activate screen
set color to w+/b
clear
close databases
release window mess
do col_schm
restore screen from deupd


RETURN

*****************************************************************************
*
*    Program Name: CLEARALL.PRG      Copyright: Peer Review Analysis
*    Date Created: 08/09/90           Language: FoxPro
*    Time Created: 15:28:38             Author: Peter Wagner
*
*****************************************************************************
* Requires : DD data files can be used exclusively
* Returns  : None
* Modifies : de.dbf, df.dbf, id.dbf, pf.dbf, mf.dbf - ZAPS 'em all
*            copies them all to .BKK files
* Calls    : None
* Procedure: None
* Called By: dd.prg
* Effects  : Cleans out all the DD data files
*
*****************************************************************************
PROCEDURE CLEARALL

define window mess from 8,27 to 10,53 NONE SHADOW
activate window mess
yn=.f.
@ 1,1 say "ZAP! all DD files?" get yn pict 'Y'
read
clear
if yn
   @ 1,2 say "Making Backups"
   copy file de.dbf to de.bkk
   @ row(),col() say "."
   copy file de.fpt to de.bkf
   @ row(),col() say "."
   copy file df.dbf to df.bkk
   @ row(),col() say "."
   copy file df.fpt to df.bkf
   @ row(),col() say "."
   copy file id.dbf to id.bkk
   @ row(),col() say "."
   copy file id.fpt to id.bkf
   @ row(),col() say "."
   copy file pf.dbf to pf.bkk
   @ row(),col() say "."
   copy file pf.fpt to pf.bkf
   @ row(),col() say "."
   copy file mf.dbf to mf.bkk
   @ row(),col() say "."
   copy file mf.fpt to mf.bkf
   @ row(),col() say "."

   clear   
   @ 1,2 say "Deleting Records..."
   use de exclusive
   delete all
   copy to x for .not. deleted()
   use
   erase de.dbf
   erase de.fpt
   copy file x.dbf to de.dbf
   copy file x.fpt to de.fpt

   use df exclusive
   delete all
   copy to x for .not. deleted()
   use
   erase df.dbf
   erase df.fpt
   copy file x.dbf to df.dbf
   copy file x.fpt to df.fpt

   use id exclusive
   delete all
   copy to x for .not. deleted()
   use
   erase id.dbf
   erase id.fpt
   copy file x.dbf to id.dbf
   copy file x.fpt to id.fpt

   use pf exclusive
   delete all
   copy to x for .not. deleted()
   use
   erase pf.dbf
   erase pf.fpt
   copy file x.dbf to pf.dbf
   copy file x.fpt to pf.fpt

   use mf exclusive
   delete all
   copy to x for .not. deleted()
   use
   erase mf.dbf
   erase mf.fpt
   copy file x.dbf to mf.dbf
   copy file x.fpt to mf.fpt

   erase x.fpt
   erase x.dbf

   clear   
   @ 1,2 say "Reindexing..."
   do ddreind
endif
release window mess

RETURN

*****************************************************************************
*
*    Program Name: DELLOST.PRG       Copyright: Peer Review Analysis
*    Date Created: 08/09/90           Language: FoxPro
*    Time Created: 15:28:38             Author: Peter Wagner
*
*****************************************************************************
* Requires : DD data files can be used
* Returns  : None
* Modifies : de.dbf, df.dbf, id.dbf, pf.dbf, mf.dbf - deletes
*            records marked as Lost
* Calls    : None
* Procedure: None
* Called By: dd.prg
* Effects  : Cleans out all the lost records in the DD data files
*
*****************************************************************************
PROCEDURE DELLOST

define window mess from 8,20 to 10,60 NONE SHADOW
activate window mess
clear

yn=.f.
@ 1,1 say "Delete Lost Data Element Records?" get yn pict 'Y'
read
if yn
   use de index de0,de1
   delete for lost
endif

yn=.f.
clear
@ 1,1 say "Delete Lost Data File Records?" get yn pict 'Y'
read
if yn
   use df index df0
   delete for lost
endif

yn=.f.
clear
@ 1,1 say "Delete Lost Index File Records?" get yn pict 'Y'
read
if yn
   use id index id0,id1
   delete for lost
endif

yn=.f.
clear
@ 1,1 say "Delete Lost Program File Records?" get yn pict 'Y'
read
if yn
   use pf index pf0,pf1
   delete for lost
endif

yn=.f.
clear
@ 1,1 say "Delete Lost Memory File Records?" get yn pict 'Y'
read
if yn
   use mf index mf0,mf1
   delete for lost
endif

use 
release window mess

RETURN
