* Program ...: dCLNDR.PRG
* Author ....: Michael B. Carlisle
* Date ......: 7-12-89
* Versions ..: dBASE IV version 1.0
* Notes .....: Daily calendar and planner

CLEAR ALL
SET CLOCK ON
SET TALK OFF
SET STATUS OFF
SET SCOREBOARD OFF
SET BORDER TO DOUBLE
SET ESCAPE OFF
SET MESSAGE TO ""

SET COLOR TO
IF ISCOLOR()			  && Set colors for color monitors.
	SET COLOR OF NORMAL      TO W+/B
	SET COLOR OF MESSAGES    TO W+/R
	SET COLOR OF TITLES      TO W/B
	SET COLOR OF HIGHLIGHT   TO GR+/BG
	SET COLOR OF BOX         TO w/r
	SET COLOR OF INFORMATION TO N/W
	SET COLOR OF FIELDS      TO N/BG
	line_fg = "GR+"
	line_bg = "R"
	norm_fg = "W"
	norm_bg = "B"
	norm    = "W/B"
	box	   = "W/R"
	shadow  = "/N"
	top_line= "N/W"
ELSE				      && Set colors for monochrome monitors.
	SET COLOR OF NORMAL	    TO N/W
	SET COLOR OF MESSAGES    TO W/N
	SET COLOR OF TITLES	    TO w/n
	SET COLOR OF HIGHLIGHT   TO N/W
	SET COLOR OF BOX         TO W/N
	SET COLOR OF INFORMATION TO W/N
	SET COLOR OF FIELDS      TO N/W
	line_fg = "W"
	line_bg = "N"
	norm_fg = "N"
	norm_bg = "W"
	norm    = "N/W"
	box	  = "W/N"
	shadow  = "W/N"
	top_line= "W/N"
ENDIF
CLEAR

DEFINE WINDOW Show_Fld FROM 18,2 TO 22,78
DEFINE WINDOW Clr_Scr  FROM 1,0 TO 23,79 COLOR &norm_bg/&norm_bg,;
					       &norm_bg/&norm_bg,;
					       &norm_bg/&norm_bg
DEFINE WINDOW ShowHelp FROM 3,5 TO 20,73

SELECT 1
USE Mark			  && Time Table database.

*--- Define Time Table menu.
DEFINE POPUP Hours FROM 3,65 TO 15,75 PROMPT FIELD Time;
       MESSAGE 'Position with: '+CHR(24)+CHR(25)+'<Pg Up><Pg Dn>'+;
	       ' - <Enter> to select choice - <F1> Help'
ON SELECTION POPUP Hours DO ACT02

USE Calendar ORDER Calendar IN 2          && Daily Planner database.
SET RELATION TO DTOS(Date) + LEFT(Time,8) INTO Calendar
USE Holiday ORDER Holiday IN 3	         && Special Day database.
RESTORE MACROS FROM Arrows	               && Load cursor control macros.

*--- Establish key traps for cursor control and system branching.
ON KEY LABEL uparrow PLAY MACRO U
ON KEY LABEL dnarrow PLAY MACRO D
ON KEY LABEL pgup    DO New_Cal WITH -1
ON KEY LABEL pgdn    DO New_Cal WITH  1
ON KEY LABEL F1      DO HelpText
ON KEY LABEL F10     DO Leave

*--- Initialize system variables. 
PUBLIC sdate, edate
sdate	= DATE()
edate	= 0
holiday = .F.
data	= .F.
day_pad = DAY(sdate)
xday	= " "
DO New_Cal with 0

*--- Display calendar matrix.
@  4,10 FILL TO 16,59 COLOR &shadow
@  3,11 FILL TO 15,60 COLOR &box
@  3,11 TO 15,60 DOUBLE COLOR &box
@  3,18 SAY CHR(209) COLOR &box
@  3,25 SAY CHR(209) COLOR &box
@  3,32 SAY CHR(209) COLOR &box
@  3,39 SAY CHR(209) COLOR &box
@  3,46 SAY CHR(209) COLOR &box
@  3,53 SAY CHR(209) COLOR &box
@  4,18 SAY CHR(179) COLOR &box
@  4,25 SAY CHR(179) COLOR &box
@  4,32 SAY CHR(179) COLOR &box
@  4,39 SAY CHR(179) COLOR &box
@  4,46 SAY CHR(179) COLOR &box
@  4,53 SAY CHR(179) COLOR &box
@  5,11 SAY CHR(199) ;
	+ REPLICATE(REPLICATE(CHR(196),6) + CHR(197),6) ;
	+ REPLICATE(CHR(196),6) + CHR(182) COLOR &box
@  6,18 SAY CHR(179) COLOR &box
@  6,25 SAY CHR(179) COLOR &box
@  6,32 SAY CHR(179) COLOR &box
@  6,39 SAY CHR(179) COLOR &box
@  6,46 SAY CHR(179) COLOR &box
@  6,53 SAY CHR(179) COLOR &box
@  7,11 SAY CHR(199) ;
	+ REPLICATE(REPLICATE(CHR(196),6) + CHR(197),6) ;
	+ REPLICATE(CHR(196),6) + CHR(182) COLOR &box
@  8,18 SAY CHR(179) COLOR &box
@  8,25 SAY CHR(179) COLOR &box
@  8,32 SAY CHR(179) COLOR &box
@  8,39 SAY CHR(179) COLOR &box
@  8,46 SAY CHR(179) COLOR &box
@  8,53 SAY CHR(179) COLOR &box
@  9,11 SAY CHR(199) ;
	+ REPLICATE(REPLICATE(CHR(196),6) + CHR(197),6) ;
	+ REPLICATE(CHR(196),6) + CHR(182) COLOR &box
@ 10,18 SAY CHR(179) COLOR &box
@ 10,25 SAY CHR(179) COLOR &box
@ 10,32 SAY CHR(179) COLOR &box
@ 10,39 SAY CHR(179) COLOR &box
@ 10,46 SAY CHR(179) COLOR &box
@ 10,53 SAY CHR(179) COLOR &box
@ 11,11 SAY CHR(199) ;
	+ REPLICATE(REPLICATE(CHR(196),6) + CHR(197),6) ;
	+ REPLICATE(CHR(196),6) + CHR(182) COLOR &box
@ 12,18 SAY CHR(179) COLOR &box
@ 12,25 SAY CHR(179) COLOR &box
@ 12,32 SAY CHR(179) COLOR &box
@ 12,39 SAY CHR(179) COLOR &box
@ 12,46 SAY CHR(179) COLOR &box
@ 12,53 SAY CHR(179) COLOR &box
@ 13,11 SAY CHR(199) ;
	+ REPLICATE(REPLICATE(CHR(196),6) + CHR(197),6) ;
	+ REPLICATE(CHR(196),6) + CHR(182) COLOR &box
@ 14,18 SAY CHR(179) COLOR &box
@ 14,25 SAY CHR(179) COLOR &box
@ 14,32 SAY CHR(179) COLOR &box
@ 14,39 SAY CHR(179) COLOR &box
@ 14,46 SAY CHR(179) COLOR &box
@ 14,53 SAY CHR(179) COLOR &box
@ 15,18 SAY CHR(207) COLOR &box
@ 15,25 SAY CHR(207) COLOR &box
@ 15,32 SAY CHR(207) COLOR &box
@ 15,39 SAY CHR(207) COLOR &box
@ 15,46 SAY CHR(207) COLOR &box
@ 15,53 SAY CHR(207) COLOR &box
@  2,11 SAY "  SUN    MON    TUE    WED    THR    FRI    SAT"

*--- Main program loop. 
leave = "No"
DO WHILE leave = "No"
	DO Disp_Cal
	@  0, 0 SAY SPACE(70) COLOR &top_line
	@  0, 0 SAY CMONTH(sdate) + ", " + STR(YEAR(sdate),4,0) COLOR &top_line
	xpad = "PAD_" + LTRIM(STR(DOW(sdate)+;
		IIF(DAY(sdate) = day_pad, 0, +day_pad-1), 2, 0))
	ACTIVATE MENU Clndr PAD &xpad
ENDDO

*--- Release key traps. 
ON KEY LABEL uparrow
ON KEY LABEL dnarrow
ON KEY LABEL pgup
ON KEY LABEL pgdn
ON KEY LABEL F1

*--- Reset environment. 
SET CLOCK OFF
SET TALK ON
SET STATUS ON
SET SCOREBOARD ON
SET ESCAPE ON
CLEAR ALL
CLEAR
RETURN

PROCEDURE Disp_Cal
	*--- Define Calendar bar menu. 

	DEFINE MENU CLNDR MESSAGE "Position with: " + CHR(27) + CHR(26) + CHR(24);
		+ CHR(25)+" - <Enter> to select choice - <F1> Help - <F10> Quit"

	*--- Define the bar menu PADS using array elements for PROMPTS.
	DEFINE PAD PAD_1  OF Clndr PROMPT Days[1,1]  AT  4,12
	DEFINE PAD PAD_2  OF Clndr PROMPT Days[1,2]  AT  4,19
	DEFINE PAD PAD_3  OF Clndr PROMPT Days[1,3]  AT  4,26
	DEFINE PAD PAD_4  OF Clndr PROMPT Days[1,4]  AT  4,33
	DEFINE PAD PAD_5  OF Clndr PROMPT Days[1,5]  AT  4,40
	DEFINE PAD PAD_6  OF Clndr PROMPT Days[1,6]  AT  4,47
	DEFINE PAD PAD_7  OF Clndr PROMPT Days[1,7]  AT  4,54
	DEFINE PAD PAD_8  OF Clndr PROMPT Days[1,8]  AT  6,12
	DEFINE PAD PAD_9  OF Clndr PROMPT Days[1,9]  AT  6,19
	DEFINE PAD PAD_10 OF Clndr PROMPT Days[1,10] AT  6,26
	DEFINE PAD PAD_11 OF Clndr PROMPT Days[1,11] AT  6,33
	DEFINE PAD PAD_12 OF Clndr PROMPT Days[1,12] AT  6,40
	DEFINE PAD PAD_13 OF Clndr PROMPT Days[1,13] AT  6,47
	DEFINE PAD PAD_14 OF Clndr PROMPT Days[1,14] AT  6,54
	DEFINE PAD PAD_15 OF Clndr PROMPT Days[1,15] AT  8,12
	DEFINE PAD PAD_16 OF Clndr PROMPT Days[1,16] AT  8,19
	DEFINE PAD PAD_17 OF Clndr PROMPT Days[1,17] AT  8,26
	DEFINE PAD PAD_18 OF Clndr PROMPT Days[1,18] AT  8,33
	DEFINE PAD PAD_19 OF Clndr PROMPT Days[1,19] AT  8,40
	DEFINE PAD PAD_20 OF Clndr PROMPT Days[1,20] AT  8,47
	DEFINE PAD PAD_21 OF Clndr PROMPT Days[1,21] AT  8,54
	DEFINE PAD PAD_22 OF Clndr PROMPT Days[1,22] AT 10,12
	DEFINE PAD PAD_23 OF Clndr PROMPT Days[1,23] AT 10,19
	DEFINE PAD PAD_24 OF Clndr PROMPT Days[1,24] AT 10,26
	DEFINE PAD PAD_25 OF Clndr PROMPT Days[1,25] AT 10,33
	DEFINE PAD PAD_26 OF Clndr PROMPT Days[1,26] AT 10,40
	DEFINE PAD PAD_27 OF Clndr PROMPT Days[1,27] AT 10,47
	DEFINE PAD PAD_28 OF Clndr PROMPT Days[1,28] AT 10,54
	DEFINE PAD PAD_29 OF Clndr PROMPT Days[1,29] AT 12,12
	DEFINE PAD PAD_30 OF Clndr PROMPT Days[1,30] AT 12,19
	DEFINE PAD PAD_31 OF Clndr PROMPT Days[1,31] AT 12,26
	DEFINE PAD PAD_32 OF Clndr PROMPT Days[1,32] AT 12,33
	DEFINE PAD PAD_33 OF Clndr PROMPT Days[1,33] AT 12,40
	DEFINE PAD PAD_34 OF Clndr PROMPT Days[1,34] AT 12,47
	DEFINE PAD PAD_35 OF Clndr PROMPT Days[1,35] AT 12,54
	DEFINE PAD PAD_36 OF Clndr PROMPT Days[1,36] AT 14,12
	DEFINE PAD PAD_37 OF Clndr PROMPT Days[1,37] AT 14,19
	DEFINE PAD PAD_38 OF Clndr PROMPT Days[1,38] AT 14,26
	DEFINE PAD PAD_39 OF Clndr PROMPT Days[1,39] AT 14,33
	DEFINE PAD PAD_40 OF Clndr PROMPT Days[1,40] AT 14,40
	DEFINE PAD PAD_41 OF Clndr PROMPT Days[1,41] AT 14,47
	DEFINE PAD PAD_42 OF Clndr PROMPT Days[1,42] AT 14,54
	ON SELECTION PAD PAD_1  OF Clndr DO ACT01
	ON SELECTION PAD PAD_2  OF Clndr DO ACT01
	ON SELECTION PAD PAD_3  OF Clndr DO ACT01
	ON SELECTION PAD PAD_4  OF Clndr DO ACT01
	ON SELECTION PAD PAD_5  OF Clndr DO ACT01
	ON SELECTION PAD PAD_6  OF Clndr DO ACT01
	ON SELECTION PAD PAD_7  OF Clndr DO ACT01
	ON SELECTION PAD PAD_8  OF Clndr DO ACT01
	ON SELECTION PAD PAD_9  OF Clndr DO ACT01
	ON SELECTION PAD PAD_10 OF Clndr DO ACT01
	ON SELECTION PAD PAD_11 OF Clndr DO ACT01
	ON SELECTION PAD PAD_12 OF Clndr DO ACT01
	ON SELECTION PAD PAD_13 OF Clndr DO ACT01
	ON SELECTION PAD PAD_14 OF Clndr DO ACT01
	ON SELECTION PAD PAD_15 OF Clndr DO ACT01
	ON SELECTION PAD PAD_16 OF Clndr DO ACT01
	ON SELECTION PAD PAD_17 OF Clndr DO ACT01
	ON SELECTION PAD PAD_18 OF Clndr DO ACT01
	ON SELECTION PAD PAD_19 OF Clndr DO ACT01
	ON SELECTION PAD PAD_20 OF Clndr DO ACT01
	ON SELECTION PAD PAD_21 OF Clndr DO ACT01
	ON SELECTION PAD PAD_22 OF Clndr DO ACT01
	ON SELECTION PAD PAD_23 OF Clndr DO ACT01
	ON SELECTION PAD PAD_24 OF Clndr DO ACT01
	ON SELECTION PAD PAD_25 OF Clndr DO ACT01
	ON SELECTION PAD PAD_26 OF Clndr DO ACT01
	ON SELECTION PAD PAD_27 OF Clndr DO ACT01
	ON SELECTION PAD PAD_28 OF Clndr DO ACT01
	ON SELECTION PAD PAD_29 OF Clndr DO ACT01
	ON SELECTION PAD PAD_30 OF Clndr DO ACT01
	ON SELECTION PAD PAD_31 OF Clndr DO ACT01
	ON SELECTION PAD PAD_32 OF Clndr DO ACT01
	ON SELECTION PAD PAD_33 OF Clndr DO ACT01
	ON SELECTION PAD PAD_34 OF Clndr DO ACT01
	ON SELECTION PAD PAD_35 OF Clndr DO ACT01
	ON SELECTION PAD PAD_36 OF Clndr DO ACT01
	ON SELECTION PAD PAD_37 OF Clndr DO ACT01
	ON SELECTION PAD PAD_38 OF Clndr DO ACT01
	ON SELECTION PAD PAD_39 OF Clndr DO ACT01
	ON SELECTION PAD PAD_40 OF Clndr DO ACT01
	ON SELECTION PAD PAD_41 OF Clndr DO ACT01
	ON SELECTION PAD PAD_42 OF Clndr DO ACT01
RETURN     && EOP: Disp_Cal

PROCEDURE New_Cal
	*--- Calculate days of month and store to array.
	PARAMETERS x
	SET TYPEAHEAD TO 0		  && Disable ON KEY LABEL key traps.

	*--- Keep cursor on same day in new month. 
	day_pad = IIF(LEN(xday) = 0, VAL(LTRIM(TRIM(SUBSTR(PROMPT(), 2, 2)))), day_pad)

	*--- Calculate the next month to process. 
	sdate = CTOD(STR(MONTH(sdate) + x, 2, 0) + "/01/" + STR(YEAR(sdate), 4, 0))
	mdate = sdate
	*--- Declare array to hold Calendar prompt values. 
	RELEASE Days
	PUBLIC ARRAY Days[1,42]

	*--- Fill array elements with blanks up to first day of month.
	cntr = 1
	DO WHILE cntr < DOW(sdate)
		Days[1,cntr] = "    "
		cntr = cntr + 1
	ENDDO

	*--- Fill array elements with days of the month. 
	mnth = MONTH(sdate)
	DO WHILE cntr <= 42
		IF MONTH(sdate) = mnth
			Days[1,cntr] = IIF(SEEK(sdate, 3),"*"," ") + STR(DAY(sdate), 2, 0);
				+ IIF(SEEK(DTOS(sdate),2),"#"," ")
		ELSE
			Days[1,cntr] = "    "
		ENDIF
		sdate = sdate + 1
		cntr = cntr + 1
	ENDDO
	sdate = mdate
	xday = ""
	SET TYPEAHEAD TO 20		  && Reactivate ON KEY LABEL key traps.

	*--- Exit from and remove Calendar from the screen. 
	PLAY MACRO O
	DEACTIVATE MENU
RETURN     && EOP: New_Cal

PROCEDURE Act01
	*--- Called by Clndr menu to activate Hours popup. 
	*--- Deactivate ON KEY LABEL key traps for cursor control.
	ON KEY LABEL uparrow
	ON KEY LABEL dnarrow
	ON KEY LABEL pgup
	ON KEY LABEL pgdn
	IF LEN(TRIM(PROMPT())) > 0
		xday = LTRIM(TRIM(SUBSTR(PROMPT(),2,2)))
		day_pad = VAL(xday)
		ldate = CTOD(STR(MONTH(sdate), 2, 0) + "/"+xday+"/" + STR(YEAR(sdate), 4, 0))
		DO Def_Pop
		@ 4,64 FILL TO 16,74 COLOR &shadow
		ACTIVATE POPUP Hours
		@ 4,64 FILL TO 16,74 COLOR /&norm_bg
		REPLACE ALL Time WITH left(Time,8)
	ENDIF

	*--- Reactivate ON KEY LABEL key traps for cursor control.
	ON KEY LABEL uparrow PLAY MACRO U
	ON KEY LABEL dnarrow PLAY MACRO D
	ON KEY LABEL pgup    DO New_Cal WITH -1
	ON KEY LABEL pgdn    DO New_Cal WITH 1
	DO New_Cal WITH 0
	DEACTIVATE MENU
RETURN     && EOP: Act01

PROCEDURE Act02
	*--- Special Day and Daily Planner input routine. 
	IF PROMPT() = "SPECIAL"    && Indicates Special Day.
		holiday = .T.    && Help screen flag.
		SELE 3
		SEEK ldate
		@ 19,1 FILL TO 23,77 COLOR &shadow
		ACTIVATE WINDOW Show_Fld
		SET MESSAGE TO "<Ctrl-End> Exit/Save - <ESC> Cancel - <F1> Help"

		IF FOUND()
			DO WHILE .NOT. STR(LASTKEY(),2,0) $ " 23, 27"    && Ctrl-End or Escape.
				@ 0,0 GET Desc
				READ
			ENDDO
		ELSE
			XDESC = SPACE(225)
			DO WHILE .NOT. STR(LASTKEY(), 2, 0) $ " 23, 27"    && Ctrl-End or Escape.
				@ 0,0 GET xdesc
				READ
			ENDDO
			APPEND BLANK
			REPLACE Desc WITH xdesc, Holiday WITH ldate
		ENDIF

		IF LEN(TRIM(Desc)) = 0    && If no entry or data removed, delete record.
			DELETE
			PACK
		ENDIF
		holiday = .F.    && Reset Help screen flag.
		SELE 1
	ELSE    && Daily Planner.
		data = .T.    && Help screen flag.
		SELE 2
		SEEK DTOS(ldate) + LEFT(PROMPT(), 8)
		@ 19,1 FILL TO 23,77 COLOR &shadow
		ACTIVATE WINDOW Show_Fld

		*--- Place a + next to records longer than display width.
		*--- Separate input blocks into three columns.
		*--- See also the LongFld UDF used in the WHEN and VALID
		*    clauses of the @...GETs below.
		@ 0,24 SAY IIF(LEN(TRIM(line1)) > 24, "+", " ")
		@ 0,25 SAY CHR(179) COLOR &box
		@ 1,24 SAY IIF(LEN(TRIM(line2)) > 24, "+", " ")
		@ 1,25 SAY CHR(179) COLOR &box
		@ 2,24 SAY IIF(LEN(TRIM(line3)) > 24, "+", " ")
		@ 2,25 SAY CHR(179) COLOR &box
		@ 0,50 SAY IIF(LEN(TRIM(line4)) > 24, "+", " ")
		@ 0,51 SAY CHR(179) COLOR &box
		@ 1,50 SAY IIF(LEN(TRIM(line5)) > 24, "+", " ")
		@ 1,51 SAY CHR(179) COLOR &box
		@ 2,50 SAY IIF(LEN(TRIM(line6)) > 24, "+", " ")
		@ 2,51 SAY CHR(179) COLOR &box
		@ 0,74 SAY IIF(LEN(TRIM(line7)) > 22, "+", " ")
		@ 1,74 SAY IIF(LEN(TRIM(line8)) > 22, "+", " ")
		@ 2,74 SAY IIF(LEN(TRIM(line9)) > 22, "+", " ")
		SET MESSAGE TO "Position with: " + CHR(24) + CHR(25);
			+ " <TAB> - <Ctrl-End> Exit/Save - <Esc> Cancel - <F1> Help"
		IF found()
			DO WHILE .NOT. STR(LASTKEY(),2,0) $ " 23, 27"    && Ctrl-End or Escape.
				@ 0, 0 GET Line1 FUNCTION "S24" WHEN LongFld(LEN(TRIM(Line1)));
					VALID LongFld(LEN(TRIM(Line1)))
				@ 1, 0 GET Line2 FUNCTION "S24" WHEN LongFld(LEN(TRIM(Line2)));
					VALID LongFld(LEN(TRIM(Line2)))
				@ 2, 0 GET Line3 FUNCTION "S24" WHEN LongFld(LEN(TRIM(Line3)));
					VALID LongFld(LEN(TRIM(Line3)))
				@ 0,26 GET Line4 FUNCTION "S24" WHEN LongFld(LEN(TRIM(Line4)));
					VALID LongFld(LEN(TRIM(Line4)))
				@ 1,26 GET Line5 FUNCTION "S24" WHEN LongFld(LEN(TRIM(Line5)));
					VALID LongFld(LEN(TRIM(Line5)))
				@ 2,26 GET Line6 FUNCTION "S24" WHEN LongFld(LEN(TRIM(Line6)));
					VALID LongFld(LEN(TRIM(Line6)))
				@ 0,52 GET Line7 FUNCTION "S22" WHEN LongFld(LEN(TRIM(Line7)));
					VALID LongFld(LEN(TRIM(Line7)))
				@ 1,52 GET Line8 FUNCTION "S22" WHEN LongFld(LEN(TRIM(Line8)));
					VALID LongFld(LEN(TRIM(Line8)))
				@ 2,52 GET Line9 FUNCTION "S22" WHEN LongFld(LEN(TRIM(Line9)));
					VALID LongFld(LEN(TRIM(Line9)))
				READ
			ENDDO
		ELSE
			xline1 = SPACE(225)
			xline2 = SPACE(225)
			xline3 = SPACE(225)
			xline4 = SPACE(225)
			xline5 = SPACE(225)
			xline6 = SPACE(225)
			xline7 = SPACE(225)
			xline8 = SPACE(225)
			xline9 = SPACE(225)
			DO WHILE .NOT. STR(LASTKEY(),2,0) $ " 23, 27"    && Ctrl-End or Escape.
				@ 0, 0 GET xline1 FUNCTION "S24" WHEN LongFld(LEN(TRIM(xline1)));
					VALID LongFld(LEN(TRIM(xline1)))
				@ 1, 0 GET xline2 FUNCTION "S24" WHEN LongFld(LEN(TRIM(xline2)));
					VALID LongFld(LEN(TRIM(xline2)))
				@ 2, 0 GET xline3 FUNCTION "S24" WHEN LongFld(LEN(TRIM(xline3)));
					VALID LongFld(LEN(TRIM(xline3)))
				@ 0,26 GET xline4 FUNCTION "S24" WHEN LongFld(LEN(TRIM(xline4)));
					VALID LongFld(LEN(TRIM(xline4)))
				@ 1,26 GET xline5 FUNCTION "S24" WHEN LongFld(LEN(TRIM(xline5)));
					VALID LongFld(LEN(TRIM(xline5)))
				@ 2,26 GET xline6 FUNCTION "S24" WHEN LongFld(LEN(TRIM(xline6)));
					VALID LongFld(LEN(TRIM(xline6)))
				@ 0,52 GET xline7 FUNCTION "S22" WHEN LongFld(LEN(TRIM(xline7)));
					VALID LongFld(LEN(TRIM(xline7)))
				@ 1,52 GET xline8 FUNCTION "S22" WHEN LongFld(LEN(TRIM(xline8)));
					VALID LongFld(LEN(TRIM(xline8)))
				@ 2,52 GET xline9 FUNCTION "S22" WHEN LongFld(LEN(TRIM(xline9)));
					VALID LongFld(LEN(TRIM(xline9)))
				READ
			ENDDO

			IF LASTKEY() <> 27
				APPEND BLANK
				REPLACE Line1 WITH xline1, Date with ldate,;
					Time WITH LEFT(PROMPT(),8) + CHR(27)
				REPLACE Line2 WITH xline2
				REPLACE Line3 WITH xline3
				REPLACE Line4 WITH xline4
				REPLACE Line5 WITH xline5
				REPLACE Line6 WITH xline6
				REPLACE Line7 WITH xline7
				REPLACE Line8 WITH xline8
				REPLACE Line9 WITH xline9
			ENDIF
		ENDIF

		SELE 2
		*--- If no entry or data removed, delete record.
		IF LEN(TRIM(Line1))+LEN(TRIM(Line2))+LEN(TRIM(Line3))+LEN(TRIM(Line4))+;
		  LEN(TRIM(Line5))+LEN(TRIM(Line6))+LEN(TRIM(Line7))+LEN(TRIM(Line8))+;
		  LEN(TRIM(Line9)) = 0
			DELETE
			PACK
			*--- Remove arrow from next to time slot. 
			SELE 1
			SET ORDER TO Mark
			SEEK DTOS(ldate) + LEFT(PROMPT(), 8)
			REPLACE Time WITH LEFT(Time, 8)
			SET ORDER TO
		ELSE
			*--- Place an arrow next to time slot. 
			SELE 1
			SET ORDER TO Mark
			SEEK DTOS(ldate) + LEFT(PROMPT(),8)
			REPLACE Time WITH LEFT(Time, 8) + CHR(27)
			SET ORDER TO
		ENDIF
		data = .F.    && Reset Help screen flag.
	ENDIF
	DEACTIVATE WINDOW Show_Fld
	@ 19,1 FILL TO 23,78 COLOR /&norm_bg
	SET MESSAGE TO ""
	IF .NOT. ISCOLOR()
		SET COLOR OF INFORMATION TO W/N
		SET COLOR OF BOX	       TO W/N
	ENDIF
RETURN     && EOP: Act02

PROCEDURE Def_Pop
	*--- Update Time Table database to mark times with
	*    Daily Planner information.
	REPLACE ALL Date WITH ldate
	REPLACE ALL Time WITH TRIM(b->Time)+Time
RETURN

FUNCTION LongFld
	*--- Tests length of data against length of input block
	*    and places a + next to data that exceeds display width.
	*    Removes + if data has been made shorter than display width.
	PARAMETERS fldlngth
	IF fldlngth > 24 .or. (fldlngth > 22 .AND.;
	  VARREAD() $ "LINE7,LINE8,LINE9,XLINE7,XLINE8,XLINE9")

		DO CASE
			CASE VARREAD() = "LINE1"
				@ 0,24 SAY "+"
			CASE VARREAD() = "LINE2"
				@ 1,24 SAY "+"
			CASE VARREAD() = "LINE3"
				@ 2,24 SAY "+"
			CASE VARREAD() = "LINE4"
				@ 0,50 SAY "+"
			CASE VARREAD() = "LINE5"
				@ 1,50 SAY "+"
			CASE VARREAD() = "LINE6"
				@ 2,50 SAY "+"
			CASE VARREAD() = "LINE7"
				@ 0,74 SAY "+"
			CASE VARREAD() = "LINE8"
				@ 1,74 SAY "+"
			CASE VARREAD() = "LINE9"
				@ 1,74 SAY "+"
			CASE VARREAD() = "XLINE1"
				@ 0,24 SAY "+"
			CASE VARREAD() = "XLINE2"
				@ 1,24 SAY "+"
			CASE VARREAD() = "XLINE3"
				@ 2,24 SAY "+"
			CASE VARREAD() = "XLINE4"
				@ 0,50 SAY "+"
			CASE VARREAD() = "XLINE5"
				@ 1,50 SAY "+"
			CASE VARREAD() = "XLINE6"
				@ 2,50 SAY "+"
			CASE VARREAD() = "XLINE7"
				@ 0,74 SAY "+"
			CASE VARREAD() = "XLINE8"
				@ 1,74 SAY "+"
			CASE VARREAD() = "XLINE9"
				@ 1,74 SAY "+"
		ENDCASE
	ELSE
		DO CASE
			CASE VARREAD() = "LINE1"
				@ 0,24 SAY " "
			CASE VARREAD() = "LINE2"
				@ 1,24 SAY " "
			CASE VARREAD() = "LINE3"
				@ 2,24 SAY " "
			CASE VARREAD() = "LINE4"
				@ 0,50 SAY " "
			CASE VARREAD() = "LINE5"
				@ 1,50 SAY " "
			CASE VARREAD() = "LINE6"
				@ 2,50 SAY " "
			CASE VARREAD() = "LINE7"
				@ 0,74 SAY " "
			CASE VARREAD() = "LINE8"
				@ 1,74 SAY " "
			CASE VARREAD() = "LINE9"
				@ 1,74 SAY " "
			CASE VARREAD() = "XLINE1"
				@ 0,24 SAY " "
			CASE VARREAD() = "XLINE2"
				@ 1,24 SAY " "
			CASE VARREAD() = "XLINE3"
				@ 2,24 SAY " "
			CASE VARREAD() = "XLINE4"
				@ 0,50 SAY " "
			CASE VARREAD() = "XLINE5"
				@ 1,50 SAY " "
			CASE VARREAD() = "XLINE6"
				@ 2,50 SAY " "
			CASE VARREAD() = "XLINE7"
				@ 0,74 SAY " "
			CASE VARREAD() = "XLINE8"
				@ 1,74 SAY " "
			CASE VARREAD() = "XLINE9"
				@ 1,74 SAY " "
		ENDCASE
	ENDIF
RETURN .T.

PROCEDURE HelpText
	SET TYPEAHEAD TO 0		  && Disable ON KEY traps.
	SET MESSAGE TO "Press any key to continue..."
	ACTIVATE WINDOW Clr_Scr    && Cover existing text so screen appears								                  && to have been cleared.
	@ 2,3 FILL TO 19,71 COLOR w/n
	ACTIVATE WINDOW ShowHelp
	DO CASE
		CASE M->holiday
			TEXT

			    Special Day
			    ===========

  Display and edit message for a Special Day (i.e. Holiday,
  Birthday, Anniversary, etc...).

			ENDTEXT

		CASE data
			TEXT

			Display/Edit Entries
			====================

  Display and edit notes for the particular time period.
  A + following an input space indicates there is data beyond
  the displayed length of the input space.  Data will scroll
  to the left within the input space.

			ENDTEXT

		CASE POPUP() = "HOURS"
			TEXT

			   Time Periods
			   ============

 Place the highlight on the time period you wish to display/modify
 and press <Enter>.

 If an entry already exists for that time an arrow will appear to
 right of it.

 Place the highlight on the word SPECIAL and press <Enter> to
 display, modify or create a Special Day message.

			ENDTEXT

		CASE MENU() = "CLNDR"
			TEXT

			   The Calendar
			   ============

  Place the highlight on the day of the month you wish to display
  planner information for and press <Enter>.

  An * to the left of the day indicates a SPECIAL day (i.e.
  Holiday, Birthday, Anniversary, etc...).  A # to the right of
  the day indicates there is planner information stored for that
  day.

			ENDTEXT
	ENDCASE
	READ
	DEACTIVATE WINDOW ShowHelp
	DEACTIVATE WINDOW Clr_Scr
	SET MESSAGE TO ""
	IF data .OR. M->holiday
		SET MESSAGE TO "Position with: " + CHR(24) + CHR(25);
			+ " <TAB> - <Ctrl-End> Exit - <Esc> Cancel - <F1> Help"
	ENDIF
	SET TYPEAHEAD TO 20    && Reactivate ON KEY traps.
	IF .NOT. ISCOLOR()
		SET COLOR OF INFORMATION TO W/N
		SET COLOR OF BOX	       TO W/N
	ENDIF
RETURN     && EOP: ShowHelp

PROCEDURE Leave
	*--- Sets main program loop variable to force program end. 
	leave = "Yes"
	PLAY MACRO O
	DEACTIVATE MENU
RETURN

* --- EOP: dCLNDR.PRG