/* key compare result definitions */
#define NODESIZ 512
#define FOXBASE 1
#define DBASE   2

/********************************************************************
 * DBASE III+/IV * DBASE III+/IV ** DBASE III+/IV ** DBASE III+/IV **
 ********************************************************************/
/* index file anchor node */
typedef struct dbanchor {            /* index file anchor node   */
	long	root_node;		/* root node number		*/
	long	next_node;		/* next node number		*/
	long	unused1;		/* unused 4 bytes		*/
    char    keylen;         /* length of key        */
	char	unused2;		/* unused 1 byte		*/
	char	keys_node;		/* maximum keys per node	*/
	char	unused3;		/* unused 1 byte		*/
	char	key_type;		/* 1 = numberic 0 = character	*/
	char	unused4;		/* unused byte			*/
	char	key_size;		/* sizeof KEY_ENTRY		*/
	char	unused5[5];		/* unused 5 bytes		*/
    char    keyexpr[100];  /* key expression in ASCII  */
    char    unused6[388];   /* unused 388 bytes     */
} DBANCHOR;

/* index file data node */
typedef struct dbnode {
	char	keys_node;		/* number of keys in this node	*/
	char	unused1[3];		/* unused 3 bytes		*/
	char	key_entry[NODESIZ - (4 * sizeof(char))];/* key values	*/
} DBNODE;

/* structure for use by ichknod and iprtnod functions */
typedef struct dbkeyptr {
    unsigned long pointer;  /* pointer to lower level */
    unsigned long record;   /* database record number */
	char	*data;			/* pointer to key data */
} DBKEYPTR;

/* structure for use be all routines */
typedef	struct	index_area {
	long	root_node;		/* root node number		*/
	long	next_node;		/* next node number		*/
	long	this_node;		/* current node number		*/
    char    key_size;     /* length of key        */
	char	keys_node;		/* maximum keys per node	*/
	char	key_type;		/* 1 = numberic 0 = character	*/
    char    key_esize;       /* sizeof KEY_ENTRY     */
    char    key_text[100];  /* key expression in ASCII  */
    char    ndxname[15];    /* index file name      */
    int ifile;              /* index file descriptor    */
    int error;              /* error code of last error */
} DBINDEX;

/************************************************************************
 * FOXPRO/FOXBASE ** FOXPRO/FOXBASE ** FOXPRO/FOXBASE ** FOXPRO/FOXBASE *
 ************************************************************************/
typedef struct foxanchor {
    unsigned long   rootnode;   /* pointer to root node */
    unsigned long   freelist;   /* pointer to free list */
    unsigned long   filesize;   /* file size in bytes */
    unsigned int    keylen;     /* length of key */
    unsigned char   idxopt;     /* 1=unique, 8=for used, 0=none, 9=both */
    unsigned char   idxsig;     /* index signature (reserved) */
    unsigned char   keyexpr[220];   /* key expression in ASCII */
    unsigned char   forexpr[220];   /* for expression in ASCII */
    unsigned char   unused[55];     /* unused */
} FOXANCHOR;

typedef struct idxnod {
    unsigned int    nodetype;   /* 0=index, 1=root, 2=leaf, 3=both */
    unsigned int    totalkey;   /* number of keys present */
    unsigned long   leftnode;   /* pointer to left node (-1 if none) */
    unsigned long   ritenode;   /* pointer to right node (-1 if none) */
    unsigned char   keyptr[499];/* key + 4 byte hex record number (leaf node) */
                                /* key + 4 byte pointer to next block (other) */
} FOXNODE;

typedef struct keyptr {
    unsigned char  *keyinfo;
    unsigned long   recptr;
} FOXKEYPTR;

