PAGE  61,130
; ....:PROGRAM  DBWIND. ASM
; ....:by H. O. Koenig
; ....:April 10, 1987
; ....:version 1.0
;
; ....: A module to be loaded into dbase .prg files
; ....: Opens a window as large or as small as you please !
; .........: receives as parameters <S> & the top left and bottom right row/col
; .........: saves what's under the window and then clears the area. OR
; .........: if given <R> it restores what was trashed before.
;
; ....: Uses Some ROM BIOS routines - some hardware dependent
;
;       Syntax Suggestions:
;         To OPEN a window on screen:
;           STORE "S"+chr(r1)+chr(c1)+chr(r2)+chr(c2) TO mparm
;           CALL Dbwind mparm
;
;         To CLOSE a window and rewrite what was under it:
;	    STORE "R" to mparm
;           CALL Dbwind with mparm
;====================================================================;
;            Catalogue of jobs in this program
;--------------------------------------------------------------------;
; CGA hardware control  - hardware dependent
;	DSABLCGA
;	ENABLCGA
; READPARM		parses the parameter pointed to by BX
; LINSZNUM		checks size of window
; GETVIDCH		ascertains video mode and page in memory
; SAVESCR		writes screen to memory buffer,saves cursor postion
; WINDDRAW              Draws window border
; RESTSCR		restores screen,cursor position
; VIDOFFS               calculates address in video meory 
;====================================================================
; ....: MACROS: Save, Restore, Ngonechk, Zgonechk
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
PUSHON	MACRO	R1,R2,R3,R4,R5,R6,R7,R8
; This macro takes a parameter list and pushes each parameter register,
; in the order given.
;
;	USAGE: SAVE AX,BX,CX....
;
		IRP	x,<R1,R2,R3,R4,R5,R6,R7,R8>
			IFNB <X>
				PUSH  X
			ENDIF
		ENDM
	ENDM
;-----------------------------------------------------------------------
POPOFF	MACRO	R1,R2,R3,R4,R5,R6,R7,R8
; This macro takes a parameter list and pushes each parameter register,
; inthe order given.
;
;	USAGE: RESTORE AX,BX,CX....
;
		IRP	x,<R8,R7,R6,R5,R4,R3,R2,R1>
			IFNB <X>
				POP  X
			ENDIF
		ENDM
	ENDM
;-----------------------------------------------------------------------
NGONECHK	MACRO	R1,ONEGOAL,TWOGOAL
;	All this thing does is OR the parameter and
;	jmp to BADGOAL if it is zero and OKGOAL if it ain't.
;	kind of a IF(~NOT~ ZERO)THEN...,ELSE
;		Think of it as "Not-zero-Go-ONE CHecK"
;
;	USAGE:	NGONECHK dl,HOWBIG,FINISH
;
			or	r1,r1
			JNZ	ONEGOAL
			JMP	TWOGOAL
		ENDM
;-----------------------------------------------------------------------
ZGONECHK	MACRO	R1,ONEGOAL,TWOGOAL
;	All this thing does is OR the parameter and
;	jmp to BADGOAL if it ain't zero and OKGOAL if it is.
;	kind of a IF(ZERO)THEN...,ELSE
;		Think of it as "Zero-Go-ONE CHecK"
;
;	USAGE:	ZGONECHK dl,HOWBIG,FINISH
;
			or	r1,r1
			JZ	ONEGOAL
			JMP	TWOGOAL
		ENDM

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  Labels for SYMDEB
; data labels
PUBLIC	ADAPTER, AWREADY, BOTROW, CURSPOS, ENABLVAL, IBMKEY, JOBTYPE
PUBLIC	LEFTCOL, LINEBYDF, LINEBYTE, LINEDIFF, LINEMID, LINENUM, LINESIZ
PUBLIC	MODEFLG, RIGHTCOL, SCREENBF, TOPROW, VIDOFFST, VIDPAGE, VIDSEG

; code labels

PUBLIC	DISABLE1, DOIT, FINISH, GOHAID, HOWBIG, LNSZGOOF, LNSZEXIT, MAIN
PUBLIC	NEXT, OPENMAIN, RCHCK, RDPMGOOF, RDPMEXIT, RESTORE1
PUBLIC	RESTORIT, RESTSCR, SAVE1, SAVEIT, STASHR, STASHS, STASHS2
PUBLIC	WHATELSE, WHATMODE, WTMDEXIT, YUP, ZAPIN, ZAPINR, ZAPOUT, ZAPOUTR

; routine labels
PUBLIC	GETVIDCH, GITBACK, DSABLCGA, ENABLCGA, LINSZNUM, READPARM,
PUBLIC	SAVESCR, VIDOFFS, WINDDRAW, WINDER

;EQUATES
; - graphics characters - double-line
lttpcrnr	equ  201		; left top corner
verln		equ  186		; vertical line
ltbmcrnr	equ  200		; left bottom corner
horln		equ  205		; horizontal line
rtbmcrnr	equ  188		; right bottom corner
rttpcrnr	equ  187		; right top corner
bordattr	equ  70H		; border attribute (inverse)
textattr	equ  07H		; text attribute (normal)

TITLE	DBWIND.BIN
;
PROG	SEGMENT BYTE PUBLIC 'PROG'
	ASSUME  CS:Prog, DS:Prog, ES:Prog;, SS:Prog
;
WINDER	PROC	FAR
org	00h
MAIN:	JMP  DOIT
;
; --------------- various bytes and words ---------------
notice		db  'dbWIND'	; authorship notice
notice1		db  ' 1987 by Harold O. Koenig. '
notice2		db  ' of Clerical Services, Inc.'
notice3		db  ' Scottsville, VA 24590'
notice4		db  ' released to Public Domain'
;
;---------------- Parameter slots
jobtype		db  '?'
toprow		db  '?'	
leftcol		db  '?'	
botrow		db  '?'
rightcol	db  '?'
;
awready		db  0			; 0 = no window saved
IBMkey		db  'IBM'		; EGA BIOS marker
adapter		db  0			; 0=MGA, 1 = CGA, 2 = EGA
modeflg		db  7			; mode holder flag, assuming monochrome
vidpage		db  '?'			; current video page
vidseg		dw  0B000H		; default video segemnt (monochrome)
vidoffst	dw  '?'			; video offset holder
linenum		db  '?'			; number of lines in window
linesiz		db  '?'			; length in characters of line
linemid		dw  '?'			; line length minus edges (WORD! for 
					;    loop control . . .
linediff	dw  '?'			; width of screen minus line length
linebyte	dw  '?'			; bytes per line
linebydf	dw  '?'			; bytes per line leftovers
curspos		dw  '?'			; cursor position holder
enablval	db  2CH,28H,2DH,29H	; Values to enable CGA display
		db  2AH, 2EH,1EH
screenbf	dw  2000 dup('?')	; windmax = 80 char * 25 lines = 2000
;
;==================== This is the Program Right Here ========================
DOIT:					; Save everything in sight!	     
	PUSHON  AX,BX,CX,DX,DS,SI,DI	; Macro pusher
NEXT:
	CALL	Readparm		; read [BX] and Store what you find
	ZGONECHK  DL,Rchck,Finish	; Any goofs?
RCHCK:
	ZGONECHK  DH,Howbig,Gitback	; Was 'R' passed as parameter?
HOWBIG:
	CALL	Linsznum		; if not,figure out size of window
	ZGONECHK  DL,Gohaid,Finish	; check for errors
GOHAID:
	CALL	Getvidch		; GET VIDEO MODE AND PAGE NUMBER
	CALL	Vidoffs			; GET VIDEO ADDRESSES
; - - - - - - - Save what underlies the window then open window - - - - - - 
;
	mov  al,Byte Ptr CS:adapter	; adapter = 1 if this is a CGA
	NGONECHK  AL,Zapout,Saveit	; if CGA then disable it a minute,
ZAPOUT:	
	CALL  Dsablcga			; otherwise
SAVEIT:
	CALL  Savescr			; just save the screen.
	CALL  Winddraw			; Write the Box to Video memory
;
	mov  al,Byte Ptr CS:adapter	; adapter = 1, if this is a CGA
	NGONECHK  AL,Zapin,Finish	; if CGA then enable it again,
ZAPIN:
	CALL Enablcga			; OTHERWISE, FINISH UP
	mov  Byte Ptr CS:awready,1	; Set the "saved one already" byte"
	JMP Finish
;
;---Here's where you go if it's a restore call! - - - - - - - - - - - - - -
GITBACK:
;--------------------------------------------------------------------;
;  Presumably, you only come to GITBACK if you have already opened   ;
;  a window.  -- TO open a window, you have to establish video mode, ;
;  video segment, and the rest of it....                             ;
;  But for GITBACK a lot of this info is already stored in variables ;
;--------------------------------------------------------------------;

; - - - - - -  Close the window and Restore what was there before  - - - - 
;
YUP:
	mov  al,Byte Ptr CS:adapter	; adapter = 1 if this is a CGA
	NGONECHK  AL,Zapoutr,RESTORIT	; if CGA then disable it a minute
ZAPOUTR: 
	CALL  Dsablcga			; otherwise
;					; just save the screen
RESTORIT:
	CALL  Restscr
	NGONECHK  AL,Zapinr,Rfinish	; IF CGA re-enable it, else go home
ZAPINR: 
	CALL  Enablcga
RFINISH:
	mov  Byte Ptr CS:awready,0	; Reset the "no window saved" byte
FINISH:
	POPOFF  AX,BX,CX,DX,DS,SI,DI	; Macro popper
	RET
;**************
WINDER	ENDP	
;============== This is the END OF the Program Right Here ================
; - now come all the (not so) little sub-routines -
;
;--------------------------------------------------------------------;
;	READPARM                                                     ;
; reads [BX] and stores what it finds there                          ;
;     Uses Al exclusively (almost) but                               ;
;     Leaves DH  set if Job is a restore                             ;
;            DH  reset if job is a save                              ;
;     Leaves DL set if an error has occurred                         ;
;            DL is reset if all is copacetic                         ;
;--------------------------------------------------------------------;

READPARM	PROC	NEAR
	PUSHON	ax
	xor	dx,dx			; clear error flag
	mov  al,Byte Ptr [bx]		; first parameter is job type.
	mov  Byte Ptr [bx],0
	and  al,05Fh			; make it capital.
	cmp  al,'R'			; is it one
	JE  STASHR			; of the two
	cmp  al,'S'			; acceptable letters?
	JE  STASHS			; if so save it and continue,
	JMP  RDPMGOOF			; otherwise there's a boo-boo.
STASHR:	mov  Byte Ptr CS:jobtype,al	; store job type.
	inc  dh				; Set DH
	mov  AL,BYTE Ptr CS:awready	; check for last job.
	ZGONECHK AL,RDPMGOOF,RDPMEXIT	; If zero go to error
					; otherwise git outta here
;
STASHS:	mov  Byte Ptr CS:jobtype,al	; store job type.
	mov  AL,BYTE Ptr CS:awready	; check for last job.
	ZGONECHK  AL,STASHS2,RDPMGOOF	; If not 0 we've already saved stuff.

;--------------------------------------------------------------------;
; Get corners from BX:0000 to 'variable' slots                       ;
;        We subtract 1 from each parameter because dBase freaks out  ;
;          if asked to deal with a chr(0)                            ;
;--------------------------------------------------------------------;
STASHS2:
	mov  al,Byte Ptr [bx+1]		; get top row
	sub  al,1
	mov  Byte Ptr CS:toprow,al	
	mov  al,Byte Ptr [bx+2]		; get left column
	sub  al,1
	mov  Byte Ptr CS:leftcol,al
	mov  al,Byte Ptr [bx+3]		; get bottom row
	sub  al,1
	mov  Byte Ptr CS:botrow,al
	mov  al,Byte Ptr [bx+4]		; get right column
	sub  al,1
	mov  Byte Ptr CS:rightcol,al
	JMP	RDPMEXIT
RDPMGOOF:
	inc	dl			; set error flag	
RDPMEXIT:
	POPOFF  ax
	RET
READPARM	ENDP
;
;--------------------------------------------------------------------;
;             Line Size and Number  (linsznum)                       ;
;              Assures that window parameters are                    ;
;               within range AND                                     ;
;              Stores line length and size in variables              ;
;              Sets DL if error in window size                       ;
;--------------------------------------------------------------------;
LINSZNUM	PROC	NEAR
	PUSHON	ax,cx
	xor  dl,dl			; clear dl for error flag
	mov  al,Byte Ptr CS:botrow	; bigger number in al
	mov  bl,Byte Ptr CS:toprow	; if bottom row not
	sub  al,bl			; greater than top then
	JNG  LNSZGOOF  			; there's an error - and...
	cmp  al,24			; gotta be less than 26
	JG  LNSZGOOF
	cmp  al,1			; and more than 1
	JLE  LNSZGOOF
	inc  al
	mov  Byte Ptr CS:linenum,al	; otherwise, store this number
	mov  al,Byte Ptr CS:rightcol	; get the columns
	mov  bl,Byte Ptr CS:leftcol
	sub  al,bl			; if left is bigger than right
	JNG  LNSZGOOF  			; it was a mistake, besides..
	cmp  al,79			; gotta be less than 81
	JG  LNSZGOOF
	cmp  al,1			; and more than 1
	JLE  LNSZGOOF
        inc  al
	mov  Byte Ptr CS:linesiz,al	; otherwise save this, too
	PUSH  ax
	sub  al,2			; calculate linewidth 
	xor  ah,ah
	mov  Word Ptr CS:linemid,ax 	; minus edges...
	POP  ax
	mov  cl,80			; get line length in cl
	sub  cl,al			; line left overs
	xor  ch,ch			; byte to word in CX
	mov  Word Ptr CS:linediff,cx	; store this too
	shl  cl,1			; bytes left over
	mov  Word Ptr CS:linebydf,cx	; line difference in bytes
	shl  al,1			; get bytes per line (size * 2)
	xor  ah,ah
	mov  Word Ptr CS:linebyte,ax	; and store that
	JMP  LNSZEXIT
LNSZGOOF:
	mov  dl,1			;if error, then set flag in dl
LNSZEXIT:
	POPOFF  ax,cx
	RET
LINSZNUM	ENDP
;-------------END of Routine to Figure some parameters
;
;--------------------------------------------------------------------;
;-------------Routine to Get Video Characteristics                   ;
;            GETVIDCH  - uses int 10h function 15 to                 ;
;        ascertain video page and mode, etc.                         ;
;--------------------------------------------------------------------;
GETVIDCH	PROC	NEAR
	PUSHON	ax,bx,

	xor  ax,ax			; set up for DOS call
	mov  ah,15			; to get mode and page
	int  10H			; do it
	mov  Byte Ptr CS:modeflg,al	; store results
	mov  Byte Ptr CS:vidpage,bh
WHATMODE:
	cmp  al,7			; is the mode monochrome?
	JE   WHATELSE			; if so, skip following
	mov  Word Ptr CS:vidseg,0B800h	; else,if CGA then goose vid address
	mov  Byte Ptr CS:adapter,1	; and set adapter flag
WHATELSE:				; (default vidseg was B000H)
				;checking for EGA
	mov  ax,0C000h			; point ES at EGA Bios segment
	mov  es,ax
	mov  di,1Eh			; point DI where signature is
	lea  si,CS:IBMKEY		; point SI at string
	mov  cx,3			; three letters to look for
	cld				; go the right way
	repe cmpsb			; check those suckers
	JNE  WTMDEXIT			; if not equal, go on
	mov  Byte Ptr CS:adapter,2	; adapter = 2 if EGA
WTMDEXIT:
	POPOFF  ax,bx
	RET
GETVIDCH	ENDP
;-------------END of Routine to Get Video Characteristics
;
;--------------------------------------------------------------------;
;                 VIDOFFS - calculates address in video memory       ;
;             Routine to calculate VIDeo OFFSet                      ;
;             Puts Value in variable 'vidoffst'                      ;
;--------------------------------------------------------------------;
VIDOFFS	PROC	NEAR
	PUSHON	AX,BX,DX,DI
	mov  dh, Byte Ptr CS:toprow
	mov  dl, Byte Ptr CS:leftcol
	xor  bh,bh			; clear out top byte
	mov  bl, Byte Ptr CS:vidpage	; so we can use number of pages
	xor  ah,ah			; clean out top byte
	mov  al,160			; 80 char/line * 2 bytes/char
	mul  dh				; gets us to the row
	shl  dl,1			; # of cols times 2
	xor  dh,dh			; clear out top byte
	add  ax,dx			; so we can add to ax
	mov  di,ax			; and move to destination index
	mov  ax,1000h			; a video page = 4000 and change
	mul  bx				; times the number of pages
	add  di,ax			; total address
	mov  Word PTR CS:vidoffst,di	; hold it
	POPOFF  AX,BX,DX,DI
	RET
VIDOFFS	ENDP
;-------------END of Routine to calculate VIDeo OFFSet
;
;--------------------------------------------------------------------;
;     DSABLECGA        ENABLCGA                                      ;
;-------------Routines to Disable/Enable CGA                         ;
;  Um, uh, Borrowed from a program in PC magazine                    ;
;  Not so subtle as waiting for the vertical retrace                 ;
;    but fast and, unfortunately, flashy!                            ;
;--------------------------------------------------------------------;
DSABLCGA	PROC	NEAR			; avoiding snow
	PUSHON  AX,BX,DX
	mov  dx,3DAH				; Load status register address
disable1:
	in  al,dx				; get video status
	test  al,8				; ???
	JE  DISABLE1				; do it until not equal
	sub  dx,2
	mov  al,25H
	out  dx,al
	POPOFF  AX,BX,DX
	RET
DSABLCGA	ENDP
;-------------END of Routine to Disable CGA
;
;-------------Routine to Enable CGA
ENABLCGA	PROC	NEAR
	PUSHON	AX,BX,DX
	mov  ah,15
	int  10h
	lea  bx,CS:enablval			
	xlat	
	mov  dx,3D8H
	out  dx,al
	POPOFF  AX,BX,DX
	RET
ENABLCGA	ENDP
;-------------END of Routine to Enable CGA
;
;-------------Routine to Save Screen to memory
;--------------------------------------------------------------------;
;                 SaveScr - saves what's under coming window         ;
;                 On Entry                                           ;
;                   ES:DI  has address of storage buffer             ;
;                  IF CGA is not disabled, you gonna get snow!       ;
;                  You need to know the video offset                 ;
;                 video segment set by Getvidch                      ;
;--------------------------------------------------------------------;
SAVESCR	PROC	NEAR
	push	cs
	pop	es
	mov  di,OFFSET screenbf			; aim at buffer
; Find and save cursor position
	mov  ah,3				; funct. 3 reads cursor postion
	int  10h				; get row into DH, col into DL
	mov  Word Ptr CS:curspos,dx		; store it
	push  di				; save dest index, make room 
	mov  di,Word Ptr CS:vidoffst		; for starting address in DI.
; Let SI point to video and DI to buffer
	mov  si,di				; move it to Source Index
	pop  di					; and get destination back
	push  ds				; save ds
	mov  ds,WORD Ptr CS:vidseg		; aim DS at video memory
;	assume  ds:nothing			; ds don't mean nothing?
; Set up outer loop (number of lines)
	xor  ch,ch
	mov  cl,Byte Ptr CS:linenum		; how many times to do this?
	cld					; FROM SI TO DI
Save1:	push  cx				; save counter
; inner loop
	xor  ch,ch
	mov  cl,Byte Ptr CS:linesiz		; counter for line length
; move line (string) a word at a time
	rep  movsw
; end of inner loop
;
	add  si,Word Ptr CS:linebydf		; point at next line
	pop  cx					; get counter
	LOOP  SAVE1				; do it agin!
; end of outer loop
;
	pop  ds					; restore ds
;	assume  ds:prog				; straighten out assembler
	RET
SAVESCR	ENDP
;-------------END of Routine to Save screen to memory
;
;--------------------------------------------------------------------;
;     WINDDRAW                                                       ;
;             Routine to open Window  - is a mess                    ;
;                                                                    ;
;                  ES:DI points at exact spot in video memory        ;  
;--------------------------------------------------------------------;
WINDDRAW	PROC	NEAR
	mov  es,Word Ptr CS:vidseg		
	mov  di,Word Ptr CS:vidoffst
	cld
;--Write top line border to screen memory--
	mov  al,lttpcrnr			; get left top corner
	mov  ah,bordattr			; in inverse video
	stosw					; move it!
	mov  cx,Word Ptr CS:linemid		; figure top line
	mov  al,horln				; horizontal line character
	rep  stosw				; move it!
	mov  al,rttpcrnr			; get right top corner
	stosw					; move it!	
;
;------------- do body of window
;
	add  di,Word Ptr CS:linebydf		; GET TO NEXT LINE
	mov  cl,Byte Ptr CS:linenum		; get number of lines
	sub  cl,2				; less top and bottom lines
	xor  ch,ch				; byte to word in CX
OPENMAIN:
	PUSH  cx				; save it
	mov  al,verln				; do left side
	stosw					; move it!
	mov  al,32				; blank character
	mov  ah,textattr			; normal attribute
	mov  cx,Word Ptr CS:linemid		; get line width
	rep	stosw				; move it!
;
	mov  al,verln				; right side
	mov  ah,bordattr			; in inverse video
	stosw					; move it!
	add  di,Word Ptr CS:linebydf		; point at next line
	POP  cx					;retrieve counter
	loop  OPENMAIN
;
; -----do bottom
;
	mov  al,ltbmcrnr			; get left bottom corner
	stosw					; move it!
;
	mov  cx,Word Ptr CS:linemid		;
	mov  al,horln				; horizontal line character
	rep  stosw				; move it!
;
	mov  al,rtbmcrnr			; get right bottom corner
	stosw					; move it!	
	RET
WINDDRAW	ENDP
;-------------END of Routine to Draw Window
;
;--------------------------------------------------------------------;
;        RESTSCR restores screen from memory                         ;
;-------------Routine to Restore Screen from memory                  ;
;                                                                    ;
;                                                                    ;
;--------------------------------------------------------------------;
RESTSCR	PROC	NEAR
	push  cs
	pop  ds
	mov  SI,OFFSET screenbf		; aim from buffer
	mov  di,Word Ptr CS:vidoffst
	push  es
	mov  es,Word Ptr CS:vidseg
;	assume	es:nothing
	mov  cl,Byte Ptr CS:linenum
	xor  ch,ch			; byte to word
	cld
restore1:
	push	cx			; save line counter
	xor	ch,ch			; byte in CL to word in CX
	mov	cl,Byte Ptr CS:linesiz	; words per line
	rep	movsw			; does a line
	add	di,Word Ptr CS:linebydf ; point at next line
	pop	cx
	loop	restore1
	pop  es
;	assume	es:prog
;Get cursor back where it was
	mov	dx,Word Ptr CS:curspos	;get info back
	xor	al,al
	mov	bh,Byte Ptr CS:vidpage
	mov	ah,2
	int	10
	RET
RESTSCR	ENDP
;-------------END of Routine to Restore screen from  memory
PROG	ENDS
END	MAIN
