/* DBTCLEAN.C - Clean up memo (.DBT) files of extraneous characters */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <dir.h>
#include <dos.h>

void memo_clean( FILE * ) ;

FILE *fp;
unsigned long blockno;
int curx, cury = 0;

int main(int argc, char *argv[])
{
   FILE *fopen();
   struct ffblk wildcard;
   char fn[65] ;
   int i = 0;
   char *title1 = "Andy San's Memo File Cleaning Utility, Version 1.0\n";
   char *title2 = "Released into the Public Domain 05/12/91.\n";

   printf(title1);
   printf(title2);

   if (argc < 2)
      {
      puts( "\nUsage: dbtclean <filespec>" ) ;
      puts( "\nfilespec = memo files to be processed, e.g. *.dbt" ) ;
      exit ( 0 ) ;
      }
   else
      strcpy(fn, argv[1]);

   strupr(fn);

   if (strchr(fn, (int) ".") == NULL)
      strcat(fn, ".DBT");

   if (findfirst(fn, &wildcard, 0))
      {
      printf ("\nAbend: No files matching \"%s\"", fn);
      exit ( 1 ) ;
      }

   i = 0 ;

   setcbrk ( 1 ) ;

   while ( 1 )
      {

      fp = fopen (wildcard.ff_name, "r+b");

      printf ("\nCleaning %s, block ", wildcard.ff_name);

      blockno = 1;
      curx = wherex() ;
      cury = wherey() ;

      memo_clean ( fp ) ;

      fclose (fp);
      gotoxy(curx - 6, cury);
      printf ("%d blocks.  ", blockno);
      if ( !strpbrk(fn, "?*") == NULL)  /* got a wild card in it  */
         if (findnext(&wildcard))
            break ;
         else
            continue ;
      else
         break ;
      }

   puts( "" ) ;
   return ( i ) ;
}

void memo_clean ( FILE *memo )
{
   long mcount;
   int mbyte;

   fseek ( memo, 512, 0 );

   while ( 1 )
      {
      mcount = 0;
      mbyte = 32;

      while ( mbyte != 26 && ! feof ( memo ) )
         {
         mbyte = getc( memo );
         ++mcount;
         }

      mbyte = getc( memo );

      if ( feof ( memo ) )
         break;
      else
         fseek ( memo, -1, SEEK_CUR );

      while ( mcount % 512 != 0 )
         {
         mbyte = putc( 32, memo );
         ++mcount;
         }

      fseek ( memo, 0, SEEK_CUR ) ;

      if ( blockno % 10 == 0 || blockno == 1 )
         {
         gotoxy(curx, cury);
         printf ("%lu", blockno);
         }

      ++blockno;
   }
   return;
}
