/*-----------------------------------------------------*
 | DBO.H  -  for use with DBO.C                        |
 |                                                     |
 |        -  dBase III and Clipper file definitions    |
 |        -  Oracle reserved symbol names              |
 |                                                     |
 | Last modified:     R.Trevithick, Tue  03-28-1989    |
 *-----------------------------------------------------*/


#define ORA_VER    "ORACLE 5.1.17.5"    /* symbol table as of...       */
#define NORM_DBF    0x03                /* ID of .dbf file w/o memo    */
#define MEMO_DBF    0x83                /* ID of .dbf file w/ memo     */
#define MAX_FIELDS  1024                /* maximum Clipper Summer '87  */
#define MAX_NAME    31                  /* maximum Oracle table name   */
#define TMP_NAME    "t_e_m_p"           /* temporary rename table      */
#define REC_NAME    "r_e_c"             /* name to use in CTL file     */
#define SYMB_EXT    "_$"                /* add to name if reserved     */
#define TAB         "        "          /* don't want real tabs        */

enum { ARGS, READ, HEAD, WRIT, NAME };  /* some likely error types     */


/*---------------------------------------- dBase file structures ------*/
struct dbf_header {
    unsigned char   id_byte;            /* version; high bit if memo   */
    signed char     year,               /* dbase's revision date.  Not */
                    month,              /*  necessarily the same as    */
                    day;                /*  DOS revision date.         */
    unsigned long   num_recs;           /* number of records in file   */
    unsigned        header_len,         /* size of the header          */
                    record_len;         /* size of each record         */
    unsigned char   reserved[20];       /* reserved bytes              */
};

struct dbf_record {
    unsigned char   field_name[11],     /* field name                  */
                    data_type;          /* C,N,L,D,M                   */
    unsigned long   data_addr;          /* field data address          */
    unsigned char   field_length,       /* field length                */
                    decimals,           /* field decimal count         */
                    reserved[14];       /* reserved bytes              */
};


/*---------------------------------------- we need to store these -----*/
struct field {
    unsigned char   name[13],           /* 10 + _$ + zero byte == 13   */
                    type,               /* add R type for decimals     */
                    len,                /* normal length value         */
                    dec;                /* normal decimal place value  */
};


/*---------------------------------------- Oracle reserved symbols ----*/
char *reserved =
" ACCESS ADD ALL ALTER AND ANY APPEND AS ASC ASSERT ASSIGN AUDIT BETWEEN \n"
" BY CHAR CHECK CLUSTER COLUMN COMMENT COMPRESS CONNECT CONTAIN CONTAINS \n"
" CRASH  CREATE  CURRENT  DATAPAGES  DATE  DBA  DBLINK  DECIMAL  DEFAULT \n"
" DEFINITION  DELETE  DESC  DISTINCT  DOES DROP EACH ELSE ERASE EVALUATE \n"
" EXCLUSIVE EXISTS FILE FLOAT FOR FORMAT FROM GRANT GRAPHIC GROUP HAVING \n"
" IDENTIFIED  IF  IMAGE  IMMEDIATE IN INCREMENT INDEX INDEXED INDEXPAGES \n"
" INITIAL  INSERT  INTEGER  INTERSECT  INTO IS LEVEL LIKE LINK LIST LOCK \n"
" LONG  MAXEXTENTS  MINUS MODE MODIFY MOVE NEW NOAUDIT NOCOMPRESS NOLIST \n"
" NOSYSSORT  NOT  NOWAIT  NULL  NUMBER OF OFFLINE OLD ON ONLINE OPTIMIZE \n"
" OPTION  OR  ORDER  PAGE  PARTITION PCTFREE PRIOR PRIVILEGES PUBLIC RAW \n"
" RENAME REPLACE REPORT RESOURCE REVOKE ROW ROWID ROWNUM ROWS RUN SELECT \n"
" SESSION SET SHARE SIZE SMALLINT SPACE START SUCCESSFUL SYNONYM SYSDATE \n"
" SYSSORT  TABLE  TEMPORARY THEN TO TRIGGER UID UNION UNIQUE UPDATE USER \n"
" USING  VALIDATE  VALUES  VARCHAR  VARGRAPHIC  VIEW WHENEVER WHERE WITH \n";

