* Program...: FIXUP.PRG
* Author....: David A. Kennedy
* Date......: 01/04/92
* Notes.....: This code is provided for users who want to use a third-party
*             library with dbMAX, such as ProClip, FUNCky, Overlay(), IDL,
*             Clipper Tools, NANFOR.LIB, etc.  If you DO use a library,
*             DO NOT use DBMAX??.LIB and REVISE all the replacement functions
*             below.  Using FIXUP.prg as is and not using DBMAX??.LIB will
*             result in 100% Clipper code.
*
* Revised...: 02/24/92, ver 1.10 - rewrote NEWCOLOR() in straight Clipper
*             07/01/92, ver 1.20 - revised for 132-column mode
*             08/29/92, ver 1.21 - fixed error in sample alldrives() code
*             01/31/93, ver 1.26 - minor text revisions
*             02/01/93, ver 1.26 - wrote GETCOLOR() in Clipper
*             03/17/93, ver 1.30 - revised for Clipper 5.2
*             12/27/93, ver 1.32 - added Clipper Tools 3.0 examples
*
*****************************************************************************
*
static vaColors := {'N  ','B  ','G  ','BG |GB ','R  ','RB |BR ','RG |GR ',;
                    'W  ','+N |N+ ','+B |B+ ','+G |G+ ','+BG|+GB|BG+|GB+',;
                    '+R |R+ ','+RB|+BR|RB+|BR+','+RG|+GR|RG+|GR+','+W |W+ '}
*
*****************************************************************************
*
function kbd_alt()
*
* Purpose:         Detects whether the <Alt> key is pressed.
* If Not Revised:  You will not be able to press <Alt> to activate the menu
*                  system (use F9 or <Alt> plus hot-key instead).
*
* If you have FUNCky, use "return KBDSTAT(8)".
* If you have NANFOR.LIB, use "return FT_ALT()".
* If you have Clipper Tools 3.0, use "return ISBIT(KBDSTAT(),4)".
*
return (.F.)
*
*****************************************************************************
*
function alldrives()
*
* Purpose:         Returns a string containing all available drive letters.
* If Not Revised:  The list of available drives will be incorrect, but
*                  no fatal errors will occur if an unavailable drive is
*                  selected.
*
* If you have IDL 2.x, use "return DRV_LETTERS()".
* If you have FUNCky, use "return DRIVESTR()".
*
* If you have Clipper Tools 3.0, use:
*
* local vnTemp
* local vcDrive := ''
*
* for vnTemp=65 to 90
*   if DISKREADY(chr(vnTemp))
*     vcDrive += chr(vnTemp)
*   endif
* next
*
* return (vcDrive)
*
return 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'          && fake it
*
*****************************************************************************
*
function dosargs(vnDummy)
*
* Purpose:         Returns the drive and path where the dbMAX .EXE is located.
* If Not Revised:  The default code will not work properly if dbMAX is not
*                  run from the current path or if the .EXE is renamed!  The
*                  program will not be able to find the .INI/.ENV or help
*                  files.  As a workaround, to run dbMAX using a batch file
*                  containing the lines:
*
*                  @ECHO OFF
*                  CD\DBMAX                  (or wherever .EXE is located)
*                  DBX %1 %2 %3 %4 %5 %6 %7
*
* If you have NANFOR.LIB, use "return FT_ORIGIN()".
* If you have Clipper Tools 3.0, use "return EXENAME()".
*
*
return curpath()+'DBX.EXE'         && see CURPATH() below
*
*****************************************************************************
*
function clock(vcMode)
*
* Purpose:         Displays a ticking clock on the screen (vcMode="on" or
*                  "off").
* If Not Revised:  No clock is displayed, no errors will occur.
*
* If you have IDL 2.x, use:
*
* if vcMode='on'
*   CLOCK(0,maxcol()-7,,.F.,.T.)
* else
*   UN_CLOCK()
* endif
* return ''
*
* If you have FUNCky, use:
*
* if vcMode='on'
*   CLOCK12(0,maxcol()-7)
* else
*   UNCLOCK()
* endif
* return ''
*
* If you have Clipper Tools 3.0, use:
*
* if vcMode='on'
*   SHOWTIME(0,maxcol()-7,.T.,vcMenuBar,.T.,.T.)
* else
*   SHOWTIME()
* endif
* return ''
*
return ''
*
*****************************************************************************
*
function curpath(vcDrive)
*
* Purpose:         Returns a string containing the full drive and path for
*                  the selected drive.
* If Not Revised:  The default code will not work properly if dbMAX is not
*                  run from the C: drive!  The program will not be able to
*                  find the .INI/.ENV or help files.
*
* If you have FUNCky, use "return CURDIR()".
*
if vcDrive=nil
  *vcDrive := CURDRIVE()              && IDL 2.x
  *vcDrive := FT_DEFAULT()            && NANFOR.LIB
  *vcDrive := DISKNAME()              && Clipper Tools 3.0
  *
  * -or-
  *
  * Set the default to drive C: or whatever drive that the .EXE is on!  If
  * not set to the proper drive, the .INI/.ENV/help files will not be found!
  *
  vcDrive := 'C'
endif
return vcDrive+':\'+iif(empty(curdir(vcDrive)),'',curdir(vcDrive)+'\')
*
*****************************************************************************
*
function flipcolor(vcColor)
*
* Purpose:         Used only to provide enhanced color for the DOS screen,
*                  which is not used in this version of dbMAX.
* If Not Revised:  No errors will occur.
*
* If you have NANFOR.LIB, use "return FT_INVCLR(vcColor)"
*
* If you have Clipper Tools 3.0, use
* "return NTOCOLOR(INVERTATTR(vcColor),.T.)".
*
return (vcColor)         && fake it
*
*****************************************************************************
*
function getcolor()
*
* Purpose:         Gets the color of the DOS screen.
* If Not Revised:  No errors will occur.
*
* If you have IDL 2.x, use "return ATT2COLOR(SCR_GETATT())".
* If you have Clipper Tools 3.0, use "return NTOCOLOR(SCREENATTR(),.T.)".
*
local vnColor := asc(substr(savescreen(row(),col(),row(),col()),2,1))
local vnBG    := int(vnColor/16)
local vnFG    := vnColor-(vnBG*16)
*
return (trim(substr(vaColors[vnFG+1],1,3))+'/'+ ;
 trim(substr(vaColors[vnBG+1],1,3)))
*
*****************************************************************************
*
function isptr(vnPort)
*
* Purpose:         Returns .T. if the selected printer port is ready.
* If Not Revised:  The printer status for LPT2 and LPT3 will always return
*                  .F. even if the port is valid and the printer on-line.
*
* If you have IDL 2.x, use "return ISPRINTER(vnPort)" or 
* "return (LPT_STAT(vnPort)=0)".
*
* If you have FUNCky, use "return ISPRINTER(vnPort)" or
* or "return ISLPT(vnPort)" or "return (PRNSTATUS(vnPort)=0)".
*
* If you have NANFOR.LIB, use "return FT_ISPRINT('LPT'+str(vnPort,1,0))"
*
* If you have Clipper Tools 3.0, use "return PRINTREADY(vnPort)" or
* "return (ISBIT(PRINTSTAT(vnPort),5))".
*
return iif(vnPort=1,isprinter(),.F.)
*
*****************************************************************************
*
function newcolor(vnTop,vnLeft,vnBottom,vnRight,vcColor)
*
* Purpose:         Sets the background color for a rectangular area on the
*                  screen.
* If Not Revised:  Slow execution speed or invalid colors if the defaults are
*                  changed or both.
*
* If you have IDL 2.x, use
* "return SCR_SETATT(COLOR2ATT(vcColor),vnTop,vnLeft,vnBottom,vnRight)".
*
* If you have NANFOR.LIB, you can use the following:
*
* local vnFG := vnBG := 0
* local vcFG,vcBG
* *
* * use only the foreground color
* *
* vcColor := upper(iif(','$vcColor,substr(vcColor,1,at(',',vcColor)-1),vcColor))
* *
* vcFG := padr(left(vcColor,at('/',vcColor)-1),3)
* vcBG := padr(substr(vcColor,at('/',vcColor)+1),3)
* vnFG := ascan(vaColors,{|x| vcFG$x})-1
* vnBG := ascan(vaColors,{|x| vcBG$x})-1
* *
* return FT_SETATTR(vnTop,vnLeft,vnBottom,vnRight,vnFG+vnBG*16)
*
* If you have Clipper Tools 3.0, use
* "return COLORWIN(vnTop,vnLeft,vnBottom,vnRight,vcColor)".
*
*
* If you really want to use Clipper, be aware that the following code is slow.
*
* Clipper 5.0 can revise background colors, but vcColor will have to be
* translated into a number.  To calculate the number, add the foreground
* color number to 16 times the background color number.  Add 128 to make the
* foreground blink or for bright backgrounds if BLINK is OFF.
*
* For improved performance, instead of making the numeric calculations, you
* can check vcColor.  If vcColor equals the shadow color, force the
* attribute to be 7, otherwise, force it to be something else.
*
* Foreground/Background       Foreground colors only
* =========================   =======================================
* black = 0   red       = 4   dark grey    = 8    bright red     = 12
* blue  = 1   magenta   = 5   bright blue  = 9    bright magenta = 13
* green = 2   brown     = 6   bright green = 10   yellow         = 14
* cyan  = 3   dim white = 7   bright cyan  = 11   bright white   = 15
*
* *
* local vnFG := vnBG := 0
* local vcFG,vcBG,vcScreen,vnTemp
* *
* * use only the foreground color
* *
* vcColor := upper(iif(','$vcColor,substr(vcColor,1,at(',',vcColor)-1),vcColor))
* *
* vcFG := padr(left(vcColor,at('/',vcColor)-1),3)
* vcBG := padr(substr(vcColor,at('/',vcColor)+1),3)
* vnFG := ascan(vaColors,{|x| vcFG$x})-1
* vnBG := ascan(vaColors,{|x| vcBG$x})-1
* *
* vcScreen := savescreen(vnBottom,vnLeft,vnBottom,vnRight)
* for vnTemp=2 to len(vcScreen) step 2
*   vcScreen := stuff(vcScreen,vnTemp,1,chr(vnFG+vnBG*16))
* next
* restscreen(vnBottom,vnLeft,vnBottom,vnRight,vcScreen)
* *
* if vlType
*   vcScreen := savescreen(vnTop,vnRight-1,vnBottom,vnRight)
*   for vnTemp=2 to len(vcScreen) step 2
*     vcScreen := stuff(vcScreen,vnTemp,1,chr(vnColor))
*   next
*   restscreen(vnTop,vnRight-1,vnBottom,vnRight,vcScreen)
* endif
* return (nil)
*
* -or-   (NOTE: hard-coded colors!)
*        (comment out all but RETURN for max speed)
*
local vnColor  := 23       && 23 = 7+(16*1) = 'w/b'
local vlType   := .T.      && .T. means you're doing a shadow; .F., a hotkey
local vcScreen,vnTemp
*
do case
  case vcColor=vcShadow                    && vcShadow is shadow color
    vnColor := 7                           && 7 = w/n
    *
  case vcColor=vcHotKey                    && vcHotKey is hot key color
    vnColor := 62                          && 62 = 14+(16*3) = +rg/bg
    vlType  := .F.                         && not doing a shadow!
    *
  otherwise
    *
    * In this case, newcolor() is intended to "low-light" the browse window
    * (w/b) to show it is inactive.  You can change the code to do the low-
    * lighting (must do a filled box), but it will be very slow.  If you
    * don't low-light, when browsing two databases on screen it may be
    * difficult to tell which window is active.  Try setting the color to
    * w/b and drawing an unfilled box as a compromise.
    *
    return (nil)
endcase
*
vcScreen := savescreen(vnBottom,vnLeft,vnBottom,vnRight)
for vnTemp=2 to len(vcScreen) step 2
  vcScreen := stuff(vcScreen,vnTemp,1,chr(vnColor))
next
restscreen(vnBottom,vnLeft,vnBottom,vnRight,vcScreen)
*
if vlType
  vcScreen := savescreen(vnTop,vnRight-1,vnBottom,vnRight)
  for vnTemp=2 to len(vcScreen) step 2
    vcScreen := stuff(vcScreen,vnTemp,1,chr(vnColor))
  next
  restscreen(vnTop,vnRight-1,vnBottom,vnRight,vcScreen)
endif
return (nil)
*
*****************************************************************************
*
function overlay(vcProg,vnFree,vcSwapPath,vcPrompt)
*
* Purpose:         Used to shell to DOS and shell out and run the hypertext
*                  help program.
* If Not Revised:  If memory is available, no errors will occur; usually,
*                  however, either the help system will not load and/or
*                  the available DOS memory will be too small to be useful
*                  or will not be available at all.
*
* vcProg     = program to run, COMMAND.COM if empty
* vnFree     = amount of memory to free (0=all)
* vcSwapPath = path to create swapfile on
* vcPrompt   = DOS prompt and/or other environment variable to set
*
* Other ways to do this could be to:
*
*   1) use the Blinker 2.x/3.x swap function(s):
*
*      SWPSETENV(vcPrompt)
*      return SWPRUNCMD(vcProg,vnFree,'',vcSwapPath)
*
*      -or-
*
*   2) use SET CLIPPER=X:nn (if required) and a RUN (the HELP program
*      requires 55K or so plus DOS needs anything from about 30K to 40K
*      (DOS 5.0 may need over 100K)).  If you don't need to run anything
*      too large, don't bother with the X:nn parameter.
*
if empty(vcProg)
  run command
else
  run (vcProg)
endif
*
return (nil)
