program dblook(input,output);
{ DBLOOK prompts the user for a DBASE III+ database file, it then
  displays the structure information on the screen, and asks if you
  wish to see the records from the database.

  The program was designed to provide simple routines to read dbase
  files to generate reports.  Using a real for the record counter,
  but ignoring the upper record count byte only 1,716,060 records
  may be read.

  Each record will be placed in a string (temp) so that limits the
  record length to 255 characters max.

  If you make major improvements to the program, let me know as
  the ongoing effort to improve the performance of Dbase requires
  more tools. 
  
  Turbo Pascal 3.02 was used to develope the program.

  Gerald Rohr   RR#3    Anamosa, Iowa 52205

                         Revision History
  ----------------------------------------------------------------
  Rev 1.0 26 Sep 87 Original Release                           gbr
 }
const
   vno  = '1.0';            { release version number }

type
   rdef = record
      name  :string[11];     { Name of this record                   }
      rtype :char;           { type of record - C,N,D,L,etc.         }
      width :byte;           { total field width of this record      }
      decp  :byte;           { number of digits to right of decimal  }
      stloc :integer;        { offset from start of field where this }
   end;                      { record starts                         }

var
   fin      :file of byte;
   finc     :file of char;
   i,j,k    :integer;
   infile   :string[64];            { file to read }
   temp     :string[80];
   norecs   :string[4];
   ch       :char;
   bytearry :array[1..80] of byte;
   tp       :byte;
   rstru    :array[1..30] of rdef;  { holds the database structure }
   tmp_recno,                       { counter for while loop }
   no_rec   :real;                  { number of records in database }
   dataoff  :integer;               { location where data starts }
   no_col   :integer;               { number of columns in database }
   rec_len  :integer;               { length of each record }
   upd_yy   :integer;               { date of last update }
   upd_mm   :integer;
   upd_dd   :integer;
   head_byt :integer;               { number of bytes in header }
   len_rec  :integer;               { number of bytes in record reported }

procedure showstruc;
{ displays the information found in the dbase header }
var
   i :integer;
   tmp :string[20];
   tpe :string[10];

begin
   writeln('Structure for database :',infile);
   writeln('Date of last update    :',upd_mm:2,'/',upd_dd:2,'/',upd_yy:2);
   writeln('Number of records      :',no_rec:8:0);
   writeln('Column     Type       Width  Decimals Offset');
   writeln('---------- ---------- ------ -------- ------');
   writeln('           Delete Flg      1               1');
   for i := 1 to no_col do
      begin
      with rstru[i] do
         begin
         tmp := copy(concat(name,'          '),1,10);
         case rtype of
            'C' :tpe := 'Character';
            'N' :tpe := 'Numeric  ';
            'D' :tpe := 'Date     ';
            'L' :tpe := 'Logical  ';
            'M' :tpe := 'Memo     ';
            else tpe := 'Unknown  ';
         end;
         writeln(tmp,' ',tpe,'    ',width:4,'      ',decp:3,'   ',stloc:4);

      end;  {with}
   end;  {for}
   writeln;
   writeln('                       Record length -> ',rec_len:4);
   if rec_len <> len_rec then
      writeln('Found rec len= ',rec_len:4,'  File reports len = ',len_rec:4);
end; {procedure showstruc }

procedure calc_coloff;
{ calculate the offset from the beginning of the record for each
  data element.}
var
   i,j :integer;
begin
   j := 2;       { first element of record is deleted flag }
   for i := 1 to no_col do
      begin
      with rstru[i] do
         begin
         stloc := j;
         j := j + width;
      end; {with}
   end;  {for}
   rec_len := j - 1;   { max record length }
end;   {procedure calc_coloff}

procedure get_header;
{ reads and stores header information on a Dbase III+ .dbf file }
begin
   assign(fin,infile);
   reset(fin);
   read(fin,tp); { type of database 03 = no dbt 83 = dbt file }
   read(fin,tp); upd_yy := tp;
   read(fin,tp); upd_mm := tp;
   read(fin,tp); upd_dd := tp;
   read(fin,tp); no_rec := tp;
   read(fin,tp); no_rec := no_rec + (256.0*tp); { low 64K offset }
   read(fin,tp); no_rec := no_rec + (65536.0*tp);
   read(fin,tp); { just throw away the upper byte of the record count }
   read(fin,tp); head_byt := tp; { header bytes }
   read(fin,tp); head_byt := head_byt + (256*tp);
   read(fin,tp); len_rec := tp;  { reported length of records }
   read(fin,tp); len_rec := len_rec + (256*tp);

   for i := 13 to 32 do
      begin
      read(fin,tp);  { skip to data }
   end;
   no_col := 1;    { counter of the number of columns }
   read(fin,tp);    { get the first character of the record name }
   while (tp <> 13) do      { check for a carriage return }
      begin
      rstru[no_col].name[1] := chr(tp);   { NOTE: must be 1 character long }
      i := 2;
      read(fin,tp);
      while (tp > 0) and (i <= 11) do
         begin
         rstru[no_col].name[i] := chr(tp);
         i := i + 1;
         read(fin,tp);
      end;
      rstru[no_col].name[0] := chr(i - 1);  { tell string how long it is }
      while (i < 11) do
         begin
         read(fin,tp);  { skip any 0 terminators }
         i := i + 1;
      end;
      read(fin,tp);
      rstru[no_col].rtype := chr(tp);   { record type,the 12th element }
      for i := 1 to 4 do read(fin,tp);  { skip to the width (17th char) }
      read(fin,tp);
      rstru[no_col].width := tp;
      read(fin,tp);                     { and the location of the dp }
      rstru[no_col].decp := tp;          { decimal point location }
      {
      rest of header record to be read here
      }
      for i := 19 to 32 do read(fin,tp);  { just skip it }
      no_col := no_col + 1;
      read(fin,tp);      { get byte for while loop compare }
   end;
   close(fin);
   no_col := no_col -1;  { adjust for actual number of columns }
   dataoff := (no_col * 32) + 32 + 1;  { start of actual data }
   calc_coloff;                        { calculate column offsets }
end;   {procedure get_header}

begin   { main }
   clrscr;
   writeln('DBLOOK    Utility to read Dbase III+ .DBF files.        Ver ',vno);
   writeln;
   lowvideo;
   write('Enter Dbase file to read (END to exit) ');
   readln(infile);
   for i := 1 to length(infile) do infile[i] := upcase(infile[i]);
   if (infile <> 'END') then
      begin
      get_header;          { read the header of the database file }
      showstruc;           { show us what you have found }
      write('Read and display the data (Y/N) ');
      readln(ch);
      ch := upcase(ch);
      if ch = 'Y' then
         begin
         { reopen the file as a character file to read the data records. }
         assign(finc,infile);
         reset(finc);
         for i := 1 to dataoff do read(finc,ch);  { skip the header }
         tmp_recno := no_rec;
         while (tmp_recno > 0.5) do
            begin
            for j := 1 to rec_len do
               read(finc,temp[j]);
            temp[0] := chr(rec_len);
            writeln('!',temp,'!');
            tmp_recno := tmp_recno - 1;
         end;
         close(finc);
      end;
   end;
   writeln('End of DBlook.');
end.
