/*
 *	Programmer:	Timothy E. Hoff, thoff@falcon.depaul.edu
 *	File name:	dbf.h release 1.0
 *	Written:	April 8, 1994
 *	Modification Log:
 *
 *	This file contains standard data structures used in
 *	xBase (FoxPro, dBase, Clipper) dbf files.  The file
 *	format information is taken from the FoxPro Developer's
 *	Guide (version 2.0) published by Fox Software.  The memo byte
 *	uses the original dBase III format (83H).
 *
 *	This file is part of DBinfo.  DBinfo is free software which
 *	may be modified and/or redistributed under the terms of the
 *	GNU General Public License published by the Free Software
 *	Foundation.
 */

#define MEMO '\x03'
#define NO_MEMO '\x83'
#define MAX_FIELDS 255
#define MAX_CHARS 254

typedef struct date {
	unsigned char year;
	unsigned char month;
	unsigned char day;
} DATE;


typedef struct hex_long {
	unsigned char l_endian;				/*	Little endian	*/
	unsigned char s_endian;				/*	Small endian	*/
	unsigned char m_endian;				/*	Medium endian	*/
	unsigned char b_endian;				/*	Big endian	*/
} X_LONG;


typedef struct hex_int {
	unsigned char l_endian;
	unsigned char b_endian;
} X_INT;



typedef struct dbf_header_rec {
	unsigned char type;					/*	Type (Memo/No Memo)	*/
	DATE last_update;					/*	YYMMDD	*/
	X_LONG records;						/*	Number of records in the file	*/
	X_INT position;						/*	Position of first data record */
	X_INT rec_size;						/*	Length of one data record	*/
	unsigned char reserved[20];
} DBF_HEADER;



typedef struct field_subrecord {
	char field[11];						/*	Field name (max. 10 characters)	*/
	char type;							/*	C, N, L, M, D, F, P	*/
	X_LONG offset;						/*	Displacement of field in record	*/
	unsigned char length;				/*	Length of field (in bytes)	*/
	unsigned char precision;			/*	Number of decimal places	*/
	unsigned char reserved[14];
} FIELD;


/* * * * * * * * * * * * * * *
 *	FUNCTION DECLARATIONS	 *
 * * * * * * * * * * * * * * */

long xtolong(X_LONG);
int xtoint(X_INT);
X_LONG *longtox(long, X_LONG *);
X_INT *inttox(int, X_INT *);
void getfilename(char *);
void dosext(char *);
int readDBF(DBF_HEADER *, FILE *);
int	readREC(FIELD * [], X_INT, FILE *);
void printhdr(DBF_HEADER *);
void printrec(FIELD * []);

