/*** DBHEAD.C ***/
#include <stdio.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include <io.h>

struct dbcont {
   unsigned char  memo;
   unsigned char  updty;
   unsigned char  updtm;
   unsigned char  updtd;
   unsigned long  nrecs;
   unsigned short frecp;
   unsigned short recsize;
   char filler[20];
};

struct fld {
   char          fname[11];
   char          type;
   char          filler[4];
   unsigned char flen;
   unsigned char decp;
   char          fill2[14];
};

#define fmode O_RDONLY|O_BINARY

main(argc, argv)
int argc;
char *argv[];
{
      struct dbcont contents;
      struct fld dbfields;

      unsigned short fhandle, bytes,nflds,i;
      char file[65],ext[4];

      if(argc != 2) {
         fprintf(stderr,"Usage: dhhead d:\\path\\dbfile > device\n");
         exit(1);
      }

     strcpy(file,*++argv);
     get_ext(file,ext);
     if(strlen(ext) == 0) {
        strcat(file,".dbf");
     } else {
        if(strcmpi(ext,"dbf") != 0) {
           fprintf(stderr,"Invalid file extension.\n");
           exit(2);
        }
     }

     strupr(file);

     if((fhandle = open(file,fmode)) == -1) {
        fprintf(stderr,"Can't open %s.\n",file);
        exit(3);
     }

    if((bytes = read(fhandle,&contents,32)) != 32) {
       fprintf(stderr,"Can't read header contents!\n");
       close(fhandle);
       exit(4);
    }

    printf("Dbase III file: %s.\n",file);
    if(contents.memo == 0x83)
       printf("Database contents memo field(s).\n");
    printf("Last Updated :  %02u/%02u/%02u.\n",contents.updtm,
            contents.updtd,contents.updty);
    printf("Record size :      %5u.\n",contents.recsize);
    printf("Records :          %5lu.\n",contents.nrecs);
    nflds = (contents.frecp -1) / 32 - 1;
    printf("# of Fields :      %5u.\n\n",nflds);

    printf("Name          Type   Len   Dec\n");
    printf("===========   ====   ===   ===\n");
    for(i=1;i <= nflds;i++) {
       if((bytes = read(fhandle,&dbfields,32)) != 32) {
          fprintf(stderr,"Can't read field contents!\n");
          close(fhandle);
          exit(5);
       }
       printf("%-11s    %c     %3u   %3u\n",dbfields.fname,
              dbfields.type,dbfields.flen,dbfields.decp);
    }
    close(fhandle);
    exit(0);
}
/*   get_ext
**       pass file name in "s"
**       returns ext in "e"
**
*/
get_ext(s,e)
char s[],e[];
{
   char *y;
   y = strchr(s,'.');
   if(*y == '.') {
      for (y++ ;*y != '\0';e++,y++)
          *e = *y;
      *e = '\0';
   } else
      *e = '\0';
   return;
}
           