;* Program to do simple fileio from DBase III/Foxbase
;* Written by Carlos Soto
;* 116-53 Queens Blvd.
;* Forest Hills, NY 11375
;*
;* Version 1.0
;*
;* Parameter: FUNCTION,RETURN,BUFFER
;*  FUNCTION = Char   1 = O=Open
;*                        R=Read line
;*                        C=Close
;*  RETURN   = Char   1 = 0=No error
;*                        1=Undefined command
;*                        2=Must open file first
;*                        3=Must close previous file first
;*                        4=Cannot open file
;*                        5=Cannot close file
;*                        6=Cannot read file
;*                        E=EOF
;*                        U=Undefinded error
;*  BUFFER   = Char 128 = File name or buffer to read must be space filled
          PUBLIC   FILEIO
_PROG     SEGMENT
          ASSUME CS:_PROG,DS:_PROG,ES:_PROG
FILEIO    PROC FAR
          PUSH     BP
          PUSH     DS
          PUSH     ES
          PUSH     BX
          PUSH     CS
          POP      ES
          OR       BX,BX
          JNZ      PARAMOK       ; CHECK PARAMETER
          JMP      GETOUT
PARAMOK:  MOV      AL,[BX]       ; GET COMMAND
          INC      BX
          MOV      ES:RETADD,BX  ; SAVE ADDRESS OF RETURNED CODE
          CMP      BYTE PTR [BX],00 ; CHECK TO SEE IF THERE IS A SPACE
          JNZ      RETADDOK      ; FOR THE RETURN CODE
          JMP      GETOUT
RETADDOK: INC      BX
          MOV      ES:BUFADD,BX  ; SAVE BUFFER LOCATION
          CMP      AL,'O'        ; IS IT OPEN
          JNE      NOOPEN
          MOV      BX,ES:HANDLE  ; CHECK TO SEE IF FILE IS OPEN
          CMP      BX,00
          JZ       FCLOSE
          JMP      ERR3          ; YES THEREIS AN ERROR
FCLOSE:   MOV      AX,3D00H      ; OPEN FILE
          MOV      DX,ES:BUFADD  ; GET ADDRESS OF FILENAME
          INT      21H           ; OPEN FILE
          JNC      FCLOSE1
          JMP      ERR4          ; ERROR OPENING FILE
FCLOSE1:  MOV      ES:HANDLE,AX  ; SAVE HANDLE
          JMP      NOERR         ; NO ERROR EXIT
NOOPEN:   CMP      AL,'C'        ; IS IT CLOSE
          JNE      NOCLOSE
          MOV      BX,ES:HANDLE  ; CHECK TO SEE IF FILE IS OPEN
          CMP      BX,00
          JZ       ERR2          ; NO FILE TO CLOSE
          MOV      AH,3EH        ; CLOSE FILE
          INT      21H           ; HANDLE ALREADY IN BX
          JC       ERR5          ; UNABLE TO CLOSE
          XOR      AX,AX
          MOV      ES:HANDLE,AX  ; CLEAR HANDLE
          JMP      NOERR
NOCLOSE:  CMP      AL,'R'        ; IS IT READ
          JNE      NOREAD
          MOV      BX,ES:HANDLE  ; CHECK TO SEE IF FILE IS OPEN
          CMP      BX,00
          JZ       ERR2          ; NO FILE TO READ
          MOV      SI,ES:BUFADD  ; GET ADDRESS OF BUFFER
          MOV      BX,ES:HANDLE
MOREREAD: MOV      AL,[SI]       ; GET CHARACTER STORED;
          OR       AL,AL
          JZ       EOL           ; IF ZERO THEN END OF BUFFER FOUND
          MOV      DX,SI
          MOV      CX,0001
          MOV      AH,3FH
          INT      21H           ; READ ONE CHARACTER
          JC       ERR6          ; IF ERROR
          CMP      BYTE PTR [SI],0AH ; CHECK FOR LINE FEED
          JZ       LFREAD
          CMP      BYTE PTR [SI],1AH ; CHECK FOR EOF()
          JZ       EOFREAD
          OR       AX,AX         ; CHECK FOR 0 CHAR READ=EOF
          JZ       EOFREAD
          INC      SI            ; INCREMENT BUFFER POSITION
          JMP      MOREREAD      ; KEEP READING
EOFREAD:  MOV      AH,'E'        ; MARK EOF()
          JMP      CLREOL
LFREAD:   DEC      SI            ; CHECK FOR CR
          CMP      BYTE PTR [SI],0DH
          JZ       EOL           ; IF NOT RESET SI
          INC      SI
EOL:      MOV      AH,'0'        ; EVERYTHING READ OK
CLREOL:   MOV      AL,' '        ; CLEAR REST OF LINE TO SPACES
CLREOL1:  MOV      CL,[SI]
          OR       CL,CL
          JZ       RETDB         ; IF ZERO THEN END OF BUFFER FOUND
          MOV      [SI],AL
          INC      SI            ; KEEP BLANKING
          JMP      CLREOL1
NOREAD:
ERR1:     MOV      AH,'1'        ; NO COMMAND
          JMP      RETDB
ERR2:     MOV      AH,'2'        ; MUST OPEN FILE
          JMP      RETDB
ERR3:     MOV      AH,'3'        ; MUST CLOSE FILE
          JMP      RETDB
ERR4:     MOV      AH,'4'        ; CANNOT OPEN FILE
          JMP      RETDB
ERR5:     MOV      AH,'5'        ; CANNOT CLOSE FILE
          JMP      RETDB
ERR6:     MOV      AH,'6'        ; CANNOT READ FILE
          JMP      RETDB
NOERR:    XOR      AH,'0'
RETDB:    MOV      BX,ES:RETADD
          MOV      [BX],AH       ; SAVE RETURN CODE
GETOUT:   POP      BX
          POP      ES
          POP      DS
          POP      BP
          RET
HANDLE    DW       0
RETADD    DW       0
BUFADD    DW       0
FILEIO    ENDP
_PROG     ENDS
          END
