*  ķ
*   DB2PRG.PRG - Automatic DBF file creation for FoxBASE+ and FoxPro 
*                Version 2.3   1/1/1994                              
*  Ľ

*  ķ
*     SOFTWARE LICENSE AGREEMENT    
*  Ľ

*  DB2PRG is not public domain or free software.  If you 
*  continue using DB2PRG after a 30 day trial period, you 
*  must register for a license to use DB2PRG.

*  To register, send $10 (Ten dollars U.S.) directly to the
*  author:   (90 day unconditional money back guarantee)

*  Carlos Berguido         Inquiries:
*  1722 Capella Court      Voice phone 707 / 762-9067
*  Petaluma, CA 94954      Compuserve  72411,1071

*  Please include your name, address, and DB2PRG version
*  number.  You will receive the latest version of DB2PRG
*  SOURCE CODE on a 5" or 3" diskette (please specify).
   
*  DB2PRG.PRG is a "shareware program" and is provided at no charge 
*  to the user for evaluation.  Feel free to share it with your
*  friends, but please do not give it away altered or as part of
*  another system.  The essence of "user-supported" software is to
*  provide personal computer users with quality software without
*  high prices, and yet to provide incentive for programmers to
*  continue to develop new products.  

*  If you find this program useful and find that you are using
*  DB2PRG and continue to use DB2PRG after a 30 day trial period,
*  you must make a registration payment of $10.00 to Carlos
*  Berguido.  The $10.00 registration fee will license one copy for
*  use on any one computer at any one time.

*  You must treat this software just like a book.  For example, this
*  software may be used by any number of people and may be freely
*  moved from one computer location to another.  However, two or
*  more computers must not be running DB2PRG at the same time with
*  only a single registration, just as one copy of a book cannot be
*  read by two different persons at the same time.

*  Commercial users of DB2PRG must register and pay for their copies
*  of DB2PRG within 30 days of first use or their license is
*  withdrawn.  Site-License arrangements may be made by contacting
*  Carlos Berguido.

*  You are encouraged to pass a copy of DB2PRG along to your friends
*  for evaluation.  Please encourage them to register their copy if
*  they find that they can use it.  All registered users will
*  receive a copy of the latest version of the DB2PRG system on 
*  diskette with source code and telephone support for 1 year.

*  ķ
*             DISCLAIMER            
*  Ľ

*  Users of DB2PRG must accept the following disclaimer of warranty:
*
*  "DB2PRG is supplied as is.  The author disclaims all warranties,
*  expressed or implied, including, without limitation, the warranties
*  of merchantability and of fitness for any purpose. The author 
*  assumes no liability for damages, direct or consequential, which 
*  may result from the use of DB2PRG."

*  ķ
*       DEFINITION OF SHAREWARE     
*  Ľ

*  Shareware distribution gives users a chance to try software
*  before buying it.  If you try a Shareware program and continue
*  using it, you are expected to register.  Individual programs
*  differ on details - some request registration while others
*  require it, some specify a maximum trial period.  With
*  registration, you get anything from the simple right to continue
*  using the software to an updated program with printed manual.
  
*  Copyright laws apply to both Shareware and commercial software,
*  and the copyright holder retains all rights, with a few specific
*  exceptions as stated below.  Shareware authors are accomplished
*  programmers, just like commercial authors, and the programs are
*  of comparable quality.  (In both cases, there are good programs
*  and bad ones!)  The main difference is in the method of
*  distribution.  The author specifically grants the right to copy
*  and distribute the software, either to all and sundry or to a
*  specific group.  For example, some authors require written
*  permission before a commercial disk vendor may copy their
*  Shareware.

*  Shareware is a distribution method, not a type of software.  You
*  should find software that suits your needs and pocketbook,
*  whether it's commercial or Shareware.  The Shareware system makes
*  fitting your needs easier, because you can try before you buy. 
*  And because the overhead is low, prices are low also.  Shareware
*  has the ultimate money-back guarantee - if you don't use the
*  product, you don't pay for it.

*  ķ
*         DB2PRG DESCRIPTION        
*  Ľ

*  While developing applications, use CREATE and MODIFY STRUCTURE as usual
*  to create and modify data file structures.

*  Just before distributing your application, use DB2PRG.PRG.  The most
*  current structure of each DBF will be recorded in the MAKEDBF.PRG 
*  generated.

*  DB2PRG.PRG does not need to be distributed with an application, only
*  the MAKEDBF.PRG it creates need be distributed with your application.

*  Your applications could use the following code in it's initialization
*  process to let it know if it needs to DO MAKEDBF:
*
*    mmakedbf = .NOT. FILE('myfile1.dbf')
*    mmakedbf = mmakedbf .OR. .NOT. FILE('myfile2.dbf')
*    mmakedbf = mmakedbf .OR. .NOT. FILE('myfile3.dbf')
*    * ... and so forth for every dbf file in the application
*    IF mmakedbf
*       DO makedbf
*       * makedbf will only create missing files.
*       * makedbf will never overwrite any dbf files that already exist.
*       DO reindex    && application specific reindexing procedure you supply
*    ENDIF

*  The author acknowledges John Bauman for his article "DBF'S ON THE FLY" in
*  the August 1989 DATA BASED ADVISOR.  The article ably proved the value of
*  DBF from scratch capabilities.  DB2PRG has incorporated adaptations of
*  some of the methodologies described in John's article.

*  ķ
*          GETTING STARTED          
*  Ľ

* The DB2PRG system and documentation is completely contained in the
* Fox executable program file DB2PRG.PRG.  There are no other files
* needed to start DB2PRG.  Simply copy DB2PRG.PRG wherever it is
* convenient to keep it.  Normally DB2PRG.PRG is installed in a 
* subdirectory below the Fox Software program (FoxPro or FoxBASE+) 
* such as C:\FOX\GOODIES.

* The PATH to that subdirectory (such as C:\FOX\GOODIES) should be 
* included in a PATH= statement in the CONFIG.FP or CONFIG.FX file.
* See the Fox User Guide for more information on the CONFIG file.
* In addition, a DOS PATH to the subdirectory of the Fox Software
* program (FoxPro or FoxBASE+) such as C:\FOX should be in effect. 
* This can be done by typing PATH C:\FOX at any DOS command prompt,
* in the AUTOEXEC.BAT file, and/or in any batch file or other system
* you use to start the Fox Software system.

* Set up this way, no matter what disk or directory you start out from
* on your computer, entering FOXPRO DB2PRG or FOXPLUS DB2PRG at any DOS 
* command prompt will get both FoxPro or FoxBASE+ and DB2PRG started 
* with just a single command.

* Or, if you would like to start the Fox Software system first, and then
* later start DB2PRG when inside the Fox environment:

* 1. Be in the subdirectory of the DBF files to be used.

* 2. Start FoxPro or FoxBASE+.

* 3. If you have DB2PRG.PRG in some other sub-directory, SET a PATH to it
*    or specify the full path name in the next instruction.

* 4. Enter the command: DO DB2PRG.

* 5. Choose PROCEED from the main menu.

* 6. The file MAKEDBF.PRG will be created in the current directory.

*  ķ
*       DB2PRG RELEASE HISTORY      
*  Ľ

* Version 1.0  7/19/1990 first release

* Version 2.0  3/16/1991 enhancements
*              DBF file creation without KEYBOARD (FoxPro only)
*              Using SYS(2000) to get dbf file names eliminates 2 temp files
*              Corrected improper SYS(3) implementation
*              Colors selected for FoxPro and FoxBASE+
*              Additional code commenting and spacing

* Version 2.1  6/30/1991 enhancement
*              Traps error when attempting to USE invalid user dbf files
*              First release as shareware.  $10 registration fee.

* Version 2.2  12/8/1992 enhancement
*              Exclude files named in ASCII list: "db2.exc".

* Version 2.3  1/1/1994 - product description changes only

*  ķ
*           OTHER PRODUCTS          
*  Ľ

*       File: QQUERY.ZIP

*      Title: Elaborate Query manager for FoxPro & FoxBASE+ 

*   Keywords: QQUERY 2.10F 1/1/94 SHAREWARE $10.00 FOX

*  QQuery helps users create, store, modify, and replay logical
*  expressions. When combined with Fox or 3rd party report
*  generators, QQuery makes a simple yet powerful query tool.

*  For Fox database application developers, QQuery can add
*  powerful, reusable, ad hoc record selection to combine with
*  developer designed data and report formats. QQuery has a
*  complete online help system. Registered users receive source
*  code and the right to use QQuery in their distributed
*  applications.


*       File: DB2DOC.ZIP

*      Title: Automatic DBF documentation for FoxPro/FB+

*   Keywords: DB2DOC 2.3 1/1/94 SHAREWARE $10.00 FOX

*  DB2DOC inspects all DBF files in the current directory and
*  quickly generates/updates a FoxBASE+/FoxPro dbf file,
*  "DB2DOC.ddb".  Menus are provided to BROWSE the documentation
*  database to add application, file, and field descriptions, and
*  record counts.

*  DB2DOC generates file and field descriptions and statistics to
*  screen, printer, or disk file for any or all dbf files.  Source
*  included from QQUERY & DB2PRG author Carlos Berguido.

*  ķ
*         DB2PRG SOURCE CODE        
*  Ľ

* BEGIN db2prg.prg

PRIVATE massign, mmessage, mtalk, msafe, mscore, mstatus,;
        mcolor, mtitle, mscreen, mchoice, mfile, fstruct, mrow,;
        firstfile, excluding, including

* Turn off screen output and cursor
SET CONSOLE OFF
massign = SYS(2002)

* Save environment
mmessage = SYS(2001,'MESSAGE')   
mtalk    = SYS(2001,'TALK')       = 'ON'
msafe    = SYS(2001,'SAFETY')     = 'ON'
mscore   = SYS(2001,'SCOREBOARD') = 'ON'
mstatus  = SYS(2001,'STATUS')     = 'ON'

* Set environment for this program
SET MESSAGE TO 23
SET TALK OFF
SET SAFETY OFF
SET SCOREBOARD OFF
SET STATUS OFF
IF ISCOLOR()
   mcolor = SYS(2001,'COLOR')
   SET COLOR TO W+/B,RG+/W,W
   IF "FOXPRO" $ UPPER(VERSION())
      ACTIVATE SCREEN
      SET COLOR OF SCHEME 2 TO ,W+/B,,,W+/B,RG+/W
   ENDIF
ENDIF

* Paint screen frame and save it
CLEAR
mtitle = '(c) Carlos Berguido 1990, 1994                               All Rights Reserved'
@  0, 0 GET mtitle
mtitle = 'Version 2.3                      D B 2 P R G                      Release 1/1/94'
@ 22, 0 GET mtitle
CLEAR GETS
SAVE SCREEN TO mscreen

* Sign on help screen:
@ 1,0 SAY ''
SET CONSOLE ON
TEXT
   DB2PRG provides a quick and easy way to enhance your FoxPro or FoxBASE+
   applications.  DB2PRG automates the task of creating all the DBF file 
   structures needed by your application.
 
   If you choose to "Proceed", DB2PRG will search the current directory and 
   quickly generate a program file, "makedbf.prg", containing the commands 
   needed to create all of any of the DBF files DB2PRG found.  You may add
   "DO makedbf" to the initialization process of your application.  See the
   DB2PRG source code for details.
 
   DB2PRG is distributed using the "shareware" method of distribution.  It
   is not free software.  Continued use after a reasonable evaluation period
   requires a $10 registration fee.  See the DB2PRG source code for details.

        Carlos Berguido                 Author of FB+ and FoxPro utilities
        1722 Capella Court                  QQUERY - $10 shareware
        Petaluma, CA 94954                  DB2PRG - $10 shareware
        (707) 762-9067                      DB2DOC - $10 shareware


ENDTEXT

* Light bar menu:
@ 24, 0 PROMPT 'Cancel'  MESSAGE 'Cancel this program'
@ 24,10 PROMPT 'Proceed' MESSAGE 'Create or replace the program file MAKEDBF.PRG in the current directory'
MENU TO mchoice

IF mchoice = 2
   * make sure that all dbf files are closed
   CLOSE DATABASES
   SET CONSOLE OFF  && output to screen from RESTORE and @ r,c SAY only

   RESTORE SCREEN from mscreen
   @ 2, 0 SAY 'Filename  Fields'
   @ 3, 0 SAY REPL(CHR(223),80)

   mfile = SYS(2000,'*.dbf')

   IF LEN(mfile) = 0
      @ 11,12 SAY 'No DBF files were found - Makedbf.prg was not created.'
      @ 24,30 SAY 'Strike any key to exit '
   ELSE
      * Create makedbf.prg file
      SET ALTERNATE TO makedbf.prg
      SET ALTERNATE ON
      ?? '* MAKEDBF.PRG  Creates missing dbf files.  Requires FoxBASE+ or FoxPro.'
      ?  '*              This program code was generated by DB2PRG.prg on', DATE()
      ? 'PRIVATE mscreen, mprinter, mprint, mtalk, msafe, mscore, mstatus,;'
      ? '        fstrutxt, fstrudbf'
      ?
      ? '* Save environment'
      ? 'SAVE SCREEN TO mscreen'
      ? 'SET CONSOLE OFF'
      ? 'mprinter= SYS(2001,"PRINT",1)'
      ? 'mprint  = SYS(2001,"PRINT")       = "ON"'
      ? 'mtalk   = SYS(2001,"TALK")        = "ON"'
      ? 'msafe   = SYS(2001,"SAFETY")      = "ON"'
      ? 'mscore  = SYS(2001,"SCOREBOARD")  = "ON"'
      ? 'mstatus = SYS(2001,"STATUS")      = "ON"'
      ?
      ? '* Set environment for this program'
      ? 'SET TALK OFF'
      ? 'SET SAFETY OFF'
      ? 'SET SCOREBOARD OFF'
      ? 'IF mstatus'
      ? '   SET STATUS OFF'
      ? 'ENDIF'
      ?
      ? '* Obtain 2 unique filenames'
      ? 'fstrutxt = SYS(3)+".txt"'
      ? 'fstrudbf = SYS(3)+".db1"'
      ?
      ? '* Create a seed dbf file for STRUCTURE EXTENDED'
      ? 'IF "FOXPRO" $ UPPER(VERSION())'
      ? '   SET PRINTER TO &fstrudbf'
      ? '   SET PRINT ON'
      ? '   ?? CHR(3)+"["+CHR(3)+CHR(6)+REPL(CHR(0),4)+CHR(161)+CHR(0)+CHR(18)'
      ? '   ?? REPL(CHR(0),21)'
      ? '   ?? "FIELD_NAME" + CHR(0)          + "C" + CHR(1)  + REPL(CHR(0),3)'
      ? '   ?? CHR(10) + REPL(CHR(0),15)'
      ? '   ?? "FIELD_TYPE" + CHR(0)          + "C" + CHR(11) + REPL(CHR(0),3)'
      ? '   ?? CHR(1) + REPL(CHR(0),15)'
      ? '   ?? "FIELD_LEN"  + CHR(0) + CHR(0) + "N" + CHR(12) + REPL(CHR(0),3)'
      ? '   ?? CHR(3) + REPL(CHR(0),15)'
      ? '   ?? "FIELD_DEC"  + CHR(0) + CHR(0) + "N" + CHR(15) + REPL(CHR(0),3)'
      ? '   ?? CHR(3) + REPL(CHR(0),15) + CHR(13) + CHR(26)'
      ? '   SET PRINT OFF'
      ? '   * restore original printer port assignment'
      ? '   SET PRINTER TO &mprinter'
      ? 'ELSE'
      ? '   * if FoxBASE+, use the CREATE user interface'
      ? '   CLEAR TYPEAHEAD'
      ? '   KEYBOARD "FIELD_NAME"          + "C10" +CHR(13)'
      ? '   KEYBOARD "FIELD_TYPE"          + "C1"  +CHR(13)'
      ? '   KEYBOARD "FIELD_LEN" + CHR(13) + "N3"  +CHR(13)+"0"+CHR(13)'
      ? '   KEYBOARD "FIELD_DEC" + CHR(13) + "N3"  +CHR(13)+"0"+CHR(13)+CHR(13)+CHR(13)+"N"'
      ? '   CREATE &fstrudbf'
      ? '   RESTORE SCREEN FROM mscreen'
      ? 'ENDIF'
      ?
      ? '* Draw alert box to display dbf file name being created'
      ? '@ 10,29 CLEAR TO 12,50'
      ? '@ 10,29 TO 12,50 DOUBLE'
      ? '@ 11,31 SAY "Creating: "'

      * get a unique filename for a temporary dbf file
      fstruct   = SYS(3) + ".db1"
      mrow      = 0
      firstfile = .T.
      excluding = .F.
      DO WHILE LEN(mfile) > 0 

         * Display the dbf file name on the screen
         mfile = LOWER(LEFT(mfile,AT('.',mfile)-1))
         mrow  = MOD(mrow,17)
         @ mrow + 4, 0 CLEAR TO mrow + 5,79
         @ mrow + 4, 0 SAY mfile

         * Make a STRUCTURE EXTENDED version of the dbf file
         not_open = .F.
         ON ERROR not_open = .T.
         USE &mfile ALIAS userfile
         ON ERROR
         SET CONSOLE OFF

         IF not_open
            @ mrow + 4,10 SAY 'ERROR: Can not open file'
         ELSE

            */ 12/8/92 text file with list of file names to exclude:
            IF firstfile .AND. FILE('db2.exc')
               firstfile = .F.
               excluding = .T.
               fexcldb = SYS(3)+'.db3'
               fexcldx = SYS(3)+'.dx1'
               COPY TO &fstruct STRUCTURE EXTENDED
               SELECT 2
               USE &fstruct
               ZAP
               APPEND BLANK
               REPLACE field_name WITH 'file_name', field_type WITH 'C',;
                       field_len  WITH 8
               USE
               CREATE &fexcldb FROM &fstruct
               USE &fexcldb ALIAS db2exclu
               APPEND FROM db2.exc SDF
               * get rid of any file name extensions
               * any .dbf or other extension will be ignored
               GOTO TOP
               DO WHILE .NOT. EOF()
                  massign = AT('.', file_name)
                  IF massign > 0
                     REPLACE file_name WITH ;
                             LEFT(file_name, massign - 1)
                  ENDIF
                  SKIP
               ENDDO
               INDEX ON LOWER(file_name) TO &fexcldx
               SELECT userfile
            ENDIF

            IF excluding
               SELECT db2exclu
               SEEK LEFT(mfile + SPACE(8), 8)
               including = EOF()
               SELECT userfile
            ELSE
               including = .T.
            ENDIF

            IF including

               COPY TO &fstruct STRUCTURE EXTENDED
               USE &fstruct

               * Generate the makedbf lines for the file
               ?
               ? 'IF .NOT. FILE("&mfile..dbf")'
               ? '   @ 11,41 CLEAR TO 11,49'
               ? '   @ 11,41 SAY UPPER("&mfile")'
               ? '   SET ALTERNATE TO &fstrutxt'
               ? '   SET ALTERNATE ON'
               ? '   TEXT'
               DO WHILE .NOT. EOF()
                  @ mrow + 4, 10 SAY REPL(CHR(254),MOD(RECNO(),71))
                  ? field_name + field_type + STR(field_len,3) + STR(field_dec,3)
                  SKIP
               ENDDO
               ? '   ENDTEXT'
               ? '   CLOSE ALTERNATE'
               ? '   USE &fstrudbf'
               ? '   ZAP'
               ? '   APPEND FROM &fstrutxt SDF  FOR field_name<>" "'
               ? '   USE'
               ? '   CREATE &mfile. FROM &fstrudbf'
               ? 'ENDIF'
            ELSE
               @ mrow + 4,10 SAY '(excluded)'
            ENDIF
         ENDIF

         USE
         ERASE &fstruct

         * get next dbf file name, nul string when there are no more
         mfile = SYS(2000,'*.dbf',1)
         mrow  = mrow + 1
      ENDDO
      ?
      ? '* Erase the temporary files'
      ? 'USE'
      ? 'ERASE &fstrudbf'
      ? 'ERASE &fstrutxt'
      ?
      ? '* Restore the environment'
      ? 'IF mprint'
      ? '   SET PRINT ON'
      ? 'ENDIF'
      ?
      ? 'IF msafe'
      ? '   SET SAFETY ON'
      ? 'ENDIF'
      ?
      ? 'IF mscore'
      ? '   SET SCOREBOARD ON'
      ? 'ENDIF'
      ?
      ? 'IF mstatus'
      ? '   SET STATUS ON'
      ? 'ENDIF'
      ?
      ? 'IF mtalk'
      ? '   SET TALK ON'
      ? 'ENDIF'
      ?
      ? 'RESTORE SCREEN FROM mscreen'
      ? 'SET CONSOLE ON'
      ?
      ? 'RETURN'
      ?

      CLOSE ALTERNATE

      @ 24,20 SAY 'Makedbf.prg created.  Strike any key to exit '

   ENDIF

ENDIF

* Restore cursor
massign = SYS(2002,1)

IF mchoice = 2
   * Wait with files closed
   massign = INKEY(0)
   @ 24, 0 CLEAR TO 24,79
ENDIF

* Restore environment
IF ISCOLOR()
   SET COLOR TO &mcolor
   IF "FOXPRO" $ UPPER(VERSION())
      SET COLOR OF SCHEME 2 TO
   ENDIF
ENDIF

SET MESSAGE TO VAL(mmessage)

IF msafe
   SET SAFETY ON
ENDIF

IF mtalk
   SET TALK ON
ENDIF

IF mstatus
   SET STATUS ON
ENDIF

IF mscore
   SET SCOREBOARD ON
ENDIF

SET CONSOLE ON

RETURN

* EOF db2prg.prg
