*         Name: FMT2SCX.PRG
*       Author: Andrew Coupe
*  Called From: FMT2SCX.SPR
*Last Revision: 05/22/92
*        NOTES: Creates an SCX file from a text file containing @ say/get statements
*
talkset=SET("TALK")
SET TALK OFF
WAIT WINDOW "Please Wait.." NOWAIT
dbfopen=.f.  &&flag to see if a DBF file is in use
IF LEN(dbfile)>0  &&they opened a dbf or vue file
	dbfopen=.t.
	IF RIGHT(dbfile,3)="DBF"  &&It's a DBF file
		USE (dbfile)
	ELSE
		SET VIEW TO (dbfile)
	ENDIF
ENDIF
SET SAFETY OFF
CREATE TABLE temp (LINE C(254))  &&Temporary table to hold text file
USE
SELECT 25
** Read in the data from the text file
USE temp
APPEND FROM (fname) SDF
SELECT j
CREATE SCREEN (newscx) FROM temp  &&create an empty SCX screen file
USE (newscx)
ZAP
SELECT 25
DIMENSION pname[10]  &&define @ options names in an array
pname[1]="SAY"
pname[2]="GET"
pname[3]="PICT"
pname[4]="FUNC"
pname[5]="VALID"
pname[6]="WHEN"
pname[7]="COLO"
pname[8]="MESS"
pname[9]="RANG"
pname[10]="ERRO"

** Start processing each line in the temporary file
SCAN  
   ucline=UPPER(ALLTRIM(LINE))
   IF ucline="READ"
      EXIT
   ENDIF
   ** Ignore lines not starting with @ or those containing CLEAR TO or FILL TO
   IF ucline <>"@" .OR. "CLEAR TO"$ucline .OR. "FILL TO"$ucline .OR. "PROM"$ucline .OR. "MENU"$ucline
      LOOP
   ENDIF
   getsay=.F.  &&is there a get and a say
   SELECT 10
   APPEND BLANK
   SELECT temp
   txt=ALLTRIM(SUBS(LINE,AT("@",LINE)+1))
   DO WHILE "  "$txt  &&remove double spaces
      txt=STRTRAN(txt,"  "," ") &&remove double spaces
   ENDDO
   txt=STRTRAN(txt,"'",'"')  &&convert single quotes to double
   IF RIGHT(txt,1)=";" &&line continues
      txt=";"
      SCAN WHILE RIGHT(txt,1)=";"
         txt=LEFT(txt,LEN(txt)-1)+ALLTRIM(LINE)
      ENDSCAN
      txt=ALLTRIM(SUBS(txt,AT("@",txt)+1))  &&remove @
   ENDIF

   m.row=LEFT(txt,AT(",",txt)-1)
   txt=LTRIM(SUBS(txt,AT(",",txt)+1))
   m.col=LEFT(txt,AT(" ",txt)-1)
   IF " BOX "$ucline
      txt=LTRIM(SUBS(txt,AT(",",txt)+1))
   ELSE
      txt=LTRIM(SUBS(txt,AT(" ",txt)+1))
   ENDIF
   REPLACE j.vpos WITH VAL(m.row),j.hpos WITH VAL(m.col)

   ** LINE OR BOX
   IF UPPER(LEFT(txt,3))="TO" .OR. " BOX "$ucline
      IF " DOUB"$ucline
         REPLACE j.objcode WITH 5,j.objtype WITH 7,j.fillchar WITH CHR(0)
      ELSE
         REPLACE j.objcode WITH 4,j.objtype WITH 7,j.fillchar WITH CHR(0)
      ENDIF
      IF UPPER(txt)="TO"
         txt=SUBS(txt,3)
      ENDIF
      m.height=VAL(LEFT(txt,AT(",",txt)-1))+1
      txt=SUBS(txt,AT(",",txt)+1)
      m.width=VAL(txt)+1
      REPLACE j.height WITH m.height-j.vpos,j.width WITH IIF(m.width-j.hpos=0,1,m.width-j.hpos)
      LOOP
   ENDIF

   DIMENSION gpos[11],options[10]
   FOR X=1 TO 10
      gpos[X]=AT(pname[X],UPPER(txt))
   ENDFOR
   gpos[11]=LEN(txt)+1
   =ASORT(gpos)
   IF "GET"$ucline .AND. "SAY"$ucline
      getsay=.T.
   ENDIF
   FOR X=1 TO 10
      IF gpos[X]=0 && option not used
         options[X]=""
         LOOP
      ENDIF
      options[X]=SUBS(txt,gpos[X],gpos[X+1]-gpos[X])
      thisopt=ALLTRIM(SUBS(options[X],AT(" ",options[X])+1))
      optname=LEFT(UPPER(options[X]),4)

      IF optname="SAY" 
      	IF OCCURS('"',thisopt)=2 .AND.LEFT(thisopt,1)='"'.AND.RIGHT(thisopt,1)='"'  &&text
				REPLACE j.objtype WITH 5,j.objcode WITH 0,j.expr WITH thisopt,;
            j.height WITH 1,j.width WITH LEN(thisopt)-2 &&-2 for quotes
      	ELSE &&expression
            REPLACE j.objtype WITH 15,j.objcode WITH 0,j.expr WITH thisopt,;
            j.height WITH 1,j.width WITH 10,j.refresh WITH .T.
			ENDIF         
      ENDIF
      pictwidth=0  &&set picture width to 0
      IF optname="GET"  &&get
         IF getsay
            thisvpos=j.vpos
            thishpos=j.hpos+LEN(j.expr)-1
            SELECT 10
            APPEND BLANK
            SELECT temp
            REPLACE j.vpos WITH thisvpos,j.hpos WITH thishpos
         ENDIF
         IF " "$thisopt &&strip out options
            thisopt=LEFT(thisopt,AT(" ",thisopt)-1)
         ENDIF
         REPLACE j.objtype WITH 15,j.objcode WITH 1,j.name WITH thisopt,;
            j.height WITH 1
         thiswidth=10  &&default width
         IF dbfopen
        		IF ">"$thisopt  &&If alias found, find alias name
        			aname=LEFT(thisopt,AT(">",thisopt)-2)
        			fldname=subs(thisopt,at(">",thisopt)+1) &&find field name
        		ELSE 
        			aname=ALIAS(1)
        			fldname=thisopt
        		ENDIF
        		thiswidth=FSIZE(fldname,aname)
        	ENDIF
        	REPLACE j.width WITH IIF(thiswidth=0,10,thiswidth)
      ENDIF
      IF optname="PICT"
         REPLACE j.picture WITH thisopt,j.width WITH LEN(j.picture)-2
      ENDIF
      IF optname="FUNC"
         IF LEN(j.picture)>0
            thispict=SUBS(j.picture,2,LEN(j.picture)-2)
            thisopt='"@'+SUBS(thisopt,2,LEN(thisopt)-2)+' '+thispict
         ELSE
            thisopt=STUF(thisopt,2,0,"@")
         ENDIF
         REPLACE j.picture WITH thisopt
      ENDIF
      IF optname="VALI"
         REPLACE j.valid WITH thisopt
      ENDIF
      IF optname="WHEN"
         REPLACE j.when WITH thisopt
      ENDIF
      IF optname="COLO"
      	REPLACE j.colorpair WITH thisopt
      ENDIF
      IF optname="MESS"
         REPLACE j.message WITH thisopt
      ENDIF
      IF optname="RANG"
         REPLACE j.rangelo WITH LEFT(thisopt,AT(",",thisopt)-1)
         IF ","$thisopt
            REPLACE j.rangehi WITH SUBS(thisopt,AT(",",thisopt)+1)
         ENDIF
      ENDIF
      IF optname="ERRO"
         REPLACE j.error WITH thisopt
      ENDIF
   ENDFOR
ENDSCAN
CLOSE DATA
ERASE temp.dbf
SET TALK &talkset
RETURN
