*:*********************************************************************
*:
*:        Program: CORRUPT.PRG
*:
*:         System: Repair Corrupt Databases
*:         Author: Randy E. Selhorst
*:      Copyright (c) 1992, Randy E. Selhorst
*:  Last modified: 03/31/92     15:04
*:
*:  Procs & Fncts: CHECKALL
*:               : FIXMEMO
*:               : CHECK
*:               : CHKFILE
*:               : REPOERR
*:               : SECERROR
*:
*:          Calls: CORRUPT.SPR
*:               : CHECKALL       (procedure in CORRUPT.PRG)
*:               : FIXMEMO        (procedure in CORRUPT.PRG)
*:               : CHECK          (procedure in CORRUPT.PRG)
*:
*:           Uses: BADDBFS.DBF    
*:               : CORRUPT.DBF    
*:
*:  This program will ask for either an indivdual database or a
*: directory in wich it will locate all corrupt databases.  If the
*: database is corrupt or the memo file is corrupt the program will 
*: ask you if you would like to fix it.  Any records that are lost
*: are recorded in the corrupt.dbf.  If you want a complete recovery on
*: the memo file I suggest you run MRECOVER.PRG
*:
*:      Documented 05/22/92 at 13:23               FoxDoc  version 2.01
*:*********************************************************************
CLEAR ALL
CLOSE ALL
SET BLINK ON
SET DELE ON
SET SAFETY OFF
CLEAR
SET TALK OFF
SET FULLPATH ON
STORE SET('DEFAULT')+CURDIR() TO fileloc
STORE FILELOC+'BADDBFS' to m.baddbfs
SELE 3
USE baddbfs excl
SELE 1
USE corrupt
SELE 2
STORE SET('DEFAULT',1) TO MDEFA
DO WHILE .T.
   SELECT baddbfs
   ZAP
   STORE '' TO mmessage
   STORE 0 TO choice,mfile
   STORE '' TO m.datafile,datadir
   DO corrupt.spr
   IF choice = 2 .OR. EMPTY(m.datafile+datadir)
      CLEAR ALL
      CLOSE ALL
      CLEAR
      ON ERROR
      RETURN
   ENDIF
   IF EMPTY(m.datafile)
      STORE .T. TO val_dir
      DEFINE WINDOW work FROM 10,33 TO 14,47 DOUBLE COLOR SCHEME 7
      ACTIVATE WINDOW WORK
      SET BLINK ON
      @ 1,1 SAY 'Working...' COLOR rg+/R*
      DO checkall
      SET DEFA TO (mdefa)
      SET BLINK OFF
      RELEASE WINDOW work
      IF val_dir
         SELE baddbfs
         IF RECCOUNT() > 0
            DEFINE WINDOW mbrowse FROM 0,0 TO 20,79 SYSTEM TITLE 'Corrupt_files'
            DEFINE WINDOW mread FROM 20,0 TO 24,79 NONE
            GO TOP
            BROWSE WINDOW mbrowse NOWAIT
            ACTIVATE WINDOW mread
            @ 1,21 SAY 'Do you wish to fix all corrupt files?'
            @ 3,30 GET mpick ;
               PICTURE "@*HT \!Yes;\?No" ;
               size 1,5,10 ;
               DEFAULT 1
            READ cycle WITH corrupt_files, mread
            RELEASE WINDOW mread
            RELEASE WINDOW mbrowse
            USE
            SELE 3
            USE &baddbfs EXCL
            IF LASTKEY() <> 27 .AND. mpick <> 2 .AND. mpick<> 0
               GO TOP
               DO WHILE .NOT. EOF()
                  IF the_error = 41
                     DEFINE WINDOW mread ;
                        FROM 18, 10 ;
                        TO 22,69 ;
                        TITLE ' '+ALLTRIM(name)+' ';
                        NOFLOAT ;
                        NOCLOSE ;
                        SHADOW ;
                        DOUBLE ;
                        COLOR SCHEME 1
                     STORE 0 TO mpick2
                     ACTIVATE WINDOW mread
                     @ 1,5 SAY "Do you wish to FIX memo file?"
                     @ 1,37 GET mpick2 ;
                        PICTURE "@*HT \!Yes;\?No" ;
                        size 1,5,3 ;
                        DEFAULT 1
                     READ cycle modal
                     RELEASE WINDOW mread
                     IF mpick2 = 1
                        DO fixmemo WITH LEFT(name,AT('.',name)-1)+'.FPT'
                     ENDIF
                  ENDIF
                  
                  IF the_error = 15
                     STORE name TO datafile
                     @ 0,12 GET m.datafile ;
                        size 1,41 ;
                        DEFAULT " "
                     CLEAR GETS
                     DO check
                  ENDIF
                  SELE baddbfs
                  SKIP
               ENDDO
            ENDIF
         ENDIF
      ENDIF
      SET DEFA TO &fileloc
      SELECT corrupt
   ELSE
      *** do one file
      DO check
   ENDIF
   @ 3,0 CLEAR
ENDDO
SET DEFA TO (mdefa)
CLOSE ALL
CLEAR ALL
CLEAR
ON ERROR

*!*********************************************************************
*!
*!      Procedure: CHECKALL
*!
*!      Called by: CORRUPT.PRG                   
*!
*!          Calls: REPOERR        (procedure in CORRUPT.PRG)
*!
*!           Uses: &MFILE         
*!
*!*********************************************************************
PROCEDURE checkall
STORE .F. TO terror
ON ERROR STORE .T. TO terror
SET DEFA TO &datadir
IF terror
   WAIT WINDOW 'Invalid directory'
   STORE .F. TO val_dir
   ON ERROR
   RETURN
ENDIF
mfile = SYS(2000,'*.dbf')
DO WHILE .NOT. EMPTY(mfile)
   STORE 0 TO merror
   STORE '' TO mmessage
   ON ERROR DO repoerr WITH ERROR()
   SELE 4
   USE &mfile EXCL
   ON ERROR
   USE
   SELE baddbfs
   IF merror <> 0
      APPEND BLANK
      REPLACE name WITH mfile, the_error WITH merror, MESS WITH mmessage
   ENDIF
   mfile = SYS(2000,'*.dbf',1)
ENDDO


*!*********************************************************************
*!
*!      Procedure: CHECK
*!
*!      Called by: CORRUPT.PRG                   
*!
*!          Calls: CHKFILE        (procedure in CORRUPT.PRG)
*!               : SECERROR       (procedure in CORRUPT.PRG)
*!
*!           Uses: (DATAFILE).DBF 
*!               : &DATAFILE      
*!
*!    Other Files: DATAFILE
*!
*!*********************************************************************
PROCEDURE check
**** CHECK TO SEE IF DATABASE IS CORRUPT
IF chkfile(datafile)
   WAIT WINDOW 'Database is not corrupt'
   RETURN
ENDIF

**** CHECK TO SEE IF CAN OPEN FILE LOW LEVEL
m.file_hndl = FOPEN(datafile, 2)
IF m.file_hndl = -1
   WAIT WINDOW 'Cannot open file'
   RETURN
ENDIF
@ 4,15 SAY "Corrupt " COLOR R*/B
m.beg = FSEEK(m.file_hndl, 0, 0)
=FSEEK(m.file_hndl, 4, 0)
m.block1 = FREAD(m.file_hndl, 1)
=FSEEK(m.file_hndl, 5, 0)
m.block2 = FREAD(m.file_hndl, 1)
SELECT corrupt
APPEND BLANK
REPLACE asc1 WITH ASC(m.block1), asc2 WITH ASC(m.block2), datadbf WITH m.datafile, DATE WITH DATE()
SELE 2

m.hold1 = ASC(m.block1)
m.hold2 = ASC(m.block2)
STORE 0 TO m.numrec
STORE .T. TO good
ON ERROR DO secerror WITH ERROR()
DO WHILE good
   STORE .F. TO good
   IF m.hold1 <> 0
      m.hold1 = m.hold1 -1
      m.block1 = CHR(m.hold1)
      =FCLOSE(m.file_hndl)
      m.file_hndl = FOPEN(datafile, 2)
      =FSEEK(m.file_hndl, 4, 0)
      =FWRITE(m.file_hndl,m.block1 )
      =FCLOSE(m.file_hndl)
   ELSE
      m.hold2 = m.hold2 - 1
      m.block2 = CHR(m.hold2)
      =FCLOSE(m.file_hndl)
      m.file_hndl = FOPEN(datafile, 2)
      =FSEEK(m.file_hndl, 5, 0)
      =FWRITE(m.file_hndl,m.block2)
      =FCLOSE(m.file_hndl)
      m.hold1 = 255
      m.block1 = CHR(m.hold1)
      =FCLOSE(m.file_hndl)
      m.file_hndl = FOPEN(datafile, 2)
      =FSEEK(m.file_hndl, 4, 0)
      =FWRITE(m.file_hndl,m.block1 )
      =FCLOSE(m.file_hndl)
   ENDIF
   m.numrec = m.numrec + 1
   @ 4,49 SAY STR(m.numrec,4)
   USE (datafile) EXCL
ENDDO
@ 4,15 SAY "Repaired"
ON ERROR
DEFINE WINDOW mread ;
   FROM 18, 10 ;
   TO 22,69 ;
   NOFLOAT ;
   NOCLOSE ;
   SHADOW ;
   DOUBLE ;
   COLOR SCHEME 1
STORE 0 TO mpick2
ACTIVATE WINDOW mread
@ 1,5 SAY "Do you wish to rebuild index?"
@ 1,37 GET mpick2 ;
   PICTURE "@*HT \!Yes;\?No" ;
   size 1,5,3 ;
   DEFAULT 1
READ cycle modal
RELEASE WINDOW mread
IF mpick2 = 1
   SELE 2
   USE &datafile EXCL
   SET TALK ON
   SET TALK WINDOW
   REINDEX
   USE
   SET TALK nowindow
   SET TALK OFF
ENDIF
SELE corrupt
REPLACE rec_lost WITH m.numrec
SELE 2
RETURN

*!*********************************************************************
*!
*!      Procedure: CHKFILE
*!
*!      Called by: CHECK          (procedure in CORRUPT.PRG)
*!
*!          Calls: REPOERR        (procedure in CORRUPT.PRG)
*!
*!           Uses: &MFILE         
*!
*!*********************************************************************
PROCEDURE chkfile
PARA mfile
STORE 0 TO merror
ON ERROR DO repoerr WITH ERROR()
SELECT 2
USE &mfile EXCL
USE
ON ERROR
DO CASE
CASE merror = 15
   RETURN .F.
CASE merror <> 0 .AND. EMPTY(datadir)
   WAIT WINDOW MESSAGE()
   RETURN .T.
OTHERWISE
   RETURN .T.
ENDCASE

*!*********************************************************************
*!
*!      Procedure: REPOERR
*!
*!      Called by: CHECKALL       (procedure in CORRUPT.PRG)
*!               : CHKFILE        (procedure in CORRUPT.PRG)
*!
*!*********************************************************************
PROCEDURE repoerr
PARA terror
STORE terror TO merror
STORE MESSAGE() TO mmessage
RETURN .T.

*!*********************************************************************
*!
*!      Procedure: SECERROR
*!
*!      Called by: CHECK          (procedure in CORRUPT.PRG)
*!
*!*********************************************************************
PROCEDURE secerror
PARA terror
IF terror <> 15
   WAIT WINDOW 'Problem '+ MESSAGE()
   STORE .F. TO good
ELSE
   STORE .T. TO good
ENDIF
RETURN .T.

*!*********************************************************************
*!
*!      Procedure: FIXMEMO
*!
*!      Called by: CORRUPT.PRG                   
*!
*!    Other Files: MEMOFILE
*!
*!*********************************************************************
PROCEDURE fixmemo
PARA memofile
m.file_hndl = FOPEN(memofile, 2)
m.eof       = FSEEK(m.file_hndl, 0, 2)
=FSEEK(m.file_hndl, 7, 0)
m.block = FREAD(m.file_hndl, 2)
m.block = ASC(RIGHT(m.block, 1)) * 256 + ASC(LEFT(m.block, 1))
m.nxtfreedec = INT(m.eof / m.block) + 1

m.nxtfree256 = ""
FOR I = 3 TO 0 STEP -1
   m.nxtfree256 = m.nxtfree256 + CHR(INT(m.nxtfreedec / 256^I))
   m.nxtfreedec = MOD(m.nxtfreedec, 256^I)
ENDFOR (I)

=FSEEK(m.file_hndl, 0, 0)
=FWRITE(m.file_hndl, m.nxtfree256)
=FCLOSE(m.file_hndl)
WAIT WINDOW memofile+' memo has been fixed'
RETURN
*: EOF: CORRUPT.PRG
