* USAGE:
*
* DO DateGet WITH datebeg,bg_dte,dateend,eg_dte,dateemy
*
*   datebeg...  .T. = The proceedure will     get a Beginning Date
*               .F. = The proceedure will not get a Beginning Date
*
*   bg_dte....  The default beginning date
*
*   dateend...  .T. = The proceedure will     get an Ending Date
*               .F. = The proceedure will not get an Ending Date
*
*   eg_dte....  The default ending date
*
*   dateemy...  .T. The date will be obtained in MM/YY format
*                     bg_dte will be returned as the first day of the month
*                     eg_dte will be returned as the last  day of the month
*
*               .F. The date will be obtained in MM/DD/YY format
*
*   EOM(mdate)  A UDF() that returns the date of the last day in the month
*                 and year of mdate


PROCEDURE DateGet
PARAMETER datebeg,bg_dte,dateend,eg_dte,datemy
PRIVATE beg_msg,beg_dte,end_msg,end_dte,date_pict,old_talk
IF .NOT. (datebeg .OR. dateend)
  RETURN TO Main_Mnu
ENDIF
old_talk=SET("TALK")
SET TALK OFF
SET BORDER TO SINGLE
DEFINE WINDOW dateget FROM 10,10 TO 16,47 COLOR W+/BG,BG+/N,BG+/N
ACTIVATE WINDOW dateget
beg_msg=IIF(dateend,'Beginning ','Enter ')+'Date - '+;
  IIF(datemy,'[MM/YY]','[MM/DD/YY]')
beg_dte=IIF(datemy,LEFT(DTOC(bg_dte),3)+RIGHT(DTOC(bg_dte),2),bg_dte)
end_msg=IIF(datebeg,'   Ending ','Enter ')+'Date - '+;
  IIF(datemy,'[MM/YY]','[MM/DD/YY]')
end_dte=IIF(datemy,LEFT(DTOC(eg_dte),3)+RIGHT(DTOC(eg_dte),2),eg_dte)
date_pict=IIF(datemy,'99/99','99/99/99')
ON KEY LABEL LEFTARROW ?? ""
ON KEY LABEL RIGHTARROW ?? ""
ON KEY LABEL UPARROW ?? ""
ON KEY LABEL DNARROW ?? ""
DO WHILE .T.
  IF datebeg
    @ 1,1 SAY beg_msg GET beg_dte PICTURE date_pict
  ENDIF
  IF dateend
    @ 3,1 SAY end_msg GET end_dte PICTURE date_pict
  ENDIF
  CLEAR TYPEAHEAD
  READ
  IF LASTKEY()=27
    EXIT
  ENDIF
  IF datemy
    IF datebeg
      beg_dte=CTOD(LEFT(beg_dte,3)+'01'+RIGHT(beg_dte,3))
    ENDIF
    IF dateend
      end_dte=CTOD(LEFT(end_dte,3)+'01'+RIGHT(end_dte,3))
      end_dte=EOM(end_dte,0)
    ENDIF
  ENDIF
  DO CASE
    CASE datebeg .AND. dateend .AND. beg_dte>end_dte
      ? CHR(7)
      LOOP
    CASE datebeg .AND. dateend
      bg_dte=beg_dte
      eg_dte=end_dte
    CASE datebeg
      bg_dte=beg_dte
    CASE dateend
      eg_dte=end_dte
  ENDCASE
  EXIT
ENDDO
ON KEY LABEL LEFTARROW
ON KEY LABEL RIGHTARROW
ON KEY LABEL UPARROW
ON KEY LABEL DNARROW
SET TALK &old_talk
RELEASE WINDOW dateget
RETURN


FUNCTION EOM
PARAMETERS date_now,months
PRIVATE mdate,yr,mo,mo_use,yr_use
IF months>=0
  yr_use=YEAR(date_now)+INT(months/12)
  mo_use=MONTH(date_now)+MOD(months,12)
ELSE
  yr=YEAR(date_now)+INT(months/12)
  mo=MONTH(date_now)-MOD(ABS(months),12)
  mo_use=IIF(mo<1,mo+12,mo)
  yr_use=IIF(mo<1,yr-1,yr)
ENDIF
RETURN CTOD(STR(mo_use+1,2)+'/01/'+STR(yr_use,4))-1

