x='   (C)Copyright 1989 Dennis E. Johnson-All Rights Reserved   '

*  DATADIC provides a list of sorted clipper database structures & index
*          file key expressions


* ============================================================================
* ----- initialization ----- *
* ============================================================================

set exclusive off

priv desc,lineno,mfileid,mroute,msortfld,n_fils,n_ntxs,pgln,pgno,scratch

lineno=0
pgno=0
scratch='dic8912.dbf'  && temporary database fileid

decl types[5]
types[1]='Character'
types[2]='Numeric'
types[3]='Date'
types[4]='Memo'
types[5]='Logical'


* ============================================================================
* ----- begin main procedure ----- *
* ============================================================================

if datadic00()   && get user parameters

  if len(trim(mroute))>0  && route output to file if specified
    set printer to &mroute
  endif
  set device to print



  * ----- process dbf's ----- *


  n_fils=adir(mfileid+'.dbf') && # of dbf's

  if n_fils>0

    * data arrays for DOS file information

    decl fid[n_fils],fsiz[n_fils],fdat[n_fils],ftim[n_fils],fattr[n_fils]
    decl fix[n_fils] 


    * print heading for dbf section

    datadic11()  && check for new page
    @ lineno+1, 5 say 'DATABASE FILES (.DBF)' 
    @ lineno+2, 5 say '====================='
    lineno=lineno+4

    datadic01('.dbf')    && load up data arrays with information from DOS


    * print dbf data

    for i=1 to n_fils
      datadic11()  && check for new page
      datadic02(i) && print data for dbf
    next
  endif



  * ----- process ntx's ----- *


  n_fils=adir(mfileid+'.ntx') && # of ntx's

  if n_fils>0

    * data arrays for DOS file information

    decl fid[n_fils],fsiz[n_fils],fdat[n_fils],ftim[n_fils],fattr[n_fils]
    decl fix[n_fils]


    * print heading for ntx section

    datadic11()  && check for new page
    @ lineno+1, 5 say 'INDEX FILES (.NTX)'
    @ lineno+2, 5 say '=================='
    @ lineno+4, 5 say 'Index          Key Expression'
    @ lineno+5, 5 say '-----          --------------'
    lineno=lineno+6


    datadic21(scratch) && create temporary database for indexes


    datadic01('.ntx')    && load up data arrays with information from DOS


    * print dbf data

    for i=1 to n_fils
      datadic11()  && check for new page
      datadic03(i) && print data for ntx
    next

  endif


  * ----- Housekeeping ----- *

  if len(trim(mroute))=0 && eject last page if routed to printer
    eject
  endif

  erase &scratch
  set device to screen
  set printer to
endif

datadic10() && termination message

return



* ============================================================================
* ----- functions ----- *
* ============================================================================


func datadic00 && get user parameters
* -----------------------------------
priv retcode


* ----- defaults for user parameters ----- *

desc=space(40)
mfileid='*.*'+space(60)
mroute=space(50)
msortfld='Y'
pgln=66


* ----- prompt for user parameters ----- *

clear
@  1, 0 to  5,79
@  2, 2 say 'DATADIC (Vers 1.2)  A Clipper database & index listing utility'
@  2,70 say date()
@  4, 2 say '(C) Copyright 1989 Denny Johnson - All rights reserved'

@  8, 0 to 18,79 double
@  9, 2 say 'File ID' get mfileid pict'@!'
@ 10, 2 say 'Descrip' get desc

@ 12, 2 say 'Sort Field Names?' get msortfld pict'@!' valid(msortfld$'YN')
@ 12,23 say '(Y/N)'

@ 14, 2 say '  Route output to' get mroute   pict'@!'
@ 15, 2 say '    (blank for printer; fileid for file)'
@ 17, 2 say '          Page Ln' get pgln    pict'99'
@ 17,24 say '(0 to suppress page breaks)'

@ 23, 0 to 23,79
@ 24, 0 say '[Esc] Exit'
read

if lastkey()<>27
  retcode=.T.

  * clean up user inputs

  mfileid=alltrim(mfileid)  && remove file extension if entered
  if '.'$mfileid
    mfileid=if('.'$mfileid,substr(mfileid,1,at('.',mfileid)-1),mfileid)
  endif

else
  retcode=.F.

endif
return retcode



func datadic01 && load up data arrays with information from DOS
* -------------------------------------------------------------
para ext
priv i


* load data arrays with information from DOS

adir(mfileid+ext,fid,fsiz,fdat,ftim,fattr)


* load index array (fileid C 12 + pointer NC 2) - used to sort all data arrays

for i=1 to n_fils 
  fix[i]=fid[i]+space(12-len(fid[i]))+str(i,2)
next


* sort index array into ascending fileid order

asort(fix) 
return .T.



func datadic02 && print dbf data
* ------------------------------
para x
priv f,fil,i

i=fsub(x)  && get dbf pointer from index array


* open dbf for processing

fil=fid[i]
use &fil

@ lineno, 5 say 'Structure for database : '+fid[i]


if neterr()
  @ lineno+1, 5 say '*** FILE CURRENTLY LOCKED ON NETWORK ***'
  lineno=lineno+3

else

  * print dbf header info

  @ lineno+1, 5 say 'Record length          : '+alltrim(str(recsize()))
  @ lineno+2, 5 say 'Number of data records : '+alltrim(str(lastrec()))
  @ lineno+3, 5 say 'Date of last update    : '+dtoc(lupdate())
  lineno=lineno+5


  * load field arrays

  f=fcount() && number of fields
  decl flnm[f],fltyp[f],flwd[f],fldec[f],flix[f]

  afields(flnm,fltyp,flwd,fldec)


  * load field index array (field C 10 + pointer NC 4)

  for i=1 to f
    flix[i]=flnm[i]+space(10-len(flnm[i]))+str(i,4)
  next


  * sort index into ascending field order, if requested

  if msortfld='Y'
    asort(flix)
  endif


  * print fields

  @ lineno, 11 say 'Field  Field Name   Type        Width  Dec'
  lineno=lineno+1

  for i=1 to f
    n=flsub(i) && get field pointer from index array
    datadic11() && check for new page
    @ lineno, 11 say str(n,4)
    @ lineno, 18 say flnm[n]
    @ lineno, 31 say types[at(fltyp[n],'CNDML')]
    @ lineno, 43 say str(flwd[n],5)
    @ lineno, 50 say if(fltyp[n]='N',str(fldec[n],2),' ')
    lineno=lineno+1
  next
  lineno=lineno+1

  use
endif
return .T.



func datadic03 && print ntx data
* ------------------------------
para x
priv fil,i

i=fsub(x) && get dbf pointer from index array
fil=fid[i]
use &scratch index &fil

@ lineno, 5 say fid[i]
@ lineno,20 say indexkey(1)
lineno=lineno+2

use
return .T.



func datadic10 && termination message
* -----------------------------------
clear
@  0, 0 to 24,79 double
@  0, 1 say '[SOFTWARE LICENSE REGISTRATION FOR DATADIC VERS 1.2]'
@  2, 2 say "PLEASE DON'T PIRATE THIS SOFTWARE.  Register your copy, and send me a"
@  3, 2 say 'little money, and I will send you the complete, documented source code'
@  4, 2 say '(ON DISK!) for this utility.  It is written in Clipper-Summer 87.  Just'
@  5, 2 say 'copy this form, complete it, sign it & send it with $19 (plus $1.14 for'
@  6, 2 say 'sales tax if you live in Florida) to:'

@  8, 2 say '    DENNY JOHNSON; 4679 Tiffany Woods Cir; Oviedo, FL 32765'

@ 10, 2 say 'Name____________________________________________________________'

@ 12, 2 say 'Addr____________________________________________________________'

@ 14, 2 say 'City_____________________________ State______  Zip______________'

@ 16, 2 say 'I understand and agree that the source code I receive is for my'
@ 17, 2 say 'own personal use only, and that I have no right to distribute it,'
@ 18, 2 say 'or to distribute any new program I develop which incorporates the'
@ 19, 2 say 'source code I receive.  THIS IS FINE WITH ME!'

@ 21, 2 say '______________________________________  _____________________'
@ 22, 2 say 'Signature                               Date'
set cursor off
inkey(0)
set cursor on
clear
return .T.



func datadic11 && check for new page
* ----------------------------------
if lineno>pgln-10 .and. pgln<>0
  eject
  lineno=0
endif

if lineno=0
  pgno=pgno+1
  @ 1, 1 say dtoc(date())+'  '+time()
  @ 1,20 say desc
  @ 1,65 say 'Page '+str(pgno,2)
  lineno=3
endif
return .T.



func datadic21 && create scratch database for indexes
* ---------------------------------------------------
para fid
create &fid
append blank
close databases
return .T.



func fsub && return dbf pointer value from element of index array
* ---------------------------------------------------------------
para x
return val(substr(fix[x],13,2))



func flsub && return field pointer value from element of index array
* ------------------------------------------------------------------
para x
return val(substr(flix[x],11,4))

