FUNCTION CURDIR
	PARAMETER lc_drive
	PRIVATE ALL LIKE l*
	IF .NOT. FILE("GETDIR.EXE")
		RETURN "GETDIR.EXE can not be located"
	ENDIF
	lc_comm = IIF(PCOUNT() = 0, "GETDIR", IIF(TYPE("lc_drive") # "C", ;
			 "GETDIR", "GETDIR " + lc_drive))
	ln_val = 1                                     
	DO WHILE .T.
		lc_file = "curdir" + LTRIM(STR(ln_val)) + ".tmp"
		IF .NOT. FILE(lc_file)
			EXIT
		ELSE
			IF ln_val >= 99
				RETURN "Unable to generate temporary file"
			ENDIF
		ENDIF
		ln_val = ln_val + 1
	ENDDO
	lc_comm = lc_comm + " > " + lc_file
	IF RUN(lc_comm) # 0
		RETURN -1
	ELSE
		ln_handle = FOPEN((lc_file),"R")
		lc_dir    = FGETS(ln_handle)
		ll_close  = FCLOSE(ln_handle)
		ERASE (lc_file)
	ENDIF
RETURN  lc_dir
