*       ķ
*                                                                
*        08/19/93             confirm.prg                 v1.00  
*                       FoxPro Version 2.x Source Code           
*       Ķ
*                                                                
*        Bill Nicholson.  Compuserve ID 70400,3672               
*                                                                
*        Copyright (c) Nicholson Computer Consulting             
*        996 Glendale Drive                                      
*        Batavia, OH 45103   (513) 752-0540                      
*                                                                
*        Description: Allow user to confirm/cancel a request.    
*                     Returns the index number of the user's     
*                     selection. Prompts and messages are        
*                     auto-centered in the window. Prompts and   
*                     messages are passed into the procedure as  
*                     parameters.                                
*                                                                
*        Arguments: choice1, choice2 are the push button labels  
*                   that will appear at the bottom of the window.
*                   Both are required.                           
*                                                                
*                   prompt1 ... prompt4 are the text strings that
*                   will appear in the window. Use them to       
*                   describe the choice that the user has to make
*                   All are optional.                            
*                                                                
*                                                                
*        Disclaimer: This program carries no warranties,         
*                    expressed or implied, and is not guaranteed 
*                    to be suitable for any purpose. <gag>       
*                    It may be incorporated into commercial      
*                    applications without cost as long as        
*                    credit is given to the author.              
*                    (as if anyone would really want to)         
*       Ķ
*
*         Example:                                                 
*                                                                  
*          result = confirm("Yes", "No", ;
*							"Do you want to reformat your hard disk?", ;
*							"It will destroy all your data!")
*
*           result will contain 1 if the user selected "Yes",      
*           2 if the user selected "No".                           
*
*
*         Another Example:                                                 
*                                                                  
*          result = confirm("Whizbang 7000", "Bambleweeny Laptop Xj", ;
*							"Which computer do you prefer?")
*
*           result will contain 1 if the user selected the Whizbang,      
*           2 if the user selected the Bambleweeny. 
*

PROCEDURE confirm
PARAMETER choice1, choice2, prompt1, prompt2, prompt3, prompt4

SET TALK OFF

PRIVATE spacing, width, min_width, lp1, lp2, tot_width, max, ScreenStat
PRIVATE mcount, choice, val, offset
m.spacing	= 4			&& Spaces between the selections
m.min_width = 9		&& Minimum width of each selection
m.ScreenStat = 0		&& See vchoice()
m.choice = 1			&& Used in READ pushbuttons

IF NOT WEXIST("wconfirm")
	DEFINE WINDOW wconfirm ;
		FROM INT((SROW()-8)/2),INT((SCOL()-78)/2) ;
		TO INT((SROW()-8)/2)+8,INT((SCOL()-78)/2)+77 ;
		NOCLOSE ;
		SHADOW ;
		DOUBLE ;
		COLOR SCHEME 5 ;

*		FLOAT			&& I don't think this window should float!
ENDIF

ACTIVATE WINDOW wconfirm

offset =  WROWS()/2 - 1 - (PARAMETERS() - 1)

IF PARAMETERS() > 2
	FOR m.mcount = 3 to PARAMETERS()
   		m.val = 'prompt' +(STR(m.mcount-2,1)) 
   		@ m.offset + m.mcount, WCOLS()/2-LEN(&val)/2 SAY &val
	ENDFOR
ENDIF

m.lp1 = LEN(choice1)
m.lp2 = LEN(choice2)
m.max = IIF(m.lp1 > m.lp2, m.lp1, m.lp2)
m.width = IIF(m.max > m.min_width, m.max, m.min_width)
m.tot_width = m.width + m.width + m.spacing + 4		&& 4 is for the <> around each selection

* Build up the Picture clause for the @ SAY/GET
m.pic = "PICTURE " + CHR(34) + "@*HT "
m.pic = m.pic + choice1 + ";"
m.pic = m.pic + choice2
m.pic = m.pic + CHR(34)		&& Double quote

@ WROWS()-1,(WCOLS()/2 - m.tot_width/2) GET m.choice ;
	&pic ;
	SIZE 1, m.width, m.spacing ;
	DEFAULT 1 ;
	VALID vchoice()

READ CYCLE MODAL

RELEASE WINDOW wconfirm

RETURN ScreenStat
*******************************************************************
*       ķ
*                                                                
*        vchoice             m.choice VALID                      
*                                                                
*       Ľ
*
FUNCTION vchoice     &&  m.choice VALID

m.ScreenStat = m.choice

RETURN
