/*
		comp.c - framework for use of PK Compression Library from PKWare
		
		John D'Ausilio
		ECR Software Corporation
		425 West King St. #206
		Boone, NC 28607
		(704)-265-2907
		
		This file is incomplete in itself; you need to purchase the PKWARE
		Data Compression Library which provides implode.h, implode.obj, and
		crc32.obj.
		
		Compile with the following commands:

		wcc /oals /s /zu /zW /ml /fpc comp
		wlink file ..\api_l, comp, implode.obj, crc32.obj lib proapi_l, clibl
		ren api_l.exe comp.plb

*/

#include <stdlib.h>
#include <dos.h>
#include <pro_ext.h>
#include "implode.h" 				/* included with PK Library */

FCHAN input,output;
int crc_rw;									/* read/write flag for crc : 1 = calc on write */
unsigned long far crc_val;	/* storage for crc being calculated */

void push_ds(void);					/* these pragmas avoid the (apparent) problem */
#pragma aux push_ds = 0x1E ;/* where _FRead and _FWrite trash DS */

void pop_ds(void);
#pragma aux pop_ds = 0x1F ;

/*
	Routine to supply data to the implode() or explode() routines.
	When this routine returns 0 bytes read, the implode() or explode()
	routines will terminate.
*/

unsigned far pascal ReadFile(char far *buff, unsigned short int far *size)
{
	size_t read;

	push_ds();
	read = _FRead(input,buff,*size);
	pop_ds();
	if(crc_rw == 0)
		crc_val = crc32(buff,(unsigned short int far *)&read,&crc_val);
		
	return((unsigned)read);
}

/*
	Routine to write compressed data output from implode() or
	uncompressed data from explode()
*/

void far pascal WriteFile(char far *buff, unsigned short far *size)
{
	push_ds();
	if(crc_rw == 1)
		crc_val = crc32(buff,size,&crc_val);
	_FWrite(output,buff,*size);
	pop_ds();
	return;
}

void myexplode(ParamBlk FAR *pblk)
{
	MHANDLE WorkHand;
	char far *WorkBuff;					/* buffer for compression tables */
	unsigned short int error;
	Value val;
	unsigned long crc_old;

	val = pblk->p[0].val;
	input = (int) val.ev_long;
	val = pblk->p[1].val;
	output = (int) val.ev_long;

	WorkHand = _AllocHand(12574);
	if(WorkHand == NULL){
		_RetInt(-1,10);						/* memory not available */
		return;
	}
	_HLock(WorkHand);
	WorkBuff = _HandToPtr(WorkHand);

	_FSeek(input,-4,2);					/* this stuff lops off the last four bytes,
	                               which contain the crc before implosion */
	_FRead(input,(char far *)&crc_old,4);
	_FCHSize(input,_FSeek(input,0,2)-4);
	_FSeek(input,0,0);

	crc_val = ~0L;
	crc_rw = 1;
	error = explode(ReadFile,WriteFile,WorkBuff); /* Extract the file	*/

	if (error){
		_RetInt(error,10);
		return;
	}
	
	if(crc_old != crc_val){
		_RetInt(-9,10);						/* crc error */
		return;
	}
	
	_HUnLock(WorkHand);
	_FreeHand(WorkHand);

}

void myimplode(ParamBlk FAR *pblk)
{
	MHANDLE WorkHand;
	char far *WorkBuff;						/* buffer for compression tables */
	unsigned short int error;
	unsigned short int  type;			/* ASCII or Binary compression	*/
	unsigned short int  dsize;		/* Dictionary Size. 1,2 or 4K	 */
	Value val;

	val = pblk->p[0].val;
	input = (int) val.ev_long;
	val = pblk->p[1].val;
	output = (int) val.ev_long;
	
	WorkHand = _AllocHand(35256U);
	if(WorkHand == NULL){
		_RetInt(-3,10);
		return;
	}
	_HLock(WorkHand);
	WorkBuff = _HandToPtr(WorkHand);

	type  = CMP_BINARY;					/* Use binary compression */
	dsize = 4096;							  /* Use 4K dictionary	  */

	crc_val = ~0L;
	crc_rw = 0;
	error = implode(ReadFile,WriteFile,WorkBuff,&type,&dsize);

	if (error){
		_RetInt(error,10);
		return;
	}
	
	_FWrite(output,(char far *)&crc_val,4); /* hang crc on end of file */
	
	_HUnLock(WorkHand);
	_FreeHand(WorkHand);
}

FoxInfo myFoxInfo[] = {
	{"EXPLODE", myexplode, 	2, 			"I,I"},
	{"IMPLODE", myimplode, 	2, 			"I,I"}
};

FoxTable _FoxTable = {
	(FoxTable FAR *)0, sizeof(myFoxInfo) / sizeof(FoxInfo), myFoxInfo
};
