PROCEDURE DOT
PARAMETERS mDot_Row, mDot_Col, mDot_Prompt
SET CONSOLE OFF
Dot_Error = 0
ON ERROR Dot_Error = ERROR()
IF Dot_Error = 94
   *-- Set default dot row, based on status bar and display mode.
   *-- Some terminal emulators for non-dos versions of dBASE use
   *-- the last line on the screen. This command adjusts for this.
   mDot_Row = IIF(SET("STATUS")="ON", 21, 24) + ;
      IIF("43" $ SET("DISPLAY"), 18, 0) - IIF("DOS" $ OS(), 0, 1)
   mDot_Col = 0
   mDot_Prompt = "."
ENDIF
RELEASE Dot_Error
DO Dot_Public
IF TYPE("m_Prog") = "U"
   PUBLIC m_Prog
   m_Prog = PROGRAM()
ENDIF
Dot_Talk = SET("TALK")
SET TALK OFF
CLEAR
SET CONSOLE ON
SET FORMAT TO
SET ESCAPE ON
ON ESCAPE Dot_Escape = 0
ON ERROR DO DOT_ERR WITH ERROR(), MESSAGE()
ON KEY LABEL CTRL-F9 CANCEL
ON KEY LABEL CTRL-HOME DO CtrlHome
IF .NOT. "RUNTIME" $ UPPER(VERSION(0))
   ON KEY LABEL F1 HELP
ELSE
   ON KEY LABEL F1 KEYBOARD "HELP" + CHR(13)
ENDIF
IF .NOT. FILE("Dot_Cfg.MEM")
   DO DOT_CFG
ELSE
   RESTORE FROM Dot_Cfg.MEM ADDITIVE
ENDIF
Dot_Row = mDot_Row
Dot_Col = mDot_Col
Dot_Prompt = mDot_Prompt
RELEASE mDot_Row, mDot_Col, mDot_Prompt
Dot_Pop = .F.
Dot_Hist = IIF(Dot_Hist = 0, 20, MIN(Dot_Hist, 1170))
DECLARE Dot_Array[Dot_Hist]
Dot_Len = 80 - (Dot_Col + LEN(Dot_Prompt) + 1)
Dot_Pic = '"@S' + LTRIM(STR(Dot_Len)) + '"'
Dot_1st=""
DO Set_Color
IF "" <> Dot_Init        && " COMMAND = " gets executed here.
   Dot_Comm = Dot_Init
   DO IsRTime
ENDIF
DO WHILE .T.
   IF Dot_1st <> "@" .AND. Dot_1st <> "?" .AND. Dot_Talk = "ON"
      ?
   ENDIF
   Dot_Comm = SPACE(254)
   @ Dot_Row, Dot_Col SAY Dot_Prompt GET Dot_Comm ;
      PICTURE &Dot_Pic COLOR &Dot_Color
   READ
   Dot_Comm = RTRIM(LTRIM(Dot_Comm))
   IF MOD(READKEY(), 256) = 4
      DO Dot_Key
   ENDIF
   IF "" <> Dot_Comm .AND. Dot_Hist > 0
      DO Dot_Stack
   ENDIF
   IF UPPER(Dot_Comm) = "EXIT"
      EXIT
   ENDIF
   *-- Disable SET TALK
   IF UPPER(Dot_Comm) = "SET TALK"
      Dot_Talk = IIF(UPPER(Dot_Comm) = "SET TALK ON", "ON", "OFF")
   ENDIF
   IF "" <> Dot_Comm .AND. UPPER(Dot_Comm) <> "SET TALK"
      ON ERROR Dot_Error = ERROR()
      Dot_Cnt = 0           && Used for break-out of fatal error.
      DO WHILE "&" $ Dot_Comm
         DO MacroSub
         Dot_Cnt = Dot_Cnt + 1
         IF Dot_Cnt >= 32        && Attempted 32 macro substitutions.
            EXIT
         ENDIF
      ENDDO
      ON ERROR DO DOT_ERR WITH ERROR(), MESSAGE()
      DO IsRTime
   ENDIF
ENDDO
SET TALK &Dot_Talk
ON ERROR
RETURN
*--*
PROCEDURE DOT_CFG
*-- Reads the Config.DB file for basic settings that can not
*-- be set automatically - History, tedit, command, etc.
*-- use fdate() for 1.5 for config.db/config.dot changes
SAVE SCREEN TO DC_Screen
dc_TALK    = SET("TALK")
dc_TITLE   = SET("TITLE")
dc_SAFETY  = SET("SAFETY")
dc_STATUS  = SET("STATUS")
dc_DBF = DBF()
dc_Dir = SET("DIRECTORY")
dc_tmp = TMP_DIR()
SET TALK OFF
SET TITLE OFF
SET SAFETY OFF     && Do I want this optional?
SET STATUS OFF
* if vers() = 1.1
SELECT 10
dc_catalog = DBF()
* else dc_catalog = CATALOG()
CLOSE DATABASES
SET CATALOG TO &dc_tmp.TMP00000
SET CATALOG TO &dc_CATALOG
USE &dc_tmp.TMP00000.CAT
COPY STRUCTURE EXTENDED TO &dc_tmp.CONFIG.TMP
USE &dc_tmp.CONFIG.TMP
ZAP
ERASE &dc_tmp.TMP00000.CAT
APPEND BLANK
REPLACE field_name WITH "Before", field_type WITH "C", ;
   field_len WITH 254, field_dec WITH 0,  field_idx WITH "N"
APPEND BLANK
REPLACE field_name WITH "After", field_type WITH "C", ;
   field_len WITH 254, field_dec WITH 0,  field_idx WITH "N"
CREATE &dc_tmp.DOT_CONF FROM &dc_tmp.CONFIG.TMP
USE &dc_tmp.DOT_CONF
INDEX ON LEFT(BEFORE, 100) TO &dc_tmp.TMP00000.TMP
SET DIRECTORY TO
APPEND FROM CONFIG.DB SDF
SET DIRECTORY TO &dc_DIR
REPLACE ALL AFTER WITH UPPER(LTRIM(SUBSTR(BEFORE, ;
   AT("=", BEFORE) + 1, LEN(BEFORE))))
REPLACE ALL BEFORE WITH UPPER(LTRIM(LEFT(BEFORE,  ;
   AT("=", BEFORE) - 1)))
dot_hist = VAL(LOOKUP(AFTER, "HIST", BEFORE))
dot_Edit = TRIM(LOOKUP(AFTER, "TEDIT", BEFORE))
Dot_init = TRIM(LOOKUP(AFTER, "COMM", BEFORE))
SAVE ALL LIKE Dot_* TO Dot_Cfg.MEM
CLOSE DATABASES
ERASE &dc_tmp.DOT_CONF.DBF
ERASE &dc_tmp.CONFIG.TMP
ERASE &dc_tmp.TMP00000.TMP
USE &dc_DBF
SET SAFETY &dc_SAFETY
SET STATUS &dc_STATUS
SET TITLE &dc_TITLE
SET TALK &dc_TALK
RETURN
*--*
PROCEDURE DOT_ERR
PARAMETERS mDot_Err, mDot_Msg
Dot_Error = mDot_Err
IF .NOT. LTRIM(STR(Dot_Error)) $ "10"
   SAVE SCREEN TO Err_Screen
   @  8, 15 CLEAR TO 14, 60
   @  8, 15 TO 14, 60 DOUBLE
   @  9, 20 SAY "ERROR Number : " + LTRIM(STR(mDot_Err))
   @ 11, 20 SAY mDot_Msg
   @ 13, 20 SAY "Press any key to continue ...  "
   i=INKEY(0)
   RESTORE SCREEN FROM Err_Screen
   RELEASE SCREEN Err_Screen
ENDIF
RETURN
*--*
PROCEDURE Dot_Key
*-- Show commands in popup or on the command line.
IF Dot_Pop
   DEFINE POPUP Dot_Pop FROM 0, 0
   counter = 1
   m_First = 1
   DO WHILE counter <= Dot_Hist
      IF TYPE("Dot_Array[counter]") = "L"
         m_First = m_First + 1
      ELSE
         DEFINE BAR 1 + (counter - m_First) OF Dot_Pop PROMPT ;
            Dot_Array[counter]
      ENDIF
      counter = counter + 1
   ENDDO
   ON SELECTION POPUP Dot_Pop DEACTIVATE POPUP
   IF counter - m_First > 0
      ACTIVATE POPUP Dot_Pop
      m_Bar = BAR()
      IF m_Bar <> 0
         @ Dot_Row, 0
         Dot_Comm = LTRIM(RTRIM(Dot_Array[m_Bar + m_First - 1]))
      ENDIF
   ENDIF
ELSE
   Stack_Num = Dot_Hist
   DO WHILE .T.
      m_Temp = Dot_Array[Stack_Num]
      m_Temp = IIF(TYPE("m_Temp") = "L", SPACE(254), m_Temp + ;
         SPACE(254 - LEN(m_Temp)))
      @ Dot_Row, Dot_Col CLEAR TO Dot_Row, 79
      @ Dot_Row, Dot_Col SAY Dot_Prompt GET m_Temp ;
         PICTURE &Dot_Pic COLOR &Dot_Color
      KEYBOARD CHR(2)
      READ
      DO CASE
      CASE MOD(READKEY(), 256) = 4
         IF Stack_Num > 1
            Stack_Num = Stack_Num - 1
         ENDIF
      CASE MOD(READKEY(), 256) = 5
         IF Stack_Num < Dot_Hist
            Stack_Num = Stack_Num + 1
         ELSE
            Dot_1st = "?"
            EXIT
         ENDIF
      CASE LASTKEY() = 29
         DO CtrlHome
         EXIT
      CASE LASTKEY() = 27
         EXIT
      CASE TYPE("m_Temp") <> "L"
         Dot_Comm = LTRIM(RTRIM(m_Temp))
         EXIT
      ENDCASE
   ENDDO
ENDIF
RETURN
*--*
PROCEDURE Dot_Public
*-- Sets up PUBLIC variables required by DOT.PRG
PUBLIC Dot_1st, Dot_Rest, Dot_Color, Dot_Comm, Dot_Exact
PUBLIC Dot_pic, Dot_len, Dot_talk, Dot_prompt, Dot_Row, Dot_Col
PUBLIC Dot_Array, Dot_Hist, Dot_Pop, Dot_Error, Dot_Escape
PUBLIC Dot_Init, Dot_Edit, Dot_Home
RETURN
*--*
PROCEDURE Dot_Release
*-- RELEASEs PUBLIC variables required by DOT.PRG
RELEASE Dot_1st, Dot_Color, Dot_Comm, Dot_Exact
RELEASE Dot_pic, Dot_len, Dot_talk, Dot_prompt, Dot_Row, Dot_Col
RELEASE Dot_Array, Dot_Hist, Dot_Pop, Dot_Safety
RELEASE Dot_Error, Dot_Escape, Dot_Init, Dot_Edit, Dot_Home
RETURN
*--*
PROCEDURE Dot_Save
PARAMETERS mFirst
*-- Preserves variables required by DOT.PRG when executing
*-- commands that could RELEASE or CLEAR them.
Dot_Safety = SET("SAFETY")
SET SAFETY OFF
SAVE ALL LIKE Dot_* TO Dot_1
DO CASE
CASE "CLEAR" = mFirst
   CLEAR &Dot_Rest
CASE "LOGOUT" = mFirst
   SAVE TO dot_2 ALL LIKE m_Prog*             && File names should be
   SAVE TO dot_3 ALL LIKE mDot_Row            && lower case for UNIX ...
   LOGOUT
   SET TALK OFF
   PUBLIC m_Prog, mDot_Row
   RESTORE FROM dot_2 ADDITIVE                && ... and VMS support.
   RESTORE FROM dot_3 ADDITIVE                && DOS can be any case.
   ERASE dot_2.mem
   ERASE dot_3.mem
CASE "RELEASE" = mFirst
   CLEAR MEMORY
CASE "SAVE" = mFirst
   SAVE &Dot_Rest
ENDCASE
DO Dot_Public
RESTORE FROM dot_1 ADDITIVE
ERASE dot_1.mem
SET SAFETY &Dot_Safety
RETURN
*--*
PROCEDURE Dot_Stack
*-- Stacks commands (history) in an array.
IF TYPE("Dot_Array[Dot_Hist]") = "L" .OR. ;
      Dot_Array[Dot_Hist] <> Dot_Comm
   m_Temp = 1
   DO WHILE m_Temp < Dot_Hist
      Dot_Array[m_Temp] = Dot_Array[m_Temp + 1]
      m_Temp = m_Temp + 1
   ENDDO
   Dot_Array[m_Temp] = Dot_Comm
ENDIF
RETURN
*--*
PROCEDURE IsRTime
*-- Parses commands so they may be executed in RunTime.
Dot_Exact = SET("EXACT")
SET EXACT OFF
IF AT(" ", Dot_Comm) = 0
   Dot_1st = UPPER(Dot_Comm)
   Dot_Rest = ""
ELSE
   Dot_1st = UPPER(LEFT(Dot_Comm, AT(" ", Dot_Comm) - 1))
   Dot_Rest = RIGHT(Dot_Comm, LEN(Dot_Comm) - ;
      AT(" ", Dot_Comm))
ENDIF
IF TYPE("As3_Runtime") <> "U"
   IF Dot_1st <> "?" .AND. Dot_1st <> "SET"
      SET TALK ON
   ELSE
      SET TALK OFF
   ENDIF
ENDIF

*-- Evaluate first word or symbol in command.
DO CASE
CASE LEFT(Dot_Comm, 1) = "?"
   Dot_Rest = RIGHT(Dot_Comm, LEN(Dot_Comm) - AT("?", Dot_Comm))
   m_Temp = AT("SET(", UPPER(Dot_Rest))
   IF m_Temp > 0
      m_Text = UPPER(SUBSTR(Dot_Rest, AT("SET(", UPPER(Dot_Rest)) ;
         + 5, AT(")", UPPER(Dot_Rest)) - ;
         (AT("SET(", UPPER(Dot_Rest)) + 6)))
      IF m_Text $ "EXACT TALK"
         Dot_Rest = STUFF(Dot_Rest, AT("SET(", UPPER(Dot_Rest)), ;
            5, "Dot_")
         Dot_Rest = LEFT(Dot_Rest, AT(")", Dot_Rest) - 2) + ;
            IIF("EXAC" = m_Text, "T", "")
      ENDIF
   ENDIF
   ?&Dot_Rest                       && '&' must be next to '?'
   &&  ? &Dot_Rest won't work for ?? or ???
   ?
CASE LEFT(Dot_Comm, 1) = "@"
   Dot_Rest = RIGHT(Dot_Comm, LEN(Dot_Comm) - AT("@", Dot_Comm))
   @ &Dot_Rest
CASE LEFT(Dot_Comm, 1) = "!"
   Dot_Rest = RIGHT(Dot_Comm, LEN(Dot_Comm) - AT("!", Dot_Comm))
   RUN &Dot_Rest
CASE "ACCEPT" = Dot_1st
   m_Temp = RIGHT(Dot_Rest, LEN(Dot_Rest) -  ;
      AT(" TO ", UPPER(Dot_Rest)) - 3)
   PUBLIC &m_Temp
   ACCEPT &Dot_Rest
CASE "ACTIVATE" = Dot_1st
   ACTIVATE &Dot_Rest
CASE "APPEND" = Dot_1st
   APPEND &Dot_Rest
CASE "AVERAGE" = Dot_1st
   AVERAGE &Dot_Rest
CASE "BROWSE" = Dot_1st
   BROWSE &Dot_Rest
CASE "CALCULATE" = Dot_1st
   CALCULATE &Dot_Rest
CASE "CALL" = Dot_1st
   CALL &Dot_Rest
CASE "CANCEL" = Dot_1st
   CANCEL
CASE "CHANGE" = Dot_1st
   CHANGE &Dot_Rest
CASE "CLEAR" = Dot_1st
   IF "" = TRIM(Dot_Rest)
      CLEAR
   ELSE
      DO Dot_Save WITH Dot_1st
   ENDIF
CASE "CLOSE" = Dot_1st
   CLOSE &Dot_Rest
CASE "COMPILE" = Dot_1st
   IF .NOT. "RUNTIME" $ UPPER(VERSION(0))
      COMPILE &Dot_Rest
   ENDIF
CASE "CONTINUE" = Dot_1st
   CONTINUE
CASE "CONVERT" = Dot_1st
   CONVERT &Dot_Rest
CASE "COPY" = Dot_1st
   COPY &Dot_Rest
CASE "COUNT" = Dot_1st
   COUNT &Dot_Rest
CASE "CREATE" = Dot_1st
   IF .NOT. "RUNTIME" $ UPPER(VERSION(0))
      CREATE &Dot_Rest
   ELSE
      IF LEFT(UPPER(TRIM(Dot_Rest)), 4) = "VIEW" ;
            .AND. " FROM ENVI" $ UPPER(Dot_Rest)
         m_Temp = SUBSTR(Dot_Rest, 6, AT(" FROM ENVI", ;
            UPPER(Dot_Rest)) - 6)
         CREATE VIEW &m_Temp FROM ENVIRONMENT
      ELSE
         IF FILE("User_Def.DBO")
            DO User_Def
            RETURN
         ENDIF
      ENDIF
   ENDIF
CASE "DEACTIVATE" = Dot_1st
   DEACTIVATE &Dot_Rest
CASE "DEBUG" = Dot_1st
   IF .NOT. "RUNTIME" $ UPPER(VERSION(0))
      DEBUG &Dot_Rest
   ENDIF
CASE "DECLARE" = Dot_1st
   DECLARE &Dot_Rest
CASE "DEFINE" = Dot_1st
   DEFINE &Dot_Rest
CASE "DELETE" = Dot_1st
   DELETE &Dot_Rest
CASE "DIR" = Dot_1st
   DIR &Dot_Rest
CASE "DISPLAY" = Dot_1st
   DISPLAY &Dot_Rest
CASE "DO" = Dot_1st
   DO &Dot_Rest
CASE "EDIT" = Dot_1st
   EDIT &Dot_Rest
CASE "EJECT" = Dot_1st
   EJECT &Dot_Rest
CASE "ERASE" = Dot_1st
   ERASE &Dot_Rest
CASE "EXPORT" = Dot_1st
   EXPORT &Dot_Rest
CASE "FIND" = Dot_1st
   FIND &Dot_Rest
CASE "GO" = Dot_1st
   GO &Dot_Rest
CASE "IMPORT" = Dot_1st
   IMPORT &Dot_Rest
CASE "INDEX" = Dot_1st
   INDEX &Dot_Rest
CASE "INPUT" = Dot_1st
   m_Temp = RIGHT(Dot_Rest, LEN(Dot_Rest) -  ;
      AT(" TO ", UPPER(Dot_Rest)) - 3)
   PUBLIC &m_Temp
   INPUT &Dot_Rest
CASE "INSERT" = Dot_1st
   INSERT &Dot_Rest
CASE "JOIN" = Dot_1st
   JOIN &Dot_Rest
CASE "KEYBOARD" = Dot_1st
   KEYBOARD &Dot_Rest
CASE "LABEL" = Dot_1st
   LABEL &Dot_Rest
CASE "LIST" = Dot_1st
   LIST &Dot_Rest
CASE "LOAD" = Dot_1st
   LOAD &Dot_Rest
CASE "LOCATE" = Dot_1st
   LOCATE &Dot_Rest
CASE "LOGOUT" = Dot_1st
   DO Dot_Save WITH Dot_1st
CASE "MODIFY" = Dot_1st
   IF .NOT. "RUNTIME" $ UPPER(VERSION(0))
      MODIFY &Dot_Rest
      Dot_1st = ""         && Bypass Procedure User-Defined
   ENDIF
CASE "MOVE" = Dot_1st
   MOVE &Dot_Rest
CASE "ON" = Dot_1st
   IF .NOT. ("ESCA" $ UPPER(Dot_Rest) .OR. "ERRO" $ UPPER(Dot_Rest))
      ON &Dot_Rest
   ENDIF
CASE "PACK" = Dot_1st
   PACK
CASE "PLAY" = Dot_1st
   PLAY &Dot_Rest
CASE "PRIVATE" = Dot_1st
   PRIVATE &Dot_Rest
CASE "PROTECT" = Dot_1st
   PROTECT
CASE "PUBLIC" = Dot_1st
   PUBLIC &Dot_Rest
CASE "QUIT" = Dot_1st
   QUIT &Dot_Rest
CASE "READ" = Dot_1st
   READ &Dot_Rest
CASE "RECALL" = Dot_1st
   RECALL &Dot_Rest
CASE "REINDEX" = Dot_1st
   REINDEX &Dot_Rest
CASE "RELEASE" = Dot_1st
   IF UPPER(TRIM(Dot_Rest)) = "ALL"
      DO Dot_Save WITH Dot_1st
   ELSE
      RELEASE &Dot_Rest
   ENDIF
CASE "RENAME" = Dot_1st
   RENAME &Dot_Rest
CASE "REPLACE" = Dot_1st
   REPLACE &Dot_Rest
CASE "REPORT" = Dot_1st
   REPORT &Dot_Rest
CASE "RESET" = Dot_1st
   RESET &Dot_Rest
CASE "RESTORE" = Dot_1st
   Dot_Rest = Dot_Rest + IIF(" ADDI" $ ;
      UPPER(Dot_Rest), "", " ADDITIVE")
   RESTORE &Dot_Rest
CASE "ROLLBACK" = Dot_1st
   ROLLBACK &Dot_Rest
CASE "RUN" = Dot_1st
   RUN &Dot_Rest
CASE "SAVE" = Dot_1st
   DO Dot_Save WITH Dot_1st
CASE "SEEK" = Dot_1st
   SEEK &Dot_Rest
CASE "SELECT" = Dot_1st
   SELECT &Dot_Rest
CASE "SET" = Dot_1st
   Dot_Temp = UPPER(LEFT(LTRIM(Dot_Rest), 4))
   DO CASE
   CASE "HIST" = Dot_Temp
      IF " TO " $ UPPER(Dot_Rest)
         m_Temp = VAL(RIGHT(Dot_Rest, LEN(Dot_Rest) - ;
            AT(" TO ", UPPER(Dot_Rest)) - 3))
         DO CASE
         CASE m_Temp = 0 .AND. RIGHT(RTRIM(Dot_Rest), 1) = "0"
            RELEASE Dot_Array
            Dot_Hist = 0
         CASE m_Temp > 0
            IF m_Temp <> Dot_Hist
               Dot_Hist = m_Temp
               DECLARE Dot_Array[Dot_Hist]
            ENDIF
         ENDCASE
      ENDIF
   CASE "" <> Dot_Temp .AND. .NOT. Dot_Temp $ ;
         "FORMATDEBUGDOHISTORYECHOINSTRUCTSQL STEPTRAP"
      Dot_t_st = SET("STATUS")
      Dot_t_DI = SET("DISPLAY")
      SET &Dot_Rest
      DO Set_Color
      *-- Move prompt if STATUS or DISPLAY mode has changed.
      IF "DISPLAY" = Dot_Temp .OR. "STATUS" = Dot_Temp
         IF SET("STATUS") <> Dot_t_st
            Dot_Row = Dot_Row + IIF(SET("STATUS") = "ON", - 3, 3)
         ENDIF
         IF SET("DISPLAY") <> Dot_t_di
            Dot_Row = Dot_Row + ;
               IIF(RIGHT(SET("DISPLAY"), 2) = "43", 18, -18)
         ENDIF
         Dot_Row = MIN(IIF("43" $ SET("DISPLAY"), 42, 24), Dot_Row)
      ENDIF
      RELEASE Dot_t_st, Dot_t_di
   ENDCASE
   RELEASE Dot_temp
CASE "SHOW" = Dot_1st
   SHOW &Dot_Rest
CASE "SKIP" = Dot_1st
   SKIP &Dot_Rest
CASE "SORT" = Dot_1st
   SORT &Dot_Rest
CASE "STORE" = Dot_1st
   STORE &Dot_Rest
CASE "SUM" = Dot_1st
   SUM &Dot_Rest
CASE "TOTAL" = Dot_1st
   TOTAL &Dot_Rest
CASE "TYPE" = Dot_1st
   TYPE &Dot_Rest
CASE "UNLOCK" = Dot_1st
   UNLOCK &Dot_Rest
CASE "UPDATE" = Dot_1st
   UPDATE &Dot_Rest
CASE "USE" = Dot_1st
   USE &Dot_Rest
CASE "WAIT" = Dot_1st
   IF "TO " $ UPPER(Dot_Rest)
      m_Temp = RIGHT(Dot_Rest, LEN(Dot_Rest) - ;
         AT(" TO ", UPPER(Dot_Rest)) - 3)
      PUBLIC &m_Temp
   ENDIF
   WAIT &Dot_Rest
CASE "ZAP" = Dot_1st
   ZAP
CASE "=" $ Dot_Comm
   mStoreVar = LEFT(Dot_Comm, AT("=", Dot_Comm) - 1)
   mstore = SUBSTR(Dot_Comm, AT("=", Dot_Comm) + 1, LEN(Dot_Comm))
   PUBLIC &mstorevar
   STORE &mstore TO &mStoreVar
CASE VAL(Dot_Comm) > 0
   GO &Dot_Comm
ENDCASE
SET TALK OFF
IF "" <> Dot_1st
   DO User_Defined
ENDIF
SET EXACT &Dot_Exact
RETURN
*--*
PROCEDURE MacroSub
*-- Check for -, +, =, >=, =<, <>, #, <, >, = in COMMAND line
DECLARE SYMBOL[11]
SYMBOL[1] = "-"
SYMBOL[2] = "+"
SYMBOL[3] = ">="
SYMBOL[4] = "<="
SYMBOL[5] = "<>"
SYMBOL[6] = "#"
SYMBOL[7] = "*"
SYMBOL[8] = "/"
SYMBOL[9] = "="
SYMBOL[10] = "<"
SYMBOL[11] = ">"
m_cnt = 1
DO WHILE m_cnt <= 8
   DO WHILE AT(SYMBOL[m_cnt], Dot_Comm) > 0 .AND. ;
         (SUBSTR(Dot_Comm, AT(SYMBOL[m_cnt], Dot_Comm) + ;
         LEN(SYMBOL[m_cnt]), 1) <> CHR(32) .OR. ;
         SUBSTR(Dot_Comm, AT(SYMBOL[m_cnt], Dot_Comm) - 1, 1) ;
         <> CHR(32))
      Dot_Comm = STUFF(Dot_Comm, AT(SYMBOL[m_cnt], Dot_Comm), ;
         LEN(SYMBOL[m_cnt])," " + CHR(1) + " ")
   ENDDO
   DO WHILE AT(CHR(1), Dot_Comm) > 0
      Dot_Comm = STUFF(Dot_Comm, AT(CHR(1), Dot_Comm), 1, SYMBOL[m_cnt])
   ENDDO
   m_cnt = m_cnt + 1
ENDDO
DO WHILE m_cnt <= 11
   DO WHILE AT(SYMBOL[m_cnt], Dot_Comm) > 0 .AND. ;
         ((.NOT. SUBSTR(Dot_Comm, AT(SYMBOL[m_cnt], Dot_Comm) + ;
         LEN(SYMBOL[m_cnt]), 1) $ " <,>,=") .OR. ;
         (.NOT. SUBSTR(Dot_Comm, AT(SYMBOL[m_cnt], Dot_Comm) - ;
         1, 1) $ " ,<,>,="))
      Dot_Comm = STUFF(Dot_Comm, AT(SYMBOL[m_cnt], Dot_Comm), ;
         LEN(SYMBOL[m_cnt])," " + CHR(1) + " ")
   ENDDO
   DO WHILE AT(CHR(1), Dot_Comm) > 0
      Dot_Comm = STUFF(Dot_Comm, AT(CHR(1), Dot_Comm), 1, SYMBOL[m_cnt])
   ENDDO
   m_cnt = m_cnt + 1
ENDDO

DOT_COMM = LTRIM(RTRIM(Dot_Comm))
part1 = SUBSTR(Dot_Comm, AT("&", Dot_Comm) + 1, LEN(Dot_Comm))
IF AT(".", part1) = 0
   is_Dot = .F.
   m_Pos = IIF(AT(" ", part1) = 0, LEN(part1), AT(" ", part1) - 1)
ELSE
   is_Dot = .T.
   IF AT(" ", part1) = 0
      m_Pos = AT(".", part1) - 1
   ELSE
      m_Pos = MIN(AT(".", part1), AT(" ", part1)) - 1
   ENDIF
ENDIF
part2 = LEFT(part1, m_Pos)
part3 = RIGHT(Dot_Comm, LEN(Dot_Comm)  - AT("&", Dot_Comm) - ;
   m_Pos - IIF(is_Dot, 1, 0))
Dot_Comm = LEFT(Dot_Comm, AT("&", Dot_Comm) - 1) + &part2 + part3
RETURN
*--*
PROCEDURE Set_Color
Dot_Color = LEFT(SET("ATTRIBUTES"), AT(",", SET("ATTRIBUTES")) - 1)
Dot_Color = Dot_Color + "," + Dot_Color
RETURN
*--*
PROCEDURE User_Defined
*-- Allows UDCs (User-Defined Commands) to execute if a non-dBASE
*-- command is entered.
IF Dot_1st = "WHO"
   SAVE SCREEN TO Dot_Screen
   CLEAR
   @  2, 23 SAY "Created By : Adam L. Menkes"
   @  4, 20 SAY "Updated On: 01/15/92"
   @  4, 40 SAY "Version : x026"
   @  6, 20 SAY "Thanks : "
   @  8, 32 SAY "Erik McBeth"
   @  9, 32 SAY "Geoff Riordan"
   @ 10, 32 SAY "Roger Bowman"
   @ 11, 32 SAY "Rick Knight"
   @ 12, 32 SAY "Linda Reese"
   @ 13, 32 SAY "Steve Koterski"
   @ 20, 20 SAY "Press any key to continue ... "
   I=INKEY(0)
   RESTORE SCREEN FROM Dot_Screen
   RELEASE SCREEN Dot_Screen
ELSE
   IF FILE("User_Def.DBO")
      DO User_Def
      *-- RETURN is optional. Add it here if you want to disable the
      *-- built-in UDCs. Only necessary if USER_DEF contains the same UDC.
   ENDIF
   IF FILE("Adam_Def.DBO")
      DO Adam_Def
   ENDIF
ENDIF
RETURN
*--*
FUNCTION Tmp_Dir
mTmp_Dir = IIF("" <> GETENV("DBTMP"), GETENV("DBTMP"), GETENV("TMP"))
RETURN mTmp_Dir + IIF(RIGHT(mTmp_Dir, 1) <> "\" .AND. ;
   LEFT(OS(), 3) = "DOS" .AND. .NOT. "" = mTmp_Dir, "\", "")
*--*
PROCEDURE CtrlHome
*-- can come from dot_comm or m_temp
on key label ctrl-home
mvar = VARREAD()
DEFINE WINDOW ctrlhome FROM 8, 10 TO 14, 59 NONE
ACTIVATE WINDOW ctrlhome
****mtmp = LEFT(&mvar + SPACE(250 - MIN(LEN(&mvar), 250)), 250)
***@ 0, 0 GET mtmp
@ 0, 0 get &mvar
KEYBOARD CHR(2)
READ
DEACTIVATE WINDOW ctrlhome
RELEASE WINDOW ctrlhome
IF MOD(READKEY(), 256) = 15
   KEYBOARD CHR(26) + CHR(25) + LTRIM(RTRIM(&mvar)) + CHR(13)
**   KEYBOARD CHR(26) + CHR(25) + LTRIM(RTRIM(mtmp)) + CHR(13)
ENDIF
on key label ctrl-home do ctrlhome
RETURN
*: EOF: DOT.PRG
