************************** HOST.PRG ********************************
*This program demonstrates how to use the powerful remote command
*functions of COMET. This program opens a specified COM port where
*a Hayes compatible modem should be present, initializes the modem
*to go into auto-answer and lastly enables COMET remote command sensing.

************** BE SURE TO CHANGE COM PORT # IN LINE 14 ******************

CLEAR
Cr = CHR(13)				&& Carriage return defined

ComPort = '2'               && COM port #
ComBaud = '2400'
ComParity = 'N'
ComData = '8'
ComStop = '1'
ComFlow = 'R'               && Might need Rts/cts flow control for high baud rates

* If Rts/cts specified for COMET, might also need to include a command
* in the ModemInit string so the modem knows to use Rts/cts.
ModemInit = 'AT &F E0 Q0 V1 S0=1 &C1 &D2' + Cr
ModemInit = STRTRAN(ModemInit, ' ', '')

* Open port
OpenCmd = 'OPEN COM' + ComPort + ':' + ComBaud + ',' + ComParity ;
  + ',' + ComData + ',' + ComStop + ',' + ComFlow
CALL COMETMP WITH OpenCmd

*Define send/recv protocol timeouts
ProtCmd = 'PROT 2,5,5'
CALL COMETMP WITH ProtCmd

*Init modem
OutInit = 'OUTPUT #' + ComPort + ',' + ModemInit
CALL COMETMP WITH OutInit

*Enable remote command sensing
EnabCmd = 'REMOTE #' + ComPort + ',1'
CALL COMETMP WITH EnabCmd

*Now modem is in auto-answer mode ready to answer any calls. Once it
*does answer, the calling PC can use COMET's REMCMD command to request
*this PC (remote) to perform any COMET command. Typically this we be
*some sort of file send or receive command.  Assuming this is the case,
*we'll continuously look to see if any file transfer has been requested
*and report its progress.

FChkCmd = 'FCHK #' + ComPort + ',' + SPACE(65)
MStatCmd = 'MSTAT #' + ComPort + ',' + SPACE(25)
DO WHILE INKEY() # 27
    CALL COMETMP WITH MStatCmd
	IF '-DCD' $ MStatCmd
        DispMess('Waiting for call. ESC exits ...', -1)
	ELSE
        CALL COMETMP WITH FChkCmd
        DispMess(FChkCmd, -1)
	ENDIF
ENDDO

CALL COMETMP WITH 'DTR #' + ComPort + ',0'
DispMess('Disconnecting. CLOSing COM port. Hit any key ...', 2)
CALL COMETMP WITH 'CLOSE #' + ComPort         && Shut down port
CLEAR


* DispMess() - Displays a message and optionally waits for keypress
FUNCTION DispMess
PARAMETERS Mess, SecsToWait
@ 10,0 TO 14,79
@ 12,1 CLEAR TO 12,78
@ 12,1 SAY Mess
IF SecsToWait >= 0
  Key = INKEY(SecsToWait)
ENDIF

RETURN ''

