*      Program: CDEFAULT.PRG
*       Author: George E. McMullen
*             : Borland Technical Support
*         Date: 10-18-91
*     Function: Utilizes COLORCTL.BIN and COLOR.MEM (made from SETCLR.PRG)
*               to set saved color settings.
* Requirements: COLORCTL.BIN
*               COLOR.MEM (made from SETCLR.PRG)
*               VGA color monitor

* Setup Environment
gl_escape=IIF(SET("ESCAPE")="ON","ON","OFF")
SET ESCAPE OFF
gl_talk=IIF(SET("TALK")="ON","ON","OFF")
SET TALK OFF
gl_echo=IIF(SET("ECHO")="ON","ON","OFF")
SET ECHO OFF
CLEAR                                  && Clear screen
                                       && Check for colorctl.bin and color.mem
IF .NOT. FILE("colorctl.bin") .OR. .NOT. FILE("color.mem")
  IF .NOT. FILE("colorctl.bin")        && Couldn't find COLORCTL.BIN
    ? CHR(7)+"Error: Could not locate COLORCTL.BIN"
  ENDIF
  IF .NOT. FILE("color.mem")           && Couldn't find COLOR.MEM
    ? CHR(7)+"Error: Could not locate COLOR.MEM - Run SETCLR.PRG first."
  ENDIF
  SET ESCAPE &gl_escape                && Reset environment
  SET ECHO &gl_echo
  SET TALK &gl_talk
  RETURN
ENDIF
LOAD colorctl.bin                      && Load COLORCTL.BIN
RESTORE FROM color ADDITIVE            && Get saved colors (gl_color[16,4])
pv_index=1
pv_new_color=""                        && Set colorctl.bin command holder
DO WHILE pv_index<17
  pv_new_color='"Index='+STR(gl_colors[pv_index,1],2)+'",'+;
               '"Red='  +STR(gl_colors[pv_index,2],2)+'",'+;
               '"Green='+STR(gl_colors[pv_index,3],2)+'",'+;
               '"Blue=' +STR(gl_colors[pv_index,4],2)+'"'
  CALL colorctl WITH '/S',&pv_new_color  && Set new index color
  pv_index=pv_index+1
ENDDO
RELEASE colorctl                     && Release COLORCTL.BIN from memory
SET ESCAPE &gl_escape                && Reset environment
SET ECHO &gl_echo
SET TALK &gl_talk
RETURN
