*      Program: SETCLR.PRG
*       Author: George E. McMullen
*             : Borland Technical Support
*         Date: 10-18-91
*     Function: Utilizes COLORCTL.BIN to custom set dBASE's color settings.
*               This program gives you access to select 16 of 264,000+ possible
*               colors on a VGA monitor.
* Requirements: COLORCTL.BIN
*               VGA color monitor

* Setup Environment
gl_escape=IIF(SET("ESCAPE")="ON","ON","OFF")
SET ESCAPE OFF
gl_talk=IIF(SET("TALK")="ON","ON","OFF")
SET TALK OFF
gl_echo=IIF(SET("ECHO")="ON","ON","OFF")
SET ECHO OFF
gl_status=IIF(SET("STATUS")="ON","ON","OFF")
SET STATUS OFF
gl_cursor=IIF(SET("CURSOR")="ON","ON","OFF")
SET CURSOR OFF
gl_color=SET("ATTRIBUTE")
SET COLOR TO W+/N                      && Set color to bright white/black
CLEAR                                  && Clear screen
IF .NOT. FILE("colorctl.bin")          && Check for colorctl.bin
  SET COLOR TO &gl_color               && Reset environment and display error
  SET CURSOR &gl_cursor
  SET STATUS &gl_status
  ? CHR(7)+"Error: Could not locate COLORCTL.BIN"
  SET ESCAPE &gl_escape
  SET ECHO &gl_echo
  SET TALK &gl_talk
  RETURN
ENDIF
PUBLIC ARRAY gl_colors[16,4]           && Public color array string
DECLARE gl_colors[16,4]                && Initial color settings
PUBLIC gl_dcolor                       && Dbase color setttings
gl_dcolor="  N  B  G GB  R RB GR  W N+ B+ G+GB+ R+RB+GR+ W+"
pv_index=1                             && Current index (color) number + 1
pv_disp_color=""                       && Sample color display
pv_new_color=""                        && New color setting
pv_count1=1                            && Restore color index counter
DO storedefaults                       && Get factory default settings
LOAD colorctl.bin                      && Load colorctl.bin into memory
CALL colorctl WITH '/R'                && Reset Default Settings
DO draw_screen                         && Draw display screen
DO WHILE .T.                           && Main loop
  DO CASE                              && Check for last key press
    CASE LASTKEY()=4                   && <right arrow> Increase Index
      pv_index=pv_index+IIF(pv_index=16,-15,1)
    CASE LASTKEY()=19                  && <left arrow> Decrease Index
      pv_index=pv_index-IIF(pv_index>1,1,-15)
    CASE LASTKEY()=26                  && <home> Increase Red Gun
      gl_colors[pv_index,2]=gl_colors[pv_index,2]+;
                            IIF(gl_colors[pv_index,2]<63,1,-63)
    CASE LASTKEY()=2                   && <end> Decrease Red Gun
      gl_colors[pv_index,2]=gl_colors[pv_index,2]-;
                            IIF(gl_colors[pv_index,2]>0,1,-63)
    CASE LASTKEY()=5                   && <up arrow> Increase Green Gun
      gl_colors[pv_index,3]=gl_colors[pv_index,3]+;
                            IIF(gl_colors[pv_index,3]<63,1,-63)
    CASE LASTKEY()=24                  && <down arrow> Decrease Green Gun
      gl_colors[pv_index,3]=gl_colors[pv_index,3]-;
                            IIF(gl_colors[pv_index,3]>0,1,-63)
    CASE LASTKEY()=18                  && <pgup> Increase Blue Gun
      gl_colors[pv_index,4]=gl_colors[pv_index,4]+;
                            IIF(gl_colors[pv_index,4]<63,1,-63)
    CASE LASTKEY()=3                   && <pgdn> Decrease Blue Gun
      gl_colors[pv_index,4]=gl_colors[pv_index,4]-;
                            IIF(gl_colors[pv_index,4]>0,1,-63)
    CASE LASTKEY()=27                  && <ESC> key exit program
      CALL colorctl WITH '/R'          && Reset Factory settings
      EXIT                             && Exit Main Loop
    CASE LASTKEY()=23                  && <ctrl-end> Save colors and exit
      SET SAFE OFF                     && Set safety off
      SAVE TO color ALL LIKE gl_colors && Save array gl_color to file color.mem
      SET SAFE ON                      && Set safety on
      EXIT                             && Exit without resetting colors
    CASE LASTKEY()=29                  && <ctrl-home> Restore colors
      IF FILE("color.mem")             && If COLOR.MEM exists...
        RESTORE FROM color ADDITIVE    && Restore colors from color.mem
        pv_count1=1                    && Restore index countere
        DO WHILE pv_count1<17          && While index number < 17
                                       && Build colorctl command
          pv_new_color='"Index='+STR(gl_colors[pv_count1,1],2)+'",'+;
                       '"Red='  +STR(gl_colors[pv_count1,2],2)+'",'+;
                       '"Green='+STR(gl_colors[pv_count1,3],2)+'",'+;
                       '"Blue=' +STR(gl_colors[pv_count1,4],2)+'"'
          CALL colorctl WITH '/S',&pv_new_color  && Set new index color
          pv_count1=pv_count1+1        && Increment index number
        ENDDO
      ENDIF
  ENDCASE
                                       && Build colorctl command
  pv_new_color='"Index='+STR(gl_colors[pv_index,1],2)+'",'+;
               '"Red='  +STR(gl_colors[pv_index,2],2)+'",'+;
               '"Green='+STR(gl_colors[pv_index,3],2)+'",'+;
               '"Blue=' +STR(gl_colors[pv_index,4],2)+'"'
  CALL colorctl WITH '/S',&pv_new_color  && Set new index color
  SET COLOR TO W+/N                    && Set color to bright white/black
  @ 10,31 TO 16,51 DOUBLE              && Draw sample edit box
  @ 11,32 SAY "Index:"+STR(gl_colors[pv_index,1],3)
  @ 13,32 SAY "Red:  "+STR(gl_colors[pv_index,2],3)
  @ 14,32 SAY "Green:"+STR(gl_colors[pv_index,3],3)
  @ 15,32 SAY "Blue: "+STR(gl_colors[pv_index,4],3)
  @ 11,44 TO 15,50 COLOR
  pv_disp_color=SUBSTR(gl_dcolor,((pv_index-1)*3)+1,3)  && Get selected index
  SET COLOR TO &pv_disp_color          && Display color box
  @ 12,45 SAY REPL(CHR(219),5)
  @ 13,45 SAY REPL(CHR(219),5)
  @ 14,45 SAY REPL(CHR(219),5)
  CLEAR TYPEAHEAD                      && Clear typeahead keyboard buffer
  READ                                 && Wait for keypress
ENDDO
RELEASE colorctl                       && Release colorctl.bin from memory
SET COLOR TO &gl_color                 && Reset environment
SET CURSOR &gl_cursor
SET ECHO &gl_echo
SET TALK &gl_talk
SET ESCAPE &gl_escape
SET STATUS &gl_status
RETURN                                 && EOF() setclr.prg

PROCEDURE draw_screen                  && draw display screen procedure
pv_count1=0                            && Index counter
pv_box_color=""                        && Current box color
DO WHIL pv_count1<16                   && While index number < 15
  pv_box_color=SUBSTR(gl_dcolor,(pv_count1*3)+1,3)  && Get new box color
  SET COLO TO W+/n                     && Set text color to bright white/black
  @ 0,0 SAY "Color Index Number:"      && Draw display screen
  @ 1,(pv_count1*5)+2 SAY STR(pv_count1,2)
  @ 2,(pv_count1*5)+1 SAY SUBS(gl_dcolor,(pv_count1*3)+1,3)
  @ 3,0 SAY REPL(CHR(205),80)
  @ 6,0 SAY REPL(CHR(205),80)
  SET COLOR TO &pv_box_color/n         && Set color for box
  @ 4,pv_count1*5 SAY REPL(CHR(219),5) && Draw colored boxes
  @ 5,pv_count1*5 SAY REPL(CHR(219),5)
  pv_count1=pv_count1+1                && Increment index number
ENDDO
                                       && Draw control panel
@ 19,0 SAY "Control Keys:    COLOR SELECTION     RED GUN     GREEN GUN    BLUE GUN"
@ 20,0 SAY "                =================    ========  =============  ========="
@ 21,0 SAY "                left/right arrows    Home/End  Up/Down arrow  PgUp/PgDn"
@ 23,0 SAY "                      <CTRL-END> to save colors to file COLOR.MEM"
@ 24,0 SAY "                     <CTRL-HOME> to load colors from file COLOR.MEM"
RETURN

PROCEDURE storedefaults                && Store factory default color values
* pv_default = "index number,red value,green value,blue value,index number,..."
pv_default="00,00,00,00,01,00,00,42,02,00,42,00,03,00,42,42,04,42,00,00,"+;
           "05,42,00,42,06,42,21,00,07,42,42,42,08,21,21,21,09,21,21,63,"+;
           "10,21,63,21,11,21,63,63,12,63,21,21,13,63,21,63,14,63,63,21,"+;
           "15,63,63,63"
pv_count1=0                            && Index counter 0 - 15
pv_count2=0                            && Element counter
DO WHILE pv_count1<16                  && While index number < 16
  pv_count2=0                          && Start at element 0 (index numeber)
  DO WHILE pv_count2<4                 && While elements < 4
                                       && Store the default settings into
                                       &&   the global array gl_color
    gl_colors[pv_count1+1,pv_count2+1]=;
      VAL(SUBSTR(pv_default,(pv_count1*12)+1+(pv_count2*3),2))
    pv_count2=pv_count2+1              && Increment the element counter
  ENDDO
  pv_count1=pv_count1+1                && Increment the index number
ENDDO
RETURN
