/*                               INCLUDE FILES                               */
#include <dos.h>
/*                        PROGRAMMER-DEFINED CONSTANTS                       */
#define isdigit(x) ((x) >='0' && (x) <='9')   /* numberic digit? */
#define zindex(x) ((x) < 6 || x == 7 ? x : x == 6 ? 20 : x < 16 ? x+48 : 0 )
/*                            FUNCTION PROTOTYPES                            */
int  zCatoi(char *str);                                   /* C ATOI function */
void zSetAnalogHue(int I, int R, int G, int B);          /* Set analog color */
void zReadAnalogHue(int I);                             /* Read analog color */
void zGetColors();                                      /* Get numberic args */
void zSetDefaultColor(int Index);             /* Set default analog color(s) */

int errno;
int I,R,G,B,D,Red,Green,Blue,commandarg;
char **argvs;
int argcs;

far main(){
  int cnt1,cnt2,Cur_Red,Cur_Green,Cur_Blue;

  argvs=MK_FP(_ES,_DI);                          /* Make far pointer to args */
  argcs=_CX;                                        /* Number of args passed */
  I=0;R=0;B=0;G=0,D=10,Red=0,Green=0,Blue=0;      /* Default Analog settings */
  for (cnt1=0;cnt1<argcs;cnt1++){                         /* Cycle thru args */
    if (argvs[cnt1][0]=='/' && (argvs[cnt1][1]=='S' ||            /* Set arg */
      argvs[cnt1][1]=='s')){
      zGetColors();                                     /* Get passed colors */
      zSetAnalogHue(zindex(I),R,G,B);}                          /* Set color */
    if (argvs[cnt1][0]=='/' && (argvs[cnt1][1]=='R' ||          /* Reset arg */
        argvs[cnt1][1]=='r')){
      if (argcs>1){                               /* If more than one arg... */
        zGetColors();                             /*   assume it's Index=#   */
        zSetDefaultColor(zindex(I));}                     /* Reset one index */
      else                                            /* Only one arg passed */
        for (cnt2=0;cnt2<16;cnt2++)        /* Counter to reset all 16 colors */
          zSetDefaultColor(zindex(cnt2));                     /* Reset index */
    }
    if (argvs[cnt1][0]=='/' && (argvs[cnt1][1]=='f' ||           /* Fade arg */
        argvs[cnt1][1]=='F')){
      zGetColors();                                    /* Get passed coloors */
      zReadAnalogHue(zindex(I));          /* Read in old index analog colors */
      for (cnt2=0;cnt2<64;cnt2++){           /* Set colors in n/64 fractions */
        if (Red>=R)
          Cur_Red=Red-((Red-R)*cnt2/64);
        else
          Cur_Red=Red+((R-Red)*cnt2/64);
        if (Green>=G)
          Cur_Green=Green-((Green-G)*cnt2/64);
        else
          Cur_Green=Green+((G-Green)*cnt2/64);
        if (Blue>=B)
          Cur_Blue=Blue-((Blue-B)*cnt2/64);
        else
          Cur_Blue=Blue+((B-Blue)*cnt2/64);
        zSetAnalogHue(zindex(I),Cur_Red,Cur_Green,Cur_Blue);    /* Set color */
        delay(D);}                                                  /* Delay */
      }
    }
    return;}
/*
ͻ
                     Set Analog Hue (color Index)                
ͼ
 Parameters: I=Color index to set
						 R=Red gun intensity value
						 G=Green gun intensity value
						 B=Blue gun intensity value
 Prototype:  zSetAnalogHue(I,R,G,B)
 Returns:    NULL
*/
static union REGS regs;

void zSetAnalogHue(int I, int R, int G, int B){
  regs.h.ah=0x10;                               /* Function 10H, DAC palette */
  regs.h.al=0x10;                                      /* Set a DAC register */
  regs.x.bx=I;                                         /* Color index to set */
  regs.h.ch=G;                                   /* Green gun value, 0 to 63 */
  regs.h.cl=B;                                    /* Blue gun value, 0 to 63 */
  regs.h.dh=R;                                     /* Red gun value, 0 to 63 */
  int86(0x10,&regs,&regs);                                   /* Call int 10H */
  return;}
/*
ͻ
                     Read Analog Hue (color Index)               
ͼ
 Parameters: I=Color index to set
 Prototype:  zReadAnalogHue(I)
 Returns:    NULL
 NOTE:       Program sets global variable
             Red, Green, Blue
*/
/*           A TYPICAL FUNCTION TO READ A COLOR USING THE VIDEO BIOS         */
void zReadAnalogHue(int I){
  regs.h.ah=0x10;                               /* Function 10H, DAC palette */
  regs.h.al=0x15;                                      /* Set a DAC register */
  regs.x.bx=I;                                        /* Color index to read */
  int86(0x10,&regs,&regs);                                   /* Call int 10H */
  Green=regs.h.ch;                               /* Green gun value, 0 to 63 */
  Blue=regs.h.cl;                                 /* Blue gun value, 0 to 63 */
  Red=regs.h.dh;                                   /* Red gun value, 0 to 63 */
  return;}
/*
ͻ
                      C atio Function (source code)              
ͼ
 Parameters: str=string pointer to evaluate
 Prototype:  Catoi(string)
 Returns:    Numeric value of string or 0
 NOTE:       This functions trims leading character looking for
						 numeric data ie. abcde30 would return 30
*/
int zCatoi(char *str){
  int n;

  while (!isdigit(*str))                                  /* Skip non digits */
    str++;                                              /* Increament string */
  for (n = 0; isdigit(*str); str++)                        /* Get the digits */
    n = n * 10 + (*str - '0');                          /* Calculate integer */
  return(n);}                                          /* Return the integer */
/*
ͻ
                      C Get Colors from arguments                
ͼ
 Parameters: None
 Prototype:  zGetColors()
 Returns:    None
*/
void zGetColors(){
  int r;

  for (r=0;r<argcs;r++){                           /* Get numberic arguments */
    if (argvs[r][0]=='r' || argvs[r][0]=='R')
      R=(zCatoi(argvs[r]) > 63 ? 63:zCatoi(argvs[r]));
    if (argvs[r][0]=='g' || argvs[r][0]=='G')
      G=(zCatoi(argvs[r]) > 63 ? 63:zCatoi(argvs[r]));
    if (argvs[r][0]=='b' || argvs[r][0]=='B')
      B=(zCatoi(argvs[r]) > 63 ? 63:zCatoi(argvs[r]));
    if (argvs[r][0]=='i' || argvs[r][0]=='I')
      I=(zCatoi(argvs[r]) > 15 ? 0:zCatoi(argvs[r]));
    if (argvs[r][0]=='d' || argvs[r][0]=='D')
      D=(zCatoi(argvs[r]) > 100 ? 100:zCatoi(argvs[r]));}
  return;}
/*
ͻ
                  C SetDefaultColor Proceedure                   
ͼ
 Parameters: Index=index number (0 - 15)
 Prototype:  zSetDefaultColor(Index)
 Returns:    NULL
*/
void zSetDefaultColor(int Index){
  switch (Index){                                /* Set default index colors */
    case 0:  zSetAnalogHue(0,0,0,0);break;
    case 1:  zSetAnalogHue(1,0,0,42);break;
    case 2:  zSetAnalogHue(2,0,42,0);break;
    case 3:  zSetAnalogHue(3,0,42,42);break;
    case 4:  zSetAnalogHue(4,42,0,0);break;
    case 5:  zSetAnalogHue(5,42,0,42);break;
    case 20: zSetAnalogHue(20,42,21,0);break;
    case 7:  zSetAnalogHue(7,42,42,42);break;
    case 56: zSetAnalogHue(56,21,21,21);break;
    case 57: zSetAnalogHue(57,21,21,63);break;
    case 58: zSetAnalogHue(58,21,63,21);break;
    case 59: zSetAnalogHue(59,21,63,63);break;
    case 60: zSetAnalogHue(60,63,21,21);break;
    case 61: zSetAnalogHue(61,63,21,63);break;
    case 62: zSetAnalogHue(62,63,63,21);break;
    case 63: zSetAnalogHue(63,63,63,63);break;}
  return;}
