* ͻ
*  Program.: CLRSHOW.PRG                                             
*  Author..: Phil Steele - President Phillipps Computer Systems Inc. 
*  Address.: 52 Hook Mountain Road,  Montville NJ 07045              
*  Phone...: (201) 575-8575                                          
*  Date....: June 25, 1990                                           
*                                                                    
*  Notice..: Copyright 1990  Philip Steele                           
*            Placed into the public domain by Phil Steele  Sept. 1990
*                                                                    
*  Version.: dBASE IV release 1.1                                    
* ͼ
* Note -- I copied and extracted these routines from Phil Steele's
* PCSDEMO.PRG routine. I wanted something so I could figure out
* color combinations -- this one works. It writes the colors to
* disk as a MEM file, which can be restored in any program, and then 
* the appropriate color combinations can be used with:
* RESTORE FROM COLOR ADDITIVE
* SET COLOR OF xxx TO &COxxx.  && see language reference & var names below
*  (I also added a few comments here and there ...)
* Handy.  Ken Mayer


*
* PREAMBLE
*
CLEAR ALL
SET STEP    OFF
SET ECHO    OFF
SET TALK    OFF
SET BELL    OFF
SET PRINT   OFF
SET CLOCK   OFF
SET DELETE  ON
SET STATUS  OFF
SET SAFETY  OFF
SET ESCAPE  OFF
SET CONFIRM ON
SET HEADING OFF
SET SCOREBOARD OFF
SET DISPLAY TO EGA25
SET DEVICE  TO SCREEN
SET CURSOR  OFF


*
* STANDARD COLORS
*
IF FILE("COLOR.MEM")
   RESTORE FROM COLOR ADDITIVE
ELSE                                   && If COLOR.MEM Does not exist
   Cl         = ISCOLOR()              && create it
   ColBlank   = "N/N,N/N,N"
   ColFunc    = "N/W"
   ColOther   = IIF(Cl, "BG+/B"        , "W+/N")
   ColHelp    = IIF(Cl, "N/G,N/W,B"    , "W+/N,N/W,N")
   ColData    = IIF(Cl, "RG+/B,N/W,B"  , "W+/N,N/W,N")
   ColError   = IIF(Cl, "W+/R,W+/N,B"  , "W/N,N/W,N")
   ColEntry   = IIF(Cl, "N/W,W+/N,B"   , "N/W,W+/N,N")
   ColStand   = IIF(Cl, "W+/B,N/W,B"   , "W+/N,N/W,N")
   ColMenu    = IIF(Cl, "RG+/R,RG+/N,B", "W+/N,N/W,N")
   ColWarning = IIF(Cl, "N/BG,W+/N,B"  , "W/N,N/W,N")
   SAVE TO COLOR ALL LIKE COL*
ENDIF


*
* MISC CONSTANTS
*
Esc      = CHR(27)

*
* KEY CONSTANTS		&& this is handy for the use of INKEY(x)
*
Key      = 0 && General purpose key variable
EndKey   = 2
PgDn     = 3
CurRight = 4
CurUp    = 5
Del      = 7
Tab      = 9
Enter    = 13
PgUp     = 18
CurLeft  = 19
CInsert  = 22
CtrlW    = 23
CtrlEnd  = 23
CurDn    = 24
CtrlY    = 25
Home     = 26
Escape   = 27
F1Key    = 28
CtrlHome = 29
CtrlPgDn = 30
CtrlPgUp = 31
Space    = 32
F2Key    = -1
F3Key    = -2
F4Key    = -3
F5Key    = -4
F6Key    = -5
F7Key    = -6
F8Key    = -7
F9Key    = -8
F10Key   = -9
BackTab  = -400
AltL     = -424

*
*PROCEDURE COLORS
*
*ͻ
*         LISTING OF COLOR.MEM              
*                                           
*  ColFunc    = "N/W"                       
*  ColBlank   = "N/N,N/N,B"                 
*  ColHelp    = "N/G,N/W,B"                 
*  ColData    = "RG+/B,N/W,B"               
*  ColError   = "W+/R,W+/R,B"               
*  ColEntry   = "N/W,W+/N,B,B"              
*  ColStand   = "W+/B,N/W,B"                
*  ColMenu    = "RG+/R,RG+/N,B"             
*  ColWarning = "N/BG,W+/N,B"               
*ͼ

DO WHILE .T.
   Dummy = BOXES(14,6,23,21,.F., "S", ColMenu)
   @ 15,12 SAY "MENU"
   @ 16,7  TO 16,20 DOUBLE
   @ 16,6  SAY ""
   @ 16,21 SAY ""
   SET BORDER  TO NONE
   SET MESSAGE TO
   DEFINE POPUP ColChoice FROM 16, 7
   DEFINE BAR 1 OF ColChoice PROMPT "1. Background"
   DEFINE BAR 2 OF ColChoice PROMPT "2. Data   "
   DEFINE BAR 3 OF ColChoice PROMPT "3. Help   "
   DEFINE BAR 4 OF ColChoice PROMPT "4. Menu   "
   DEFINE BAR 5 OF ColChoice PROMPT "5. Warning "
   DEFINE BAR 6 OF ColChoice PROMPT "6. Return "
   mChoice = 0
   ON SELECTION POPUP ColChoice DO PopSel WITH mChoice
   SET BORDER TO SINGLE
   ACTIVATE POPUP ColChoice
   IF mChoice = 0 .OR. mChoice = 6
      EXIT
   ELSE
      DO CLRS WITH mChoice
   ENDIF
ENDDO
SET MESSAGE TO " " AT 23,0
set cursor on
RETURN
*END:COLORS

*
* U S E R   D E F I N E D   F U N C T I O N S    &   P R O C E D U R E S *
*
  * this gets used in the procedures below
*
FUNCTION BOXES
*
PARAMETERS T, L, B, R, Shadow, SD, BC
PRIVATE    T, L, B, R, Shadow, SD, BC, Kind
DO CASE
   CASE SD = "D"
      Kind = "DOUBLE"
   CASE SD = "S"
      Kind = " "
   CASE SD = "N"
      Kind = "NONE"
ENDCASE
IF Shadow                               && With or without a drop shadow
   @ T+1,L+1 FILL TO B+1,R+2 COLOR N+/N && T,L,B,R = Corners of the box
ENDIF                                   && Shadow = .T. or .F.
SET COLOR TO &BC                        && SD = SIngle or Double line box
@ T,L CLEAR TO B,R                      && BC = Color of the box
@ T,L       TO B,R &Kind
RETURN(.T.)
*END:BOXES

  * I don't think this one gets used here, but I left it in since it was
  * an intriguing function. <g>
*
FUNCTION MESSBOX
*
PARAMETERS Line, Mess, Shadow, SD, BC
PRIVATE    Line, Mess, Shadow, SD, BC, Kind,;
   SCol, MLen, T, L, B, R
MLen  = LEN(Mess)                      && Line = Line to put the message
SCol  = (80 - MLen) / 2                && Mess = Message to display
T     = Line - 1                       && Shadow = .T. or .F. indicating
L     = SCol-2                         &&          if a shadow is needed
B     = Line + 1                       && SD = Single or Double line box
R     = SCol + MLen + 2                && BC = Box color
Dummy = BOXES(T, L, B, R, Shadow, SD, BC)
SET COLOR TO &BC
@ Line, SCol SAY Mess
RETURN(.T.)
*END:MESSBOX

	* same can be said for this -- it's not used, but it's interesting.
*
FUNCTION WBOX
*
PARAMETERS WName,T, L, B, R, SD, Shadow, BColor
DEFINE WINDOW &WName FROM T,L TO B,R NONE COLOR &BColor
BB = B - T
BR = R - L
IF Shadow
  SName = "S" + WName
  DEFINE WINDOW &SName FROM T+1,L+1 TO B+1,R+2;
                NONE COLOR N+,N,N
  ACTIVATE WINDOW &SName
ENDIF
ACTIVATE WINDOW &WName
DO CASE
   CASE SD = "D"
      Kind = "DOUBLE"
   CASE SD = "S"
      Kind = " "
   CASE SD = "N"
      Kind = "NONE"
ENDCASE
SET COLOR TO &BColor
@ 0,0 TO BB,BR &Kind
RETURN(.T.)
*END:WBOX

	* and again. 
*
FUNCTION MBOX                          && Draw a menu box on the screen
*
PARAMETERS S, T, B, Shadow, SD, BC, Mess

PRIVATE L, R, Kind
L = (78 - S) / 2                       &&  Ŀ    ͻ
R = L + S + 1                          &&   MESS      MESS 
Dummy = BOXES(T,L,B,R,Shadow,SD,BC)    &&  ͵    Ķ
SET COLOR TO &BC                       &&                  
IF SD = "S"                            &&                  
   @ T+2,L+1 TO T+2,R-1 DOUBLE         &&                  
   @ T+2,L SAY ""                     &&      ͼ
   @ T+2,R SAY ""                     && S = Width of centered box
ELSE                                   && T & B = Top and Bottom lines
   @ T+2,L+1 TO T+2,R-1                &&         for the box
   @ T+2,L SAY ""                     && Shadow = .T. or .F.
   @ T+2,R SAY ""                     && SD = Single or Double lines
ENDIF                                  && BC = Color of the box
Dummy = CENT(T+1,80,Mess)              && Mess = Message for the top of
RETURN(.T.)                            &&        the box
*END:MBOX


*
PROCEDURE POPSEL
*
PARAMETERS mVar
mVar = BAR()
DEACTIVATE POPUP
RETURN
*END:POPSEL


*
PROCEDURE PADSEL
*
YN = VAL(SUBSTR(PAD(), 2))
DEACTIVATE MENU
RETURN
*END:PADSEL

*--------------------------------------------------------------------
* This is where we get into the really interesting stuff ...
*--------------------------------------------------------------------

*
PROCEDURE CLRS
*
PARAMETERS BDHMW	&& Background,Data,Help,Menu,Warning (BDHMW)
IF BDHMW > 5
   RETURN
ENDIF
Pass = 1
DECLARE mColArray[16]
RESTORE FROM COLOR ADDITIVE
mColArray [ 1] = "W+"	&& bright white
mColArray [ 2] = "W"		&& white
mColArray [ 3] = "RG+"	&& yellow
mColArray [ 4] = "RG"	&& brown
mColArray [ 5] = "RB+"	&& bright magenta
mColArray [ 6] = "RB"	&& magenta
mColArray [ 7] = "R+"	&& pink ("light" red)
mColArray [ 8] = "R"		&& red
mColArray [ 9] = "GB+"	&& light cyan
mColArray [10] = "GB"	&& cyan
mColArray [11] = "G+"	&& light green
mColArray [12] = "G"		&& green
mColArray [13] = "B+"	&& light blue
mColArray [14] = "B"		&& blue
mColArray [15] = "N+"	&& grey
mColArray [16] = "N"		&& black
STORE 6  TO X1,X2,HoldX,X
STORE 50 TO Y1,Y
STORE 65 TO Y2,HoldY
Forg   = "W+"
Bakg   = "W"
Active = "X"
DO ColDisp WITH Forg,Bakg,Active,X1,X2,Y1,Y2,9,Pass,BDHMW
DO WHILE .T.
   SET CURSOR OFF
   Key = INKEY(0)
   DO CASE
      CASE Key = CurDn .OR. Key = CurUp
         IF Active = "X"
            X = X1
            Y = Y1
         ELSE
            X = X2
            Y = Y2
         ENDIF
         X = IIF(Key = CurDn,X + 1,X - 1)
         X = IIF(Y = 65 .AND. X = 15,6,X)
         X = IIF(Y = 65 .AND. X = 5,14,X)
         X = IIF(Y = 50 .AND. X = 22,6,X)
         X = IIF(Y = 50 .AND. X = 5,21,X)
      CASE Key = CurRight
         SET COLOR TO W+/B
         @ X1,Y1 SAY ""
         SET COLOR TO W+*/B
         @ HoldX,HoldY SAY ""
         X = HoldX
         Y = HoldY
         HoldX = X1
         HoldY = 50
         STORE 65 TO Y2,Y
         Active = "Y"
      CASE Key = CurLeft
         SET COLOR TO W+/B
         @ X2,Y2 SAY ""
         SET COLOR TO W+*/B
         @ HoldX,HoldY SAY ""
         X = HoldX
         Y = HoldY
         HoldX = X2
         HoldY = 65
         STORE 50 TO Y1,Y
         Active = "X"
      CASE Key = Escape
         EXIT
   ENDCASE
   IF Active = "X"
      SET COLOR TO B/B
      @ X1,Y1 SAY " "
      X1 = X
      Y1 = Y
      SET COLOR TO W+*/B
      @ X1,Y1 SAY ""
   ENDIF
   IF Active = "Y"
      SET COLOR TO B/B
      @ X2,Y2 SAY " "
      X2 = X
      Y2 = Y
      SET COLOR TO W+*/B
      @ X2,Y2 SAY ""
   ENDIF
   DoIt = .T.
   IF Active = "Y" .AND. X2 = 14 .AND. Key = Enter
      DoIt       = .F.
      ColFunc    = "N/W"
      ColBlank   = "N/N,N/N,B"
      ColHelp    = "N/G,N/W,B"
      ColData    = "RG+/B,N/W,B"
      ColError   = "W+/R,W+/R,B"
      ColEntry   = "N/W,W+/N,B,"
      ColStand   = "W+/B,N/W,B"
      ColMenu    = "RG+/R,RG+/N,B"
      ColWarning = "N/BG,W+/N,B"
      DO CASE
         CASE BDHMW = 1
            Forg = "W+/"
            Bakg = "B"
         CASE BDHMW = 2
            Forg = "RG+/"
            Bakg = "B"
         CASE BDHMW = 3
            Forg = "N/"
            Bakg = "G"
         CASE BDHMW = 4
            Forg = "RG+/"
            Bakg = "R"
         CASE BDHMW = 5
            Forg = "N/"
            Bakg = "BG"
      ENDCASE
      DO ColDisp WITH Forg,Bakg,Active,X1,X2,Y1,Y2,BDHMW,Pass,BDHMW
   ENDIF
   IF Key = Enter
      SET COLOR TO W+*/R
      @ 17,66 SAY "    SAVING   "
      SAVE TO COLOR ALL LIKE COL*
      DoIt       = .F.
      DO CASE
         CASE BDHMW = 1
            ColStand   = Forg + Bakg + ",N/W,B"
         CASE BDHMW = 2
            ColData    = Forg + Bakg + ",N/W,B"
         CASE BDHMW = 3
            ColHelp    = Forg + Bakg + ",N/W,B"
         CASE BDHMW = 4
            ColMenu    = Forg + Bakg + ",RG+/N,B"
         CASE BDHMW = 5
            ColWarning = Forg + Bakg + ",W+/N,B"
      ENDCASE
      Key = INKEY(3)
      SET COLOR TO W+/B
      @ 17,66 SAY "             "
      EXIT
   ENDIF
   IF DoIt
      IF Key <> Enter
         Forg = mColArray[X1-5] + "/"
         IF X2 < 14
            Bakg = mColArray[(X2-5)*2]
         ENDIF
      ENDIF
      DO CASE
         CASE BDHMW = 1
            ColStand   = Forg + Bakg + ",N/W,B"
         CASE BDHMW = 2
            ColData    = Forg + Bakg + ",N/W,B"
         CASE BDHMW = 3
            ColHelp    = Forg + Bakg + ",N/W,B"
         CASE BDHMW = 4
            ColMenu    = Forg + Bakg + ",RG+/N,B"
         CASE BDHMW = 5
            ColWarning = Forg + Bakg + ",W+/N,B"
      ENDCASE
      DO ColDisp WITH Forg,Bakg,Active,X1,X2,Y1,Y2,BDHMW,Pass,BDHMW
   ENDIF
ENDDO
SET COLOR TO &ColStand
DO NOARROW
RETURN
*END:CLRS.PRG


*
PROCEDURE COLDISP
*
PARAMETERS Forg,Bakg,Active,X1,X2,Y1,Y2,Choice,Pass,BDHMW
NewCol = Forg + Bakg
IF Choice = 1                          && STANDARD COLOR
   SET COLOR TO &NewCol
ELSE
   SET COLOR TO &ColStand
ENDIF
@  3,0 CLEAR TO 23,47
@  3,18      TO  5,33
@  3,0 SAY " "
@  4,0 SAY " "
@  5,0 SAY " "
@  6,0 SAY " Customer:"
@  7,0 SAY " "
@  8,0 SAY " Address :"
@  9,0 SAY " "
@ 10,0 SAY " City    :                      State:"
@ 11,0 SAY " "
@ 12,0 SAY " Phone   : (   )   -            Zip  :"
@ 13,0 SAY "ĳ"
@ 14,0 SAY "                    "
@ 15,0 SAY "                    "
@ 16,0 SAY "                    "
@ 17,0 SAY "                   "
@ 18,0 SAY "                    "
@ 19,0 SAY "                       "
@ 20,0 SAY "                           "
@ 21,0 SAY "                     "
@ 22,0 SAY ""
@ 23,0 SAY ""
@ 23,1 TO 23,47 DOUBLE
@ 4,20 SAY "MAIN HEADING"

IF Choice = 2                          && DATA COLOR
   SET COLOR TO &NewCol
ELSE
   SET COLOR TO &ColData
ENDIF
@  6,13 SAY "Phillipps Computer Systems Inc."
@  8,13 SAY "52 Hook Mountain Road"
@ 10,13 SAY "Montville"
@ 10,41 SAY "NJ"
@ 12,14 SAY "201"
@ 12,18 SAY "575"
@ 12,22 SAY "8575"
@ 12,40 SAY " 07045"
SET COLOR TO N+/N
@ 16,42 FILL TO 19,44
@ 19,30 FILL TO 19,44

IF Choice = 3                          && HELP COLOR
   SET COLOR TO &NewCol
ELSE
   SET COLOR TO &ColHelp
ENDIF
@ 0,0 SAY ""
@ 1,0 SAY "     These are the help colors.                "
@ 2,0 SAY ""

IF Choice = 4                          && MENU COLOR
   SET COLOR TO &NewCol
ELSE
   SET COLOR TO &ColMenu
ENDIF
@ 14,6 SAY "Ŀ"
@ 15,6 SAY "     MENU     "
@ 16,6 SAY "͵"
@ 17,6 SAY "1. Background"
@ 18,6 SAY " 2. Data"
@ 19,6 SAY "3. Help      "
@ 20,6 SAY " 4. Menu      "
@ 21,6 SAY " 5. Warning"
@ 22,6 SAY " 6. Return    "
@ 23,6 SAY ""
SET COLOR TO &ColFunc
DO CASE
   CASE BDHMW = 1
      @ 17,8 SAY "1. Background"
   CASE BDHMW = 2
      @ 18,8 SAY "2. Data"
   CASE BDHMW = 3
      @ 19,8 SAY "3. Help      "
   CASE BDHMW = 4
      @ 20,8 SAY "4. Menu      "
   CASE BDHMW = 5
      @ 21,8 SAY "5. Warning"
ENDCASE

IF Choice = 5                          && WARNING COLOR
   SET COLOR TO &NewCol
ELSE
   SET COLOR TO &ColWarning
ENDIF
@ 15,28 TO 18,41
@ 16,29 SAY "  Warning   "
@ 17,29 SAY "   Colors   "

IF Pass = 1
   Pass = 2
   SET COLOR TO  &ColHelp
   @ 24,0 CLEAR TO 24,79
   @ 24,7  SAY "-return"
   @ 24,19 SAY "-up/down"
   @ 24,33 SAY "-background"
   @ 24,48 SAY "-foreground"
   @ 24,65 SAY "-reset/save"
   SET COLOR TO  &ColFunc
   @ 24,4 SAY "ESC"
   @ 24,17 SAY ""
   @ 24,32 SAY CHR(26)                 && -
   @ 24,47 SAY CHR(27)                 && -
   @ 24,61 SAY ""
   SET COLOR TO W+/B,W+/B,B,B          && CHOICES
   @ 0,48 CLEAR TO 23,79
   @ 0,48       TO 23,79
   @  0,48 SAY " SCREEN COLOR ͸"
   @  2,52 SAY "SELECT COLORS COMBINATIONS"
   @  4,52 SAY "Foreground     Background"
   @  5,52 SAY "     "
   SET COLOR TO W+/B
   @  6,52 SAY "HI WHITE     "
   Forg = "W+"
   SET COLOR TO W/B
   @  7,52 SAY "WHITE        "
   Forg = "W"
   SET COLOR TO RG+/B
   @  8,52 SAY "HI YELLOW    "
   Forg = "RG+"
   SET COLOR TO RG/B
   @  9,52 SAY "BROWN        "
   Forg = "RG"
   SET COLOR TO RB+/B
   @ 10,52 SAY "HI MAGENTA   "
   Forg = "RB+"
   SET COLOR TO RB/B
   @ 11,52 SAY "MAGENTA      "
   Forg = "RB"
   SET COLOR TO R+/B
   @ 12,52 SAY "HI RED       "
   Forg = "R+"
   SET COLOR TO R/B
   @ 13,52 SAY "RED          "
   Forg = "R"
   SET COLOR TO GB+/B
   @ 14,52 SAY "HI CYAN      "
   Forg = "GB+"
   SET COLOR TO GB/B
   @ 15,52 SAY "CYAN         "
   Forg = "GB"
   SET COLOR TO G+/B
   @ 16,52 SAY "HI GREEN     "
   Forg = "G+"
   SET COLOR TO G/B
   @ 17,52 SAY "GREEN        "
   Forg = "G"
   SET COLOR TO B+/B
   @ 18,52 SAY "HI BLUE      "
   Forg = "B+"
   SET COLOR TO B/B
   @ 19,52 SAY "BLUE         "
   Forg = "B"
   SET COLOR TO N+/B
   @ 20,52 SAY "HI BLACK     "
   Forg = "N+"
   SET COLOR TO N/B
   @ 21,52 SAY "BLACK        "
   Forg = "N"
   SET COLOR TO  /W
   Bakg = "W"
   @  6,66 SAY "WHITE       "
   SET COLOR TO  /RG
   Bakg = "RG"
   @  7,66 SAY "BROWN       "
   SET COLOR TO  /RB
   Bakg = "RB"
   @  8,66 SAY "MAGENTA     "
   SET COLOR TO  /R
   Bakg = "R"
   @  9,66 SAY "RED         "
   SET COLOR TO  /GB
   Bakg = "GB"
   @ 10,66 SAY "CYAN        "
   SET COLOR TO  /G
   Bakg = "G"
   @ 11,66 SAY "GREEN       "
   SET COLOR TO  /B
   Bakg = "B"
   @ 12,66 SAY "BLUE        "
   SET COLOR TO  /N
   Bakg = "N"
   @ 13,66 SAY "BLACK       "
   SET COLOR TO N/W
   @ 14,66 SAY "RESET ORIG."
ENDIF
IF Active = "X"
   SET COLOR TO W+*/B
   @ X1,Y1 SAY ""
   SET COLOR TO W+/B
   @ X2,Y2 SAY ""
ELSE
   SET COLOR TO W+*/B
   @ X2,Y2 SAY ""
   SET COLOR TO W+/B
   @ X1,Y1 SAY ""
ENDIF
SET CURSOR OFF
RETURN
*EOF:COLDISP


*
PROCEDURE NOARROW	&& cleans out the arrow on screen ...
*
SET COLOR TO W+/B
X = 5
DO WHILE X < 22
   X = X + 1
   @ X,50 SAY " "
   IF X < 15
      @ X,65 SAY " "
   ENDIF
ENDDO
RETURN
*END:NOARROR
