* -- PROGRAM NAME: .......... CI_PRD.PRG
* -- PROGRAM TITLE: ......... Compound Interest: Number of Time Periods
* -- AUTHOR: ................ Venkat Penugonde, Irvine Micro Arts, Irvine, CA
* -- DATE FIRST CREATED .............. 05/10/86
* -- DATE MOST RECENTLY MODIFIED .....
*
*  This program calculates the number of time periods in a
*   compound interest calculation given the following:
*
*    principal =  Present value or principal
*    ann_rate  =  Nominal annual interest rate in %
*    y_period  =  Number of compounding periods per year
*    fu_value  =  Value at the end of the total time period
*
SET TALK OFF
CLEAR
 principal = 0.00
 fu_value  = 0.00
 ann_rate  = 0.00
 y_period  = 0
*
@  2, 17 SAY '            COMPOUND INTEREST'
@  3, 17 SAY '            NUMBER OF PERIODS'
@  5, 17 SAY 'PRINCIPAL [enter zero to exit]: . '
@  7, 17 SAY 'FUTURE VALUE .................... '
@  9, 17 SAY 'ANNUAL INTEREST RATE [in % ]: ... '
@ 11, 17 SAY 'COMPOUNDING PERIODS PER YEAR: ... '
*
DO WHILE .t.
 @ 5, 51 GET principal
 READ
 IF principal <= 0
   EXIT
  ELSE
   @  7, 51 GET fu_value
   @  9, 51 GET ann_rate
   @ 11, 51 GET y_period
   READ
 ENDIF
 *
 * ----- Compute interest rate per period
 int_rate = ann_rate/y_period
 *
 * ----- Compute total number of compounding periods
 numerator   = LOG(fu_value/principal)
 denomanator = LOG(1+int_rate/100)
 t_period    = numerator/denomanator
 *
 @ 15, 17 SAY 'Number of Compounding Periods --> ' + STR(t_period, 10)
 *
ENDDO WHILE .t.
RETURN
* -- EOF CI_PRD