*
*  Procedure to retreive messages from CIS saved in a *.SAV file.
*
*
=talkoff()   &sets TALK OFF AND saves current setting

** Find table to store messages

STORE GETFILE('DBF','Store messages in which table?','',1) TO lcDbf
IF EMPTY(lcDbf)
   WAIT WINDOW 'Must have open database first'
   RETURN
ENDIF

** User selected <New>
** So create table
**
IF 'UNTITLED'$UPPER(lcDbf)
   STORE PUTFILE('Name for new message database?','','DBF','Save') TO lcDbf
   IF EMPTY(lcDbf)
      WAIT WINDOW 'Must have open database first'
      RETURN
   ENDIF
   CREATE TABLE (lcDbf) (MessNu C(10), SECTION C(30), Subject C(40),DATE D(8), TIME C(8),FromId C(40),ToId C(40), ;
      MESSAGE m(10), Comment m(10) )
   WAIT WINDOW 'Table Created: ' + lcDbf NOWAIT
   USE
ENDIF

** Check to see if file already open
**
**
lcAlias='dbftable'
IF USED(lcAlias)
   SELECT (lcAlias)
   USE (lcDbf) AGAIN ALIAS dbftable
ELSE
   SELECT 0
   USE (lcDbf) AGAIN ALIAS dbftable
ENDIF

**  Check to see if selected file has correct structure
**
**
IF TYPE('MessNu')#'C' OR TYPE('Subject')#'C' OR TYPE('FromID')#'C' OR TYPE('ToId')#'C' ;
      OR TYPE('Message')#'M' OR TYPE('Comment')#'M' OR TYPE('Date')#'D' OR TYPE('Time')#'C' OR TYPE('Section')#'C'
   WAIT WINDOW 'Chosen database has incorrect structure'
   RETURN
ENDIF
**
**  Get name of messave file. Default is *.SAV
**
lcInMes='xxxxxx' &&Garbage
DO WHILE NOT EMPTY(lcInMes)  && allow more than one sav file to be added
   STORE GETFILE('SAV','Retrieve messages from where') TO lcInMes
   IF EMPTY(lcInMes)
      WAIT WINDOW 'No message file, Job completed.'
      RETURN
   ENDIF
**
**  OPen the message file
**
   lnFH=FOPEN(lcInMes)
   IF lnFH<0
      WAIT WINDOW 'Error opening '+lcInMes
      RETURN
   ENDIF
   lcOut=''
   lcIn=''
   lcIn=FGETS(lnFH) && Get a line
**
**  Find a line which starts with '#:'
**  CIS message all start with this.
**

   DO WHILE AT('#:',lcIn)#1 AND NOT FEOF(lnFH)
      lcIn=FGETS(lnFH)
   ENDDO

**
**  If never found must be a bad file
**

   IF FEOF(lnFH)
      =FCLOSE(lnFH)
      WAIT WINDOW 'Not a message file'
      RETURN
   ENDIF
**
**  Finally we march through the file
**

   DO WHILE NOT FEOF(lnFH)
      lcIn=lcIn+'  '    && add two spaces so at(' ',lcIn,2) always >0
      lnFspace=AT(' ',lcIn)           && First Space
      lnSspace=AT(' ',lcIn,2)         &&Second Space
      SCATTER MEMVAR MEMO BLANK
      m.MessNu=SUBSTR(lcIn,lnFspace+1,lnSspace-lnFspace-1) && Message #
      m.Section=SUBSTR(lcIn,lnSspace+1)                    && Section Info
      lcIn=ALLTRIM(FGETS(lnFH))+'  '                       && Next Line
      lcFspace=AT(' ',lcIn)
      lcDate=LEFT(lcIn,lcFspace-1)             && Date in form 11-Aug-92

   **
   ** Fix Date
   **
      IF OCCURS('-',lcDate)=2
         lcMon=SUBSTR(lcDate,AT('-',lcDate)+1,AT('-',lcDate,2)-AT('-',lcDate)-1)
         lcMon=UPPER(ALLTRIM(lcMon))
         DO CASE
         CASE lcMon='JAN'
            lcMonpart='01'
         CASE lcMon='FEB'
            lcMonpart='02'
         CASE lcMon='MAR'
            lcMonpart='03'
         CASE lcMon='APR'
            lcMonpart='04'
         CASE lcMon='MAY'
            lcMonpart='05'
         CASE lcMon='JUN'
            lcMonpart='06'
         CASE lcMon='JUL'
            lcMonpart='07'
         CASE lcMon='AUG'
            lcMonpart='08'
         CASE lcMon='SEP'
            lcMonpart='09'
         CASE lcMon='OCT'
            lcMonpart='10'
         CASE lcMon='NOV'
            lcMonpart='11'
         CASE lcMon='DEC'
            lcMonpart='12'
         OTHERWISE
            lcMonpar='  '
         ENDCASE
         lcdaypart=LEFT(lcDate,AT('-',lcDate)-1)
         lcYearpart=SUBSTR(lcDate,AT('-',lcDate,2)+1)
         lcDate=lcMonpart+'/'+lcdaypart+'/'+lcYearpart
      ELSE
         lcDate='00/00/00'
      ENDIF
      m.date =CTOD(lcDate)   && Convert to date format
      m.time =ALLTRIM(SUBSTR(lcIn,lcFspace+1))  && Time on same line
      lcIn=FGETS(lnFH)
      m.Subject = SUBSTR(lcIn,5)     && Subject
      lcIn=FGETS(lnFH)
      m.fromid=SUBSTR(lcIn,5)        && Senders name
      lcIn=FGETS(lnFH)
      m.toid=SUBSTR(lcIn,5)          && Recipients name
      lcOut=''
      lcIn=FGETS(lnFH)
   **
   ** get the message now. Follow CIS criteria for word wrap
   ** If first char of a line is not white space wrap the line
   **
      DO WHILE NOT FEOF(lnFH) AND AT('#: ',lcIn)#1)  && get message
         IF lcIn=' ' OR lcIn='*'
            lcOut=lcOut+CHR(13)+CHR(10)+lcIn
         ELSE
            lcOut=lcOut+' '+lcIn
         ENDIF
         lcIn=FGETS(lnFH)
      ENDDO
      m.message=lcOut
      APPEND BLANK
      GATHER MEMVAR MEMO
   ENDDO   && end of message0
   =FCLOSE(lnFH)
ENDDO
SET TALK &lcTalkSet
*!*****************************************************************
*!
*!       Function: TALKOFF
*!
*!*****************************************************************
FUNCTION talkoff
RELEASE lcTalkSet
PUBLIC lcTalkSet
** SETS TALK OFF WITHOUT ECHOING ANYTHING TO SCREEN
**
**  Public MEMVAR necessary since
**    STORE talkoff() to lcTalkSet (assuming talkoff would return on or off
**    echos to the screen even if talkoff set talk off
**
IF SET('TALK') = 'ON'
   SET TALK OFF
   lcTalkSet='ON'
ELSE
   lcTalkSet='OFF'
ENDIF

