/**********
*
*   trlib.h
*
*   Header file for all TRLIB.C modules.
*
*   By: Tom Rettig, Leonard Zerman, Ralph Davis
* 
*   Placed in the public domain by Tom Rettig Associates, 10/22/1990.
*
**********/

#define TRLIBVERS    "TRLIB, Clipper Edition, Version 1.20"
#define TRTYPE       void pascal
#define ABRENDCHAR   '.'                      /* used in street() */
#define ABS(p)       (((p)<0)?-(p):(p))
#define ADTOI(p)     (int) ((p)-('0'))        /* ascii digit to int */
#define ADTOL(p)     (long) ((p)-('0'))       /* ascii digit to long*/
#define BLANKDS      "00000000"
#define COLOR_VID_AD 0xB800
#define DEFAULT      0
#define DIGIT(p)     (char) ((p)+('0'))       /* int digit to ascii */
#define DONE         "DONE"    /* for filewrite() return successful */
#define ERROR        0
#define ERRORNEG     -1
#define ERRORNEGL    -1L
//#define FALSE        (0)
#define HYPHEN       "-"       /* string, not char, for password array */
#define MAXEXPAND    16        /* maximum number of spaces to replace tabs */
#define MAXELEM      1000
#define MONO_VID_AD  0xB000
#define NULLC        '\0'      /* use to terminate char arrays as strings */
#define NULLLONG     0L        /* for NULL pointer return */
#define NULLS        ""        /* use with _retc() to return null string */
#define PW_MIN_LEN   3         /* number of chars in password */
#define PW_MIN_NUM   10000000  /* number of digits in password return number */
#define SPACEC       ' '
//#define TRUE         (1)
#define TWO_BILLION  2000000000               /* for base.c */
#define UPPER        ('a' - 'A')
#define ZEROC        '0'

/* Replace #define macros in Microsoft and Clipper */
 
#define isalpha(p)   ((('A'<=(p)&&(p)<= 'Z')||('a'<= (p)&&(p)<='z'))\
                                                     ? TRUE : FALSE) 
#define isdigit(p)   (('0'<=(p)&&(p)<='9') ? TRUE : FALSE)

#define isspace(p)   ((((p) == ' ')||((p) == '\n')||((p) == '\t')||\
                       ((p) == '\f')||((p) == '\r')) ? TRUE : FALSE)

#define islower(p)   ( 'a' <= (p) && (p) <= 'z' )

#define toupper(p)   ( islower(p) ? ((p) - UPPER) : ((p)) )

/* valid structure of 8 byte time string is "##:##:##" */
#define TIMELEN      8 /* number of bytes in time string not including null */
#define TIMEDELIM    ':'   /* character used by DELIM_1 and DELIM_2 */
#define TDELIMS(p)   ( (p)[TDELIM_1]==TIMEDELIM && (p)[TDELIM_2]==TIMEDELIM )
#define HOURS        0
#define HOUR         1
#define TDELIM_1     2
#define MINS         3
#define MIN          4
#define TDELIM_2     5
#define SECS         6
#define SEC          7

#define ISHOURS(p)   (( (p)[HOURS] == '2' && \
                        (p)[HOUR ] >= '0' && (p)[HOUR ] <= '3'  ) || \
                     ( ((p)[HOURS] == '0' || (p)[HOURS] == '1') && \
                        (p)[HOUR ] >= '0' && (p)[HOUR ] <= '9'  ))

#define ISMINS(p)    ((p)[MINS]>='0' && (p)[MINS]<='5' &&\
                      (p)[MIN ]>='0' && (p)[MIN ]<='9')

#define ISSECS(p)    ((p)[SECS]>='0' && (p)[SECS]<='5' &&\
                      (p)[SEC ]>='0' && (p)[SEC ]<='9')

#define VALIDTIME(p) (TDELIMS(p) && ISHOURS(p)  &&\
                       ISMINS(p)  && ISSECS(p)  &&\
                       (p)[TIMELEN]==NULLC)

#define ISTS(p)      (ISDIGIT(p[HOURS]) && ISDIGIT(p[HOUR]) &&\
                      ISDIGIT(p[MINS ]) && ISDIGIT(p[MIN ]) &&\
                      ISDIGIT(p[SECS ]) && ISDIGIT(p[SEC ]) &&\
                      TDELIMS(p) && (p)[TIMELEN]==NULLC)

/* valid structure of 10 byte zip code is "#####-####" */
#define ZIPLEN       10
#define ZIPDELIM     '-'
#define ZDELIM       5

#define VALIDZIP1(p) ((p)[0]>='0' && (p)[0]<='9' &&\
                      (p)[1]>='0' && (p)[1]<='9' &&\
                      (p)[2]>='0' && (p)[2]<='9' &&\
                      (p)[3]>='0' && (p)[3]<='9' &&\
                      (p)[4]>='0' && (p)[4]<='9')

#define VALIDZIP2(p) ((p)[ZDELIM]==ZIPDELIM      &&\
                      (p)[6]>='0' && (p)[6]<='9' &&\
                      (p)[7]>='0' && (p)[7]<='9' &&\
                      (p)[8]>='0' && (p)[8]<='9' &&\
                      (p)[9]>='0' && (p)[9]<='9' &&\
                      (p)[ZIPLEN]==NULLC)

/* valid structure of 13 byte telephone number is "(###)###-####" */
#define PHONLEN       13
#define PHONDELIM_1   '('
#define PHONDELIM_2   ')'
#define PHONDELIM_3   '-'
#define PDELIM_1      0
#define PDELIM_2      4
#define PDELIM_3      8

#define VALIDPHON1(p) ((p)[PDELIM_1]==PHONDELIM_1 &&\
                       (p)[ 1]>='0' && (p)[ 1]<='9' &&\
                       (p)[ 2]>='0' && (p)[ 2]<='9' &&\
                       (p)[ 3]>='0' && (p)[ 3]<='9' &&\
                       (p)[PDELIM_2]==PHONDELIM_2)

#define VALIDPHON2(p) ((p)[ 5]>='0' && (p)[ 5]<='9' &&\
                       (p)[ 6]>='0' && (p)[ 6]<='9' &&\
                       (p)[ 7]>='0' && (p)[ 7]<='9' &&\
                       (p)[PDELIM_3]==PHONDELIM_3)

#define VALIDPHON3(p) ((p)[ 9]>='0' && (p)[ 9]<='9' &&\
                       (p)[10]>='0' && (p)[10]<='9' &&\
                       (p)[11]>='0' && (p)[11]<='9' &&\
                       (p)[12]>='0' && (p)[12]<='9' &&\
                       (p)[PHONLEN]==NULLC)

/* valid structure of 11 byte social security number is "###-##-####" */
#define SSNUMLEN      11
#define SSNUMDELIM    '-'
#define SSDELIM_1     3
#define SSDELIM_2     6

#define VALIDSS1(p)   ((p)[ 0]>='0' && (p)[ 0]<='9' &&\
                       (p)[ 1]>='0' && (p)[ 1]<='9' &&\
                       (p)[ 2]>='0' && (p)[ 2]<='9' &&\
                       (p)[SSDELIM_1]==SSNUMDELIM   &&\
                       (p)[ 4]>='0' && (p)[ 4]<='9' &&\
                       (p)[ 5]>='0' && (p)[ 5]<='9')

#define VALIDSS2(p)   ((p)[SSDELIM_2]==SSNUMDELIM   &&\
                       (p)[ 7]>='0' && (p)[ 9]<='9' &&\
                       (p)[ 8]>='0' && (p)[ 7]<='9' &&\
                       (p)[ 9]>='0' && (p)[10]<='9' &&\
                       (p)[10]>='0' && (p)[11]<='9' &&\
                       (p)[SSNUMLEN]==NULLC)

#define ISLPYR(yr)    ((yr)>0 && (((yr)%4==0&&(yr)%100!=0) || (yr)%400==0))

#define ISMONTH(p)    ((p)>=1 && (p)<=12)       /* valid month */

#define ISYEAR(p)     ((p)>=1 && (p)<=9999)     /* valid year */

#define ISDS(p)       ( ISDIGIT(p[0]) && ISDIGIT(p[1]) &&\
                        ISDIGIT(p[2]) && ISDIGIT(p[3]) &&\
                        ISDIGIT(p[4]) && ISDIGIT(p[5]) &&\
                        ISDIGIT(p[6]) && ISDIGIT(p[7]) && !p[8] )

#define DSYEAR(p)     ( (ADTOI(p[0])*1000) +\
                        (ADTOI(p[1])* 100) +\
                        (ADTOI(p[2])*  10) +\
                        (ADTOI(p[3])) )         /* ds year to int */

#define DSMONTH(p)   ( (ADTOI(p[4])*  10) +\
                       (ADTOI(p[5])) )         /* ds month to int */

#define DSDAY(p)     ( (ADTOI(p[6])*  10) +\
                       (ADTOI(p[7])) )         /* ds day to int */

#define ISDIGIT(p)   ((p)>='0' && (p)<='9')    /* valid digit */
#define MK_FP(seg,ofs)	((void far *)(((unsigned long)(seg) << 16) | (ofs)))

/* #defines Months for generic use in programs */
#define MONTH0       ""
#define MONTH1       "January"
#define MONTH2       "February"
#define MONTH3       "March"
#define MONTH4       "April"
#define MONTH5       "May"
#define MONTH6       "June"
#define MONTH7       "July"
#define MONTH8       "August"
#define MONTH9       "September"
#define MONTH10      "October"
#define MONTH11      "November"
#define MONTH12      "December"

/* #defines for _tr_reg.c */

#define REG_AX  0
#define REG_BX  1
#define REG_CX  2
#define REG_DX  3
#define REG_SP  4
#define REG_BP  5
#define REG_SI  6
#define REG_DI  7
#define REG_DS  8
#define REG_ES  9
#define REG_SS 10
#define REG_CS 11
#define REG_IP 12
#define REG_FF 13

/* #defines for tomoney() */
#define DECPOINT     '.'  /* separates dollars and cents */
#define INPUTMAX     32   /* chars in input string  */
#define OUTPUTMAX    256  /* chars in output string */ 
#define DECIMAX      2    /* number of decimal places  */ 
#define PTRMAX       64   /* numper of pointers to output words */ 
#define NUM_OVRFLW   "****************" /* overflow condition */ 
#define ONES(p)   ((int)(p)[-1]-('0'))  /* convert first ascii digit to int */
#define TENS(p)   ((int)(p)[-2]-('0'))  /* convert second ascii digit to int */
#define HUNS(p)   ((int)(p)[-3]-('0'))  /* convert third ascii digit to int */

/* #defines for capfirst() */
#define UC1          'A'
#define UC2          'Z' 
#define LC1          'a' 
#define LC2          'z' 
#define CASEDIFF     (LC1 - UC1)  


/* #defines for file attribute used by _tr_creat() */
#define FL_NORMAL    0
#define FL_RDONLY    1
#define FL_HIDDEN    2
#define FL_SYSTEM    4
#define FL_VOLUME    8
#define FL_DIR      16
#define FL_ARCHIVE  32

/* #defines for file mode used by _tr_open() */
#define READONLY     0
#define WRITEONLY    1
#define READWRITE    2
#define EOF_MARK     0x1A
#define FILEERROR    -1

/* Error Message function numbers */
#define E_PREFIX     0
#define E_SYNTAX     1
#define E_ALLOC      2
#define E_FOPEN      3
#define E_FSEEK      4
#define E_FREAD      5
#define E_FWRITE     6 
#define E_FCLOSE     7

/* _parinfo types */
#define UNDEF        0
#define CHARACTER    1
#define NUMERIC      2
#define LOGICAL      4
#define DATE         8
#define ALIAS       16
#define MPTR        32   /* bitwise or'ed with type for pass by reference */
#define MEMO        65
#define WORD       128
#define ARRAY      512

/* parameter check macros */
#define PCOUNT      (_parinfo(0))
#define ISCHAR(n)   (_parinfo(n) & CHARACTER)
#define ISNUM(n)    (_parinfo(n) & NUMERIC)
#define ISLOG(n)    (_parinfo(n) & LOGICAL)
#define ISDATE(n)   (_parinfo(n) & DATE)
#define ISMEMO(n)   (_parinfo(n) & MEMO)
#define ISBYREF(n)   (_parinfo(n) & MPTR)
#define ISARRAY(n)	(_parinfo(n) & ARRAY)
#define ALENGTH(n)	(_parinfa(n, 0))

/* uses internal functions of the C compiler; source code not supplied */
#define _tr_fabs(p)       (((p)<0.0)?-1.0*(p):(p))

#define _tr_atof     atof
#define _tr_pow      pow
#define _tr_log      log
#define _tr_fmod     fmod
#define _tr_modf     _modf
#define _tr_ceil     ceil
#define _tr_floor    floor
#define _tr_sqrt     sqrt
#define _tr_strrchr  strrchr
#define _tr_strncpy  strncpy
#define _tr_allocmem _exmgrab
#define _tr_freemem  _exmback

/* uses internal functions of the Clipper compiler; source code not supplied */
#define _tr_ntoa     _ntoa

/* parameter count/type */
extern int     _parinfo();
extern int     _parinfa();

/* parameter values */
extern char   *_parc();
extern char   *_pards();       /* date string */
extern int     _parl();        /* logical */
extern int     _parni();
extern int     _parcsiz();
extern int     _parclen();
extern long    _parnl();
extern double  _parnd();
            
/* function return values */
extern void _ret();                 /* procedure (DO) return */
extern void _retc();                /* character */
extern void _retclen(char *, int);
extern void _retds();               /* date string */
extern void _retl();                /* logical */
extern void _retnd();               /* double */
extern void _retnl();               /* long */
extern void _retni();               /* integer */
/* one and only one of the _ret*() functions must used */

/* character externals */
extern char *_tr_crypt();
extern char *_tr_errmsgs();
extern char *_tr_getenv();
extern char *_tr_makedate();
extern char *_tr_stpchr();
extern char *_tr_strcat();
extern char *_tr_strcpy();
extern char *_tr_strncpy();
extern char *_tr_strrchr();
extern char *_tr_toup();
extern char *_tr_hexasm();

/* double externals */
extern double _tr_atof();
extern double _tr_fmod();
extern double _tr_frexp();
extern double _tr_htod();
extern double _tr_infinity();
extern double _tr_itod();
extern double _tr_log();
extern double _tr_ltod();
extern double _tr_modf();
extern double _tr_pow();
extern double _tr_round();
extern double _tr_sqrt();
extern double ceil();
extern double floor();

/* int externals */
extern int _tr_doscnf();
extern int _tr_atoi();
extern int _tr_close();
extern int _tr_creat();
extern int _tr_dtoi();
extern int _tr_htoi();
extern int _tr_isdsvalid();
extern int _tr_open();
extern int _tr_read();
extern int _tr_reg();
extern int _tr_strcmp();
extern int _tr_strlen();
extern int _tr_strncmp();
extern int _tr_write();

/* long externals */
extern long _tr_dtol();
extern long _tr_fs();
extern long _tr_htol();
extern long _tr_lseek();
extern long _tr_pnum();

/* no return externals */
extern _tr_ntoa();

/* clippers memory allocation functions */
extern unsigned char *_exmgrab();
extern void _exmback();
extern unsigned strlen();
//typedef unsigned char byte;
//typedef unsigned int quant;
//typedef int Boolean;

/* eof */

