
******************************************************************************
* CHIP() -- get type of processor(s)                                         *
*                                                                            *
* Syntax:                                                                    *
* mvar=CHIP()  (no argument)                                                 *
*                                                                            *
* Returns: <ExpC> "8088|8086|80186|80188|80286|80386|V20|V30"                *
*                 + "P" if in protected mode                                 *
*                 + "/"+"8087|80287|80387" if Intel coprocessor detected     *
******************************************************************************

PROCEDURE CHIP

PRIVATE chipsstr,protchar,mainproc,coproc

chipsstr="  "
protchar=""
LOAD Chip
CALL Chip WITH chipsstr
RELEASE MODULE Chip

mainproc = ASC(chipsstr)
IF MOD(mainproc,2) = 1        && if odd, in protected mode
        protchar = "P"
        mainproc = mainproc - 1
ENDIF
mainproc=LTRIM(STR(mainproc)) && make into a string

IF mainproc$"38,28"
      mainproc=mainproc+"6"
ENDIF
IF mainproc$"20,30"
      mainproc="V"+mainproc
ENDIF
coproc=ASC(RIGHT(chipsstr,1))
DO CASE
CASE coproc = 1
      coproc="/8087"
CASE coproc = 2
      coproc="/80287"
CASE coproc = 3
      coproc="/80387"
OTHERWISE
      coproc = ""
ENDCASE
prefix=IIF("V"$mainproc,"","80")
mainproc=prefix+mainproc+protchar

RETURN mainproc+coproc
