*-- PROGRAM: Checkbox
*--------------------------------------------------------------------
*-- Programmer: Ed Lafferty (GICHIN)
*-- Date      : 2/25/92
*-- Notes     : Routine to create and size a popup with check boxes
*--             for choosing any of a number (up to five) options.  Pressing
*--             the <Space Bar> on an option turns it on or off.
*--             Pressing <Enter> chooses the selected option and leaves
*--             the routine.
*-- Written for: dBase IV 1.1
*-- Rev. Hist.: None
*-- Calls     : Center, Shadow (if you want to put it in)
*-- Called by : Any
*-- Usage     : do checkbox with 8, 15, lchk1, lchk2, lchk3, lchk4, lchk5,;
*--             "LPT1", "LPT2", "LPT3","", "", "Choose a printer port"
*-- Example   : && Place a logical in lChk<n>, either by
*--             && store .f. (or .t.) to lChk<n>
*--             && or
*--             && restore from <memfile name>
*--             do Checkbox with 8, 15, lchk1, lchk2, lchk3, lchk4, lchk5,;
*--             "LPT1", "LPT2", "LPT3","", "", "Choose a printer port"
*-- Returns   : .T. for selected items, .F. for non-selected items
*-- Parameters: nUlrow: upper left row of popup
*--             nUlcol: upper left column of popup
*--             lChk<n>: default value of box
*--             cTxt1  : Text for 1st box
*--             cTxt2  :  "    "  2nd   "
*--             cTxt3  :  "    "  3rd   "
*--             cTxt4  :  "    "  4th   "
*--             cTxt5  :  "    "  5th   "
*--             cTxt0  : Text for the box title

*PROCEDURE Checkbox
para nUlrow, nUlcol, lChk1, lChk2, lChk3, lChk4, lChk5, cTxt1, cTxt2, cTxt3, cTxt4, cTxt5, cTxt0
clear
store 0 to nHeight, nKey, nCnt, nWidth
store lChk1 to lOrig1
store lChk2 to lOrig2
store lChk3 to lOrig3
store lChk4 to lOrig4
store lChk5 to lOrig5

*-- Determine height and width of popup
*-- Determine height
do case
case len(cTxt5) > 0
   nHeight = 5
case len(cTxt4) > 0
   nHeight = 4
case len(cTxt3) > 0
   nHeight = 3
case len(cTxt2) > 0
   nHeight = 2
case len(cTxt1) > 0
   nHeight = 1
endcase
*-- Determine width
do while nCnt <=nHeight
   store "cTxt"+str(nCnt,1) to cStr
   if len(&cstr) > nWidth
      nWidth = len(&cStr)
   endif
   nCnt = nCnt + 1
enddo

*-- create popup
define window wCheck from nUlrow, nUlcol to nUlrow+nHeight+5, nUlcol+nWidth+8
do center with 23,80,"","Press <Space> to select/de-select, <Enter> to quit"
activate window wCheck
store 1 to nCnt
do center with 0, nWidth+8, "", cTxt0

*-- paint screen
do while nCnt <= nHeight
   store "cTxt"+str(nCnt,1) to cStr
   store "lChk"+str(nCnt,1) to cChk
   @ nCnt+1, 2 SAY "[ ] "+&cStr
   @ nCnt+1, 3 SAY IIF(&cChk,"X"," ")
   nCnt = nCnt + 1
enddo

*-- prepare for and get nChoice
store 1 to nCnt
store .F. to ldone
do while .not. ldone
store "lChk"+str(nCnt,1) to cChk
@ nCnt+1,3 say ""
nkey = inkey(0)
do case
case nkey = 27                                   && Press Esc to exit
   store lorig1 to lChk1                         && Therefore, restore original
   store lOrig2 to lChk2                         && values to lChk<n>'s
   store lOrig3 to lChk3
   store lOrig4 to lChk4
   store lOrig5 to lChk5
   store .T. to ldone
case nkey = 13                                   && Press Enter when finished
   store .T. to ldone
case nkey = 32                                   && Press Space
      set cursor off
      if &cChk                                   && Box was already selected,
         @ nCnt+1,3 say " "                      && so now de-select it
         store .F. to &cChk
      else                                       && Box was not already selected,
         @ nCnt+1,3 say "X"                      && so now select it
         store .T. to &cChk
      endif
      set cursor on
case nkey = 5                                    && Press up arrow
   if nCnt > 1
      nCnt = nCnt - 1
   else
      nCnt = nHeight
   endif
case nkey = 24                                   && Press down arrow
   if nCnt < nHeight
      nCnt = nCnt + 1
   else
      nCnt = 1
   endif
endcase
enddo
release window wCheck
release nHeight, nKey, nCnt, nWidth, lOrig1, lOrig2, lOrig3, lOrig4, lOrig5
set message to
RETURN

