PARAMETER mflag

EXTERNAL chany, chall, chexact, chnone, chset, chclear, chnext

SET BELL OFF
SET CONFIRM OFF
SET INTENSITY ON

clr   = IIF(ISCOLOR(), 'W/B, B/W', '')
invclr= IIF(ISCOLOR(), 'B/W', 'N/W')
SET COLOR TO (clr)
IF TYPE('mflag') = 'U'
    DO INITSCRN
ENDIF

DO MAINSCRN

STORE CHR(0)+CHR(0)+CHR(0) TO mvar1 && initialize mvars
STORE 'ABC' TO MVAR2

mflag = 1                           && toggle chSET/chCLEAR/chNEXT
curvar  = '1'

DO WHILE .T.
    SET CURSOR OFF                  && turn cursor off for screen refresh
    @ 5,22 SAY mvar1
    @ 5,30 SAY CHAR2DEC(mvar1)
    @ 5,45 SAY CHAR2BIN(mvar1)
    @ 6,22 SAY mvar2
    @ 6,30 SAY CHAR2DEC(mvar2)
    @ 6,45 SAY CHAR2BIN(mvar2)
    @12,29 SAY IIF(chANY(mvar1, mvar2)  , 'Yes', 'No ') && various bit test
    @13,29 SAY IIF(chALL(mvar1, mvar2)  , 'Yes', 'No ') && functions
    @14,29 SAY IIF(chNONE(mvar1, mvar2) , 'Yes', 'No ')
    @15,29 SAY IIF(chEXACT(mvar1, mvar2), 'Yes', 'No ')
    SET CURSOR ON
    mpos = '  '
    @18,54 GET mpos VALID CHKCHR(mpos)
    READ
    IF LASTKEY() = 27
        QUIT
    ENDIF
    IF mflag = 1
        chSET(mvar&curvar., VAL(mpos))     && perform requested operation
    ELSEIF mflag = 2                       && on specified mvarXX
        chCLEAR(mvar&curvar., VAL(mpos))
    ENDIF
ENDDO

FUNCTION CHKCHR                     && valid function for the read
    PARAMETERS mpos
    IF TRIM(mpos) $ 'Ss'
        mflag = 1
        @18,40 SAY 'chSET(  '
    ELSEIF TRIM(mpos) $ 'Cc'
        mflag = 2
        @18,40 SAY 'chCLEAR('
    ELSEIF LASTKEY() = 18 .OR. LASTKEY() = 3    && pgup/pgdn
        curvar = IIF(curvar = '1', '2', '1')
        @18,51 SAY curvar
    ELSE
        RETURN .T.
    ENDIF
    KEYBOARD CHR(7)                 && clear the character
RETURN .F.

FUNCTION CHAR2BIN                   && returns boolean string of mvar
    PARAMETERS mvar
    PRIVATE str, x
    str = REPLICATE('0', LEN(mvar) * 8)     && fill out return var
    z = chNEXT(mvar, 0)                     && locate first set bit
    DO WHILE z <> 0
        str = STUFF(str, z, 1, '1')
        z = chNEXT(mvar, z)
    ENDDO
RETURN str

FUNCTION CHAR2DEC                  && returns decimal equivalent of mvar
    PARAMETERS mvar
RETURN STR(ASC(SUBSTR(mvar, 1, 1)), 3) + ;
       STR(ASC(SUBSTR(mvar, 2, 1)), 4) + ;
       STR(ASC(SUBSTR(mvar, 3, 1)), 4)

PROCEDURE MAINSCRN                 && splashs main screen with pretty stuff
CLEAR SCREEN
@ 1,26 SAY 'BOOLEAN chARACTER FUNCTIONS'
@ 3, 4 TO  8,77
@ 3,20 SAY '(ASCII)(DECIMAL)(BINARY)'
@ 5,12 SAY 'var1:    "   "'
@ 6,12 SAY 'var2:    "   "'
@ 7,45 SAY '|      |       |       |'
@ 8,45 SAY '181624'
@12, 7 SAY 'chANY  (var1, var2):'
@13, 7 SAY 'chALL  (var1, var2):             chSET(  varX, XX) -sets a bit'
@14, 7 SAY 'chNONE (var1, var2):             chCLEAR(varX, XX) -clears a bit'
@15, 7 SAY 'chEXACT(var1, var2):'
@10, 4 TO 16,37
@11,38 TO 16,77
@10,12 SAY 'Test Results '
@11,39 SAY ' Available operations '
@18,20 SAY 'Current Operation:  chSET(  var1, XX)'
@20,18 SAY '(Press S or C to change current operation.)'
@21,19 SAY '(PGUP/PGDN to toggle varX.   ESC quits.)'
RETURN

PROCEDURE INITSCRN
    CLEAR SCREEN
    TEXT
                        BOOLEAN chARACTER FUNCTIONS

     INTRODUCTION:  I had a need to be able to tie a record in a primary
     database with one or more records in a secondary database, for the
     purposes of a user defined lookup table.  In operation the system
     would work like this:  the user would bring a record of interest up
     onto the screen.  He/she would then have the option of tagging that
     record with one or more 'characteristics'; the characteristics were
     in reality records from another (lookup table) .dbf.

     What I do is create a character field of length XX in the primary 
     .dbf, which for each record contains a character value that corresponds 
     to the record No.s in the lookup file, which the user wants assigned to 
     the record in question.  Each character (byte) in the field can point 
     to up to 8 records in the secondary .dbf.  For the demo I use 3 byte 
     variables (24 positions, however you can use anything you want, up 
     to 255 bytes (2040 positions).

     From there it became obvious that to be really useful, a means of
     allowing the user to perform sorts and filters would be necessary.
     That is what these functions provide.  Try the following demo to see 
     if there might not be a place in one of your applications for them.

    ENDTEXT
    WAIT
    TEXT
                         BOOLEAN chARACTER FUNCTIONS

     FUNCTION                  DESCRIPTION

     ChSet (mvar, position)  - Sets bit number <position> in mvar
     ChClear(mvar, position) - Clears bit number <position> in mvar
     ChNext(mvar, position)  - Returns the position of the next set bit
                               after <position>.  Use ChNext(mvar, 0) to
                               find the first set bit within mvar. ChNext()
                               returns 0 if no further bits are set.
     ChAny(mvar, pattern)    - Returns .T. if ANY set bits in mvar match ANY
                               set bits in <pattern> (also an mvar).
     ChAll(mvar, pattern)    - Returns .T. if ALL bits in <pattern> have a
                               corresponding set bit in mvar.  Note that mvar
                               may contain more set bits than specified in
                               <pattern>, but must contain at least the ones
                               set in <pattern>.
     ChExact(mvar, pattern)  - Similar to ChAll(), however tests for an
                               exact match (mvar and pattern must be 
                               identical).
     ChNone(mvar, pattern)   - Opposite of ChAny().  Returns .T. if NO set
                               bits within mvar match any of those set in
                               <pattern>.

    ENDTEXT
    WAIT
    TEXT

                         BOOLEAN chARACTER FUNCTIONS
                 (Copyright (c) 1988  by K. Stephan Larsen)
               (All Rights Reserved.  No Publication Intended)


     Compile and link the program CH.prg with the assembly object file.
     Be sure to include EXTEND.LIB in your link.

     To re-run the demo program without having to read all this stuff 
     again, simply invoke the program (CH.EXE) with a command line 
     parameter (doesn't matter what you use, just use something).

     Released to the public domain under the auspices of "NoWare", which
     means that I want nothing, nada in return.  Likewise I make no guar-
     antees as to the suitability of these functions.  I do listen to
     suggestions however, and sometimes even act upon them.

     K. Stephan Larsen, TechSupport, Inc.      
                        5852 W. Chestnut Ave.
                        Littleton, CO  80123

     Compuserve 76370,1532       (303) 972-2261      (01/29/90)

    ENDTEXT
    WAIT
RETURN


