
  * Sample Code from _The FoxPro Codebook_ Diskette
  *
  * Function cdxstrip()
  * Parameters:
  * lcFile     - CDX file to strip
  * lcThermStr - String to remove from CDX.  *OPTIONAL*
  *     Defaults to THERM()
  *
  * Brute force approach.  Check 1024 bytes ahead for the string.
  *  If found, replace it with CHR(0)'s.
  *
  FUNCTION CDXSTRIP
  PARA lcFile, lcThermStr
  private tset
  if SET('TALK')='ON'
    set talk off
    tset="ON"
  else
    tset='OFF'
  endif
       
  IF PARA() = 1
    lcThermStr = '+PROGUP("C")'
  ELSE
    IF LEFT(lcThermStr,1) # "+"  && Make sure the "+" was included
      lcThermStr = "+"+lcThermStr
    ENDIF
  ENDIF

  lnHandle = FOPEN(lcFile,2)            && Open the file read/write
  IF lnHandle = -1
    ?? CHR(7)
    WAIT WINDOW "ERROR!  File could not be opened.  Press Any Key..."
    set talk &tset
    RETURN
  ENDIF

  lnEOF = FSEEK(lnHandle, 0, 2)       && Move pointer to EOF
  lnBOF = FSEEK(lnHandle, 0)          && Move pointer to BOF
  lnFileSize = lnEOF - lnBOF

  lnIterate = INT(lnFileSize/512)+1

  FOR i = 1 TO lnIterate
    lcString = FREAD(lnHandle,1024)
    lnPos = -1
    lnCounter = 0
  DO WHILE lnPos # 0
    lnCounter = lnCounter+1
    lnPos = ATC(lcThermStr,lcString,lnCounter)
    IF lnPos # 0
      =FSEEK(lnHandle,512*(i-1)+(lnPos-1),0)         && Position on +THERM()
      =FWRITE(lnHandle,REPLICATE(CHR(0),LEN(lcThermStr)))  && Repl w/ CHR(0)
    ENDIF
  ENDDO
  =FSEEK(lnHandle,i*512,0)
 ENDFOR
 =FCLOSE(lnHandle)
 set talk &tset
  RETURN .T.




