*------------------------------------------------------------------------------
*-- Name....: D:\DBASE11\FINAL\u_VENDOR.PRG
*-- Date....: 9-05-90
*-- Version.: dBASE IV, Procedures for Format (.fmt) v1.1
*-- Notes...: Procedure file for VALID POPUPs and/or Context Sensitive Help
*-- ........: for VENDORS.FMT
*------------------------------------------------------------------------------
PROCEDURE S_vendors                    && Open Lookup files for faster processing
  USE Cities ORDER City IN SELECT()  
  USE States ORDER State IN SELECT()  
RETURN
*-- EOP: S_vendors

PROCEDURE C_vendors                    && Close Lookup files
  USE IN ALIAS("Cities")
  USE IN ALIAS("States")
RETURN
*-- EOP: C_vendors

FUNCTION Empty                       && Determine if the passed argument is NULL
  PARAMETER x
  PRIVATE retval, lc_type
  lc_type = TYPE("x")
  DO CASE
    CASE lc_type = "C"
      retval = (LEN(TRIM(x))=0)
    CASE lc_type$"NF"
      retval = (x=0)
    CASE lc_type = "D"
      retval = (" "$DTOC(x))
    OTHERWISE lc_type = "U"
      retval = .T.
  ENDCASE
RETURN (retval)
*-- EOP: _Empty

*------------------------------------------------------------------------------
PROCEDURE _DbfEmpty
   *-- Error box if Lookup .dbf is empty
   *-- Save the screen and setup window
   PRIVATE ALL LIKE l?_*
   DEFINE WINDOW u_error FROM 5,15 TO 11,55
   SAVE SCREEN TO u_error
   DO _Shadowg WITH 5,15,11,55

   *-- Activate the window and put up error message
   ACTIVATE WINDOW u_error
   lc_fpath = SET("fullpath")
   SET FULLPATH OFF
   @ 1,2 SAY "Lookup table: " + SUBSTR( DBF(),3) + " is empty!"
   @ 2,2 SAY "Press any key ..."
   ln_errorky = INKEY(10)

   *-- Restore the screen and clean up
   SET FULLPATH &lc_fpath.
   RELEASE WINDOW u_error
   RESTORE SCREEN FROM u_error
   RELEASE SCREEN u_error
RETURN
*-- EOP: _DbfEmpty

*------------------------------------------------------------------------------
FUNCTION L_city
  PARAMETER fld_name
  PRIVATE ALL LIKE l?_*
  PRIVATE fld_name, rtn_fld

  ll_return = .T.                      && Declare return variable for function
  ln_row = ROW()                       && Current Row of Get
  ln_col = COL()                       && Current Column of Get
  rtn_fld = fld_name                   && Current Value of Get


  ON KEY LABEL F1
  ON KEY LABEL F9

  lc_alias = ALIAS()                   && Grab current workarea

  IF ln_row = 9 .AND. (ln_col >= 30 .AND. ln_col <= 56 )
     ll_edit = .T.
  ELSE
     ll_edit = .F.
  ENDIF

  SELECT ("Cities")

  lc_exact = SET("EXACT")              && Store value of EXACT
  SET EXACT ON
  lc_near =  SET("NEAR")               && Store value of NEAR
  SET NEAR ON                          && Do "soft" seek into "BROWSE"

  fld_name = IIF( EMPTY( TRIM( fld_name)), fld_name, TRIM( fld_name))
  SEEK fld_name

  SET EXACT &lc_exact.                 && Restore SET EXACT to org. value
  SET NEAR  &lc_near.                  && Restore SET NEAR  to org. value

  IF .NOT. FOUND()

     IF RECCOUNT() = 0
        DO _DbfEmpty
        ll_return = .F.
     ENDIF

     IF ll_return

        DEFINE WINDOW l_city FROM 12, 30 to 18, 65
        SAVE SCREEN TO l_city


        lc_message = [Select:]+CHR(17)+CHR(196)+CHR(217)+[   Cancel:Esc] +;
                     [   Pan Left:F3   Pan Right:F4   Move Window:F7]

        lc_message = IIF("500" $ VERSION(1), ;
                      LEFT( lc_message, LEN( lc_message) - 17) , lc_message)
        SET MESSAGE TO lc_message

        ON KEY LABEL Ctrl-M KEYBOARD( CHR( kn_CtrlEnd)) CLEAR   && Same as Enter send Ctrl-W

        IF .NOT. "500" $ VERSION(1)
           ON KEY LABEL F7 DO _MoveWind WITH WINDOW(), lc_message
        ENDIF

        BROWSE WINDOW l_city NOMENU COMPRESS NOFOLLOW NODELETE LOCK 1 ;
           FIELDS city /R,state,zip_code 

        ON KEY LABEL F7
        ON KEY LABEL Ctrl-M
        SET MESSAGE TO

        RELEASE WINDOW l_city

        RESTORE SCREEN FROM l_city

     ENDIF

     IF LASTKEY() <> kn_esc
       rtn_fld = City

       IF EMPTY(rtn_fld)             && Is a required field, so return .F.
          ll_return = .F.
       ELSE

          IF ll_edit
             @ 9,30 GET rtn_fld PICTURE "@! XXXXXXXXXXXXXXXXXXXX" 
          ENDIF

          REPLACE Vendors->City WITH rtn_fld

          ll_return = .T.
       ENDIF
     ELSE
       ll_return = .F.
     ENDIF

  ELSE
    ll_return = .T.
  ENDIF

  IF ll_return
     DO U_city WITH ll_edit, rtn_fld
  ENDIF

  SELECT (lc_alias)                    && Go back to the edit file

  ON KEY LABEL F1 DO H_vendor WITH VARREAD() && Call Help code
  ON KEY LABEL F9 DO Z_vendor WITH VARREAD() && Call Zoom code
RETURN (ll_return)
*-- EOP: L_city

*------------------------------------------------------------------------------
FUNCTION L_state
  PARAMETER fld_name
  PRIVATE ALL LIKE l?_*
  PRIVATE fld_name, rtn_fld

  ll_return = .T.                      && Declare return variable for function
  ln_row = ROW()                       && Current Row of Get
  ln_col = COL()                       && Current Column of Get
  rtn_fld = fld_name                   && Current Value of Get


  ON KEY LABEL F1
  ON KEY LABEL F9

  lc_alias = ALIAS()                   && Grab current workarea

  IF ln_row = 10 .AND. (ln_col >= 30 .AND. ln_col <= 38 )
     ll_edit = .T.
  ELSE
     ll_edit = .F.
  ENDIF

  SELECT ("States")

  lc_exact = SET("EXACT")              && Store value of EXACT
  SET EXACT ON
  fld_name = IIF( EMPTY( TRIM( fld_name)), fld_name, TRIM( fld_name))
  SEEK fld_name

  SET EXACT &lc_exact.                 && Restore SET EXACT to org. value

  IF .NOT. FOUND()

     DEFINE POPUP l_state FROM 11,30 ;
      TO 20,33 ;
      PROMPT FIELD State ;
      MESSAGE [Select:]+CHR(17)+CHR(196)+CHR(217)+[   Cancel:Esc]

     ON SELECTION POPUP l_state DEACTIVATE POPUP

     KEYBOARD TRIM( fld_name ) CLEAR

     SAVE SCREEN TO l_state

     DO _Shadowg WITH 11,30,20,33

     ACTIVATE POPUP l_state

     rtn_fld = PROMPT()               && Get user choice from Picklist

     RELEASE POPUP l_state

     RESTORE SCREEN FROM l_state


     IF LASTKEY() <> kn_esc

       IF EMPTY(rtn_fld)             && Is a required field, so return .F.
          ll_return = .F.
       ELSE

          IF ll_edit
             @ 10,30 GET rtn_fld PICTURE "!!" 
          ENDIF

          REPLACE Vendors->State WITH rtn_fld

          ll_return = .T.
       ENDIF
     ELSE
       ll_return = .F.
     ENDIF

  ELSE
    ll_return = .T.
  ENDIF

  SELECT (lc_alias)                    && Go back to the edit file

  ON KEY LABEL F1 DO H_vendor WITH VARREAD() && Call Help code
  ON KEY LABEL F9 DO Z_vendor WITH VARREAD() && Call Zoom code
RETURN (ll_return)
*-- EOP: L_state


*------------------------------------------------------------------------------
PROCEDURE U_city
   PARAMETER is_edit, key_field
   *-- Update Look'ed up fields for City

   REPLACE Vendors->State WITH State, ;
          Vendors->Zip WITH Zip_code

   IF is_edit
      @ 10,30 GET Vendors->State PICTURE "!!" 
      @ 11,30 GET Vendors->Zip PICTURE "99999-9999" 
   ENDIF
RETURN
*-- EOP: U_city


*------------------------------------------------------------------------------
PROCEDURE Z_vendor
*-- Branch to another EDIT form based on lc_var
PARAMETER lc_var
PRIVATE ALL LIKE l?_*

ON KEY LABEL F9
SAVE SCREEN TO Z_vendor
lc_area = ALIAS()
ll_edit = .F.
SELECT SELECT()
DO CASE
   CASE lc_var = "CITY"
         SELECT ("Cities")
         SEEK &lc_area.->&lc_var.

         IF FILE("Cities.FMT")
             SET FORMAT TO Cities
         ENDIF
         ll_edit = .T.
   CASE lc_var = "STATE"
         SELECT ("States")
         SEEK &lc_area.->&lc_var.

         IF FILE("States.FMT")
             SET FORMAT TO States
         ENDIF
         ll_edit = .T.
   OTHERWISE
       KEYBOARD CHR( kn_CtrlHme ) CLEAR          && Gets user into memo field
ENDCASE

IF ll_edit
   EDIT NEXT 1                                   && Edit the Zoomed record
ENDIF

SELECT (lc_area)                                 && Back to edit work area
RESTORE SCREEN FROM Z_vendor
RELEASE SCREEN Z_vendor
ON KEY LABEL F1 DO H_vendor WITH VARREAD()
ON KEY LABEL F6 DO _Cut
ON KEY LABEL F8 DO _Paste
ON KEY LABEL Ctrl-F5 DO _Edpaste
ON KEY LABEL F9 DO Z_vendor WITH VARREAD()
RETURN
*-- EOP: Z_vendor
*------------------------------------------------------------------------------

PROCEDURE H_vendor
  *-- Activates the HELP window
  PARAMETER lc_var
  PRIVATE ALL LIKE l?_*
  IF .NOT. FILE("VENDOR_H.dbf")
     *-- Help file has been deleted or can't be found
     RETURN
  ENDIF

  SET CURSOR OFF
  ON KEY LABEL F1

  *-- Select workarea and open Help dbf
  lc_area = ALIAS()
  SELECT SELECT()
  USE VENDOR_H ORDER fld_name NOUPDATE   && Open HELP .dbf

  lc_exact = SET("EXACT")                && Store value of EXACT
  SET EXACT ON
  SEEK lc_var
  SET EXACT &lc_exact.

  IF FOUND()                             && If found show Help
    ln_t = 5
    ln_l = 6
    ln_b = 15
    ln_r = 74
    DEFINE WINDOW h_vendor FROM ln_t+1, ln_l+2 TO ln_b-1, ln_r-2 NONE
    ON ERROR lc_error = error()
    SAVE SCREEN TO h_vendor

    *-- Make Help Box
    DO _Shadowg WITH ln_t, ln_l, ln_b, ln_r
    @ ln_t+1, ln_l+1 CLEAR TO ln_b-1, ln_r-1
    @ ln_t, ln_l TO ln_b, ln_r DOUBLE

    ln_memline = SET("MEMO")
    SET MEMOWIDTH TO 65
    IF MEMLINES(fld_help) > 9
      @ ln_t+1,ln_r SAY CHR(24)
      @ ln_b-1,ln_r SAY CHR(25)
      SET CURSOR ON
    ENDIF
    lc_string = CHR(185)+ [ Help for ] + TRIM(fld_headng) +[ ] + CHR(204)
    lc_message = IIF( MEMLINES(fld_help) > 9 , ;
                      "Scroll thru Help:Ctrl-Home   Exit Viewing Help:Esc   " , ;
                      "" ;
                    )

    @ ln_t,CENTER(lc_string,80) SAY lc_string
    @ 0,0 GET fld_help OPEN WINDOW h_vendor MESSAGE lc_message
    READ
    SET MEMOWIDTH TO ln_memline
    ON ERROR
    RELEASE WINDOW h_vendor
    RESTORE SCREEN FROM h_vendor
    RELEASE SCREEN h_vendor
  ENDIF
  SET MESSAGE TO
  SET CURSOR ON
  USE                                              && Close help file
  SELECT (lc_area)                                 && Back to edit work area
  ON KEY LABEL F1 DO H_vendor WITH VARREAD()
RETURN
*-- EOP: H_vendor

*------------------------------------------------------------------------------
PROCEDURE _Shadowg                      && displays shadow that grows
  PARAMETER x1,y1,x2,y2
  PRIVATE   x1,y1,x2,y2

  x0 = x2+1
  y0 = y2+2
  dx = 1
  dy = (y2-y1) / (x2-x1)
  DO WHILE x0 <> x1 .OR. y0 <> y1+2
    @ x0,y0 FILL TO x2+1,y2+2 COLOR n+/n
    x0 = IIF(x0<>x1,x0 - dx,x0)
    y0 = IIF(y0<>y1+2,y0 - dy,y0)
    y0 = IIF(y0<y1+2,y1+2,y0)
  ENDDO
RETURN
*-- EOP: _Shadowg

*------------------------------------------------------------------------------
PROCEDURE _dbtrap                             && error routine for SET("dbtrap")
  SET CURSOR OFF
  PRIVATE ALL LIKE l?_*
  SAVE SCREEN TO _dbtrap
  DO _Shadowg WITH 10, 18, 15, 62
  DEFINE WINDOW _dbtrap FROM 10,18 TO 15,62 DOUBLE
  ACTIVATE WINDOW _dbtrap
  lc_error = "ERROR - SET DBTRAP OFF to use this FORM."
  lc_error2 = "Press any key ..."
  @ 1, CENTER( lc_error,  44) SAY lc_error
  @ 2, CENTER( lc_error2, 44) SAY lc_error2
  lc_wait = INKEY(10)
  RELEASE WINDOW _dbtrap
  RESTORE SCREEN FROM _dbtrap
  RELEASE SCREEN _dbtrap
  SET CURSOR ON
RETURN
*-- EOP: _dbtrap

*------------------------------------------------------------------------------
PROCEDURE _Cut
  *-- Cut data from a field
  PRIVATE ALL LIKE l?_*

  lc_field = VARREAD()
  lc_type = TYPE( lc_field)
  SAVE SCREEN TO _cut

  DO CASE
  CASE lc_type = "C"
      gc_cut = TRIM( &lc_field.)
  CASE lc_type $ "NF"
      ln_cnt = 0
      ln_number = &lc_field.
      DO WHILE _numdec( ln_number)
         ln_number = ln_number * 10
         ln_cnt = ln_cnt + 1
      ENDDO
      gc_cut = LTRIM( STR( &lc_field., 14, ln_cnt))
  CASE lc_type = "D"
      gc_cut = DTOC( &lc_field.)
  CASE lc_type = "L"
      gc_cut = IIF( &lc_field., "Y", "F")
  CASE lc_type = "M"
      gc_cut = SUBSTR( &lc_field., 1, 254)
      ln_len = LEN( TRIM( gc_cut))
      ln_cnt = 1

      DO WHILE ln_cnt <= ln_len
         *-- Get rid of MODI COMM's soft carriage returns characters
         IF ASC( SUBSTR( gc_cut, ln_cnt, 1)) = 141 .OR.;
            ASC( SUBSTR( gc_cut, ln_cnt, 1)) =  10 .OR.;
            ASC( SUBSTR( gc_cut, ln_cnt, 1)) =  13

            IF ASC( SUBSTR( gc_cut, ln_cnt, 1)) =  13
               gc_cut = STUFF( gc_cut, ln_cnt, 1, " ")
            ELSE
               gc_cut = STUFF( gc_cut, ln_cnt, 1, "")
            ENDIF

            ln_len = LEN( TRIM( gc_cut))             && Length of string can change
            LOOP
         ENDIF
         ln_cnt = ln_cnt + 1
        ENDDO
  ENDCASE

  lc_message = SUBSTR( gc_cut, 1, 37) + " - cut to scrap.   Edit:Ctrl-F5   Paste:F8"
  SET MESSAGE TO lc_message
  ln_key = INKEY(2.5)
  gc_cut = gc_cut + SPACE( 254 - LEN( gc_cut))
  SET MESSAGE TO
  RESTORE SCREEN FROM _cut
  RELEASE SCREEN _cut
RETURN

*------------------------------------------------------------------------------
PROCEDURE _Paste
  *-- Cut data to a field
  PRIVATE ALL LIKE l?_*

  lc_field = VARREAD()                               && Grab field we left from
  lc_type = TYPE( lc_field)                          && Grab the data type
  lc_cut = TRIM( gc_cut)                             && Trim blanks from cut data

  IF lc_type = "D"
      *-- Remove "/" from character data so that KEYBOARD will work on a
      *-- date field
      lc_cut = STUFF(lc_cut, AT("/", lc_cut), 1, "") && Get rid of first  "/"
      lc_cut = STUFF(lc_cut, AT("/", lc_cut), 1, "") && Get rid of second "/"
  ENDIF
  *-- Keyboard cut data into the field
  DO CASE
     CASE lc_type $ "NFD"
        *-- Start at the beginning of the field and clear it.
        KEYBOARD ( CHR(kn_home) + CHR(kn_CtrlY) + lc_cut) CLEAR
     CASE lc_type <> "M"
        *-- Paste at the location of the cursor
        KEYBOARD (lc_cut) CLEAR
     OTHERWISE
        IF LEN( &lc_field.) > 0
           *-- Pad space to offset "scrap" from end of memo
           lc_cut = " " + lc_cut
        ENDIF
        REPLACE &lc_field. WITH lc_cut ADDITIVE         && Replace into memo field
        ln_keyboard = CHR(kn_ctrlhme) + CHR(kn_ctrlpdn) + ;
                      CHR(kn_space) + CHR(kn_bakspce)   && Makes EDIT think data has changed
        KEYBOARD (ln_keyboard) CLEAR                    && Move to bottom of memo
  ENDCASE
RETURN

*------------------------------------------------------------------------------
PROCEDURE _Edpaste
  *-- Edit Cut data
  PRIVATE ALL LIKE l?_*

  lc_deli = SET("DELIMITERS")
  lc_form = SET("FORMAT")
  SET DELIMITERS OFF
  SET FORMAT TO
  SAVE SCREEN TO _edpaste
  DEFINE WINDOW _edpaste FROM 19,0 TO 21,79

  lc_message = "Editing paste string.   Move Window:F7"
  lc_message = IIF("500" $ VERSION(1), ;
                   LEFT( lc_message, LEN( lc_message) - 17) , lc_message)
  IF .NOT. "500" $ VERSION(1)
     ON KEY LABEL F7 DO _MoveWind WITH WINDOW(), lc_message
  ENDIF
  ACTIVATE WINDOW _edpaste
  SET MESSAGE TO lc_message
  @ 0,0 GET gc_cut PICTURE "@S78"
  READ
  ON KEY LABEL F7
  SET MESSAGE TO
  RELEASE WINDOW _edpaste
  RESTORE SCREEN FROM _edpaste
  RELEASE SCREEN _edpaste
  SET DELIMITERS &lc_deli.
  SET FORM TO (lc_form)
RETURN

*------------------------------------------------------------------------------
PROCEDURE _MoveWind
PARAMETER wind_name, message
  *----------------------------------------------------------
  *- Move the &wind_name. window based on arrow keys.  Any 
  *- other key stops the move process.
  *----------------------------------------------------------
  ON KEY LABEL F7
  ON ERROR ?? CHR(7)
  SET MESSAGE TO
  DO WHILE .T.
    SET MESSAGE TO [Position: ]+CHR(27)+CHR(26)+CHR(25)+CHR(24)+[   Exit: Esc]
    ln_keyhit = INKEY(0)
    IF ln_keyhit <> 0
      DO CASE
        CASE ln_keyhit = kn_RghtArw               && Right arrow
           MOVE WINDOW &wind_name. BY 0,1
        CASE ln_keyhit = kn_UpArw                 && Up arrow
           MOVE WINDOW &wind_name. BY -1,0
        CASE ln_keyhit = kn_LeftArw               && Left arrow
           MOVE WINDOW &wind_name. BY 0,-1
        CASE ln_keyhit = kn_DownArw               && Down Arrow
           MOVE WINDOW &wind_name. BY 1,0
        OTHERWISE
           EXIT
      ENDCASE
    ENDIF
  ENDDO
  ON ERROR
  ON KEY LABEL F7 DO _MoveWind WITH WINDOW(), "&message."
  SET MESSAGE TO message
RETURN
*-- EOP: _MoveWind

*------------------------------------------------------------------------------
FUNCTION _numdec
PARAMETER ln_dec
IF ln_dec - INT(ln_dec) > 0
   RETURN .T.
ELSE
   RETURN .F.
ENDIF
*-- EOF: _numdec

*------------------------------------------------------------------------------
FUNCTION Center
*-- UDF to center a string.
*-- lc_string = String to center
*-- ln_width = Width of screen to center in
*--
*-- Ex. @ 15,center(string,80) say string
*-- Will center the <string> withing 80 columns
PARAMETER lc_string, ln_width
RETURN ((ln_width/2)-(LEN(lc_string)/2))
*-- EOP: Center()

*------------------------------------------------------------------------------
PROCEDURE _key_vars
*----------------------------------------------------------------------------
* Enumerate the key values for LASTKEY() and INKEY() functions
*
* To check for the Escape key after the INKEY()
* 
*   ln_key = INKEY(0)   && Wait for any key press
*   IF ln_key = kn_Esc  && Escape was pressed
*     DO esc_hand
*   ENDIF
*
*----------------------------------------------------------------------------
IF TYPE("kn_end") = "U"
  PUBLIC kn_End     , kn_Tab     , kn_Enter   , kn_CtrlEnd , kn_CtrlY   , ;
         kn_Home    , kn_Esc     , kn_CtrlHme , kn_CtrlPDn , kn_CtrlPUp , ;
         kn_Space   , kn_BakSpce , kn_RghtArw , kn_UpArw   , kn_LeftArw , ;
         kn_DownArw , kn_PgDn    , kn_PgUp    , kn_F1      , kn_Del     , ;
         kn_CtrLArw , kn_CtrRArw , kn_f7      , kn_ShftF7

    kn_End     =   2      && Ctrl-B
    kn_Tab     =   9      && Ctrl-I
    kn_Enter   =  13      && Ctrl-M
    kn_CtrlEnd =  23      && Ctrl-W
    kn_CtrlY   =  25
    kn_Home    =  26      && Ctrl-Z
    kn_Esc     =  27      && Ctrl-[
    kn_CtrlHme =  29      && Ctrl-]
    kn_CtrlPDn =  30      && Ctrl-PgDn
    kn_CtrlPUp =  31      && Ctrl-PgUp
    kn_Space   =  32
    kn_BakSpce = 127
    kn_RghtArw =   4      && Ctrl-D
    kn_UpArw   =   5      && Ctrl-E
    kn_LeftArw =  19      && Ctrl-S
    kn_DownArw =  24      && Ctrl-X
    kn_PgDn    =   3      && Ctrl-C
    kn_PgUp    =  18      && Ctrl-R
    kn_F1      =  28      && Ctrl-  kn_Del     =   7      && Ctrl-G
    kn_CtrLArw =   1      && Ctrl-A
    kn_CtrRArw =   6      && Ctrl-F
    kn_F7      =  -6
    kn_ShftF7   = -26

  *----------------------------------------------------------------------------
  * Enumerate the key values for READKEY()
  *
  * To check to see if data has changed
  *
  *   IF READKEY() >= rn_updated   && Data has changed
  *     REPLACE name WITH m->name
  *   ENDIF
  *
  * To check for page down regardless of data change
  *
  *   ln_readkey = READKEY()
  *   IF ln_readkey = rn_PgDn .OR. ln_readkey = rn_PgDn+rn_Updated
  *     DO pgdn_hand
  *   ENDIF
  *
  *----------------------------------------------------------------------------
  PUBLIC rn_Updated , rn_LeftArw , rn_BakSpce , rn_RghtArw , rn_CtrLArw , ;
         rn_CtrRArw , rn_UpArw   , rn_DownArw , rn_PgUp    , rn_PgDn    , ;
         rn_Esc     , rn_CtrlEnd , rn_Enter   , rn_EnterA  , rn_CtrlHme , ;
         rn_CtrlPUp , rn_CtrlPDn , rn_F1

    rn_Updated = 256      && Add to rn_key value for updated condition
    rn_LeftArw =   0      && Includes Ctrl-S and Ctrl-H - backward one character
    rn_BakSpce =   0      && backward one character                                   
    rn_RghtArw =   1      && Includes Ctrl-D and Ctrl-L - forward one character
    rn_CtrLArw =   2      && Ctrl-Left Arrow, includes Ctrl-A - previous word
    rn_CtrRArw =   3      && Ctrl-Right Arrow, includes Ctrl-F - next word
    rn_UpArw   =   4      && Includes Ctrl-E and Ctrl-K - backward one field
    rn_DownArw =   5      && Includes Ctrl-J and Ctrl-X - forward one field
    rn_PgUp    =   6      && Includes Ctrl-R - backward one screen
    rn_PgDn    =   7      && Includes Ctrl-C - forward one screen
    rn_Esc     =  12      && Includes Ctrl-Q - Terminate w/o save
    rn_CtrlEnd =  14 + rn_updated  && Includes Ctrl-W - Terminate w/save
    rn_Enter   =  15      && Includes Ctrl-M  RETURN of fill last record
    rn_EnterA  =  16      && Enter at the beginning of a record in APPEND
    rn_CtrlHme =  33      && Ctrl-Home - Menu display toggle
    rn_CtrlPUp =  34      && Ctrl-PgUp - Zoom Out
    rn_CtrlPDn =  35      && Ctrl-PgDn - Zoom In
    rn_F1      =  36      && Help function key
ENDIF

RETURN
*-- EOP: _key_vars

