/* peek.c */
/* Andrew Schulman 5-31-87 */
/* link with c0t.obj and then exe2bin to produce peek.bin for dBase III+ */
/* example: 
        x = "Hello world"
        call memdump with x
            [[[ get x's address in memory ]]]
            [[[ e.g., 68e1:000d, not counting length byte ]]]
        tmp = "68e1 d"
        call peek with tmp
        ? tmp
        H                   && bash argv[0] with peek(argv[1],argv[2])
*/              
/* except it's not working properly in FoxBase+ yet */

unsigned int htoi(char *);

/* borrowed from Turbo C dos.h */
#define MK_FP(a,b)      ((void *far)(((unsigned long)(a) << 16) | (b)))
#define peekb(a,b)   (unsigned char)(*((unsigned char *far) MK_FP((a),(b))))

main(argc, argv)
    int argc;
    char *argv[];
    {
    int count = (argc > 3) ? atoi(argv[3]) : 1;
    register int i;
	unsigned int seg = htoi(argv[1]), ofs = htoi(argv[2]);
	
    for (i = 0; i < count; i++)
        argv[0][i] = peekb(seg, ofs + i);
    argv[0][count] = '\0';
    return 1;
    }
    
/* convert hex string to integer -- partially lifted from Dr. Dobb's
 * Toolbook of C, p.307
 */
unsigned int htoi(s)
    register char *s;
    {
    unsigned int i = 0, t;

    while (*s == ' ' || *s == '\t')
        s++;
    while (1)
        {
        if      (*s >= '0' && *s <= '9') t = 48;
        else if (*s >= 'A' && *s <= 'F') t = 55;
        else if (*s >= 'a' && *s <= 'f') t = 87;
        else break;
        i = (i << 4) + (*s - t);        /* i = i * 16 + (*s - t) */
        s++;
        }
    return i;
    }
