/*
bit.c -- bit operations for dBase
AS 7/7/87, revised 7/18/87
link with ltoa.obj
note that lmod() does heavy-duty recursion and requires big stack if
    arg1 is large and arg2 is small (e.g., call bit with "16929 base 2")
*/

char *ultoa(char *, unsigned long, int);
unsigned long atol(char *);
unsigned long htol(char *);
    
main(argc, argv)
    int argc;
    char *argv[];
{
    char buf[40], op = argv[2][0], opx = argv[2][1];
    unsigned long retval;
    unsigned long arg1 = (argv[1][0]=='x'||argv[1][0]=='X') ?
        htol(&argv[1][1]) :
        atol(argv[1]);
    unsigned long arg3 = (argv[3][0]=='x'||argv[3][0]=='X') ?
        htol(&argv[3][1]) :
        atol(argv[3]);
    int baseconv = (op=='b'||op=='B');

    retval =    (op=='>'&&opx=='>') ? (arg1 >> arg3) :
                (op=='<'&&opx=='<') ? (arg1 << arg3) :
                (op == '&')         ? (arg1 & arg3) :
                (op == '|')         ? (arg1 | arg3) :
                (op == '^')         ? (arg1 ^ arg3) :
                (op == '%')         ? (arg1 % arg3) :
                (op == '~')         ? (~ arg3) :
                (op == '+')         ? (arg1 + arg3) :
                (op == '-')         ? (arg1 - arg3) :   /* unsigned! */
                (op == '/')         ? (arg1 / arg3) :   /* unsigned! */
                (op == '*')         ? (arg1 * arg3) :
                (baseconv) ?        arg1 :      /* base conversion */
                /* default */       0;

    strcpy(argv[0], ultoa(buf,retval,((baseconv) ? (int)arg3 : 10)));
    return 1;
}   

/* convert hex string to long -- partially lifted from Dr. Dobb's
 * Toolbook of C, p.307
 */
unsigned long htol(s)
    register char *s;
    {
    unsigned long ul = 0;
    int t;

    while (*s == ' ' || *s == '\t')
        s++;
    while (1)
        {
        if      (*s >= '0' && *s <= '9') t = 48;
        else if (*s >= 'A' && *s <= 'F') t = 55;
        else if (*s >= 'a' && *s <= 'f') t = 87;
        else break;
        ul = (ul << 4) + (*s - t);        /* i = i * 16 + (*s - t) */
        s++;
        }
    return ul;
    }

