/*
inter.c
interrupts for dBase III Plus:  inter.bin
cf. inter.prg: e.g., do inter with 33,8*256,0,0,0
also cf. testint.prg
AS 7/4/87
*/

#ifdef __TURBOC__
    #include <dos.h>
#else
    #include <i8086.h>
    #include <bdos.h>
#endif      

unsigned int atoi(char *s);
char *my_itoa(unsigned int i);

main(int argc, char *argv[])
{
    union REGS regs;

#ifdef CBIN 
    if (argc < 5) return;
#else
    if (argc < 5)
        {
        puts("syntax:  INTER <intno> <ax> <bx> <cx> <dx>");
        exit(1);
        }
#endif
    
    regs.x.ax = atoi(argv[2]);
    regs.x.bx = atoi(argv[3]);
    regs.x.cx = atoi(argv[4]);
    regs.x.dx = atoi(argv[5]);
    /* geninterrupt() doesn't work if intno is a variable! */
    int86(atoi(argv[1]), &regs, &regs);
#ifdef CBIN 
    memcpy(&argv[0][0], my_itoa(regs.x.ax), 6);
    memcpy(&argv[0][6], my_itoa(regs.x.bx), 6);
    memcpy(&argv[0][12], my_itoa(regs.x.cx), 6);
    memcpy(&argv[0][18], my_itoa(regs.x.dx), 6);
    argv[0][23] = '\0';
    return 1;   /* tell CBIN to copy it back into dBase's real copy */
#else
/* STANDALONE EXE PROGRAM */
/* e.g., getchar.bat:  inter 33 2048 0 0 0 */
    {
    static char ax[20] = "set AX=";
    static char bx[20] = "set BX=";
    static char cx[20] = "set CX=";
    static char dx[20] = "set DX=";
    strcat(ax,my_itoa(regs.x.ax));
    strcat(bx,my_itoa(regs.x.bx));
    strcat(cx,my_itoa(regs.x.cx));
    strcat(dx,my_itoa(regs.x.dx));
    /* Turbo C putenv() doesn't set parent environment */
    /* changes only last for duration of program */
    /* same with changes made to *envp[] */
    /* but output from inter can be redirected to tmp.bat, then run tmp */
    puts(ax);
    puts(bx);
    puts(cx);
    puts(dx);
    }
#endif
}

unsigned int atoi(char *s)
{
    unsigned int n = 0;
    
    while (*s == ' ' || *s == '\t')
        ++s;
    while (*s >= '0' && *s <= '9')
        {
        n = n * 10 + *s - '0';
        s++;
        }
    return n;
}

char *my_itoa(unsigned int i)
{
    static char s[7];
    register unsigned int x;
    int y,z;
    
    for (y = 10000, z = 0; z < 5; y /= 10, z++)
        {
        x = (i / y);
        s[z] = x + '0';
        i -= x * y;
        }
    s[5] = ' ';
    s[6] = '\0';
    return &s[0];
}   
