PROCEDURE db_open
PARAMETER m.dbname,m.order,m.use_loc
* db_open(<expC1>[, <expC2>] [, <expL1>])
* 
* Returns logical value indicating database was
* opened successfully
* Return value - Logical
* 
* <expC1> m.dbname
* database name to be opened 

* <expC2> m.order
* database order, no order if blank

* <expL1> m.use_loc
* "use locfile" flag, if .T. use LOCFILE dialog
******************************************************************
* Example:
*IF NOT db_open('alllube','sescsndx') THEN
*   WAIT WINDOW "Unable to open database ALLLUBE.  Press any key..."
*ELSE
*   REPORT FORMAT LUBESNDX.FRX TO PRINTER NOCONSOLE
*ENDIF
******************************************************************
opened = .F.
IF PARAMETERS()=0 THEN
   RETURN opened
ENDIF
m.order=IIF(EMPTY(m.order),0,m.order)
IF USED(m.dbname)
   SELECT (m.dbname)
   SET ORDER TO m.order
   opened = .T.
ELSE
   SELECT 0
   IF m.use_loc THEN
      USE (LOCFILE(m.dbname,"DBF",;
       "Where is "+UPPER(ALLTRIM(m.dbname))+".DBF"));
      ORDER m.order
      opened = .T.
   ELSE
      IF FILE(m.dbname + '.dbf') 
         USE(m.dbname) ORDER m.order
         opened = .T.
      ENDIF
   ENDIF
ENDIF
RETURN opened
