*******************************************************************************
* Function Name :  CALENDAR
* Author        :  Sri Raju.
* Date          :  02/21/92
* Purpose       :  Draws Calendar for a complete year or the current month 
*               :  and year or any given month and any given year.
* Expects       :  1.   No Arguments.
*               :  2.   Any Number indicating a year. ( Example : calendar(1992) )
*               :  3.   Any two numbers, indicating a month and a year.
*               :       ( Example : calendar(03,1992) )
* Returns       :  Nothing.
* Calls         :  DRAWCAL.    
*******************************************************************************

FUNCTION CALENDAR
PARAMETERS someno,someyear

SET TALK OFF
SET ECHO OFF
SET STATUS OFF
inmon = someno
m_count = 0
DO CASE
	
	CASE PCOUNT() > 2
		CLEAR
		@ 2,2 SAY "Error. Usage:  calendar( [[ month], [year] ]) "
		@ 3,2 SAY "Try again..."
	
	CASE PCOUNT() = 2
		IF  ( inmon > 12 ) .or. ( inmon < 1 ) .or. ( someyear > 9999 )
			CLEAR
			@ 2, 2 SAY "Bad arguments. Month must be greater than 1"
			@ 2,45 SAY " or less than 12."
			@ 3, 2 SAY "And the Year must be less than 9999"
			@ 4, 2 SAY "Try again..."
		ELSE
			somedate = CTOD(STR(inmon) + '/' + '01' + '/' + ;
			STR(someyear))
			Do DRAWCAL WITH somedate, inmon, 3, 3
		ENDIF 
		
	CASE PCOUNT()  = 0
		somedate = CTOD(LTRIM(STR(MONTH(DATE()))) + '/' ;
		+ '01' + '/' + LTRIM(STR(YEAR(DATE()))) )
		inmon = MONTH(somedate)
		DO DRAWCAL WITH somedate, inmon, 3, 3
	
	CASE PCOUNT() = 1
		m_count = 1
		somevar = m_count
		CLEAR
		IF LEN(LTRIM(STR(someno))) <= 4
			DO WHILE m_count <= 6
				somedate = CTOD(LTRIM(STR(m_count)) + '/' + ;
				'01'+ '/' + LTRIM(STR(someno)))
				IF m_count <= 3
					DO DRAWCAL WITH somedate, ;
					m_count, 3, 3 + (m_count-1)*25
					m_count = m_count + 1
					somevar = somevar + 1
				ELSE
					DO CASE
						CASE m_count = 4
							somevar = 1
						CASE m_count = 5
							somevar = 2
						CASE m_count = 6
							somevar = 3
					ENDCASE
						DO DRAWCAL WITH somedate, ;
						m_count, 15, 3 + (somevar-1)*25
						m_count = m_count+1
				ENDIF
			ENDDO
			WAIT
			CLEAR
			somevar = 1 
			somevar2 = 1
			
			DO WHILE m_count <= 12
				somedate = CTOD(LTRIM(STR(m_count)) + '/' + ;
				'01'+ '/' + LTRIM(STR(someno)))
				IF somevar2 <= 3
					DO DRAWCAL WITH somedate, m_count, 3, ;
					3 + (somevar2-1)*25
					m_count  = m_count  + 1
					somevar  = somevar  + 1
					somevar2 = somevar2 + 1
				ELSE
					DO CASE
						CASE somevar2 = 4
							somevar = 1
						CASE somevar2 = 5
							somevar = 2
						CASE somevar2 = 6
							somevar = 3
					ENDCASE
						DO DRAWCAL WITH somedate, ;
						m_count, 15, 3 + (somevar-1)*25
						m_count = m_count+1
						somevar2 = somevar2+1
				ENDIF
					
			ENDDO
		ELSE
			CLEAR
			@ 2,2 SAY "Error. Year must be between 0100 and 9999." 
			@ 2,43 SAY "Try again..."
		ENDIF

ENDCASE
WAIT
SET CONSOLE OFF
SET STAT ON
RETURN .T.

*******************************************************************************
* Procedure Name :  DRAWCAL
* Author         :  Sri Raju.
* Date           :  02/21/92
* Purpose        :  This is the heart of the entire program.  This procedure
*                :  is the one, that actually paints the calendar and assigns
*                :  the appropriate dates to the corresponding days, based on
*                :  the value returned by the function POSITION.
* Expects        :  1.  The Actual date.
*                :  2.  The number for the month.
*                :  3.  The row position.
*                :  4.  The column position.
* Returns        :  N O N E.
* Calls          :  POSITION.
*******************************************************************************


PROCEDURE DRAWCAL
PARAMETERS notsomedate, notinmon, inrow, incol

x = 1
row = inrow+2

@ inrow-2, incol+5 SAY CMONTH(somedate) + ' ' + LTRIM(STR(YEAR(notsomedate)))
@ inrow, incol + 1     SAY 'S'
@ inrow, incol + 3 + 1   SAY 'M'
@ inrow, incol + 6 + 1   SAY 'T'
@ inrow, incol + 9 + 1   SAY 'W'
@ inrow, incol + 12  SAY 'Th'
@ inrow, incol + 16  SAY 'F'
@ inrow, incol+18  SAY 'Sa'

DO WHILE (MONTH(notsomedate) = notinmon) 
	col = POSITION(notsomedate,incol)
	IF col >= incol+18
		@ row, col SAY LTRIM(STR(DAY(notsomedate)))
		
		row = row+1
	ELSE
		@ row, col SAY LTRIM(STR(DAY(notsomedate)))
		
	ENDIF
	notsomedate = notsomedate + 1
ENDDO
?
RETURN 
	
*******************************************************************************
* Function Name :  POSITION.
* Author        :  Sri Raju.
* Date          :  02/21/92
* Purpose       :  This function returns the actual position whre a date needs
*               :  to be placed on the screen, based on the date, and the 
*               :  column value that are passed in as the parameters.
* Expects       :  1. The Actual date.
*               :  2. The column position.
* Returns       :  The actual position where a particular date needs to be
*               :  placed on the screen
* Calls         :  None.
*******************************************************************************

FUNCTION POSITION
PARAMETERS indate, somcol

offset = 0
IF LEN(LTRIM(STR(DAY(indate)))) < 2
	offset = 1
ENDIF

DO CASE 

	CASE LEFT(CDOW(indate), 2) = 'Su'
		poscol = somcol + offset

	CASE LEFT(CDOW(indate), 2) = 'Mo'
		poscol = somcol + 3 + offset
	
	CASE LEFT(CDOW(indate),2) = 'Tu'
		poscol = somcol + 6 + offset
		

	CASE LEFT(CDOW(indate), 2) = 'We'
		poscol = somcol + 9 + offset
		

	CASE LEFT(CDOW(indate), 2) = 'Th'
		poscol = somcol + 12 + offset
		

	CASE LEFT(CDOW(indate), 2) = 'Fr'
		poscol = somcol + 15 + offset
		

	CASE LEFT(CDOW(indate), 2) = 'Sa'
		poscol = somcol + 18 + offset
		
	
ENDCASE

RETURN(poscol)






