 *  Use the cursor keys to move one day or one week at a time.
 *  Use PgUp & PgDn to move one month at a time, or with Ctrl
 *  to move one year at a time.  Use Home & End to move to the
 *  first and last day of the month, or with Ctrl to move to
 *  the first and last day of the year.  Use Ctrl-Left and
 *  Ctrl-Right to move to the first and last day of the week.
 *  Use <T>oday or <D>ate to access the current system date.
 *  Ctrl-U <Undo> will return the calendar to the date with
 *  which the calendar was called.

 1) PARAMETERS p_date
 2) ?? SYS(2002)
 3) SAVE SCREEN TO s_clnd
 4) m_lmit=CTOD("01/01/1583")
 5) m_days=" 1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 "+;
           "16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 "
 6) PRIVATE ALL LIKE t_*
 7) STORE SYS(2001,"COLOR") to t_colr,t_nkey
 8) t_crnt=DATE()
 9) t_date=IIF(TYPE("p_date")="D" .AND.;
                DTOC(p_date)>" ",MAX(p_date,m_lmit),t_crnt)
10) t_left=IIF(COL()>39,10,50)
11) SET COLOR TO R/W
12) @ 7,t_left-2,17,t_left+21 BOX CHR(219)+CHR(223)+CHR(219)+;
                                  CHR(219)+CHR(219)+CHR(220)+;
                                  CHR(219)+CHR(219)+" "
13) @ 9,t_left-1 SAY "" && CHR(196)
14) @10,t_left   SAY "Su Mo Tu We Th Fr Sa"
  
15) DO WHILE ! t_nkey$" 13 27"
16)   t_tday=DAY(t_date)
17)   t_last=t_date-t_tday+32-DAY(t_date-t_tday+32)
18)   t_lday=DAY(t_last)
19)   t_ofst=DOW(t_date-t_tday+1)-1
20)   t_days=STUFF(SPACE(111),t_ofst*3+1,t_lday*3,;
                             LEFT(m_days,t_lday*3))
21)   SET COLOR TO N/W
22)   t_titl=CMONTH(t_date)+STR(YEAR(t_date),5)
23)   @ 8,t_left SAY STUFF(SPACE(20),(22-LEN(t_titl))/2,;
                                         LEN(t_titl),t_titl)
24)   @11,t_left SAY LEFT(t_days,21)
25)   @12,t_left SAY SUBSTR(t_days,22,21)
26)   @13,t_left SAY SUBSTR(t_days,43,21)
27)   @14,t_left SAY SUBSTR(t_days,64,21)
28)   @15,t_left SAY SUBSTR(t_days,85,21)
29)   @16,t_left SAY RIGHT(t_days,6)
 
30)   IF MONTH(t_date)=MONTH(t_crnt) .AND.;
                        YEAR(t_date)=YEAR(t_crnt)
31)     SET COLOR TO R/W
32)     @11+(DAY(t_crnt)+t_ofst)/7.1,t_left+DOW(t_crnt)*3-3;
                                        SAY STR(DAY(t_crnt),2)
33)   ENDIF
  
34)   DO WHILE ! t_nkey$" 13 27" .AND.;
            MONTH(t_date)=MONTH(t_last) .AND.;
                     YEAR(t_date)=YEAR(t_last)
35)     t_tday=DAY(t_date)
36)     t_crow=11+(t_tday+t_ofst)/7.1
37)     t_ccol=t_left+DOW(t_date)*3-3
 
38)     IF t_date=t_crnt
39)       SET COLOR TO W+/R
40)     ELSE
41)       SET COLOR TO W+/N
42)     ENDIF
 
43)     @t_crow,t_ccol SAY STR(t_tday,2)
44)     t_nkey=STR(INKEY(0),3)
45)     CLEAR TYPEAHEAD

46)     DO CASE
      * Left Arrow/Backspace & Right Arrow/Space - Change Days
47)     CASE t_nkey$"127 19" .AND. t_date>m_lmit .OR.;
                                               t_nkey$"  4 32"
48)       t_date=t_date+IIF(t_nkey$"127 19",-1,1)
 
      * Up & Down Arrows - Change Weeks
49)     CASE t_nkey="  5" .AND. t_date>m_lmit+6 .OR.;
                                              t_nkey=" 24"
50)       t_date=t_date+IIF(t_nkey="  5",-7,7)
 
      * Page Up - Backward One Month
51)     CASE t_nkey=" 18" .AND. t_date>m_lmit+30
52)       t_date=t_date-MAX(t_tday,DAY(t_date-t_tday))
 
      * Page Down - Forward One Month
53)     CASE t_nkey="  3"
54)       t_temp=t_date+t_lday
55)       t_date=t_temp-IIF(DAY(t_temp)<t_tday,DAY(t_temp),0)
 
      * Home & End - First & Last Day of Month
56)     CASE t_nkey$"  1  6" .AND.;
                       t_tday#IIF(t_nkey="  1",1,DAY(t_last))
57)       t_date=IIF(t_nkey="  1",t_date-t_tday+1,t_last)
 
      * Ctrl-Home & Ctrl-End - First & Last Day of the Year
58)     CASE t_nkey$" 29 23" .AND.;
         DTOC(t_date)#IIF(t_nkey=" 29","01/01","12/31")
59)       t_date=CTOD(IIF(t_nkey=" 29","01/01/","12/31/")+;
                                       STR(YEAR(t_date),4))
 
      * Ctrl-Left Arrow & Ctrl-Right Arrow - First & Last DOW
60)     CASE t_nkey=" 26" .AND. DOW(t_date)>1 .AND.;
                                    t_date>m_lmit+1 .OR.;
             t_nkey="  2" .AND. DOW(t_date)<7
61)       t_date=t_date-DOW(t_date)+IIF(t_nkey=" 26",1,7)
 
      * Ctrl-Page Up & Ctrl-Page Down - Change Years
62)     CASE t_nkey=" 31" .AND. t_date>m_lmit+365 .OR.;
             t_nkey=" 30"
63)       t_temp=LEFT(DTOC(t_date),6)
64)       t_date=CTOD(IIF(t_temp="02/29","02/28/",t_temp)+;
                  STR(YEAR(t_date)+IIF(t_nkey=" 31",-1,1),4))
 
      * <D>ate/<T>oday
65)     CASE t_nkey$"100 68 84,116" .AND. t_date#t_crnt
66)       t_date=t_crnt
 
      * Ctrl-U - Undo
67)     CASE t_nkey=" 21"
68)       t_date=IIF(TYPE("p_date")="D" .AND.;
                      DTOC(p_date)>" ",p_date,t_crnt)
69)     OTHERWISE
70)       CLEAR TYPEAHEAD
71)       LOOP
72)     ENDCASE
 
73)     IF SYS(2001,"COLOR")="W+/R"
74)       SET COLOR TO R/W
75)     ELSE
76)       SET COLOR TO N/W
77)     ENDIF
 
78)     @t_crow,t_ccol SAY STR(t_tday,2)
  
79)   ENDDO
80) ENDDO
 
81) IF t_nkey=" 13" .AND. TYPE("p_date")="D"
      p_date=t_date
      KEYBOARD DTOC(p_date)
    ENDIF
 
82) IF SYS(2001,"COLOR")#t_colr
83)   SET COLOR TO &t_colr
84) ENDIF
 
85) RESTORE SCREEN FROM s_clnd
86) ?? SYS(2002,1)
87) RETURN p_date

