*:*********************************************************************
*:
*:        Program: CALENDAR.PRG
*:
*:  Procs & Fncts: CALNDR
*:
*:*********************************************************************
*!*********************************************************************
*!
*!      Procedure: CALNDR
*!
*!*********************************************************************
PROCEDURE Calndr
PARAMETERS P_date

*Ŀ
*    Use the cursor keys to move one day or one week         
*    at a time.  Use pgup and pgdn to move one month at      
*    a time, or with ctrl to move one year at a time.        
*    Use home & end to move to the first and last day        
*    of the month, or with ctrl to move to the first         
*    and last day of the year.  Use ctrl-lef arrow           
*    and ctrl-right arrow to move to the first and           
*    last day of the week.  Use <T>oday or <D>ate            
*    to access the current system date.  Ctrl-U <undo>       
*    will return the calendar to the date with               
*    which the calendar was called.                          
*

*ͻ
*You must un-comment the correct color scheme for your system 
*Upper case denotes color                                     
*ͼ
?? SYS(2002)
SAVE SCREEN TO S_clnd

M_lmit = CTOD("01/01/1583")
M_days = " 1  2  3  4  5  6  7  8  9 " + ;
         "10 11 12 13 14 15 16 17 18 19 " + ;
         "20 21 22 23 24 25 26 27 28 29 30 31 "

PRIVATE ALL LIKE T_*
STORE SYS(2001,"COLOR") TO t_colr,t_nkey

T_crnt = DATE()
T_date = IIF(TYPE("p_date")="D" .AND. ;
   
DTOC(P_date) > " ",MAX(P_date,M_lmit),T_crnt)

T_left = IIF(COL() > 39,10,50)

* set color to n/w
* SET COLOR TO BG

@ 7,T_left - 2,17,T_left + 21 BOX CHR(219) + CHR(223) +;
             CHR(219) + CHR(219) + CHR(219) + CHR(220)+;
             CHR(219) + CHR(219) + " "
*Ŀ
*use chr(196) for underscore character 
*
@ 9,T_left-1 SAY REPLICATE(CHR(196),22)
@ 10,T_left SAY "Su Mo Tu We Th Fr Sa"

DO WHILE ! T_nkey$" 13 27"
   T_tday = DAY(T_date)
   T_last = T_date-T_tday+32-DAY(T_date-T_tday+32)
   T_lday = DAY(T_last)
   T_ofst = DOW(T_date-T_tday+1)-1
   T_days = STUFF(SPACE(111),T_ofst*3+1,T_lday*3,LEFT(M_days,T_lday*3))
   
   * set color to n/w
   * SET COLOR TO W+
   
   T_titl = CMONTH(T_date)+STR(YEAR(T_date),5)
   
   @ 08,T_left SAY STUFF(SPACE(20),(22-LEN(T_titl))/2,LEN(T_titl),T_titl)
   @ 11,T_left SAY LEFT(T_days,21)
   @ 12,T_left SAY SUBSTR(T_days,22,21)
   @ 13,T_left SAY SUBSTR(T_days,43,21)
   @ 14,T_left SAY SUBSTR(T_days,64,21)
   @ 15,T_left SAY SUBSTR(T_days,85,21)
   @ 16,T_left SAY RIGHT(T_days,6)
   
   * if month(t_date)=month(t_crnt) .and. year(t_date)=year(t_crnt)
   * set color to n/w
   * SET COLOR TO BG
   * @ 11+day(t_crnt)+t_ofst/7.1,t_left+;
   * dow(t_crnt)*3-3 say str(day(t_crnt),2)
   * endif
   
   DO WHILE ! T_nkey$" 13 27" .AND. ;
              MONTH(T_date) = MONTH(T_last) .AND.;
              YEAR(T_date)  = YEAR(T_last)

      T_tday  = DAY(T_date)
      T_crow  = 11+(T_tday+T_ofst)/7.1
      T_ccol  = T_left+DOW(T_date)*3-3
      
      IF T_date = T_crnt
         * set color to w+/n
         * SET COLOR TO GR+/BG
      ELSE
         * set color to w+/w
         * SET COLOR TO GR+/BG
      ENDIF
      
      @ T_crow,T_ccol SAY STR(T_tday,2)
      T_nkey = STR(INKEY(0),3)
      
      CLEAR TYPEAHEAD
      DO CASE
      *Ŀ
      *leftarrow/bkspace/rt. arrow/space-change days  
      *
      CASE T_nkey$"127 19" .AND. T_date > M_lmit .OR. T_nkey$"  4 32"
         
         T_date = T_date + IIF(T_nkey$"127 19",-1,1)
         
         *Ŀ
         *up & down arrows - change weeks  
         *
      CASE T_nkey = "  5" .AND. T_date > M_lmit + 6 .OR. T_nkey = " 24"
         
         T_date = T_date + IIF(T_nkey = "  5",-7,7)
         
         *Ŀ
         *page up - backward one month 
         *
      CASE T_nkey = " 18" .AND. T_date > M_lmit+30
         
         T_date = T_date-MAX(T_tday,DAY(T_date-T_tday))
         
         *Ŀ
         *page daown - forward one month  
         *
      CASE T_nkey = "  3"
         
         T_temp = T_date + T_lday
         T_date = T_temp - IIF(DAY(T_temp) < T_tday,DAY(T_temp),0)
         
         *Ŀ
         *home & end - first & last day of month 
         *
      CASE T_nkey$"  1  6" .AND. T_tday#IIF(T_nkey="  1",1,DAY(T_last))
         
         T_date = IIF(T_nkey="  1",T_date-T_tday+1,T_last)
         
         *Ŀ
         *control home/control end first/last day of the year 
         *
      CASE T_nkey$" 29 23" .AND. DTOC(T_date)#IIF(T_nkey=" 29","01/01","12/31")
         
         T_date = CTOD(IIF(T_nkey=" 29","01/01/","12/31/")+STR(YEAR(T_date),4))
         
         *Ŀ
         *control leftarrow/control right arrow--first last day of the week 
         *
      CASE T_nkey = " 26" .AND. DOW(T_date) > 1 .AND. T_date > M_lmit + 1 ;
            .OR. T_nkey = "  2" .AND. DOW(T_date) < 7
         
         T_date = T_date - DOW(T_date) + IIF(T_nkey = " 26",1,7)
         
         *Ŀ
         *control page up and control page down --change years 
         *
      CASE T_nkey = " 31" .AND. T_date > M_lmit + 365 .OR. T_nkey = " 30"
         
         T_temp = LEFT(DTOC(T_date),6)
         T_date = CTOD(IIF(T_temp = " 02/29","02/28",T_temp) + STR(YEAR(T_date) +;
            IIF(T_nkey=" 31",-1,1),4))
         *Ŀ
         *<D>ate/<T>oday  
         *
      CASE T_nkey$"100 68 84,116" .AND. T_date # T_crnt
         
         T_date = T_crnt
         
         *Ŀ
         *control u - undo    
         *
      CASE T_nkey = " 21"
         
         T_date = IIF(TYPE("p_date") = "D" .AND. DTOC(P_date) > " ",P_date,T_crnt)
         
      OTHERWISE
         
         CLEAR TYPEAHEAD
         LOOP
      ENDCASE
      
      IF SYS(2001,"COLOR") = "W+/R"
         * set color to n/w
         * SET COLOR TO BG
      ELSE
         * set color to n/w
         * SET COLOR TO W+
      ENDIF (SYS(2001,"COLOR") = "W+/R")
      
      @ T_crow,T_ccol SAY STR(T_tday,2)
   ENDDO
ENDDO

IF T_nkey = " 13" .AND. TYPE("p_date") = "D"
   P_date = T_date
   KEYBOARD DTOC(P_date)
ENDIF

IF SYS(2001,"COLOR") # T_colr
   SET COLOR TO &t_colr
ENDIF

RESTORE SCREEN FROM S_clnd
?? SYS(2002,1)
REPLACE Batch->Effdate WITH P_date

RETURN

*: EOF: CALENDAR.PRG
