'// ---------------------------------------------------------------- '//
'// ---  System: Azalea Database Extensions
'// ---  Program: FMT_C39.VB for Microsoft Visual Basic
'// ---  Copyright 1994 Jerry Whiting All Rights Reserved
'// ---  Azalea Software, Inc. 206 932.4030 azalea@igc.org 72627,746
'// ---  All Rights Reserved. Unauthorized Use Prohibited
'// ---------------------------------------------------------------- '//
'// --- Description: This function validats and formats a passed
'//                  in Code 39 String
'// --- Validations Performed:
'// ---     1. Checks parameter passed in to see that it is in the valid
'// ---        set of ASCII characters.
'// --- Formatting performed:
'// ---     1. Concatenates "*" to beginning and end of string.
'// ---     2. Replaces all <spaces> with underscore "_" character
'// ---------------------------------------------------------------- '//
'// --- Parameters: str39Str : Code 39 String to be formatted
'// ---             strAscSet: ASCII set to test for
'// ---                         SHORT = A-Z,0-9, -.*$/+% <space>
'// ---                         SHORT_WITH_CHEKDIGIT = add checkdigit
'// ---                         LONG  = ASCII 0-127
'// --- NOTE. If this is a LONG string then the string is converted
'// ---       withing the validation program.
'// ---------------------------------------------------------------- '//
'// --- Returns: If bad parameter string passed: "-Bad Parameter-"
'// ---          If bad ASCII character: "-Bad ASCII-"
'// ---------------------------------------------------------------- '//
'// --- Sample call: lc_fmtc39 = fmt_c39("VB3 0001","SHORT")
'// ---              ? lc_fmtc39
'// ---       Output: *VB3_0001*
'// ---------------------------------------------------------------- '//
Function fmt_c39 (strC39Str As String, strAscSet As String) As String

Dim true_value As Integer
Dim false_value As Integer

Dim strRetVal As String
Dim intgoodasc As Integer
strRetVal = ""   '// return value initialized to erro


'// Initialize True and False values
true_value = 1
false_value = 0
intgoodasc = true_value


'// Process string depending upon ASCII character set we are using
Select Case strAscSet
   Case "SHORT"
      intgoodasc = l_short(strC39Str)

      '// --- convert spaces to underscores
      strC39Str = spaceconvert(strC39Str)
		
   Case "SHORT_WITH_CHECKDIGIT"
      ll_goodasc = l_short(strC39Str)

      '// calculate check digit
      strC39Str = strC39Str + c39CheckDigit(strC39Str)

      '// --- convert spaces to underscores
      strC39Str = spaceconvert(strC39Str)

   Case "LONG"
      intgoodasc = l_long(strC39Str) '// long sets pass the parameter by
				      '// reference because of special
				      '// formatting
   Case Else
     strRetVal = "-Bad Parameter-"
End Select

'// --- if the check of the string j rned out OK return true
If intgoodasc = true_value Then
   strRetVal = "*" + strC39Str + "*"
Else
   strRetVal = "-Bad ASCII-"
End If
   
fmt_c39 = strRetVal
End Function

'// This function checks as string to make sure that it contains characters
'// in the 128 character set of Code 39
'// NOTE: The variable passed to this function is passed by reference. The variable is
'// manipulated by this function
Function l_long (strAscStr As String)

'// --- initialize variables
Dim intRetVal As Integer   '// return value
Dim strStorage As String   '// storage for referenced value
Dim strChar    As String   '// character space
Dim intKounter As Integer  '// loop counter
intRetVal = 1
strStorage = ""

'// --- retrieve characters from passed in string
For intKounter = 1 To Len(strAscStr)
    strChar = Mid$(strAscStr, intKounter, 1)
    
    '// Validate and convert string character
    Select Case Asc(strChar)
       Case 0
	  strStorage = strStorage + "%U"
       Case 1 To 26
	  strStorage = strStorage + "$" + Chr$(Asc(strChar) + 64)
       Case 27 To 31
	  strStorage = strStorage + "%" + Chr$(Asc(strChar) + 38)
       Case 32
	  strStorage = strStorage + "_"
       Case 33 To 44
	  strStorage = strStorage + "/" + Chr$(Asc(strChar) + 32)
       Case 45 To 46
	  strStorage = strStorage + strChar
       Case 47
	  strStorage = strStorage + "/O"
       Case 48 To 57
	  strStorage = strStorage + strChar
       Case 58
	  strStorage = strStorage + "/Z"
       Case 59 To 63
	  strStorage = strStorage + "%" + Chr$(Asc(strChar) + 11)
       Case 64
	  strStorage = strStorage + "%V"
       Case 65 To 90
	  strStorage = strStorage + strChar
       Case 91 To 95
	  strStorage = strStorage + "%" + Chr$(Asc(strChar) - 16)
       Case 96
	  strStorage = strStorage + "%W"
       Case 97 To 122
	  strStorage = strStorage + "+" + Chr$(Asc(strChar) - 32)
       Case 123 To 126
	  strStorage = strStorage + "%" + Chr$(Asc(strChar) - 43)
       Case 127
	  strStorage = strStorage + "%T"
       Case 128 To 255
	  intRetVal = 0
    End Select
Next


'// --- change parameter with converted string
strAscStr = strStorage

l_long = intRetVal

End Function

'// This function checks as string to make sure that it contains characters
'// in the 44 character set of Code 39
Function l_short (strAscStr As String) As Integer

'// --- initialize return value
Dim intRetVal  As Integer
Dim intKounter As Integer
intRetVal = 1
 
'// --- retrieve characters from passed in string
For intKounter = 1 To Len(strAscStr)
    
    '// Check to see if character is in 44 character ASCII set
    If InStr("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 *-.$/+%", Mid$(strAscStr, intKounter, 1)) = 0 Then
       intRetVal = 0
    End If
Next

l_short = intRetVal
End Function

'// This function converts spaces to Underscores
'// The variable passed to this function is handed in by reference.
'// The variables WILL be changed
Function spaceconvert (strToChange As String) As String
    Dim intKounter As Integer
    Dim strChar As String
    Dim strStorage As String
    strStorage = ""

    '// Coast through string
    For intKounter = 1 To Len(strToChange)
	strChar = Mid$(strToChange, intKounter, 1)
	
	'// if it is a space convert to underscore
	   If strChar = " " Then
	   strChar = "_"
	End If
	strStorage = strStorage + strChar
   Next
    
    '// return value
    spaceconvert = strStorage
End Function

'// This function returns a check digit for a code 39 string.
function c39CheckDigit (strC39String as string) as string
dim intKounter    as integer  '// Looping counter
dim c39Value      as integer  '// Numeric value of string
dim c39CharSet    as string   '// The c39 43 character set
dim strChar       as string   '// the current character

c39CharSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%"

    For intKounter = 1 To Len(strC39String)
      strChar = Mid$(strC39String, intKounter, 1)

      '// find the location of this character in the valid set of characters
      '// subtract 1 to make sure this because the character set values are
      '// 0 based
      c39Value = c39Value + (instr(c39CharSet, strChar) - 1)
    Next
    
    c39CheckDigit = mid$(c39CharSet, (c39Value mod 43) + 1,1)
end function



