*-------------------------------------------------------------------------------
*
*  FUNCTION ButMes
*  Multi-line message / multi-button Button/Message Window for FP

*  SYNTAX:
*  ?butmes( <expC1>, ;  && MESSAGE :: the rest of the parameters are optional....
*           <expC2>, ;  && WINDOW TITLE
*           <expC3>, ;  && Buttons,Buttons delimited by comma
*           <expC4>, ;  && COLOR 
*           <expN1>, ;  && default button
*           <expC4>, ;  && FONT
*           <expN2>, ;  && FONT SIZE
*           <expC5>, ;  && FONT STYLE
*           <expN3>, ;  && TOP LH ROW 
*           <expN4>, ;  && TOP LH COL 
*           <expN5>, ;  && BOTTOM RH ROW
*           <expN6>     && BOTTOM RH COL
*
*  ?butmes( [If  Mares  eat  oats  &  Does  eat  oats  and  Little  Lambs  eat  ivy,  then  Kids'd....],  ;
   'SILLY TITLE', ;
   '\<Eat ivy too, \<Barf, \<Croak', ;
   'GR+/N', ;
   1, ;
   'arial', 20, 'b' )

*
*  Pass unlimited length message, and message will be scaled to the # of lines 
*  according to width of button set. 
*  Specify buttons, window font, color, and window coordinates
*  ButMes.PRG returns which button number was pressed. 
*  Stretches horizontally to fit buttons & vertically to fit message. 

*  Author: Lee Rodgers
*  Copyright: Released into Public Domain

*  Enjoy it, and if you are in Austin, feel free to give me a call. 
*  leebert@io.com - Lee Rodgers CI$: 73144,2276
*
*  Ly Minh Tri's (CompuServe: 73062,512) wMsgBox() is a wonderful graphical 
*  alternative udf(), but it doesn't have the vertical-stretching functionality 
*  to accomodate large multi-line messages. My hack job can't accomodate graphics.

*  There are your choices. <G>
*
*-------------------------------------------------------------------------------
PARAMETERS s_message, s_title, s_buttons, s_color, n_def_but, s_font, ;
           n_font_size, s_font_style, n_Trow, n_Lcol, n_bRow, n_rCol

PRIVATE sPrevWind, _l_center, n_button_width, n_wind_width, ;
        _s2_buttons, n_num_lines, n_wind_depth, n_choice, _s_old_rd_bord

sPrevWind = WONTOP()

IF PARAMETERS() < 1
  WAIT WINDOW "ERROR - NOT ENOUGH PARAMETERS"
  s_message = "ERROR - NOT ENOUGH PARAMETERS"
ENDIF
IF PARAMETERS() < 2
  s_title = "Please Choose:"
ENDIF
IF PARAMETERS() < 3 OR EMPTY( s_buttons )
  s_buttons = '\<OK'
ENDIF
IF PARAMETERS() < 4 OR ( TYPE('s_color')#"U" AND EMPTY(s_color) )
  s_color = 'GR+/R, GR+/R, GR+/R, GR+/R, GR+/R, GR+/R, GR+/R, GR+/R, GR+/R, GR+/R'
ENDIF
IF OCCURS( ',' , s_color ) < 1 
  s_color = REPLICATE( s_color + ',', 10 )
ENDIF  
IF PARAMETERS() < 5
  n_def_but = 1
ENDIF
IF PARAMETERS() < 6 OR (PARAMETERS() < 8 )
  s_font = 'ARIAL'
  n_font_size = 9
  s_font_style = 'b'
ENDIF
IF PARAMETERS() < 9
   n_Trow = -1
   n_Lcol = -1
ENDIF
IF PARAMETERS() < 11 OR (n_Brow - n_Trow < 2) OR (n_Rcol-n_Lcol) < 10) && minimum window width is 10
   n_Brow = -1
   n_Rcol = -1
ENDIF

n_button_width = 0

*--get actual width of text for these buttons 
IF _windows OR _mac
  n_button_width = Get_ButtWidth( STRTRAN( s_buttons,[\<],[]), s_font, n_font_size, s_font_style )
  _n_buttons = IIF( EMPTY( s_buttons), 0, OCCURS( ',', s_buttons ) + 1 )
  n_button_width = n_button_width  + ( _n_buttons * 3 )
ELSE
  n_button_width = LEN( STRTRAN( s_buttons,[\<],[]) ) + OCCURS( ',',s_buttons)+2
ENDIF    
n_wind_width = n_button_width + 4
IF n_wind_width < 10
   n_wind_width = 10  && minimum window width is 10
ENDIF
IF !( n_Rcol = -1 OR n_Lcol = -1) AND n_Wind_width <= n_Rcol-n_Lcol  
   n_wind_width = n_Rcol-n_Lcol  && user specified WIDER window width parameters
ENDIF

IF !EMPTY( s_buttons )
  *--change the parseable button string so that it works with @GET...FUNCTION <expr>
  _s2_buttons = [*HT ] + STRTRAN( s_buttons, ',' , ';' )
ELSE
  _s2_buttons = ''  
ENDIF

*--get the # of text lines that'll be used
IF LEN(s_message) <= n_wind_width     &&  if message is one line
  n_num_lines = 1
ELSE                          &&  if message is 2+ lines
  SET MEMOWIDTH TO IIF( n_wind_width >=8, n_wind_width, 8 )  && min. set memo width is 8, max is 256
  n_num_lines = MEMLINES(s_message)  && get memo depth
ENDIF

IF !EMPTY( _s2_buttons )
  n_wind_depth = n_num_lines + 1
  IF n_wind_depth < 2
    n_wind_depth = 2
  ENDIF
ELSE
  n_wind_depth = n_num_lines  
ENDIF  

IF !( n_Trow = -1 OR n_Brow = -1) AND n_Wind_Depth <= n_Brow-n_Trow  
   n_wind_depth = n_Brow-n_Trow  && user specified DEEPER window depth parameters
ENDIF

*-- define the window accordingly
DEFINE WINDOW zx ;
   AT 0,0 ;
   SIZE n_wind_depth, n_wind_width ;
   FONT s_font, n_font_size STYLE s_font_style ;
   SYSTEM ;
   TITLE s_title ;
   NOCLOSE ;
   NOZOOM ;
   FLOAT 

*--did they specify coordinates?
IF !( n_Trow=-1 OR n_Lcol=-1 )
  MOVE WINDOW zx TO n_trow, n_lcol
ELSE
  *-- otherwise, center it
  MOVE WINDOW zx CENTER
ENDIF  
ACTIVATE WINDOW zx NOSHOW
   
*--paint the box red
@ 0,0 FILL TO WROWS(), WCOLS() COLOR &s_color
*--print the message
@ 0, .3 EDIT s_message ;
      SIZE IIF(_windows OR _mac, WROWS()-.1, WROWS()-1), WCOLS()-.5  DISABLED ;
      COLOR &s_color
      
*--init. var for buttons
n_choice = n_def_but

_s_old_rd_bord = SET("READBORDER")
SET READBORDER OFF  

*--can't terminate with any of these
ON KEY LABEL Ctrl+W KEYBOARD ""
ON KEY LABEL Ctrl+Q KEYBOARD ""
ON KEY LABEL ESCAPE KEYBOARD ""


IF !EMPTY( _s2_buttons )
 nsaycol = (WCOLS() - n_button_width) / 2
 IF _windows OR _mac
  *@ WROW()-1.1, 2.5 GET n_choice FUNCTION _s2_buttons
   @ WROW()-1.1, nSayCol GET n_choice FUNCTION _s2_buttons
 ELSE
   @ WROW()-1, 0 GET n_choice FUNCTION _s2_buttons COLOR ,,,,,W+/N,N/W,,BG+/R
 ENDIF
 ACTIVATE WINDOW zx 
 READ CYCLE MODAL OBJECT n_def_but+1 COLOR ,W+/N
ELSE
ENDIF 

ON KEY LABEL Ctrl+W
ON KEY LABEL Ctrl+Q
ON KEY LABEL ESCAPE  
SET READBORDER &_s_old_rd_bord

*------momentarily let them see the result of their key press
SET CURSOR OFF
WAIT "" TIMEOUT .2
SET CURSOR ON

RELEASE WINDOW zx

IF !EMPTY(sPrevWind ) AND WEXIST(sPrevWind)
 ACTIVATE WINDOW (sPrevWind )
ENDIF

RETURN n_choice

*-------------------------------------------------------------------------------
*
*  FUNCTION Get_ButtWidth
*
*-------------------------------------------------------------------------------
FUNCTION Get_ButtWidth
PARAMETERS s_buttons, s_font, n_font_size, s_font_style
_n_mx_loops = IIF( OCCURS(',', s_buttons )>0,OCCURS(',', s_buttons )+1,1 ) 
_n_buttons = 0
s_butt = [  ]
FOR _x_ = 1 TO _n_mx_loops 
  s_curr_button = Parser( s_buttons , _x_ )
  IF !EMPTY( s_curr_button )
    _n_buttons = _n_buttons + 1
    s_butt = s_butt + [  ] + s_curr_button
  ENDIF
ENDFOR
RETURN TXTWIDTH( s_butt, s_font, n_font_size, s_font_style ) 

*--------------------------------------------------------------
*
* FUNCTION parser
* Parses strings based upon current value of _n_posit from a 
* string that looks like this "AB,CD,EF,GH" 
* returning AB when passed 1, CD when passed 2, etc...
*--------------------------------------------------------------
FUNCTION parser
PARAMETERS _s_string, _n_posit, _s_delimiter
PRIVATE n_beg_pos, n_end_pos, _s_working_str

n_beg_pos = 1
n_end_pos = 0
_s_working_str = ''

IF INLIST( TYPE( '_s_delimiter' ), "U","L" )
  _s_delimiter = ','
ENDIF

*parse out table names from _s_string string

_n_segments = OCCURS( _s_delimiter , _s_string ) + 1
IF _n_Posit > _n_segments
*  *--they've specified an invalid position on the string
*  ?? CHR(7)
*  ?? CHR(7)
*  WAIT WINDOW "THE SEGMENT YOU SPECIFIED TO PARSE DOES NOT EXIST!" + CHR(13) + "YOU SPECIFIED BEYOND THE RANGE OF SEGMENTS!" + CHR(13) + "PARSER() WILL RETURN A NULL STRING!"
  RETURN ''  && return null string
ENDIF


n_beg_pos = AT( _s_delimiter  , _s_string, IIF(_n_posit>1,_n_posit-1,1) )
IF _n_posit = 0
  *--user passed 0!
  n_end_pos = 0
ELSE  
  n_end_pos = AT( _s_delimiter , _s_string, _n_posit )
ENDIF  

  DO CASE
    CASE n_end_pos = 0 AND _n_posit > 1
    *--go to end of string
      _s_parsed_string = SUBSTR( _s_string, n_beg_pos+1 )
    CASE n_end_pos = 0 AND _n_posit = 1 
      _s_parsed_string = STRTRAN(_s_string,_s_delimiter,"")
    CASE n_end_pos > 1 AND _n_posit = 1
      _s_parsed_string = SUBSTR( _s_string, 1, (n_end_pos-1) )
    CASE n_end_pos > 1 AND _n_posit > 1
      _s_parsed_string = SUBSTR( _s_string, n_beg_pos+1, (n_end_pos-n_beg_pos)-1 )
    CASE _n_posit = 0
      WAIT WINDOW NOWAIT "ZERO PASSED AS 2nd PARAMETER"
      _s_parsed_string = ''
    OTHERWISE
      _s_parsed_string = ''
  ENDCASE



RETURN _s_parsed_string
